/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.OperatorUtil;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierUtils;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.common.TopicPartition;

public class ReconcilePartitionOperator {
    private FtpsSegmentView ftpsSegmentView;

    public ReconcilePartitionOperator(TopicPartition topicPartition, String stateFileName, long fromTimestamp) throws IOException {
        this.ftpsSegmentView = new FtpsSegmentView(topicPartition, new File(stateFileName), fromTimestamp);
    }

    public Map<UUID, String> reconcile(Map<UUID, SegmentState> segmentMap) throws Exception {
        HashMap<UUID, String> segmentPathMap = new HashMap<UUID, String>();
        SegmentState maxSegmentState = OperatorUtil.findMaxSegmentState(segmentMap);
        if (maxSegmentState == null) {
            return segmentPathMap;
        }
        UUID maxSegmentStateId = maxSegmentState.objectId();
        Long newLogStartOffset = maxSegmentState.endOffset() + 1L;
        int index = this.ftpsSegmentView.indexOf(maxSegmentStateId);
        if (index == -1) {
            return segmentPathMap;
        }
        while (index >= 0) {
            SegmentState segmentState = this.ftpsSegmentView.segmentStateList().get(index);
            if (segmentState.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) {
                TierUtils.updateSegmentState(this.ftpsSegmentView.topicIdPartition(), segmentState, TierObjectMetadata.State.SEGMENT_FENCED, this.ftpsSegmentView.stateFileChannel(), false, Long.MAX_VALUE);
                ObjectMetadata objectMetadata = new ObjectMetadata(this.ftpsSegmentView.topicIdPartition(), segmentState);
                segmentPathMap.put(segmentState.objectId(), objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath());
            }
            --index;
        }
        this.ftpsSegmentView.updateFtpsHeaderLogStartOffset(newLogStartOffset);
        this.ftpsSegmentView.close();
        return segmentPathMap;
    }

    public FtpsSegmentView getOperatorContext() {
        return this.ftpsSegmentView;
    }
}

