/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dr!B\u00181\u0011\u0003)d!B\u001c1\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\r\u0006\u0001\u000b\u0011B\"\t\u000f\u001d\u000b!\u0019!C\u0005\u0011\"1A*\u0001Q\u0001\n%Cq!T\u0001C\u0002\u0013%a\n\u0003\u0004X\u0003\u0001\u0006Ia\u0014\u0005\u00071\u0006!\t\u0001M-\u0007\t]\u0002\u0004\u0001\u0018\u0005\tA*\u0011)\u0019!C\u0005C\"AQN\u0003B\u0001B\u0003%!\r\u0003\u0005o\u0015\t\u0015\r\u0011\"\u0003p\u0011!9(B!A!\u0002\u0013\u0001\b\"\u0003=\u000b\u0005\u0003\u0005\u000b\u0011B=\u0000\u0011)\t\tA\u0003BC\u0002\u0013%\u00111\u0001\u0005\u000b\u00033Q!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\u000e\u0015\t\u0015\r\u0011\"\u0003\u0002\u001e!Q\u0011\u0011\u0007\u0006\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005M\"B!A!\u0002\u0013\t)\u0004\u0003\u0004@\u0015\u0011\u0005\u0011Q\b\u0005\n\u0003\u001bR!\u0019!C\u0005\u0003\u001fB\u0001\"a\u0016\u000bA\u0003%\u0011\u0011\u000b\u0005\t\u00033R\u0001\u0019!C\u0005\u0005\"I\u00111\f\u0006A\u0002\u0013%\u0011Q\f\u0005\b\u0003SR\u0001\u0015)\u0003D\u0011%\tYG\u0003b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002x)\u0001\u000b\u0011BA8\u0011%\tIH\u0003b\u0001\n\u0003\tY\b\u0003\u0005\u0002\u0004*\u0001\u000b\u0011BA?\u0011\u001d\t)I\u0003C\u0001\u0003wBq!a\"\u000b\t\u0013\tI\tC\u0004\u0002\u0018*!I!!'\t\u000f\u0005}%\u0002\"\u0001\u0002\"\"9\u0011Q\u0015\u0006\u0005\u0002\u0005\u001d\u0006bBAV\u0015\u0011\u0005\u0011Q\u0016\u0005\b\u0003\u001fTA\u0011AAi\u0011\u001d\t)N\u0003C!\u0003/Dq!a8\u000b\t\u0003\n\t\u000f\u0003\u0004\u0002n*!\tE\u0011\u0005\b\u0003_TA\u0011BAy\u0011\u001d\u0011\tA\u0003C\u0005\u0005\u0007A\u0001B!\u0004\u000b\t#\u0002$q\u0002\u0005\b\u0005'QA\u0011\u0001B\u000b\u0011\u001d\u0011yB\u0003C!\u0005CAQBa\t\u000b!\u0003\r\t\u0011!C\u0005\u0005Ky\u0018!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJT!!\r\u001a\u0002\rM,'O^3s\u0015\u0005\u0019\u0014!B6bM.\f7\u0001\u0001\t\u0003m\u0005i\u0011\u0001\r\u0002\u001a\u00072LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'o\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u000259\u000bgn\\:U_B+'oY3oi\u0006<W\rU3s'\u0016\u001cwN\u001c3\u0016\u0003\r\u0003\"A\u000f#\n\u0005\u0015[$A\u0002#pk\ndW-A\u000eOC:|7\u000fV8QKJ\u001cWM\u001c;bO\u0016\u0004VM]*fG>tG\rI\u00011\t\u00164\u0017-\u001e7u\u0013:\f7\r^5wK\u0016CX-\u001c9u'\u0016t7o\u001c:FqBL'/\u0019;j_:$\u0016.\\3TK\u000e|g\u000eZ:\u0016\u0003%\u0003\"A\u000f&\n\u0005-[$\u0001\u0002'p]\u001e\f\u0011\u0007R3gCVdG/\u00138bGRLg/Z#yK6\u0004HoU3og>\u0014X\t\u001f9je\u0006$\u0018n\u001c8US6,7+Z2p]\u0012\u001c\b%\u0001\tFq\u0016l\u0007\u000f^*f]N|'OT1nKV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A.\u00198h\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\rM#(/\u001b8h\u0003E)\u00050Z7qiN+gn]8s\u001d\u0006lW\rI\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,GCA\"[\u0011\u0015Y\u0016\u00021\u0001J\u0003\u0015q\u0017M\\8t'\tQQ\f\u0005\u00027=&\u0011q\f\r\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0001\u0004d_:4\u0017nZ\u000b\u0002EB\u00111m[\u0007\u0002I*\u0011\u0001-\u001a\u0006\u0003c\u0019T!aM4\u000b\u0005!L\u0017AB1qC\u000eDWMC\u0001k\u0003\ry'oZ\u0005\u0003Y\u0012\u0014\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nq!\\3ue&\u001c7/F\u0001q!\t\tX/D\u0001s\u0015\tq7O\u0003\u0002uM\u000611m\\7n_:L!A\u001e:\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,\u0007C\u0001>~\u001b\u0005Y(B\u0001?t\u0003\u0015)H/\u001b7t\u0013\tq8P\u0001\u0003US6,\u0017B\u0001=_\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070\u0006\u0002\u0002\u0006A!\u0011qAA\u000b\u001d\u0011\tI!!\u0005\u0011\u0007\u0005-1(\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019bO\u0001\u0007!J,G-\u001a4\n\u0007Y\u000b9BC\u0002\u0002\u0014m\n\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003M\u0019G.[3oiF+x\u000e^1DC2d'-Y2l+\t\ty\u0002E\u0003;\u0003C\t)#C\u0002\u0002$m\u0012aa\u00149uS>t\u0007\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-R-A\u0003rk>$\u0018-\u0003\u0003\u00020\u0005%\"aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001F2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\u000bbGRLg/\u001a+f]\u0006tGo]'b]\u0006<WM\u001d\t\u0006u\u0005\u0005\u0012q\u0007\t\u0004m\u0005e\u0012bAA\u001ea\t!\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ$b\"a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY\u0005\u0005\u00027\u0015!)\u0001-\u0006a\u0001E\")a.\u0006a\u0001a\")\u00010\u0006a\u0001s\"9\u0011\u0011A\u000bA\u0002\u0005\u0015\u0001bBA\u000e+\u0001\u0007\u0011q\u0004\u0005\b\u0003g)\u0002\u0019AA\u001b\u0003I!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN]:\u0016\u0005\u0005E\u0003c\u0001\u001c\u0002T%\u0019\u0011Q\u000b\u0019\u0003%QC'/Z1e+N\fw-Z*f]N|'o]\u0001\u0014i\"\u0014X-\u00193Vg\u0006<WmU3og>\u00148\u000fI\u0001\u0014Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\\u0001\u0018Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\0%KF$B!a\u0018\u0002fA\u0019!(!\u0019\n\u0007\u0005\r4H\u0001\u0003V]&$\b\u0002CA43\u0005\u0005\t\u0019A\"\u0002\u0007a$\u0013'\u0001\u000bmCN$H*[7ji\u000e{'O]3di&|g\u000eI\u0001\u0011Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016,\"!a\u001c\u0011\t\u0005E\u00141O\u0007\u0002g&\u0019\u0011QO:\u0003\u00155+GO]5d\u001d\u0006lW-A\tfq\u0016l\u0007\u000f^'fiJL7MT1nK\u0002\nA\"\u001a=f[B$8+\u001a8t_J,\"!! \u0011\u0007E\fy(C\u0002\u0002\u0002J\u0014aaU3og>\u0014\u0018!D3yK6\u0004HoU3og>\u0014\b%A\fo_:,\u00050Z7qi\u000e\u000b\u0007/Y2jif\u001cVM\\:pe\u0006I\"/Z2pe\u0012,\u00050Z7qi:+Go^8sWRC'/Z1e)!\ty&a#\u0002\u0010\u0006M\u0005BBAGA\u0001\u00071)A\u0003wC2,X\rC\u0004\u0002\u0012\u0002\u0002\r!!\u0002\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\r\u0005U\u0005\u00051\u0001J\u0003\u0019!\u0018.\\3Ng\u0006!\"/Z2pe\u0012,\u00050Z7qi&{G\u000b\u001b:fC\u0012$b!a\u0018\u0002\u001c\u0006u\u0005BBAGC\u0001\u00071\t\u0003\u0004\u0002\u0016\u0006\u0002\r!S\u0001\u0013C\u0012$G*[:uK:,'/T3ue&\u001c7\u000f\u0006\u0003\u0002`\u0005\r\u0006bBAIE\u0001\u0007\u0011QA\u0001\u0016e\u0016lwN^3MSN$XM\\3s\u001b\u0016$(/[2t)\u0011\ty&!+\t\u000f\u0005E5\u00051\u0001\u0002\u0006\u0005yR.Y=cKJ+7m\u001c:e\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\r\u0005=\u0016QWAg!\rQ\u0014\u0011W\u0005\u0004\u0003g[$aA%oi\"9\u0011q\u0017\u0013A\u0002\u0005e\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003w\u000b9M\u0004\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tMM\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t)-a0\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011\u0011ZAf\u0005\u001d\u0011V-];fgRTA!!2\u0002@\"1\u0011Q\u0013\u0013A\u0002%\u000b\u0011#\\1zE\u0016\u0014VmY8sI\u0016CX-\u001c9u)\u0011\ty&a5\t\u000f\u0005]V\u00051\u0001\u0002:\u0006\u0019\"-Y2laJ,7o];sK\u0016s\u0017M\u00197fIV\u0011\u0011\u0011\u001c\t\u0004u\u0005m\u0017bAAow\t9!i\\8mK\u0006t\u0017\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002p\u0005\r\bbBAsO\u0001\u0007\u0011q]\u0001\u0010cV|G/Y'fiJL7\rV1hgBA\u0011qAAu\u0003\u000b\t)!\u0003\u0003\u0002l\u0006]!aA'ba\u0006\u0019r-\u001a;Ce>\\WM])v_R\fG*[7ji\u0006\u0019\"/Z2pe\u0012Lu\u000e\u00165sK\u0006$Wk]1hKRA\u0011qLAz\u0003k\fy\u0010\u0003\u0004\u0002\u000e&\u0002\ra\u0011\u0005\b\u0003oL\u0003\u0019AA}\u0003-\u0011X-];fgR$\u0016\u0010]3\u0011\u0007Y\nY0C\u0002\u0002~B\u00121BU3rk\u0016\u001cH\u000fV=qK\"1\u0011QS\u0015A\u0002%\u000b!C]3d_J$g*\u001a;x_J\\Wk]1hKRQ\u0011q\fB\u0003\u0005\u000f\u0011IAa\u0003\t\r\u00055%\u00061\u0001D\u0011\u001d\t\tJ\u000ba\u0001\u0003\u000bAq!a>+\u0001\u0004\tI\u0010\u0003\u0004\u0002\u0016*\u0002\r!S\u0001\u0017kB$\u0017\r^3Ce>\\WM])v_R\fG*[7jiR!\u0011q\fB\t\u0011\u0019\t)j\u000ba\u0001\u0013\u00061R\u000f\u001d3bi\u0016\fEM[;ti\u0016$7)\u00199bG&$\u0018\u0010F\u0003D\u0005/\u0011Y\u0002\u0003\u0004\u0003\u001a1\u0002\raQ\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;MS6LG\u000f\u0003\u0004\u0003\u001e1\u0002\raQ\u0001\u001a]>tW\t_3naR$v\u000e^1m)\"\u0014X-\u00193MS6LG/\u0001\u0005tQV$Hm\\<o)\t\ty&\u0001\u0006tkB,'\u000f\n;j[\u0016,\u0012!\u001f")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureConfig.nonExemptRequestCapacityMetricName((Metrics)this.metrics()));
    }

    private void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    private void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordIoThreadUsage(value, ExemptRequest$.MODULE$, timeMs);
    }

    public void addListenerMetrics(String listenerName) {
        this.threadUsageSensors().addListenerMetrics(listenerName);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double reqIoThreadPercentage = ClientRequestQuotaManager$.MODULE$.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.recordIoThreadUsage(reqIoThreadPercentage, NonExemptRequest$.MODULE$, timeMs);
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(request.session(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> {
                long timeMs = this.super$time().milliseconds();
                this.recordNoThrottle(clientSensors, ClientRequestQuotaManager$.MODULE$.nanosToPercentage(timeNanos), timeMs);
                this.recordNetworkUsage(ClientRequestQuotaManager$.MODULE$.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, timeMs);
            }));
            return this.recordAndGetThrottleTimeMs(clientSensors, reqIoThreadPercentage, timeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(ClientRequestQuotaManager$.MODULE$.nanosToPercentage(timeNanos), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double reqIoThreadPercentage = ClientRequestQuotaManager$.MODULE$.nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExemptNetworkThread(ClientRequestQuotaManager$.MODULE$.nanosToPercentage(timeNanos), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNetworkUsage(ClientRequestQuotaManager$.MODULE$.nanosToPercentage(timeNanos), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
        this.recordIoThreadUsage(reqIoThreadPercentage, ExemptRequest$.MODULE$, currentTimeMs);
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig && ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(this.dynamicBackpressureConfig().tenantEndpointListenerNames).asScala()).nonEmpty();
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureConfig.nonExemptRequestCapacityMetricName((Metrics)this.metrics())));
        if (metricOpt instanceof Some) {
            return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue());
        }
        return Double.MAX_VALUE;
    }

    private void recordIoThreadUsage(double value, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(value, timeMs, requestType);
            return;
        }
        this.threadUsageSensors().recordIoThreadUsage(value, timeMs, AllRequests$.MODULE$);
    }

    private void recordNetworkUsage(double value, String listenerName, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, requestType);
            return;
        }
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, AllRequests$.MODULE$);
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Buffer tenantEndpointsListenerNames = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.dynamicBackpressureConfig().tenantEndpointListenerNames).asScala();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), NonExemptRequest$.MODULE$);
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), AllRequests$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq<String>)tenantEndpointsListenerNames, NonExemptRequest$.MODULE$);
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq<String>)tenantEndpointsListenerNames, AllRequests$.MODULE$);
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), (Seq<String>)tenantEndpointsListenerNames));
            double nonExemptTotalThreadLimit = nonExemptIoThreadLimit + nonExemptNetworkThreadLimit;
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptTotalThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit, nonExemptTotalThreadLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
            return;
        }
    }

    public double updateAdjustedCapacity(double brokerRequestLimit, double nonExemptTotalThreadLimit) {
        double d;
        double queueSize = RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), this.dynamicBackpressureConfig().queueSizePercentile, RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize$default$3());
        double minAdjustment = 25.0;
        double increaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * 0.02);
        double decreaseAdjustment = package$.MODULE$.max(minAdjustment, nonExemptTotalThreadLimit * 0.1);
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota;
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = package$.MODULE$.min(maxAdjustmentLimit, this.lastLimitCorrection() + decreaseAdjustment);
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - increaseAdjustment);
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadUsageSensors().close();
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * 0.8 - exemptUsage;
        double minNonExemptCapacity = totalCapacity * 0.3;
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        this.threadUsageSensors = new ThreadUsageSensors(metrics);
        this.lastLimitCorrection = 0.0;
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds));
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(this.exemptMetricName(), (MeasurableStat)new Rate());
            return BoxedUnit.UNIT;
        });
    }
}

