/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0003\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u00069\u0002!\t!\u0018\u0005\u0006K\u0002!\tE\u001a\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006S\u0002!\t\u0005\u001b\u0002\u0013\t\u0016d\u0017-_3e\u0019&\u001cHo\u00144gg\u0016$8O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\bI\u0016d\u0017-_'t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0011auN\\4\u0002'\u0019,Go\u00195P]2LhI]8n\u0019\u0016\fG-\u001a:\u0011\u0005ay\u0012B\u0001\u0011\u001a\u0005\u001d\u0011un\u001c7fC:\f!\u0002\\8dC2d\u0015n\u001d;t!\u0011\u0019\u0003FK\u001b\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICEA\u0004ICNDW*\u00199\u0011\u0005-\u001aT\"\u0001\u0017\u000b\u00055r\u0013AB2p[6|gN\u0003\u0002\u0010_)\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0013\t!DF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007a1\u0004(\u0003\u000283\t1q\n\u001d;j_:\u0004\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u00071|wM\u0003\u0002>}\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u007f9\nqa\u001d;pe\u0006<W-\u0003\u0002Bu\tIb)\u001a;dQ\u0016$G+[7fgR\fW\u000e]!oI>3gm]3u\u0003\u001d\u0001XM\u001c3j]\u001e\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u000f\u0019,Go\u00195fe*\u0011\u0001JD\u0001\u0005i&,'/\u0003\u0002K\u000b\nI\u0002+\u001a8eS:<wJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"aE'\n\u00059c!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004B\u0001G)T3&\u0011!+\u0007\u0002\n\rVt7\r^5p]F\u0002B\u0001V,+k5\tQK\u0003\u0002W3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a+&aA'baB\u0011\u0001DW\u0005\u00037f\u0011A!\u00168ji\u00061A(\u001b8jiz\"rAX0aC\n\u001cG\r\u0005\u0002\u0014\u0001!)ac\u0002a\u0001/!)Qd\u0002a\u0001=!)\u0011e\u0002a\u0001E!)!i\u0002a\u0001\u0007\")1j\u0002a\u0001\u0019\")qj\u0002a\u0001!\u0006YAO]=D_6\u0004H.\u001a;f)\u0005q\u0012\u0001D8o\u000bb\u0004\u0018N]1uS>tG#A-\u0002\u0015=t7i\\7qY\u0016$X\r")
public class DelayedListOffsets
extends DelayedOperation {
    private final boolean fetchOnlyFromLeader;
    private final HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists;
    private final PendingOffsetForTimestamp pending;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedListOffsets.$anonfun$tryComplete$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            if (x$1 != null) {
                TopicPartition tp = (TopicPartition)x$1._1();
                Option v = (Option)x$1._2();
                try {
                    Partition partition = $this.replicaManager.getPartitionOrException(tp);
                    Optional leaderEpoch = ((FetchedTimestampAndOffset)v.get()).leaderEpoch();
                    return partition.localLogWithEpochOrThrow(leaderEpoch, $this.fetchOnlyFromLeader);
                }
                catch (Exception e) {
                    $this.pending.completeExceptionally(tp, e);
                    return BoxedUnit.UNIT;
                }
            }
            throw new MatchError(null);
        });
        if (this.pending.isDone()) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.pending.cancel();
    }

    @Override
    public void onComplete() {
        scala.collection.mutable.Map tierResponses = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.pending.tierTimestampAndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                Option timestampAndOffset = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.pending.results().getOrDefault(topicPartition, Optional.of(new FetchedTimestampAndOffset((Exception)((Object)Errors.REQUEST_TIMED_OUT.exception()))))));
                return new Tuple2((Object)topicPartition, (Object)timestampAndOffset);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.localLists).asScala()).$plus$plus((GenTraversableOnce)tierResponses));
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public DelayedListOffsets(long delayMs, boolean fetchOnlyFromLeader, HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists, PendingOffsetForTimestamp pending, ReplicaManager replicaManager, Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback) {
        this.fetchOnlyFromLeader = fetchOnlyFromLeader;
        this.localLists = localLists;
        this.pending = pending;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

