/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kafka.cluster.EndPoint;
import kafka.network.SocketServer;
import kafka.server.DynamicBrokerConfig;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.telemetry.ClientTelemetry;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u000f\u001f\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B*\u0001\t\u0003!\u0006bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B/\t\u0011\u0011\u0004!\u0019!C\u0001=\u0015Da!\u001b\u0001!\u0002\u00131\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00027\t\u0011M\u0004!\u0019!C\u0001=QDa! \u0001!\u0002\u0013)\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0002!A\u0011\u0011\u0003\u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0001\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\r\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GA\u0001\"!\u0016\u0001\t\u0003q\u0012q\u000b\u0005\b\u0003+\u0002A\u0011BA9\u0011!\t)\t\u0001C\u0001=\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\t\t\f\u0001C\u0005\u0003gC\u0001\"a.\u0001\t\u0003q\u0012\u0011\u0018\u0002\u001b\tft\u0017-\\5d\u001b\u0016$(/[2SKB|'\u000f^3s'R\fG/\u001a\u0006\u0003?\u0001\naa]3sm\u0016\u0014(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"!\n\u0017\n\u000552#aA%oi\u000611m\u001c8gS\u001e\u0004\"\u0001M\u0019\u000e\u0003yI!A\r\u0010\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\t)d(D\u00017\u0015\t\u0019tG\u0003\u00029s\u000511m\\7n_:T!!\t\u001e\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012q!T3ue&\u001c7/A\u0005dYV\u001cH/\u001a:JIB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001\u0012\u0014\u000e\u0003\u0015S!A\u0012\u0012\u0002\rq\u0012xn\u001c;?\u0013\tAe%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%'\u00031\u0019xnY6fiN+'O^3s!\tq\u0015+D\u0001P\u0015\t\u0001\u0006%A\u0004oKR<xN]6\n\u0005I{%\u0001D*pG.,GoU3sm\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004V-^C\u0016L\u0017\t\u0003a\u0001AQA\u000b\u0004A\u0002-BQA\f\u0004A\u0002=BQa\r\u0004A\u0002QBQ\u0001\u0011\u0004A\u0002\u0005CQ\u0001\u0014\u0004A\u00025\u000b1\u0001\\8h+\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011=\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0011wL\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0007es:\fW.[2D_:4\u0017nZ\u000b\u0002MB\u0011\u0001gZ\u0005\u0003Qz\u00111\u0003R=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\fa\u0002Z=oC6L7mQ8oM&<\u0007%A\u0007qe>\u00048o\u0014<feJLG-Z\u000b\u0002YB!Q\u000e]!%\u001b\u0005q'BA8'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c:\u00141!T1q\u00039\u0001(o\u001c9t\u001fZ,'O]5eK\u0002\n\u0001cY;se\u0016tGOU3q_J$XM]:\u0016\u0003U\u0004BA^=Bu6\tqO\u0003\u0002y]\u00069Q.\u001e;bE2,\u0017BA9x!\t)40\u0003\u0002}m\tyQ*\u001a;sS\u000e\u001c(+\u001a9peR,'/A\tdkJ\u0014XM\u001c;SKB|'\u000f^3sg\u0002\na\u0003^3mK6,GO]=SKB|'\u000f^3s\u00072\f7o]\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0003mC:<'BAA\u0006\u0003\u0011Q\u0017M^1\n\u0007)\u000b)!A\fuK2,W.\u001a;ssJ+\u0007o\u001c:uKJ\u001cE.Y:tA\u0005aB.Z4bGf$V\r\\3nKR\u0014\u0018PU3q_J$XM]\"mCN\u001c\u0018!\b7fO\u0006\u001c\u0017\u0010V3mK6,GO]=SKB|'\u000f^3s\u00072\f7o\u001d\u0011\u0002-%\u001cH+\u001a7f[\u0016$(/_(o\u00072\f7o\u001d9bi\",\"!!\u0007\u0011\u0007\u0015\nY\"C\u0002\u0002\u001e\u0019\u0012qAQ8pY\u0016\fg.A\fjgR+G.Z7fiJLxJ\\\"mCN\u001c\b/\u0019;iA\u0005IrN^3se&$W\rU8sij+'o\u001c'jgR,g.\u001a:t)!\t)#a\u000b\u0002.\u0005=\u0002cA\u0013\u0002(%\u0019\u0011\u0011\u0006\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006]U\u0001\ra\f\u0005\u0006\u0019V\u0001\r!\u0014\u0005\b\u0003c)\u0002\u0019AA\u001a\u0003\u001d\u0019wN\u001c4jON\u0004D!!\u000e\u0002DA9\u0011qGA\u001f\u0003\u0006}RBAA\u001d\u0015\u0011\tY$!\u0003\u0002\tU$\u0018\u000e\\\u0005\u0004c\u0006e\u0002\u0003BA!\u0003\u0007b\u0001\u0001\u0002\u0007\u0002F\u0005=\u0012\u0011!A\u0001\u0006\u0003\t9E\u0001\u0003`IE\n\u0014\u0003BA%\u0003\u001f\u00022!JA&\u0013\r\tiE\n\u0002\b\u001d>$\b.\u001b8h!\r)\u0013\u0011K\u0005\u0004\u0003'2#aA!os\u0006y1M]3bi\u0016\u0014V\r]8si\u0016\u00148\u000f\u0006\u0004\u0002&\u0005e\u00131\r\u0005\b\u000372\u0002\u0019AA/\u0003=\u0011X\r]8si\u0016\u00148\t\\1tg\u0016\u001c\b#BA\u001c\u0003?\n\u0015\u0002BA1\u0003s\u0011A\u0001T5ti\"9\u0011Q\r\fA\u0002\u0005\u001d\u0014AD;qI\u0006$X\rZ\"p]\u001aLwm\u001d\u0019\u0005\u0003S\ni\u0007E\u0004\u00028\u0005u\u0012)a\u001b\u0011\t\u0005\u0005\u0013Q\u000e\u0003\r\u0003_\n\u0019'!A\u0001\u0002\u000b\u0005\u0011q\t\u0002\u0005?\u0012\n$\u0007\u0006\u0006\u0002&\u0005M\u0014QOA<\u0003sBQAL\fA\u0002=BQ\u0001Q\fA\u0002\u0005Cq!a\u0017\u0018\u0001\u0004\ti\u0006C\u0004\u0002f]\u0001\r!a\u001f1\t\u0005u\u0014\u0011\u0011\t\b\u0003o\ti$QA@!\u0011\t\t%!!\u0005\u0019\u0005\r\u0015\u0011PA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\t}#\u0013gM\u0001\u000fe\u0016lwN^3SKB|'\u000f^3s)\u0011\t)#!#\t\r\u0005-\u0005\u00041\u0001B\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0010dQ\u0016\u001c7NR8s)\u0016dW-\\3uef\u0014V\r]8si\u0016\u00148\t\\1tgR\u0011\u0011\u0011D\u0001\u0012[\u0006L(-Z!eIR+G.Z7fiJLHCBAK\u00037\u000b)\u000b\u0005\u0003&\u0003/\u000b\u0015bAAMM\t1q\n\u001d;j_:Dq!!(\u001b\u0001\u0004\ty*A\u0004dY\u0006\u001c8/Z:\u0011\tY\f\t+Q\u0005\u0004\u0003G;(A\u0002\"vM\u001a,'\u000fC\u0004\u00022i\u0001\r!a*1\t\u0005%\u0016Q\u0016\t\b\u0003o\ti$QAV!\u0011\t\t%!,\u0005\u0019\u0005=\u0016QUA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\t}#\u0013\u0007N\u0001\u001dC2L\u0017m\u001d'fO\u0006\u001c\u0017\u0010V3mK6,GO]=SKB|'\u000f^3s)\u0011\ti&!.\t\u000f\u0005u5\u00041\u0001\u0002^\u00051R.\u001a;sS\u000e\u001c(+\u001a9peR,'o\u00117bgN,7\u000f\u0006\u0003\u0002 \u0006m\u0006bBA\u00199\u0001\u0007\u0011Q\u0018\u0019\u0005\u0003\u007f\u000b\u0019\rE\u0004\u00028\u0005u\u0012)!1\u0011\t\u0005\u0005\u00131\u0019\u0003\r\u0003\u000b\fY,!A\u0001\u0002\u000b\u0005\u0011q\t\u0002\u0005?\u0012\nT\u0007")
public class DynamicMetricReporterState {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final String clusterId;
    private final SocketServer socketServer;
    private final Logger log;
    private final DynamicBrokerConfig dynamicConfig;
    private final Map<String, Object> propsOverride;
    private final scala.collection.mutable.Map<String, MetricsReporter> currentReporters;
    private final String telemetryReporterClass;
    private final String legacyTelemetryReporterClass;
    private final boolean isTelemetryOnClasspath;

    public Logger log() {
        return this.log;
    }

    public DynamicBrokerConfig dynamicConfig() {
        return this.dynamicConfig;
    }

    private Map<String, Object> propsOverride() {
        return this.propsOverride;
    }

    public scala.collection.mutable.Map<String, MetricsReporter> currentReporters() {
        return this.currentReporters;
    }

    private String telemetryReporterClass() {
        return this.telemetryReporterClass;
    }

    private String legacyTelemetryReporterClass() {
        return this.legacyTelemetryReporterClass;
    }

    private boolean isTelemetryOnClasspath() {
        return this.isTelemetryOnClasspath;
    }

    private void overridePortZeroListeners(KafkaConfig config, SocketServer socketServer, java.util.Map<String, ?> configs) {
        BooleanRef requiresOverride = BooleanRef.create((boolean)false);
        String listeners = ((TraversableOnce)config.listeners().map((Function1 & Serializable & scala.Serializable)endpoint -> {
            EndPoint e = endpoint;
            if (endpoint.port() == 0 && (socketServer.apiVersionManager().listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER) || !config.controllerListenerNames().contains((Object)endpoint.listenerName().value()))) {
                requiresOverride$1.elem = true;
                e = new EndPoint(endpoint.host(), socketServer.boundPort(endpoint.listenerName()), endpoint.listenerName(), endpoint.securityProtocol());
            }
            return e.connectionString();
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        if (requiresOverride.elem) {
            configs.put("listeners", listeners);
            return;
        }
    }

    public void createReporters(List<String> reporterClasses, java.util.Map<String, ?> updatedConfigs) {
        this.createReporters(this.config, this.clusterId, reporterClasses, updatedConfigs);
    }

    /*
     * WARNING - void declaration
     */
    private void createReporters(KafkaConfig config, String clusterId, List<String> reporterClasses, java.util.Map<String, ?> updatedConfigs) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        HashMap props = new HashMap();
        updatedConfigs.forEach((k, v) -> props.put(k, v));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> props.put(k, v);
        Map<String, Object> map = Implicits$.MODULE$.MapExtensionMethods(this.propsOverride());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.overridePortZeroListeners(config, this.socketServer, props);
        List reporters = this.dynamicConfig().currentKafkaConfig().getConfiguredInstances(reporterClasses, MetricsReporter.class, props);
        KafkaBroker$.MODULE$.notifyMetricsReporters(clusterId, config, (Seq<Object>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(reporters).asScala()));
        reporters.forEach(reporter -> {
            ClientTelemetryReceiver clientTelemetryReceiver;
            $this.metrics.addReporter(reporter);
            this.currentReporters().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reporter.getClass().getName()), reporter));
            boolean isClientMetricsEnabled = BoxesRunTime.unboxToBoolean((Object)this.dynamicConfig().currentKafkaConfig().get("confluent.telemetry.external.client.metrics.push.enabled"));
            ClientTelemetryReceiver clientTelemetryReceiver2 = clientTelemetryReceiver = reporter instanceof ClientTelemetry && isClientMetricsEnabled ? ((ClientTelemetry)reporter).clientReceiver() : null;
            if (clientTelemetryReceiver != null) {
                Option<ClientMetricsReceiverPlugin> option = this.dynamicConfig().clientMetricsReceiverPlugin();
                if (option instanceof Some) {
                    ((ClientMetricsReceiverPlugin)((Some)option).value()).add(clientTelemetryReceiver);
                    this.log().info("Client telemetry receiver plugin is registered");
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                throw new MatchError(option);
            }
        });
        KafkaBroker$.MODULE$.notifyClusterListeners(clusterId, (Seq<Object>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(reporters).asScala()));
    }

    public void removeReporter(String className) {
        this.currentReporters().remove((Object)className).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.metrics.removeReporter(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private boolean checkForTelemetryReporterClass() {
        try {
            Utils.loadClass((String)this.telemetryReporterClass(), MetricsReporter.class);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log().error("TelemetryReporter is not on the classpath. Continuing without telemetry...");
            return false;
        }
    }

    private Option<String> maybeAddTelemetry(Buffer<String> classes, java.util.Map<String, ?> configs) {
        if (!classes.contains((Object)this.telemetryReporterClass()) && BoxesRunTime.unboxToBoolean(configs.get("confluent.reporters.telemetry.auto.enable")) && this.isTelemetryOnClasspath()) {
            return Option$.MODULE$.apply((Object)this.telemetryReporterClass());
        }
        return Option$.MODULE$.empty();
    }

    private List<String> aliasLegacyTelemetryReporter(List<String> classes) {
        ArrayList<String> newClasses = new ArrayList<String>(classes);
        if (this.isTelemetryOnClasspath() && newClasses.removeAll(Collections.singletonList(this.legacyTelemetryReporterClass()))) {
            newClasses.add(this.telemetryReporterClass());
        }
        return newClasses;
    }

    public Buffer<String> metricsReporterClasses(java.util.Map<String, ?> configs) {
        Buffer classes = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.aliasLegacyTelemetryReporter((List)configs.get("metric.reporters"))).asScala();
        classes.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(this.maybeAddTelemetry((Buffer<String>)classes, configs)));
        if (BoxesRunTime.unboxToBoolean(configs.get("auto.include.jmx.reporter")) && !classes.contains((Object)JmxReporter.class.getName())) {
            classes.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)JmxReporter.class.getName())));
        }
        return classes;
    }

    public DynamicMetricReporterState(int brokerId, KafkaConfig config, Metrics metrics, String clusterId, SocketServer socketServer) {
        this.config = config;
        this.metrics = metrics;
        this.clusterId = clusterId;
        this.socketServer = socketServer;
        this.log = LoggerFactory.getLogger((String)"DynamicMetricsReporterState");
        this.dynamicConfig = config.dynamicConfig();
        this.propsOverride = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker.id"), (Object)Integer.toString(brokerId))}));
        this.currentReporters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.telemetryReporterClass = "io.confluent.telemetry.reporter.TelemetryReporter";
        this.legacyTelemetryReporterClass = "io.confluent.telemetry.reporter.KafkaServerMetricsReporter";
        this.isTelemetryOnClasspath = this.checkForTelemetryReporterClass();
        this.createReporters(config, clusterId, (List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(this.metricsReporterClasses(this.dynamicConfig().currentKafkaConfig().values())).asJava(), Collections.emptyMap());
    }
}

