/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.IncrementalFetchContext$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%i\u0001\u000e\u0005\u0007\u007f\u0005\u0001\u000bQB\u001b\u0007\t%\u0012\u0003\u0001\u0011\u0005\t\t\u0016\u0011)\u0019!C\u0005\u000b\"A1+\u0002B\u0001B\u0003%a\t\u0003\u0005U\u000b\t\u0015\r\u0011\"\u0003V\u0011!IVA!A!\u0002\u00131\u0006\u0002\u0003.\u0006\u0005\u000b\u0007I\u0011B.\t\u0011}+!\u0011!Q\u0001\nqC\u0001\u0002Y\u0003\u0003\u0006\u0004%I!\u0019\u0005\tS\u0016\u0011\t\u0011)A\u0005E\")\u0011'\u0002C\u0001U\"A1'\u0002EC\u0002\u0013\u0005C\u0007C\u0003q\u000b\u0011\u0005\u0013\u000fC\u0003\u007f\u000b\u0011\u0005sP\u0002\u0004\u0002\u0018\u0015!\u0011\u0011\u0004\u0005\u000b\u0003c\u0011\"Q1A\u0005\u0002\u0005M\u0002BCA\u001b%\t\u0005\t\u0015!\u0003\u0002,!Q\u0011q\u0007\n\u0003\u0006\u0004%\t!!\u000f\t\u0015\u0005\u0005#C!A!\u0002\u0013\tY\u0004\u0003\u00042%\u0011\u0005\u00111\t\u0005\f\u0003\u001b\u0012\u0002\u0019!a\u0001\n\u0013\ty\u0005C\u0006\u0002~I\u0001\r\u00111A\u0005\n\u0005}\u0004bCAC%\u0001\u0007\t\u0011)Q\u0005\u0003#Bq!a\"\u0013\t\u0003\nI\tC\u0004\u0002\fJ!\t%!$\t\u000f\u0005=%\u0003\"\u0011\u0002\u0012\"9\u00111S\u0003\u0005B\u0005U\u0005bBAV\u000b\u0011\u0005\u0013Q\u0016\u0005\b\u0003{+A\u0011IA`\u0003]Ien\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nQ8oi\u0016DHO\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0013!D\u0001#\u0005]Ien\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nQ8oi\u0016DHo\u0005\u0002\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0014\u0002\r1|wmZ3s+\u0005)\u0004C\u0001\u001c>\u001b\u00059$B\u0001\u001d:\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ4(\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0014aA2p[&\u0011ah\u000e\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sAM\u0019QaK!\u0011\u0005!\u0012\u0015BA\"#\u000511U\r^2i\u0007>tG/\u001a=u\u0003\u0011!\u0018.\\3\u0016\u0003\u0019\u0003\"aR)\u000e\u0003!S!!\u0013&\u0002\u000bU$\u0018\u000e\\:\u000b\u0005-c\u0015AB2p[6|gN\u0003\u0002&\u001b*\u0011ajT\u0001\u0007CB\f7\r[3\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011\u0006J\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u0004:fcV,7\u000f^#q_\u000eDW#\u0001,\u0011\u00051:\u0016B\u0001-.\u0005\rIe\u000e^\u0001\u000ee\u0016\fX/Z:u\u000bB|7\r\u001b\u0011\u0002\u000fM,7o]5p]V\tA\f\u0005\u0002);&\u0011aL\t\u0002\r\r\u0016$8\r[*fgNLwN\\\u0001\tg\u0016\u001c8/[8oA\u0005QAo\u001c9jG:\u000bW.Z:\u0016\u0003\t\u0004\"a\u00194\u000f\u0005!\"\u0017BA3#\u000311U\r^2i'\u0016\u001c8/[8o\u0013\t9\u0007N\u0001\bU\u001fBK5i\u0018(B\u001b\u0016{V*\u0011)\u000b\u0005\u0015\u0014\u0013a\u0003;pa&\u001cg*Y7fg\u0002\"Ra\u001b7n]>\u0004\"\u0001K\u0003\t\u000b\u0011s\u0001\u0019\u0001$\t\u000bQs\u0001\u0019\u0001,\t\u000bis\u0001\u0019\u0001/\t\u000b\u0001t\u0001\u0019\u00012\u0002\u001d\u001d,GOR3uG\"|eMZ:fiR\u0011!\u000f\u001f\t\u0004YM,\u0018B\u0001;.\u0005\u0019y\u0005\u000f^5p]B\u0011AF^\u0005\u0003o6\u0012A\u0001T8oO\")\u0011\u0010\u0005a\u0001u\u0006\u0011A\u000f\u001d\t\u0003wrl\u0011AS\u0005\u0003{*\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002!\u0019|'/Z1dQB\u000b'\u000f^5uS>tG\u0003BA\u0001\u0003\u000f\u00012\u0001LA\u0002\u0013\r\t)!\f\u0002\u0005+:LG\u000fC\u0004\u0002\nE\u0001\r!a\u0003\u0002\u0007\u0019,h\u000e\u0005\u0005-\u0003\u001bQ\u0018\u0011CA\u0001\u0013\r\ty!\f\u0002\n\rVt7\r^5p]J\u00022\u0001KA\n\u0013\r\t)B\t\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\n\t\u0002+\u0019:uSRLwN\\%uKJ\fGo\u001c:\u0014\u000bI\tY\"a\u000b\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A.\u00198h\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u0003?\u0011aa\u00142kK\u000e$\bcA2\u0002.%\u0019\u0011q\u00065\u0003\u001bI+5\u000bU0N\u0003B{\u0016\nV#S\u0003\u0011IG/\u001a:\u0016\u0005\u0005-\u0012!B5uKJ\u0004\u0013!J;qI\u0006$XMR3uG\"\u001cuN\u001c;fqR\fe\u000e\u001a*f[>4X-\u00168tK2,7\r^3e+\t\tY\u0004E\u0002-\u0003{I1!a\u0010.\u0005\u001d\u0011un\u001c7fC:\fa%\u001e9eCR,g)\u001a;dQ\u000e{g\u000e^3yi\u0006sGMU3n_Z,WK\\:fY\u0016\u001cG/\u001a3!)\u0019\t)%!\u0013\u0002LA\u0019\u0011q\t\n\u000e\u0003\u0015Aq!!\r\u0018\u0001\u0004\tY\u0003C\u0004\u00028]\u0001\r!a\u000f\u0002\u00179,\u0007\u0010^#mK6,g\u000e^\u000b\u0003\u0003#\u0002r!a\u0015\u0002di\fIG\u0004\u0003\u0002V\u0005uc\u0002BA,\u00033j!!a\t\n\t\u0005m\u00131E\u0001\u0005kRLG.\u0003\u0003\u0002`\u0005\u0005\u0014aA'ba*!\u00111LA\u0012\u0013\u0011\t)'a\u001a\u0003\u000b\u0015sGO]=\u000b\t\u0005}\u0013\u0011\r\t\u0005\u0003W\n9H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\tHS\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t)(a\u001c\u0002#\u0019+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002z\u0005m$!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0002v\u0005=\u0014a\u00048fqR,E.Z7f]R|F%Z9\u0015\t\u0005\u0005\u0011\u0011\u0011\u0005\n\u0003\u0007K\u0012\u0011!a\u0001\u0003#\n1\u0001\u001f\u00132\u00031qW\r\u001f;FY\u0016lWM\u001c;!\u0003\u001dA\u0017m\u001d(fqR$\"!a\u000f\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003#\naA]3n_Z,GCAA\u0001\u0003=9W\r\u001e*fgB|gn]3TSj,G#\u0002,\u0002\u0018\u0006\u0005\u0006bBAM=\u0001\u0007\u00111T\u0001\bkB$\u0017\r^3t!\r\u0019\u0017QT\u0005\u0004\u0003?C'\u0001\u0003*F'B{V*\u0011)\t\u000f\u0005\rf\u00041\u0001\u0002&\u0006Ia/\u001a:tS>t\u0017\n\u001a\t\u0004Y\u0005\u001d\u0016bAAU[\t)1\u000b[8si\u0006iR\u000f\u001d3bi\u0016\fe\u000eZ$f]\u0016\u0014\u0018\r^3SKN\u0004xN\\:f\t\u0006$\u0018\r\u0006\u0003\u00020\u0006m\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005U&*\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tI,a-\u0003\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0011\u001d\tIj\ba\u0001\u00037\u000bAcZ3u)\"\u0014x\u000e\u001e;mK\u0012\u0014Vm\u001d9p]N,G\u0003BAX\u0003\u0003Da!a1!\u0001\u00041\u0016A\u0004;ie>$H\u000f\\3US6,Wj\u001d")
public class IncrementalFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final int requestEpoch;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private final Map<Uuid, String> topicNames;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private int requestEpoch() {
        return this.requestEpoch;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = IncrementalFetchContext$.MODULE$.kafka$server$IncrementalFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(partition -> {
                if (this.kafka$server$IncrementalFetchContext$$session().usesTopicIds()) {
                    partition.maybeResolveUnknownName(this.topicNames());
                }
                fun.apply((Object)new TopicIdPartition(partition.topicId(), partition.partition(), partition.topic()), partition);
            });
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, int requestEpoch, FetchSession session, Map<Uuid, String> topicNames) {
        this.time = time;
        this.requestEpoch = requestEpoch;
        this.kafka$server$IncrementalFetchContext$$session = session;
        this.topicNames = topicNames;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        private void nextElement_$eq(Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicIdPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                IncrementalPartitionFetchMetadata cachedPart = (IncrementalPartitionFetchMetadata)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        @Override
        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

