/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.BootstrapTcpConnectionFailedUnavailableLinkReason;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$Cloud$;
import kafka.server.link.TimeoutUnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnknownUnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkConnectionChecker$
implements Logging {
    public static ClusterLinkConnectionChecker$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkConnectionChecker$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Option<ClusterLinkConnectionCheckerResult> check(DescribeClusterResult describeClusterResult, ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        try {
            describeClusterResult.clusterId().get();
            return Option$.MODULE$.empty();
        }
        catch (Throwable ex) {
            void var12_18;
            void var11_17;
            List list;
            Option option;
            ApiException apiException;
            block15: {
                List list2;
                apiException = ClusterLinkUtils$.MODULE$.apiException(ex, "Basic describeCluster check failed");
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$check$1(ex, apiException)));
                }
                if (apiException instanceof AuthenticationException) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                }
                if (apiException instanceof AuthorizationException) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)));
                }
                List<String> checkBasicNetworking_checkAddresses_bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
                String checkBasicNetworking_checkAddresses_dnsLookupConfig = config.getString("client.dns.lookup");
                ClientDnsLookup checkBasicNetworking_checkAddresses_dnsLookup = checkBasicNetworking_checkAddresses_dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)checkBasicNetworking_checkAddresses_dnsLookupConfig);
                ArrayList checkBasicNetworking_checkAddresses_invalidAddresses = new ArrayList();
                try {
                    list2 = ClientUtils.parseAndValidateAddresses(checkBasicNetworking_checkAddresses_bootstrapServers, (ClientDnsLookup)checkBasicNetworking_checkAddresses_dnsLookup);
                }
                catch (ConfigException checkBasicNetworking_checkAddresses_ex) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(checkBasicNetworking_checkAddresses_ex)));
                    }
                    option = Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config));
                    list = null;
                    break block15;
                }
                catch (Throwable checkBasicNetworking_checkAddresses_ex) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(checkBasicNetworking_checkAddresses_ex)));
                    }
                    option = Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
                    list = null;
                    break block15;
                }
                List checkBasicNetworking_checkAddresses_validatedAddresses = list2;
                ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(checkBasicNetworking_checkAddresses_validatedAddresses).asScala()).foreach((Function1 & Serializable & scala.Serializable)inetSocketAddress -> {
                    if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                        return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
                    }
                    return BoxedUnit.UNIT;
                });
                if (!checkBasicNetworking_checkAddresses_invalidAddresses.isEmpty()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(checkBasicNetworking_checkAddresses_invalidAddresses)));
                    }
                    option = Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config));
                    list = null;
                } else {
                    option = None$.MODULE$;
                    list = checkBasicNetworking_checkAddresses_validatedAddresses;
                }
            }
            List list3 = list;
            Option checkBasicNetworking_dnsErr = option;
            List checkBasicNetworking_validatedAddresses = list3;
            void checkBasicNetworking_dnsErr2 = var11_17;
            void checkBasicNetworking_validatedAddresses2 = var12_18;
            UnavailableLinkReason reason = (UnavailableLinkReason)checkBasicNetworking_dnsErr2.getOrElse(() -> ClusterLinkConnectionChecker$.$anonfun$checkBasicNetworking$1((List)checkBasicNetworking_validatedAddresses2, config));
            ClusterLinkError clusterLinkError = reason.clusterLinkError();
            ClusterLinkError clusterLinkError2 = ClusterLinkError.UNKNOWN;
            if (!(clusterLinkError != null ? !clusterLinkError.equals(clusterLinkError2) : clusterLinkError2 != null) && apiException instanceof TimeoutException) {
                if (this.isSecuritySettingsMissingForCloudLink(config, linkMetrics, connectionToRemoteCluster)) {
                    return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                }
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, new TimeoutUnavailableLinkReason(config)));
            }
            return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, reason));
        }
    }

    public DescribeClusterResult doBasicDescribeCluster(ClusterLinkBatchAdmin admin) {
        return admin.describeCluster();
    }

    public boolean isSecuritySettingsMissingForCloudLink(ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster) {
        boolean bl;
        ClusterLinkFactory.LinkMetrics clusterLinkMetrics;
        if (linkMetrics instanceof Some && (clusterLinkMetrics = (ClusterLinkFactory.LinkMetrics)((Some)linkMetrics).value()) instanceof ClusterLinkMetrics) {
            LinkType linkType = ((ClusterLinkMetrics)clusterLinkMetrics).linkType();
            LinkType$Cloud$ linkType$Cloud$ = LinkType$Cloud$.MODULE$;
            bl = !(linkType != null ? !linkType.equals(linkType$Cloud$) : linkType$Cloud$ != null);
        } else {
            bl = false;
        }
        return bl && connectionToRemoteCluster && (this.isSecurityConfigNull(config, "security.protocol", this.isSecurityConfigNull$default$3()) || this.isSecurityConfigNull(config, "sasl.mechanism", this.isSecurityConfigNull$default$3()) || this.isSecurityConfigNull(config, "sasl.jaas.config", true));
    }

    private boolean isSecurityConfigNull(ClusterLinkConfig config, String securityConfig, boolean isPasswordConfig) {
        boolean configIsNull;
        boolean bl = configIsNull = securityConfig == null;
        if (!configIsNull) {
            String string = isPasswordConfig ? config.getPassword(securityConfig).value() : config.getString(securityConfig);
            String string2 = "null";
            return string != null && string.equals(string2);
        }
        return configIsNull;
    }

    private boolean isSecurityConfigNull$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private UnavailableLinkReason checkBasicNetworking(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        void var5_13;
        void var4_12;
        List list;
        Option option;
        block8: {
            List list2;
            List<String> checkAddresses_bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
            String checkAddresses_dnsLookupConfig = config.getString("client.dns.lookup");
            ClientDnsLookup checkAddresses_dnsLookup = checkAddresses_dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)checkAddresses_dnsLookupConfig);
            ArrayList checkAddresses_invalidAddresses = new ArrayList();
            try {
                list2 = ClientUtils.parseAndValidateAddresses(checkAddresses_bootstrapServers, (ClientDnsLookup)checkAddresses_dnsLookup);
            }
            catch (ConfigException checkAddresses_ex) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(checkAddresses_ex)));
                }
                option = Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config));
                list = null;
                break block8;
            }
            catch (Throwable checkAddresses_ex) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(checkAddresses_ex)));
                }
                option = Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
                list = null;
                break block8;
            }
            List checkAddresses_validatedAddresses = list2;
            ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(checkAddresses_validatedAddresses).asScala()).foreach((Function1 & Serializable & scala.Serializable)inetSocketAddress -> {
                if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                    return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
                }
                return BoxedUnit.UNIT;
            });
            if (!checkAddresses_invalidAddresses.isEmpty()) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(checkAddresses_invalidAddresses)));
                }
                option = Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config));
                list = null;
            } else {
                option = None$.MODULE$;
                list = checkAddresses_validatedAddresses;
            }
        }
        List list3 = list;
        Option dnsErr = option;
        List validatedAddresses = list3;
        void dnsErr2 = var4_12;
        void validatedAddresses2 = var5_13;
        return (UnavailableLinkReason)dnsErr2.getOrElse(() -> ClusterLinkConnectionChecker$.$anonfun$checkBasicNetworking$1((List)validatedAddresses2, config));
    }

    public Option<UnavailableLinkReason> checkTcpConnection(List<InetSocketAddress> validatedAddresses, ClusterLinkConfig config) {
        try {
            this.tryTcpConnectionToBootstrapServers(validatedAddresses);
            return None$.MODULE$;
        }
        catch (ConnectException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$1(ex)));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (SocketTimeoutException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$2(ex)));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (BindException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$3(ex)));
            }
            return Option$.MODULE$.apply((Object)new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$4(ex)));
            }
            return Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config));
        }
    }

    public Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> checkAddresses(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        List list;
        List<String> bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
        String dnsLookupConfig = config.getString("client.dns.lookup");
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)dnsLookupConfig);
        ArrayList invalidAddresses = new ArrayList();
        try {
            list = ClientUtils.parseAndValidateAddresses(bootstrapServers, (ClientDnsLookup)dnsLookup);
        }
        catch (ConfigException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(ex)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnresolvableBootstrapUnavailableLinkReason(config)), null);
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(ex)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new UnknownUnavailableLinkReason(config)), null);
        }
        List validatedAddresses = list;
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(validatedAddresses).asScala()).foreach((Function1 & Serializable & scala.Serializable)inetSocketAddress -> {
            if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                return BoxesRunTime.boxToBoolean((boolean)checkBasicNetworking_checkAddresses_invalidAddresses.add(inetSocketAddress));
            }
            return BoxedUnit.UNIT;
        });
        if (!invalidAddresses.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(invalidAddresses)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)), null);
        }
        return new Tuple2((Object)None$.MODULE$, (Object)validatedAddresses);
    }

    private void tryTcpConnectionToBootstrapServers(List<InetSocketAddress> validatedAddresses) {
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(validatedAddresses).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$2(endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public int tcpConnectionTimeoutsMs() {
        return 5000;
    }

    public static final /* synthetic */ String $anonfun$check$1(Throwable ex$1, ApiException apiException$1) {
        return new StringBuilder(67).append("Failed to contact remote cluster with exception ").append(ex$1).append(" and api exception ").append(apiException$1).toString();
    }

    public static final /* synthetic */ UnavailableLinkReason $anonfun$checkBasicNetworking$1(List validatedAddresses$1, ClusterLinkConfig config$1) {
        return (UnavailableLinkReason)MODULE$.checkTcpConnection(validatedAddresses$1, config$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> new UnknownUnavailableLinkReason(config$1));
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$1(ConnectException ex$2) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$2(SocketTimeoutException ex$3) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$3).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$3(BindException ex$4) {
        return new StringBuilder(27).append("Failed to bind to endpoint ").append(ex$4).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$4(Throwable ex$5) {
        return new StringBuilder(53).append("Failed to connect to endpoint with unknown exception ").append(ex$5).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$1(ConfigException ex$6) {
        return new StringBuilder(23).append("Failed to validate DNS ").append((Object)ex$6).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$2(Throwable ex$7) {
        return new StringBuilder(49).append("Failed to validate DNS with an unknown exception ").append(ex$7).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$4(ArrayList invalidAddresses$1) {
        return new StringBuilder(95).append("Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: ").append(invalidAddresses$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$tryTcpConnectionToBootstrapServers$1(InetSocketAddress check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$tryTcpConnectionToBootstrapServers$2(InetSocketAddress endpoint) {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(endpoint, MODULE$.tcpConnectionTimeoutsMs());
        }
    }

    private ClusterLinkConnectionChecker$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

