/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.AclLimitExceededTaskErrorCode$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSyncAcls$;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.SecurityDisabledTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005b\u0001B,Y\u0001}C\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t!\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005U\"Aa\u000e\u0001BC\u0002\u0013\u0005q\u000e\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003q\u0011!9\bA!b\u0001\n\u0003A\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0011u\u0004!\u0011!Q\u0001\nyD\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u000e\u0001\u0011)\u0019!C\u0001\u0003\u001fA!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u00111\tI\u0002\u0001B\u0001B\u0003%\u00111DA\u001b\u00111\t9\u0004\u0001B\u0001B\u0003%\u0011\u0011HA!\u0011)\t\u0019\u0005\u0001BC\u0002\u0013\u0005\u0011Q\t\u0005\u000b\u0003'\u0002!\u0011!Q\u0001\n\u0005\u001d\u0003BCA+\u0001\t\u0005\t\u0015!\u0003\u0002X!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003\"CA=\u0001\u0001\u0007I\u0011BA>\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0015BA?\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)\n\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAL\u0011%\t\t\u000b\u0001b\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAS\u0011%\t9\f\u0001a\u0001\n\u0013\tI\fC\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"A\u0011\u0011\u0019\u0001!B\u0013\t9\u0006C\u0005\u0002D\u0002\u0001\r\u0011\"\u0003\u0002F!I\u0011Q\u0019\u0001A\u0002\u0013%\u0011q\u0019\u0005\t\u0003\u0017\u0004\u0001\u0015)\u0003\u0002H!I\u0011Q\u001a\u0001A\u0002\u0013%\u0011q\u001a\u0005\n\u0003;\u0004\u0001\u0019!C\u0005\u0003?D\u0001\"a9\u0001A\u0003&\u0011\u0011\u001b\u0005\n\u0003[\u0004!\u0019!C\u0005\u0003_D\u0001\"a>\u0001A\u0003%\u0011\u0011\u001f\u0005\n\u0003s\u0004!\u0019!C\u0005\u0003wD\u0001Ba,\u0001A\u0003%\u0011Q \u0005\b\u0005c\u0003A\u0011\u000bBZ\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u0017DqAa:\u0001\t\u0013\u0011I\u000fC\u0004\u0003l\u0002!IA!<\t\u000f\tM\b\u0001\"\u0003\u0003v\"9!1 \u0001\u0005\n\tu\bbBB\u0001\u0001\u0011%11\u0001\u0005\b\u0007[\u0001A\u0011BB\u0018\u0011\u001d\u00199\u0005\u0001C\u0005\u0007\u0013Bqaa\u0015\u0001\t\u0013\u0019)\u0006C\u0004\u0004d\u0001!Ia!\u001a\t\u000f\rU\u0004\u0001\"\u0003\u0004x!A1\u0011\u0012\u0001\u0005\u0002a\u001bY\tC\u0004\u0004&\u0002!Iaa*\t\u000f\rE\u0006\u0001\"\u0003\u00044\"91q\u0019\u0001\u0005B\t\u001d\u0006bBBe\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0007\u0017\u0004A\u0011ABg\u0011\u001d\u0019\u0019\u000e\u0001C\u0001\u0003\u000bBqa!6\u0001\t#\u001a9\u000eC\u0004\u0004d\u0002!Ia!:\t\u000f\r%\b\u0001\"\u0011\u0004l\"91Q\u001e\u0001\u0005\u0002\r=\b\u0002CBy\u0001\u0011\u0005\u0001la=\u0007\r\t\u0005\u0001\u0001\u0002B\u0002\u0011)\u0011YA\u0010B\u0001B\u0003%!Q\u0002\u0005\b\u0003;rD\u0011\u0001B\n\u0011%\u00119B\u0010a\u0001\n\u0003\tI\fC\u0005\u0003\u001ay\u0002\r\u0011\"\u0001\u0003\u001c!A!q\u0004 !B\u0013\t9\u0006C\u0005\u0003\"y\u0002\r\u0011\"\u0001\u0003$!I!Q\u0006 A\u0002\u0013\u0005!q\u0006\u0005\t\u0005gq\u0004\u0015)\u0003\u0003&!I!Q\u0007 A\u0002\u0013%!q\u0007\u0005\n\u0005wq\u0004\u0019!C\u0005\u0005{A\u0001B!\u0011?A\u0003&!\u0011\b\u0005\n\u0005\u0007r$\u0019!C\u0005\u0005\u000bB\u0001B!\u0019?A\u0003%!q\t\u0005\b\u0005GrD\u0011\u0001B3\u0011\u001d\u0011\tJ\u0010C\u0001\u0005'CqA!*?\t\u0013\u00119\u000bC\u0004\u0003*z\"\tAa+\t\u000f\t5f\b\"\u0003\u0003(\"q1q\u001f\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0004z\u0006Ur!CB~1\u0006\u0005\t\u0012AB\u007f\r!9\u0006,!A\t\u0002\r}\bbBA/'\u0012\u0005A\u0011\u0001\u0005\n\t\u0007\u0019\u0016\u0013!C\u0001\t\u000bA\u0011\u0002b\u0007T#\u0003%\t\u0001\"\b\u0003'\rcWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:\u000b\u0005eS\u0016\u0001\u00027j].T!a\u0017/\u0002\rM,'O^3s\u0015\u0005i\u0016!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0004\"!Y3\u000f\u0005\t\u001cW\"\u0001-\n\u0005\u0011D\u0016\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002gO\na\u0001+\u001a:j_\u0012L7\rV1tW*\u0011A\rW\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0016\u0003)\u0004\"AY6\n\u00051D&\u0001H\"mkN$XM\u001d'j].$Um\u001d;DY&,g\u000e^'b]\u0006<WM]\u0001\u000fG2LWM\u001c;NC:\fw-\u001a:!\u0003!a\u0017N\\6ECR\fW#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005Md\u0016A\u0001>l\u0013\t)(OA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003%a\u0017N\\6ECR\f\u0007%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\u0005I\bC\u00012{\u0013\tY\bL\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005Y!/Z7pi\u0016\fE-\\5o!\t\u0011w0C\u0002\u0002\u0002a\u0013Qc\u00117vgR,'\u000fT5oW\n\u000bGo\u00195BI6Lg.\u0001\u0006m_\u000e\fG.\u00113nS:\fq!\\3ue&\u001c7\u000fE\u0002c\u0003\u0013I1!a\u0003Y\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u00027\u0005\u001cGNQ5oI&twMR5mi\u0016\u0014HK]1og\u001a|'/\\3s+\t\t\t\u0002E\u0002c\u0003'I1!!\u0006Y\u0005m\t5\r\u001c\"j]\u0012Lgn\u001a$jYR,'\u000f\u0016:b]N4wN]7fe\u0006a\u0012m\u00197CS:$\u0017N\\4GS2$XM\u001d+sC:\u001chm\u001c:nKJ\u0004\u0013\u0001\u0002;j[\u0016\u0004B!!\b\u000225\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0003vi&d7O\u0003\u0003\u0002&\u0005\u001d\u0012AB2p[6|gNC\u0002^\u0003SQA!a\u000b\u0002.\u00051\u0011\r]1dQ\u0016T!!a\f\u0002\u0007=\u0014x-\u0003\u0003\u00024\u0005}!\u0001\u0002+j[\u0016L1!!\u0007f\u0003\u0015\tXo\u001c;b!\u0011\tY$!\u0010\u000e\u0003iK1!a\u0010[\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-C\u0002\u00028\u0015\f\u0001%Y2m\r&dG/\u001a:XSRD'+Z:pkJ\u001cW-\u00133Qe&t7-\u001b9bYV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0011\u0011QJ\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003#\nYEA\u0004C_>dW-\u00198\u0002C\u0005\u001cGNR5mi\u0016\u0014x+\u001b;i%\u0016\u001cx.\u001e:dK&#\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u0013\t\fGo\u00195TSj,\u0007\u0003BA%\u00033JA!a\u0017\u0002L\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)a\t\t'a\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002t\u0005U\u0014q\u000f\t\u0003E\u0002AQ\u0001[\tA\u0002)DQA\\\tA\u0002ADQa^\tA\u0002eDQ!`\tA\u0002yDa!a\u0001\u0012\u0001\u0004q\bbBA\u0003#\u0001\u0007\u0011q\u0001\u0005\b\u0003\u001b\t\u0002\u0019AA\t\u0011\u001d\tI\"\u0005a\u0001\u00037Aq!a\u000e\u0012\u0001\u0004\tI\u0004C\u0005\u0002DE\u0001\n\u00111\u0001\u0002H!I\u0011QK\t\u0011\u0002\u0003\u0007\u0011qK\u0001\u0007G>tg-[4\u0016\u0005\u0005u\u0004c\u00012\u0002\u0000%\u0019\u0011\u0011\u0011-\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!a\"\u0002\u000eB!\u0011\u0011JAE\u0013\u0011\tY)a\u0013\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001f\u001b\u0012\u0011!a\u0001\u0003{\n1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001\\5oW&#WCAAL!\u0011\tI*a'\u000e\u0005\u0005\r\u0012\u0002BAO\u0003G\u0011A!V;jI\u00069A.\u001b8l\u0013\u0012\u0004\u0013\u0001D1dY2Kgn[%e'\u0016$XCAAS!\u0019\t9+!-\u0002\u00186\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+\u0001\u0003vi&d'BAAX\u0003\u0011Q\u0017M^1\n\t\u0005M\u0016\u0011\u0016\u0002\u0004'\u0016$\u0018!D1dY2Kgn[%e'\u0016$\b%\u0001\tuCN\\7oT;ugR\fg\u000eZ5oOV\u0011\u0011qK\u0001\u0015i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F%Z9\u0015\t\u0005\u001d\u0015q\u0018\u0005\n\u0003\u001fS\u0012\u0011!a\u0001\u0003/\n\u0011\u0003^1tWN|U\u000f^:uC:$\u0017N\\4!\u0003-Ig.\u001b;jC2L'0\u001a3\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$B!a\"\u0002J\"I\u0011qR\u000f\u0002\u0002\u0003\u0007\u0011qI\u0001\rS:LG/[1mSj,G\rI\u0001\ti\u0006\u001c8\u000eR3tGV\u0011\u0011\u0011\u001b\t\u0007\u0003\u0013\n\u0019.a6\n\t\u0005U\u00171\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\t\fI.C\u0002\u0002\\b\u0013q\u0002V1tW\u0012+7o\u0019:jaRLwN\\\u0001\ri\u0006\u001c8\u000eR3tG~#S-\u001d\u000b\u0005\u0003\u000f\u000b\t\u000fC\u0005\u0002\u0010\u0002\n\t\u00111\u0001\u0002R\u0006IA/Y:l\t\u0016\u001c8\r\t\u0015\u0004C\u0005\u001d\b\u0003BA%\u0003SLA!a;\u0002L\tAao\u001c7bi&dW-A\ffq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\u001f\t\u0004E\u0006M\u0018bAA{1\n9R\t_2fgNLg/\u001a'pO\u001eLgn\u001a%b]\u0012dWM]\u0001\u0019Kb\u001cWm]:jm\u0016dunZ4j]\u001eD\u0015M\u001c3mKJ\u0004\u0013!F2sK\u0006$X-Q2m%\u0016$(/\u001f\"bG.|gMZ\u000b\u0003\u0003{\u00042!a@?\u001b\u0005\u0001!!F\"sK\u0006$X-Q2m%\u0016$(/\u001f\"bG.|gMZ\n\u0004}\t\u0015\u0001\u0003BA%\u0005\u000fIAA!\u0003\u0002L\t1\u0011I\\=SK\u001a\fqAY1dW>4g\r\u0005\u0003\u0002\u001e\t=\u0011\u0002\u0002B\t\u0003?\u0011!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gMR!\u0011Q B\u000b\u0011\u001d\u0011Y\u0001\u0011a\u0001\u0005\u001b\tQB]3uef\fE\u000f^3naR\u001c\u0018!\u0005:fiJL\u0018\t\u001e;f[B$8o\u0018\u0013fcR!\u0011q\u0011B\u000f\u0011%\tyIQA\u0001\u0002\u0004\t9&\u0001\bsKR\u0014\u00180\u0011;uK6\u0004Ho\u001d\u0011\u0002\u00179,\u0007\u0010\u001e*fiJLXj]\u000b\u0003\u0005K\u0001b!!\u0013\u0002T\n\u001d\u0002\u0003BA%\u0005SIAAa\u000b\u0002L\t!Aj\u001c8h\u0003=qW\r\u001f;SKR\u0014\u00180T:`I\u0015\fH\u0003BAD\u0005cA\u0011\"a$F\u0003\u0003\u0005\rA!\n\u0002\u00199,\u0007\u0010\u001e*fiJLXj\u001d\u0011\u0002+1LW.\u001b;WS>d\u0017\r^3e\u0003\u000ed7i\\;oiV\u0011!\u0011\b\t\u0007\u0003\u0013\n\u0019.a\u0016\u000231LW.\u001b;WS>d\u0017\r^3e\u0003\u000ed7i\\;oi~#S-\u001d\u000b\u0005\u0003\u000f\u0013y\u0004C\u0005\u0002\u0010\"\u000b\t\u00111\u0001\u0003:\u00051B.[7jiZKw\u000e\\1uK\u0012\f5\r\\\"pk:$\b%A\nj]Z\fG.\u001b3SKN|WO]2f\u0003\u000ed7/\u0006\u0002\u0003HA1!\u0011\nB*\u0005+j!Aa\u0013\u000b\t\t5#qJ\u0001\b[V$\u0018M\u00197f\u0015\u0011\u0011\t&a\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\n-\u0003\u0003\u0002B,\u0005;j!A!\u0017\u000b\t\tm\u00131E\u0001\u0004C\u000ed\u0017\u0002\u0002B0\u00053\u0012!\"Q2m\u0005&tG-\u001b8h\u0003QIgN^1mS\u0012\u0014Vm]8ve\u000e,\u0017i\u00197tA\u00051Q\u000f\u001d3bi\u0016$\u0002\"a\"\u0003h\t-$q\u000e\u0005\b\u0005Sb\u0005\u0019\u0001B$\u0003uqw\u000e^\"sK\u0006$X\rZ%om\u0006d\u0017\u000e\u001a*fg>,(oY3BG2\u001c\bb\u0002B7\u0019\u0002\u0007\u0011qK\u0001\u0015]>$8I]3bi\u0016$G)^3U_2KW.\u001b;\t\u000f\tED\n1\u0001\u0003t\u0005\tb-\u001b7uKJ,G-Q2m\u000bJ\u0014xN]:\u0011\r\tU$Q\u0011BF\u001d\u0011\u00119H!!\u000f\t\te$qP\u0007\u0003\u0005wR1A! _\u0003\u0019a$o\\8u}%\u0011\u0011QJ\u0005\u0005\u0005\u0007\u000bY%A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d%\u0011\u0012\u0002\u0004'\u0016\f(\u0002\u0002BB\u0003\u0017\u00022A\u0019BG\u0013\r\u0011y\t\u0017\u0002\u0014)\u0006\u001c8.\u0012:s_J\u001cu\u000eZ3B]\u0012l5oZ\u0001\u0014M&dG/\u001a:De\u0016\fG/\u00192mK\u0006\u001bGn\u001d\u000b\u0007\u0005+\u0013iJ!)\u0011\u0011\u0005%#q\u0013BN\u0005gJAA!'\u0002L\t1A+\u001e9mKJ\u0002bA!\u001e\u0003\u0006\nU\u0003b\u0002BP\u001b\u0002\u0007!1T\u0001\rC\u000ed7\u000fV8De\u0016\fG/\u001a\u0005\b\u0005Gk\u0005\u0019\u0001B\u0014\u0003\rqwn^\u0001\u0016[\u0006L(-Z%oGJ,W.\u001a8u\u0005\u0006\u001c7n\u001c4g)\t\t9)A\rdY\u0016\f'\u000fT5nSR,\u0005pY3fI\u0016$')Y2l_\u001a4GCAA$\u0003\u0015\u0019G.Z1s\u0003Y\u0019'/Z1uK\u0006\u001bGNU3uef\u0014\u0015mY6pM\u001a\u0004\u0013a\u0001:v]R\u0011!Q\u0017\t\u0005\u0005o\u0013)MD\u0002\u0003:\u000etAAa/\u0003D:!!Q\u0018Ba\u001d\u0011\u0011IHa0\n\u0003uK!a\u0017/\n\u0005eS\u0016b\u0001BdO\nQA+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u0011MLhnY!dYN$bA!.\u0003N\n]\u0007b\u0002BhO\u0001\u0007!\u0011[\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u00038\nM\u0017b\u0001BkO\nYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\u0011In\na\u0001\u00057\fQ\"Y2m\r&dG/\u001a:MSN$\bC\u0002B%\u0005;\u0014\t/\u0003\u0003\u0003`\n-#A\u0003'jgR\u0014UO\u001a4feB!!q\u000bBr\u0013\u0011\u0011)O!\u0017\u0003!\u0005\u001bGNQ5oI&twMR5mi\u0016\u0014\u0018!C1os\u001aKG\u000e^3s)\t\u0011\t/\u0001\fj]&$\u0018.\u00197ju\u0016$\u0006.\u001a8Ts:\u001c\u0017i\u00197t)\u0019\u0011)La<\u0003r\"9!qZ\u0015A\u0002\tE\u0007b\u0002BmS\u0001\u0007!1\\\u0001\u000bY&t7NR5mi\u0016\u0014H\u0003\u0002Bq\u0005oDqA!?+\u0001\u0004\u0011\t/A\u0005bG24\u0015\u000e\u001c;fe\u00069A.\u001b8l\u0003\u000edG\u0003\u0002B+\u0005\u007fDqAa\u0017,\u0001\u0004\u0011)&A\rdkJ\u0014XM\u001c;EKN$\u0018i\u00197t/&$\b\u000eT5oW&#GCBB\u0003\u0007'\u0019)\u0003\u0005\u0004\u0004\b\r=!Q\u000b\b\u0005\u0007\u0013\u0019Y\u0001\u0005\u0003\u0003z\u0005-\u0013\u0002BB\u0007\u0003\u0017\na\u0001\u0015:fI\u00164\u0017\u0002BAZ\u0007#QAa!\u0004\u0002L!91Q\u0003\u0017A\u0002\r]\u0011\u0001B1vi\"\u0004Ba!\u0007\u0004\"5\u001111\u0004\u0006\u0005\u0007;\u0019y\"\u0001\u0006bkRDwN]5{KJT1aWA\u0014\u0013\u0011\u0019\u0019ca\u0007\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0004\u0003Z2\u0002\raa\n\u0011\r\t%3\u0011\u0006Bq\u0013\u0011\u0019YCa\u0013\u0003\r\t+hMZ3s\u0003IA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\f5\r\\:\u0015\u0011\tU6\u0011GB\u001a\u0007kAqAa4.\u0001\u0004\u0011\t\u000eC\u0004\u0003Z6\u0002\rAa7\t\u000f\r]R\u00061\u0001\u0004:\u0005Qa-\u001e;ve\u0016d\u0015n\u001d;\u0011\r\t%#Q\\B\u001e!\u0019\tIj!\u0010\u0004B%!1qHA\u0012\u0005-Y\u0015MZ6b\rV$XO]3\u0011\r\u0005\u001d61\tB+\u0013\u0011\u0019)%!+\u0003\u0015\r{G\u000e\\3di&|g.A\fva\u0012\fG/Z!dYN|e\u000eR3ti&t\u0017\r^5p]RA!QWB&\u0007\u001b\u001ay\u0005C\u0004\u0003P:\u0002\rA!5\t\u000f\teg\u00061\u0001\u0003\\\"91\u0011\u000b\u0018A\u0002\r\u0015\u0011AC:pkJ\u001cW-Q2mg\u0006i\u0012\r\u001a3UQ\u0016tG)\u001a7fi\u0016\f5\r\\:UQ\u0016t7+\u001f8d\u0003\u000ed7\u000f\u0006\u0006\u00036\u000e]3\u0011LB/\u0007CBqAa40\u0001\u0004\u0011\t\u000eC\u0004\u0004\\=\u0002\rAa'\u00025I,W.Y5oS:<Gj\\2bY\u0006\u001bGn\u001d+p\u0007J,\u0017\r^3\t\u000f\r}s\u00061\u0001\u0003\u001c\u0006)\"/Z7bS:LgnZ!dYN$v\u000eR3mKR,\u0007b\u0002Bm_\u0001\u0007!1\\\u0001\u0018kB$\u0017\r^3BG2\u001cH)\u001a8z)\",g.\u00117m_^$\"B!.\u0004h\r%4QNB9\u0011\u001d\u0011y\r\ra\u0001\u0005#Dqaa\u001b1\u0001\u0004\u0011Y*A\u0011sK6\f\u0017N\\5oO\u0012+g._!oI\u0006cGn\\<BG2\u001cHk\\\"sK\u0006$X\rC\u0004\u0004pA\u0002\rAa'\u00025I,W.Y5oS:<\u0017\t\u001c7po\u0006\u001bGn\u001d+p\t\u0016dW\r^3\t\u000f\rM\u0004\u00071\u0001\u0003\u001c\u0006I\"/Z7bS:Lgn\u001a#f]f\f5\r\\:U_\u0012+G.\u001a;f\u0003)!W\r\\3uK\u0006\u001bGn\u001d\u000b\t\u0005k\u001bIha\u001f\u0004\u0000!9!qZ\u0019A\u0002\tE\u0007bBB?c\u0001\u0007!1T\u0001\rC\u000ed7\u000fV8EK2,G/\u001a\u0005\b\u0007\u0003\u000b\u0004\u0019ABB\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003CA%\u0007\u000b\u0013\tN!.\n\t\r\u001d\u00151\n\u0002\n\rVt7\r^5p]F\nQ\u0003[1oI2,\u0017i\u00197EK2,G/\u001a*fgVdG\u000f\u0006\u0005\u00036\u000e55qRBR\u0011\u001d\u0011yM\ra\u0001\u0005#Dqa!%3\u0001\u0004\u0019\u0019*\u0001\teK2,G/Z!dYN\u0014Vm];miB!1QSBP\u001b\t\u00199J\u0003\u0003\u0004\u001a\u000em\u0015!B1e[&t'\u0002BBO\u0003O\tqa\u00197jK:$8/\u0003\u0003\u0004\"\u000e]%\u0001\u0005#fY\u0016$X-Q2mgJ+7/\u001e7u\u0011\u001d\u0019\tI\ra\u0001\u0007\u0007\u000b!b\u0019:fCR,\u0017i\u00197t)!\u0011)l!+\u0004,\u000e=\u0006b\u0002Bhg\u0001\u0007!\u0011\u001b\u0005\b\u0007[\u001b\u0004\u0019\u0001BN\u0003\u001dqWm^!dYNDqa!!4\u0001\u0004\u0019\u0019)A\u000biC:$G.Z!dY\u000e\u0013X-\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0015\tU6QWB\\\u0007\u0003\u001c\u0019\rC\u0004\u0003PR\u0002\rA!5\t\u000f\reF\u00071\u0001\u0004<\u0006\u00012M]3bi\u0016\f5\r\\:SKN,H\u000e\u001e\t\u0005\u0007+\u001bi,\u0003\u0003\u0004@\u000e]%\u0001E\"sK\u0006$X-Q2mgJ+7/\u001e7u\u0011\u001d\u0011\t\b\u000ea\u0001\u0005gBqa!25\u0001\u0004\u0019\u0019)\u0001\u0005dC2d')Y2l\u0003!\u0019\b.\u001e;e_^t\u0017aF2veJ,g\u000e\u001e+bg.\u001cx*\u001e;ti\u0006tG-\u001b8h\u0003E!\u0018m]6t\u001fV$8\u000f^1oI&twm\u0018\u000b\u0005\u0003\u000f\u001by\rC\u0004\u0004R^\u0002\r!a\u0016\u0002\u0003Q\fQ\"[:J]&$\u0018.\u00197ju\u0016$\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BAD\u00073Dqaa7:\u0001\u0004\u0019i.\u0001\u0004sKN,H\u000e\u001e\t\u0004C\u000e}\u0017bABqO\n\u00192i\\7qY\u0016$X\r\u001a+bg.\u0014Vm];mi\u000612/\u001a;UCN\\7\u000b^1uK\u001a\u0013x.\u001c*fgVdG\u000f\u0006\u0003\u0002H\r\u001d\bbBBnu\u0001\u00071Q\\\u0001\u0010i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]R\u0011\u0011\u0011[\u0001\u000fY><w-\u001b8h\u0011\u0006tG\r\\3s)\t\t\t0\u0001\u0006sKR\u0014\u0018p\u0015;bi\u0016,\"a!>\u0011\u0011\u0005%#qSA,\u0005K\t!b];qKJ$C/[7f+\t\tY\"A\nDYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7\u000f\u0005\u0002c'N\u00191K!\u0002\u0015\u0005\ru\u0018\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\t\u000fQC!a\u0012\u0005\n-\u0012A1\u0002\t\u0005\t\u001b!9\"\u0004\u0002\u0005\u0010)!A\u0011\u0003C\n\u0003%)hn\u00195fG.,GM\u0003\u0003\u0005\u0016\u0005-\u0013AC1o]>$\u0018\r^5p]&!A\u0011\u0004C\b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192+\t!yB\u000b\u0003\u0002X\u0011%\u0001")
public class ClusterLinkSyncAcls
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final boolean aclFilterWithResourceIdPrincipal;
    private final int batchSize;
    private ClusterLinkConfig config;
    private final Uuid linkId;
    private final Set<Uuid> aclLinkIdSet;
    private int tasksOutstanding;
    private boolean initialized;
    private volatile Option<TaskDescription> taskDesc;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private final CreateAclRetryBackoff createAclRetryBackoff;

    public static int $lessinit$greater$default$11() {
        return ClusterLinkSyncAcls$.MODULE$.$lessinit$greater$default$11();
    }

    public static boolean $lessinit$greater$default$10() {
        return ClusterLinkSyncAcls$.MODULE$.$lessinit$greater$default$10();
    }

    public /* synthetic */ Time kafka$server$link$ClusterLinkSyncAcls$$super$time() {
        return super.time();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    public boolean aclFilterWithResourceIdPrincipal() {
        return this.aclFilterWithResourceIdPrincipal;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Set<Uuid> aclLinkIdSet() {
        return this.aclLinkIdSet;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private CreateAclRetryBackoff createAclRetryBackoff() {
        return this.createAclRetryBackoff;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName()) && this.config().aclSyncEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().aclFilters().isEmpty()) {
                String errMsg = new StringBuilder(106).append("ACL migration is enabled but acl.filters is not set. Please set acl.filters to ").append("proceed with ACL migration.").toString();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            }
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
            AclFiltersJson aclFilterJson = (AclFiltersJson)this.config().aclFilters().get();
            ListBuffer<AclBindingFilter> aclFilterList = AclJson$.MODULE$.toAclBindingFilters(aclFilterJson);
            if (!this.initialized()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Not initialized for ").append(this.linkId()).append(". Starting initialization process.").toString());
                return this.initializeThenSyncAcls(taskContext, aclFilterList);
            }
            return this.syncAcls(taskContext, aclFilterList);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult syncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        ListBuffer describeAclsFutureList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        aclFilterList.foreach((Function1 & Serializable & scala.Serializable)aclFilter -> {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve ACLs from source cluster");
            return describeAclsFutureList.$plus$eq((Object)$this.remoteAdmin.describeAcls((AclBindingFilter)aclFilter));
        });
        if (describeAclsFutureList.nonEmpty()) {
            ListBuffer futureList = (ListBuffer)describeAclsFutureList.map((Function1 & Serializable & scala.Serializable)result -> result.values(), ListBuffer$.MODULE$.canBuildFrom());
            KafkaFuture future = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futureList.toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
            this.scheduleWhenComplete(future, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleDescribeAcls((ClusterLinkScheduler.TaskContext)tc, aclFilterList, (ListBuffer<KafkaFuture<Collection<AclBinding>>>)futureList), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private AclBindingFilter anyFilter() {
        if (this.aclFilterWithResourceIdPrincipal()) {
            return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(MultiTenantPrincipal.WILDCARD_USERV2_PRINCIPAL.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        }
        return AclBindingFilter.ANY;
    }

    private ClusterLinkScheduler.TaskResult initializeThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList) {
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            scala.collection.immutable.Set<AclBinding> linkAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)((Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.anyFilter()}))));
            scala.collection.immutable.Set<AclBinding> matchingAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList);
            scala.collection.immutable.Set notMatchingLinkAclsToDelete = (scala.collection.immutable.Set)linkAcls.diff(matchingAcls);
            scala.collection.immutable.Set localAclsToCreate = (scala.collection.immutable.Set)notMatchingLinkAclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> {
                AccessControlEntry ace = acl.entry();
                AccessControlEntry linkAce = new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
                return new AclBinding(acl.pattern(), linkAce);
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
            return this.addThenDeleteAclsThenSyncAcls(taskContext, (Seq<AclBinding>)localAclsToCreate.toSeq(), (Seq<AclBinding>)notMatchingLinkAclsToDelete.toSeq(), aclFilterList);
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. Aborting initialization. No ACLs will be synced.";
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        }
        throw new MatchError(option);
    }

    private AclBindingFilter linkFilter(AclBindingFilter aclFilter) {
        AccessControlEntryFilter ace = aclFilter.entryFilter();
        AccessControlEntryFilter linkFilter = new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), this.aclLinkIdSet());
        return new AclBindingFilter(aclFilter.patternFilter(), linkFilter);
    }

    private AclBinding linkAcl(AclBinding acl) {
        Collection collection = acl.entry().clusterLinkIds();
        Set<Uuid> set = this.aclLinkIdSet();
        if (!(collection != null ? !((Object)collection).equals(set) : set != null)) {
            return acl;
        }
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, this.aclLinkIdSet());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclsWithLinkId(Authorizer auth, Buffer<AclBindingFilter> aclFilterList) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)aclFilterList.map((Function1 & Serializable & scala.Serializable)aclFilter -> this.linkFilter((AclBindingFilter)aclFilter), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)filter -> {
            AclBindingFilter transformedFilter = this.aclBindingFilterTransformer().transform((AclBindingFilter)filter);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Transformed filter from ").append(filter).append(" to ").append(transformedFilter).toString());
            return (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(auth.acls(transformedFilter)).asScala();
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    private ClusterLinkScheduler.TaskResult handleDescribeAcls(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, ListBuffer<KafkaFuture<Collection<AclBinding>>> futureList) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Seq bindingsAndErrors = ((ListBuffer)futureList.map((Function1 & Serializable & scala.Serializable)future -> {
            try {
                return new Tuple2((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)future.get()).asScala()).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), Iterable$.MODULE$.canBuildFrom())).toSeq(), (Object)None$.MODULE$);
            }
            catch (ExecutionException e) {
                KafkaException kafkaException;
                String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                $this.metrics.describeAclsFromSourceFailedSensor().record();
                Throwable throwable = e.getCause();
                if (throwable instanceof SecurityDisabledException) {
                    String errMsg = new StringBuilder(118).append(errMsgPrefix).append(" because no authorizer is configured on the source cluster. Please configure ").append("authorizer to proceed with ACL migration.").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(SecurityDisabledTaskErrorCode$.MODULE$, errMsg)));
                }
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)));
                }
                if (throwable instanceof AuthorizationException) {
                    String errMsg = new StringBuilder(110).append(errMsgPrefix).append(" due to authorization failure. ").append("Please enable DESCRIBE ACLs on the source cluster to proceed with ACL migration").toString();
                    this.excessiveLoggingHandler().handle(e, this, errMsg);
                    return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)));
                }
                String errMsg = new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString();
                this.excessiveLoggingHandler().handle(e, this, errMsg);
                return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
            }
            catch (Throwable e) {
                String errMsgPrefix = "Unable to retrieve ACLs on source cluster";
                $this.metrics.describeAclsFromSourceFailedSensor().record();
                String errMsg = new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString();
                this.excessiveLoggingHandler().handle(e, this, errMsg);
                return new Tuple2(null, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
            }
        }, ListBuffer$.MODULE$.canBuildFrom())).toSeq();
        Seq errs = (Seq)bindingsAndErrors.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable((Option)x$1._2()), Seq$.MODULE$.canBuildFrom());
        if (errs.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)errs, Seq$.MODULE$.canBuildFrom())));
        }
        scala.collection.immutable.Set sourceAcls = ((TraversableOnce)bindingsAndErrors.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2._1(), Seq$.MODULE$.canBuildFrom())).toSet();
        return this.updateAclsOnDestination(taskContext, aclFilterList, (scala.collection.immutable.Set<AclBinding>)sourceAcls);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult updateAclsOnDestination(ClusterLinkScheduler.TaskContext taskContext, ListBuffer<AclBindingFilter> aclFilterList, scala.collection.immutable.Set<AclBinding> sourceAcls) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Result of describeAcls on source cluster for ").append(this.linkId()).append(": ").append(sourceAcls).toString());
        Option<Authorizer> option = this.clientManager().getAuthorizer();
        if (option instanceof Some) {
            void var16_16;
            void var15_15;
            void var11_11;
            void var10_10;
            Authorizer auth = (Authorizer)((Some)option).value();
            scala.collection.immutable.Set<AclBinding> currentDestAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList);
            scala.collection.immutable.Set aclsToDelete = (scala.collection.immutable.Set)currentDestAcls.diff(sourceAcls);
            scala.collection.immutable.Set aclsToAdd = (scala.collection.immutable.Set)sourceAcls.diff(currentDestAcls);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Removing following ACLs on destination cluster: ").append(aclsToDelete).toString());
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Adding following ACLs on destination cluster: ").append(aclsToAdd).toString());
            Tuple2 tuple2 = aclsToDelete.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAcls.$anonfun$updateAclsOnDestination$4(x$3)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            scala.collection.immutable.Set denyAclsToDelete = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set allowAclsToDelete = (scala.collection.immutable.Set)tuple2._2();
            void denyAclsToDelete2 = var10_10;
            void allowAclsToDelete2 = var11_11;
            Tuple2 tuple22 = aclsToAdd.partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAcls.$anonfun$updateAclsOnDestination$5(x$5)));
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            scala.collection.immutable.Set denyAclsToAdd = (scala.collection.immutable.Set)tuple22._1();
            scala.collection.immutable.Set allowAclsToAdd = (scala.collection.immutable.Set)tuple22._2();
            void denyAclsToAdd2 = var15_15;
            void allowAclsToAdd2 = var16_16;
            return this.updateAclsDenyThenAllow(taskContext, (Seq<AclBinding>)((Seq)denyAclsToAdd2.toSeq().$plus$plus((GenTraversableOnce)allowAclsToAdd2.toSeq(), Seq$.MODULE$.canBuildFrom())), (Seq<AclBinding>)allowAclsToDelete2.toSeq(), (Seq<AclBinding>)denyAclsToDelete2.toSeq());
        }
        if (None$.MODULE$.equals(option)) {
            String errMsg = "No authorizer is configured on the destination broker. No ACLs will be synced.";
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult addThenDeleteAclsThenSyncAcls(ClusterLinkScheduler.TaskContext taskContext, Seq<AclBinding> remainingLocalAclsToCreate, Seq<AclBinding> remainingAclsToDelete, ListBuffer<AclBindingFilter> aclFilterList) {
        if (remainingLocalAclsToCreate.nonEmpty()) {
            void var18_13;
            void var17_12;
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = remainingLocalAclsToCreate.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toCreateNow = (Seq)tuple2._1();
            Seq toCreateLater = (Seq)tuple2._2();
            void toCreateNow2 = var6_6;
            void toCreateLater2 = var7_7;
            Function1 & Serializable & scala.Serializable createAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$addThenDeleteAclsThenSyncAcls$1(this, (Seq)toCreateLater2, remainingAclsToDelete, aclFilterList, arg_0);
            Tuple2<Seq<AclBinding>, Seq<TaskErrorCodeAndMsg>> tuple22 = this.createAclRetryBackoff().filterCreatableAcls((Seq<AclBinding>)toCreateNow2, super.time().milliseconds());
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Seq createAcls_aclsToCreate = (Seq)tuple22._1();
            Seq createAcls_filteredAclErrors = (Seq)tuple22._2();
            void createAcls_aclsToCreate2 = var17_12;
            void createAcls_filteredAclErrors2 = var18_13;
            if (createAcls_aclsToCreate2.nonEmpty()) {
                try {
                    List createAcls_aclsToCreateList = createAcls_aclsToCreate2.toList();
                    CreateAclsResult createAcls_createAclResult = this.localAdmin.createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)createAcls_aclsToCreateList).asJava());
                    Map createAcls_values = createAcls_createAclResult.values();
                    Iterable createAcls_createAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAcls_values).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)((Function1 & Serializable & scala.Serializable)arg_0 -> ClusterLinkSyncAcls.$anonfun$createAcls$1(this, createAcls_createAclResult, (Seq)createAcls_filteredAclErrors2, createAcls_callback, arg_0)), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable createAcls_e) {
                    String createAcls_errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(createAcls_errMsg).append(" ").append(createAcls_e).toString());
                    this.metrics.aclsAddFailedSensor().record((double)createAcls_aclsToCreate2.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, createAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            if (createAcls_filteredAclErrors2.nonEmpty()) {
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)createAcls_filteredAclErrors2, Seq$.MODULE$.canBuildFrom())));
            }
            ClusterLinkScheduler.TaskContext taskContext2 = taskContext;
            return this.addThenDeleteAclsThenSyncAcls(taskContext2, (Seq<AclBinding>)((Seq)toCreateLater2), (Seq<AclBinding>)remainingAclsToDelete, (ListBuffer<AclBindingFilter>)aclFilterList);
        }
        if (remainingAclsToDelete.nonEmpty()) {
            void var12_25;
            void var11_24;
            Tuple2 tuple2 = remainingAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toDeleteNow = (Seq)tuple2._1();
            Seq toDeleteLater = (Seq)tuple2._2();
            void toDeleteNow2 = var11_24;
            void toDeleteLater2 = var12_25;
            Function1 & Serializable & scala.Serializable deleteAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$addThenDeleteAclsThenSyncAcls$2(this, remainingLocalAclsToCreate, (Seq)toDeleteLater2, aclFilterList, arg_0);
            if (toDeleteNow2.nonEmpty()) {
                try {
                    List deleteAcls_deleteAclsFilterList = ((TraversableOnce)toDeleteNow2.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Seq$.MODULE$.canBuildFrom())).toList();
                    DeleteAclsResult deleteAcls_deleteAclsResult = this.localAdmin.deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAcls_deleteAclsFilterList).asJava());
                    Iterable deleteAcls_deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAcls_deleteAclsResult.values()).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable deleteAcls_e) {
                    String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(deleteAcls_errMsg).append(" ").append(deleteAcls_e).toString());
                    this.metrics.aclsDeletedSensor().record((double)toDeleteNow2.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            ClusterLinkScheduler.TaskContext taskContext3 = taskContext;
            return this.addThenDeleteAclsThenSyncAcls(taskContext3, (Seq<AclBinding>)remainingLocalAclsToCreate, (Seq<AclBinding>)((Seq)toDeleteLater2), (ListBuffer<AclBindingFilter>)aclFilterList);
        }
        this.initialized_$eq(true);
        return this.syncAcls(taskContext, aclFilterList);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult updateAclsDenyThenAllow(ClusterLinkScheduler.TaskContext taskContext, Seq<AclBinding> remainingDenyAndAllowAclsToCreate, Seq<AclBinding> remainingAllowAclsToDelete, Seq<AclBinding> remainingDenyAclsToDelete) {
        boolean bl = remainingAllowAclsToDelete.nonEmpty() || remainingDenyAclsToDelete.nonEmpty() ? this.createAclRetryBackoff().clearLimitExceededBackoff() || remainingDenyAndAllowAclsToCreate.isEmpty() : false;
        if (bl) {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = ((Seq)remainingAllowAclsToDelete.$plus$plus(remainingDenyAclsToDelete, Seq$.MODULE$.canBuildFrom())).splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toDeleteNow = (Seq)tuple2._1();
            Seq toDeleteLater = (Seq)tuple2._2();
            void toDeleteNow2 = var6_6;
            void toDeleteLater2 = var7_7;
            Function1 & Serializable & scala.Serializable deleteAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$updateAclsDenyThenAllow$1(this, remainingDenyAndAllowAclsToCreate, (Seq)toDeleteLater2, arg_0);
            if (toDeleteNow2.nonEmpty()) {
                try {
                    List deleteAcls_deleteAclsFilterList = ((TraversableOnce)toDeleteNow2.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Seq$.MODULE$.canBuildFrom())).toList();
                    DeleteAclsResult deleteAcls_deleteAclsResult = this.localAdmin.deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAcls_deleteAclsFilterList).asJava());
                    Iterable deleteAcls_deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAcls_deleteAclsResult.values()).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable deleteAcls_e) {
                    String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(deleteAcls_errMsg).append(" ").append(deleteAcls_e).toString());
                    this.metrics.aclsDeletedSensor().record((double)toDeleteNow2.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            ClusterLinkScheduler.TaskContext taskContext2 = taskContext;
            return this.updateAclsDenyThenAllow(taskContext2, (Seq<AclBinding>)remainingDenyAndAllowAclsToCreate, (Seq<AclBinding>)((Seq)toDeleteLater2), (Seq<AclBinding>)Nil$.MODULE$);
        }
        if (remainingAllowAclsToDelete.nonEmpty()) {
            void var12_19;
            void var11_18;
            Tuple2 tuple2 = remainingAllowAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toDeleteNow = (Seq)tuple2._1();
            Seq toDeleteLater = (Seq)tuple2._2();
            void toDeleteNow3 = var11_18;
            void toDeleteLater3 = var12_19;
            Function1 & Serializable & scala.Serializable deleteAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$updateAclsDenyThenAllow$2(this, remainingDenyAndAllowAclsToCreate, (Seq)toDeleteLater3, remainingDenyAclsToDelete, arg_0);
            if (toDeleteNow3.nonEmpty()) {
                try {
                    List deleteAcls_deleteAclsFilterList = ((TraversableOnce)toDeleteNow3.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Seq$.MODULE$.canBuildFrom())).toList();
                    DeleteAclsResult deleteAcls_deleteAclsResult = this.localAdmin.deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAcls_deleteAclsFilterList).asJava());
                    Iterable deleteAcls_deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAcls_deleteAclsResult.values()).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable deleteAcls_e) {
                    String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(deleteAcls_errMsg).append(" ").append(deleteAcls_e).toString());
                    this.metrics.aclsDeletedSensor().record((double)toDeleteNow3.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            ClusterLinkScheduler.TaskContext taskContext3 = taskContext;
            return this.updateAclsDenyThenAllow(taskContext3, (Seq<AclBinding>)remainingDenyAndAllowAclsToCreate, (Seq<AclBinding>)((Seq)toDeleteLater3), (Seq<AclBinding>)remainingDenyAclsToDelete);
        }
        if (remainingDenyAndAllowAclsToCreate.nonEmpty()) {
            void var40_37;
            void var39_36;
            void var17_31;
            void var16_30;
            Tuple2 tuple2 = remainingDenyAndAllowAclsToCreate.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toCreateNow = (Seq)tuple2._1();
            Seq toCreateLater = (Seq)tuple2._2();
            void toCreateNow2 = var16_30;
            void toCreateLater2 = var17_31;
            Function1 & Serializable & scala.Serializable createAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$updateAclsDenyThenAllow$3(this, (Seq)toCreateLater2, remainingAllowAclsToDelete, remainingDenyAclsToDelete, arg_0);
            Tuple2<Seq<AclBinding>, Seq<TaskErrorCodeAndMsg>> tuple22 = this.createAclRetryBackoff().filterCreatableAcls((Seq<AclBinding>)toCreateNow2, super.time().milliseconds());
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Seq createAcls_aclsToCreate = (Seq)tuple22._1();
            Seq createAcls_filteredAclErrors = (Seq)tuple22._2();
            void createAcls_aclsToCreate2 = var39_36;
            void createAcls_filteredAclErrors2 = var40_37;
            if (createAcls_aclsToCreate2.nonEmpty()) {
                try {
                    List createAcls_aclsToCreateList = createAcls_aclsToCreate2.toList();
                    CreateAclsResult createAcls_createAclResult = this.localAdmin.createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)createAcls_aclsToCreateList).asJava());
                    Map createAcls_values = createAcls_createAclResult.values();
                    Iterable createAcls_createAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAcls_values).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)((Function1 & Serializable & scala.Serializable)arg_0 -> ClusterLinkSyncAcls.$anonfun$createAcls$1(this, createAcls_createAclResult, (Seq)createAcls_filteredAclErrors2, createAcls_callback, arg_0)), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable createAcls_e) {
                    String createAcls_errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(createAcls_errMsg).append(" ").append(createAcls_e).toString());
                    this.metrics.aclsAddFailedSensor().record((double)createAcls_aclsToCreate2.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, createAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            if (createAcls_filteredAclErrors2.nonEmpty()) {
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)createAcls_filteredAclErrors2, Seq$.MODULE$.canBuildFrom())));
            }
            ClusterLinkScheduler.TaskContext taskContext4 = taskContext;
            return this.updateAclsDenyThenAllow(taskContext4, (Seq<AclBinding>)((Seq)toCreateLater2), (Seq<AclBinding>)remainingAllowAclsToDelete, (Seq<AclBinding>)remainingDenyAclsToDelete);
        }
        if (remainingDenyAclsToDelete.nonEmpty()) {
            void var22_49;
            void var21_48;
            Tuple2 tuple2 = remainingDenyAclsToDelete.splitAt(this.batchSize);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq toDeleteNow = (Seq)tuple2._1();
            Seq toDeleteLater = (Seq)tuple2._2();
            void toDeleteNow4 = var21_48;
            void toDeleteLater4 = var22_49;
            Function1 & Serializable & scala.Serializable deleteAcls_callback = arg_0 -> ClusterLinkSyncAcls.$anonfun$updateAclsDenyThenAllow$4(this, remainingDenyAndAllowAclsToCreate, remainingAllowAclsToDelete, (Seq)toDeleteLater4, arg_0);
            if (toDeleteNow4.nonEmpty()) {
                try {
                    List deleteAcls_deleteAclsFilterList = ((TraversableOnce)toDeleteNow4.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Seq$.MODULE$.canBuildFrom())).toList();
                    DeleteAclsResult deleteAcls_deleteAclsResult = this.localAdmin.deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAcls_deleteAclsFilterList).asJava());
                    Iterable deleteAcls_deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAcls_deleteAclsResult.values()).asScala()).values();
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAcls_deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
                }
                catch (Throwable deleteAcls_e) {
                    String deleteAcls_errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(deleteAcls_errMsg).append(" ").append(deleteAcls_e).toString());
                    this.metrics.aclsDeletedSensor().record((double)toDeleteNow4.size());
                    return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, deleteAcls_errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
                }
            }
            ClusterLinkScheduler.TaskContext taskContext5 = taskContext;
            return this.updateAclsDenyThenAllow(taskContext5, (Seq<AclBinding>)remainingDenyAndAllowAclsToCreate, (Seq<AclBinding>)remainingAllowAclsToDelete, (Seq<AclBinding>)((Seq)toDeleteLater4));
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult deleteAcls(ClusterLinkScheduler.TaskContext taskContext, Seq<AclBinding> aclsToDelete, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        if (aclsToDelete.nonEmpty()) {
            try {
                List deleteAclsFilterList = ((TraversableOnce)aclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Seq$.MODULE$.canBuildFrom())).toList();
                DeleteAclsResult deleteAclsResult = this.localAdmin.deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAclsFilterList).asJava());
                Iterable deleteAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> this.handleAclDeleteResult((ClusterLinkScheduler.TaskContext)tc, deleteAcls_deleteAclsResult, (Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)deleteAcls_callback), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to delete ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(deleteAcls_errMsg).append(" ").append(deleteAcls_e).toString());
                this.metrics.aclsDeletedSensor().record((double)aclsToDelete.size());
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
            }
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    public ClusterLinkScheduler.TaskResult handleAclDeleteResult(ClusterLinkScheduler.TaskContext taskContext, DeleteAclsResult deleteAclsResult, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Seq errs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                AclBindingFilter binding = (AclBindingFilter)x0$1._1();
                try {
                    java.util.List filters = ((DeleteAclsResult.FilterResults)((KafkaFuture)x0$1._2()).get()).values();
                    return (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(filters).asScala()).flatMap((Function1 & Serializable & scala.Serializable)aclBindingDeleteResult -> {
                        ApiException ex = aclBindingDeleteResult.exception();
                        if (ex != null) {
                            KafkaException kafkaException;
                            this.excessiveLoggingHandler().handle((Throwable)ex, this, new StringBuilder(64).append("Encountered the following exception while trying to delete ACL: ").append(aclBindingDeleteResult.exception()).toString());
                            $this.metrics.aclsDeleteFailedSensor().record();
                            String errMsgPrefix = new StringBuilder(29).append("Failed to delete ACL binding ").append(binding).toString();
                            Throwable throwable = ex.getCause();
                            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString())));
                            }
                            if (throwable instanceof AuthorizationException) {
                                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString())));
                            }
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString())));
                        }
                        $this.metrics.aclsDeletedSensor().record();
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }, Buffer$.MODULE$.canBuildFrom());
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to delete ACL");
                    $this.metrics.aclsDeleteFailedSensor().record();
                    String errMsgPrefix = new StringBuilder(29).append("Failed to delete ACL binding ").append(binding).toString();
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        return new .colon.colon((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString()), (List)Nil$.MODULE$);
                    }
                    if (throwable instanceof AuthorizationException) {
                        return new .colon.colon((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString()), (List)Nil$.MODULE$);
                    }
                    return new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString()), (List)Nil$.MODULE$);
                }
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (errs.nonEmpty()) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append(this.logIdent()).append("Failed to delete ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)errs, Seq$.MODULE$.canBuildFrom())));
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult createAcls(ClusterLinkScheduler.TaskContext taskContext, Seq<AclBinding> newAcls, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callback) {
        void var6_6;
        void var5_5;
        Tuple2<Seq<AclBinding>, Seq<TaskErrorCodeAndMsg>> tuple2 = this.createAclRetryBackoff().filterCreatableAcls(newAcls, super.time().milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq aclsToCreate = (Seq)tuple2._1();
        Seq filteredAclErrors = (Seq)tuple2._2();
        void aclsToCreate2 = var5_5;
        void filteredAclErrors2 = var6_6;
        if (aclsToCreate2.nonEmpty()) {
            try {
                List aclsToCreateList = aclsToCreate2.toList();
                CreateAclsResult createAclResult = this.localAdmin.createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)aclsToCreateList).asJava());
                Map values = createAclResult.values();
                Iterable createAclsResultFutures = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(values).asScala()).values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)((Function1 & Serializable & scala.Serializable)arg_0 -> ClusterLinkSyncAcls.$anonfun$createAcls$1(this, createAclResult, (Seq)filteredAclErrors2, callback, arg_0)), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            catch (Throwable e) {
                String errMsg = "Unexpected error encountered while trying to create ACLs on destination cluster";
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(createAcls_errMsg).append(" ").append(createAcls_e).toString());
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate2.size());
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
            }
        }
        if (filteredAclErrors2.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)filteredAclErrors2, Seq$.MODULE$.canBuildFrom())));
        }
        return (ClusterLinkScheduler.TaskResult)callback.apply((Object)taskContext);
    }

    private ClusterLinkScheduler.TaskResult handleAclCreateResult(ClusterLinkScheduler.TaskContext taskContext, CreateAclsResult createAclsResult, Seq<TaskErrorCodeAndMsg> filteredAclErrors, Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> callBack) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.mutable.Set invalidResourceAcls = Set$.MODULE$.empty();
        Seq errs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclsResult.values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                AclBinding binding = (AclBinding)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    $this.metrics.aclsAddedSensor().record();
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    $this.metrics.aclsAddFailedSensor().record();
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to create ACL");
                    String errMsgPrefix = new StringBuilder(29).append("Failed to create ACL binding ").append(binding).toString();
                    boolean bl = false;
                    InvalidRequestException invalidRequestException = null;
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString())));
                    }
                    if (throwable instanceof AuthorizationException) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString())));
                    }
                    if (throwable instanceof InvalidRequestException) {
                        bl = true;
                        invalidRequestException = (InvalidRequestException)throwable;
                        if (invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("ACLs not created since it will exceed the limit")) {
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, new StringBuilder(58).append(errMsgPrefix).append(" due to reaching the ACL limit on the destination cluster.").toString())));
                        }
                    }
                    if (bl && invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("Could not create ACLs because following resource names are invalid")) {
                        handleAclCreateResult_invalidResourceAcls.$plus$eq((Object)binding);
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, new StringBuilder(47).append(errMsgPrefix).append(" due to the ACL resource name(s) being invalid.").toString())));
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString())));
                }
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (errs.nonEmpty() || filteredAclErrors.nonEmpty()) {
            if (errs.nonEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Failed to create ").append(handleAclCreateResult_errs.size()).append(" ACLs.").toString());
            }
            if (filteredAclErrors.nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Filtered out ").append(filteredAclErrors$1.size()).append(" ACLs from create list due to backoff.").toString());
            }
            int limitExceeded = errs.count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$4(x$14)));
            this.createAclRetryBackoff().update((scala.collection.mutable.Set<AclBinding>)invalidResourceAcls, limitExceeded, filteredAclErrors);
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append(this.logIdent()).append("Failed to create ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)((TraversableLike)taskContext.errs().$plus$plus((GenTraversableOnce)errs, Seq$.MODULE$.canBuildFrom())).$plus$plus(filteredAclErrors, Seq$.MODULE$.canBuildFrom())));
        }
        return (ClusterLinkScheduler.TaskResult)callBack.apply((Object)taskContext);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Task ").append(this.getClass().getName()).append(" shutting down").toString());
    }

    public int currentTasksOutstanding() {
        return this.tasksOutstanding();
    }

    public void tasksOutstanding_(int t) {
        this.tasksOutstanding_$eq(t);
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.setTaskStateFromResult(result)) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    private boolean setTaskStateFromResult(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager().isLinkCoordinator(this.linkData().linkName())) {
            if (this.config().aclSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncAclsTaskType$.MODULE$, false, "run the sync acls task"));
                Option<TaskDescription> option = this.taskDesc();
                if (option instanceof Some) {
                    TaskState taskState = ((TaskDescription)((Some)option).value()).state();
                    ActiveTaskState$ activeTaskState$ = ActiveTaskState$.MODULE$;
                    return !(taskState != null ? !taskState.equals(activeTaskState$) : activeTaskState$ != null);
                }
                return false;
            }
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
            return true;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
        return true;
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public ExcessiveLoggingHandler loggingHandler() {
        return this.excessiveLoggingHandler();
    }

    public Tuple2<Object, Option<Object>> retryState() {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.createAclRetryBackoff().retryAttempts()), this.createAclRetryBackoff().nextRetryMs());
    }

    public static final /* synthetic */ boolean $anonfun$updateAclsOnDestination$4(AclBinding x$3) {
        AclPermissionType aclPermissionType = x$3.entry().permissionType();
        AclPermissionType aclPermissionType2 = AclPermissionType.DENY;
        return !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateAclsOnDestination$5(AclBinding x$5) {
        AclPermissionType aclPermissionType = x$5.entry().permissionType();
        AclPermissionType aclPermissionType2 = AclPermissionType.DENY;
        return !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null);
    }

    public static final /* synthetic */ ClusterLinkScheduler.TaskResult $anonfun$createAcls$1(ClusterLinkSyncAcls $this, CreateAclsResult createAclResult$1, Seq filteredAclErrors$1, Function1 callback$2, ClusterLinkScheduler.TaskContext tc) {
        $this.tasksOutstanding_$eq($this.tasksOutstanding() - 1);
        scala.collection.mutable.Set handleAclCreateResult_invalidResourceAcls = Set$.MODULE$.empty();
        Seq handleAclCreateResult_errs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclResult$1.values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                AclBinding binding = (AclBinding)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    $this.metrics.aclsAddedSensor().record();
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    $this.metrics.aclsAddFailedSensor().record();
                    this.excessiveLoggingHandler().handle(ex, this, "Unexpected error encountered while trying to create ACL");
                    String errMsgPrefix = new StringBuilder(29).append("Failed to create ACL binding ").append(binding).toString();
                    boolean bl = false;
                    InvalidRequestException invalidRequestException = null;
                    Throwable throwable = ex.getCause();
                    if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString())));
                    }
                    if (throwable instanceof AuthorizationException) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString())));
                    }
                    if (throwable instanceof InvalidRequestException) {
                        bl = true;
                        invalidRequestException = (InvalidRequestException)throwable;
                        if (invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("ACLs not created since it will exceed the limit")) {
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, new StringBuilder(58).append(errMsgPrefix).append(" due to reaching the ACL limit on the destination cluster.").toString())));
                        }
                    }
                    if (bl && invalidRequestException.getMessage() != null && invalidRequestException.getMessage().contains("Could not create ACLs because following resource names are invalid")) {
                        handleAclCreateResult_invalidResourceAcls.$plus$eq((Object)binding);
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, new StringBuilder(47).append(errMsgPrefix).append(" due to the ACL resource name(s) being invalid.").toString())));
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString())));
                }
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (handleAclCreateResult_errs.nonEmpty() || filteredAclErrors$1.nonEmpty()) {
            if (handleAclCreateResult_errs.nonEmpty()) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Failed to create ").append(handleAclCreateResult_errs.size()).append(" ACLs.").toString());
            }
            if (filteredAclErrors$1.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Filtered out ").append(filteredAclErrors$1.size()).append(" ACLs from create list due to backoff.").toString());
            }
            int handleAclCreateResult_limitExceeded = handleAclCreateResult_errs.count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$4(x$14)));
            $this.createAclRetryBackoff().update((scala.collection.mutable.Set<AclBinding>)handleAclCreateResult_invalidResourceAcls, handleAclCreateResult_limitExceeded, (Seq<TaskErrorCodeAndMsg>)filteredAclErrors$1);
            if ($this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append($this.logIdent()).append("Failed to create ACLs but there are still ").append($this.tasksOutstanding()).toString());
            }
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)((TraversableLike)tc.errs().$plus$plus((GenTraversableOnce)handleAclCreateResult_errs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)filteredAclErrors$1, Seq$.MODULE$.canBuildFrom())));
        }
        return (ClusterLinkScheduler.TaskResult)callback$2.apply((Object)tc);
    }

    public static final /* synthetic */ boolean $anonfun$handleAclCreateResult$4(TaskErrorCodeAndMsg x$14) {
        TaskErrorCode taskErrorCode = x$14.code();
        AclLimitExceededTaskErrorCode$ aclLimitExceededTaskErrorCode$ = AclLimitExceededTaskErrorCode$.MODULE$;
        return !(taskErrorCode != null ? !taskErrorCode.equals(aclLimitExceededTaskErrorCode$) : aclLimitExceededTaskErrorCode$ != null);
    }

    public ClusterLinkSyncAcls(ClusterLinkDestClientManager clientManager, ClusterLinkData linkData, ClusterLinkMetadataManager metadataManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, AclBindingFilterTransformer aclBindingFilterTransformer, Time time, ClusterLinkRequestQuota quota, boolean aclFilterWithResourceIdPrincipal, int batchSize) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.aclFilterWithResourceIdPrincipal = aclFilterWithResourceIdPrincipal;
        this.batchSize = batchSize;
        super(clientManager.scheduler(), "ClusterLinkSyncAcls", Predef$.MODULE$.Integer2int(clientManager.currentConfig().aclSyncMs()), time, quota);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(this.getClass().getSimpleName()).append("-").append(linkData.linkName()).append("] ").toString());
        this.config = clientManager.currentConfig();
        this.linkId = linkData.linkId();
        this.aclLinkIdSet = Collections.singleton(this.linkId());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
        this.excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        this.createAclRetryBackoff = new CreateAclRetryBackoff(this, this.config().aclSyncBackoff());
    }

    private class CreateAclRetryBackoff {
        private final ExponentialBackoff backoff;
        private int retryAttempts;
        private Option<Object> nextRetryMs;
        private Option<Object> limitViolatedAclCount;
        private final scala.collection.mutable.Set<AclBinding> invalidResourceAcls;
        public final /* synthetic */ ClusterLinkSyncAcls $outer;

        public int retryAttempts() {
            return this.retryAttempts;
        }

        public void retryAttempts_$eq(int x$1) {
            this.retryAttempts = x$1;
        }

        public Option<Object> nextRetryMs() {
            return this.nextRetryMs;
        }

        public void nextRetryMs_$eq(Option<Object> x$1) {
            this.nextRetryMs = x$1;
        }

        private Option<Object> limitViolatedAclCount() {
            return this.limitViolatedAclCount;
        }

        private void limitViolatedAclCount_$eq(Option<Object> x$1) {
            this.limitViolatedAclCount = x$1;
        }

        private scala.collection.mutable.Set<AclBinding> invalidResourceAcls() {
            return this.invalidResourceAcls;
        }

        public void update(scala.collection.mutable.Set<AclBinding> notCreatedInvalidResourceAcls, int notCreatedDueToLimit, Seq<TaskErrorCodeAndMsg> filteredAclErrors) {
            if (!this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().isInitialized()) {
                return;
            }
            if (notCreatedDueToLimit == 0 && notCreatedInvalidResourceAcls.isEmpty() && filteredAclErrors.isEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Clearing retry state after successful update");
                this.retryAttempts_$eq(0);
                this.nextRetryMs_$eq((Option<Object>)None$.MODULE$);
            }
            if (notCreatedDueToLimit > 0) {
                this.limitViolatedAclCount_$eq((Option<Object>)this.limitViolatedAclCount().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$15 -> x$15 + notCreatedDueToLimit).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)notCreatedDueToLimit))));
                this.maybeIncrementBackoff();
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Failed to create ").append(notCreatedDueToLimit).append(" ACLs due to ACL limit, ACL creation will be retried with exponential backoff for attempt #").append(this.retryAttempts()).append(" or when ACL count reduces.").toString());
            }
            if (notCreatedInvalidResourceAcls.nonEmpty()) {
                this.invalidResourceAcls().$plus$plus$eq(notCreatedInvalidResourceAcls);
                this.maybeIncrementBackoff();
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(128).append("Failed to create ").append(notCreatedInvalidResourceAcls).append(" ACLs due to invalid resources, Creation of these ACLs will be retried after exponential backoff for attempt #").append(this.retryAttempts()).append(".").toString());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Tuple2<Seq<AclBinding>, Seq<TaskErrorCodeAndMsg>> filterCreatableAcls(Seq<AclBinding> aclsToCreate, long now) {
            void var6_5;
            void var5_4;
            if (this.nextRetryMs().isEmpty()) {
                return new Tuple2(aclsToCreate, (Object)Nil$.MODULE$);
            }
            if (now >= BoxesRunTime.unboxToLong((Object)this.nextRetryMs().get())) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Clearing retry backoff state for ACL creation since backoff interval has elapsed.");
                this.clear();
                return new Tuple2(aclsToCreate, (Object)Nil$.MODULE$);
            }
            if (this.limitViolatedAclCount().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$16 -> x$16 > aclsToCreate.size())) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Clearing retry backoff state for limit exceeded error for ACL creation since new ACL count has reduced from ").append(this.limitViolatedAclCount().get()).append(" to ").append(aclsToCreate.size()).append(".").toString());
                this.clear();
                return new Tuple2(aclsToCreate, (Object)Nil$.MODULE$);
            }
            if (this.limitViolatedAclCount().nonEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Not creating ACLs due to limit exceeded retry backoff for ").append(BoxesRunTime.unboxToLong((Object)this.nextRetryMs().get()) - now).append(" more milliseconds.").toString());
                return new Tuple2((Object)Nil$.MODULE$, aclsToCreate.map((Function1 & Serializable & scala.Serializable)binding -> new TaskErrorCodeAndMsg(AclLimitExceededTaskErrorCode$.MODULE$, new StringBuilder(87).append("Failed to create ACL binding ").append(binding).append(" due to reaching the ACL limit on the destination cluster.").toString()), Seq$.MODULE$.canBuildFrom()));
            }
            Tuple2 tuple2 = aclsToCreate.partition((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)CreateAclRetryBackoff.$anonfun$filterCreatableAcls$6(this, elem)));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq invalid = (Seq)tuple2._1();
            Seq creatable = (Seq)tuple2._2();
            void invalid2 = var5_4;
            void creatable2 = var6_5;
            if (aclsToCreate.size() > creatable2.size()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> CreateAclRetryBackoff.$anonfun$filterCreatableAcls$7(this, aclsToCreate, (Seq)creatable2, now)));
            }
            return new Tuple2((Object)creatable2, invalid2.map((Function1 & Serializable & scala.Serializable)binding -> new TaskErrorCodeAndMsg(InvalidRequestErrorCode$.MODULE$, new StringBuilder(76).append("Failed to create ACL binding ").append(binding).append(" due to the ACL resource name(s) being invalid.").toString()), Seq$.MODULE$.canBuildFrom()));
        }

        private void maybeIncrementBackoff() {
            long now = this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().kafka$server$link$ClusterLinkSyncAcls$$super$time().milliseconds();
            if (this.nextRetryMs().forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$18 -> x$18 <= now)) {
                long nextBackoff = this.backoff.backoff((long)this.retryAttempts());
                this.nextRetryMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(now + nextBackoff))));
                this.retryAttempts_$eq(this.retryAttempts() + 1);
                return;
            }
        }

        public boolean clearLimitExceededBackoff() {
            if (this.limitViolatedAclCount().nonEmpty()) {
                this.kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Clearing retry backoff due to ACL limit since source ACLs have been deleted");
                this.clear();
                return true;
            }
            return false;
        }

        private void clear() {
            this.limitViolatedAclCount_$eq((Option<Object>)None$.MODULE$);
            this.invalidResourceAcls().clear();
        }

        public /* synthetic */ ClusterLinkSyncAcls kafka$server$link$ClusterLinkSyncAcls$CreateAclRetryBackoff$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$filterCreatableAcls$6(CreateAclRetryBackoff $this, AclBinding elem) {
            return $this.invalidResourceAcls().contains((Object)elem);
        }

        public static final /* synthetic */ String $anonfun$filterCreatableAcls$7(CreateAclRetryBackoff $this, Seq aclsToCreate$1, Seq creatable$1, long now$1) {
            return new StringBuilder(80).append("Not creating ").append(aclsToCreate$1.size() - creatable$1.size()).append(" ACLs due to invalid request retry backoff for ").append(BoxesRunTime.unboxToLong((Object)$this.nextRetryMs().get()) - now$1).append(" more milliseconds..").toString();
        }

        public CreateAclRetryBackoff(ClusterLinkSyncAcls $outer, ExponentialBackoff backoff) {
            this.backoff = backoff;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.retryAttempts = 0;
            this.nextRetryMs = None$.MODULE$;
            this.limitViolatedAclCount = None$.MODULE$;
            this.invalidResourceAcls = Set$.MODULE$.empty();
        }
    }
}

