/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.PartitionFence;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionFence
extends AbstractTierMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 48;
    private final TopicIdPartition topicIdPartition;
    private final PartitionFence metadata;

    public TierPartitionFence(TopicIdPartition topicIdPartition, UUID messageId, boolean freezeLogStartOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(48).forceDefaults(true);
        PartitionFence.startPartitionFence((FlatBufferBuilder)builder);
        PartitionFence.addVersion((FlatBufferBuilder)builder, (byte)1);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        PartitionFence.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        PartitionFence.addFreezeLogStartOffset((FlatBufferBuilder)builder, (boolean)freezeLogStartOffset);
        int entryId = PartitionFence.endPartitionFence((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionFence.getRootAsPartitionFence((ByteBuffer)builder.dataBuffer());
    }

    public TierPartitionFence(TopicIdPartition topicIdPartition, PartitionFence metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 48;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionFence;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    private byte version() {
        return this.metadata.version();
    }

    public boolean freezeLogStartOffset() {
        return this.metadata.freezeLogStartOffset();
    }

    public String toString() {
        return "TierPartitionFence(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", freezeLogStartOffset=" + this.freezeLogStartOffset() + ")";
    }
}

