/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.yammer.metrics.core.Counter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ValidateLogResult$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierLogCompactionFencedException$;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\rg\u0001\u0002#F\u00059C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005;\"AA\r\u0001BC\u0002\u0013\u0005S\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003g\u0011!Y\u0007A!b\u0001\n\u0003a\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011E\u0004!\u00111A\u0005\u0002ID!b!\u001b\u0001\u0005\u0003\u0007I\u0011AB6\u0011%\u0019y\u0007\u0001B\u0001B\u0003&1\u000f\u0003\u0006\u0002j\u0002\u0011)\u0019!C\u0001\u0007cB!ba\u001d\u0001\u0005\u0003\u0005\u000b\u0011BAv\u0011)\t\u0019\u0010\u0001B\u0001B\u0003%\u0011Q\u001f\u0005\b\u0003'\u0001A\u0011AB;\u0011\u001d\t9\u0002\u0001C!\u00033A\u0011ba!\u0001\u0005\u0004%\ta!\"\t\u0011\r\u001d\u0005\u0001)A\u0005\u00057C\u0011b!#\u0001\u0001\u0004%\taa#\t\u0013\r=\u0005\u00011A\u0005\u0002\rE\u0005\u0002CBK\u0001\u0001\u0006Ka!$\t\u000f\r}\u0005\u0001\"\u0001\u0004\"\"9\u0011\u0011\u000e\u0001\u0005B\r5\u0006b\u0002BU\u0001\u0011\u0005#1V\u0004\b\u0003\u0003)\u0005\u0012AA\u0002\r\u0019!U\t#\u0001\u0002\u0006!9\u00111\u0003\r\u0005\u0002\u0005U\u0001bBA\f1\u0011E\u0013\u0011\u0004\u0005\n\u0003WA\"\u0019!C\u0001\u0003[A\u0001\"!\u000e\u0019A\u0003%\u0011q\u0006\u0005\n\u0003oA\"\u0019!C\u0001\u0003[A\u0001\"!\u000f\u0019A\u0003%\u0011q\u0006\u0005\n\u0003wA\"\u0019!C\u0001\u0003{A\u0001\"a\u0013\u0019A\u0003%\u0011q\b\u0004\u000b\u0003\u001bB\u0002\u0013aI\u0011\u000b\u0006=\u0003bBA)C\u0019\u0005\u0011Q\u0006\u0005\b\u0003'\nc\u0011AA+\u0011\u001d\tI'\tD\u0001\u0003W2aA!\u0002\u0019\u0001\n\u001d\u0001BCA)K\tU\r\u0011\"\u0001\u0002.!Q!QC\u0013\u0003\u0012\u0003\u0006I!a\f\t\u0015\t]QE!f\u0001\n\u0003\u0011I\u0002\u0003\u0006\u0003\u001c\u0015\u0012\t\u0012)A\u0005\u0003/Bq!a\u0005&\t\u0003\u0011i\u0002C\u0004\u0002T\u0015\"\t%!\u0016\t\u000f\u0005%T\u0005\"\u0011\u0003&!9!qH\u0013\u0005\u0002\t\u0005\u0003b\u0002B:K\u0011%!Q\u000f\u0005\b\u0005\u000f+C\u0011\u0001BE\u0011\u001d\u0011I+\nC!\u0005WC\u0011B!,&\u0003\u0003%\tAa,\t\u0013\tUV%%A\u0005\u0002\t]\u0006\"\u0003BgKE\u0005I\u0011\u0001Bh\u0011%\u0011\u0019.JA\u0001\n\u0003\u0012)\u000eC\u0005\u0003f\u0016\n\t\u0011\"\u0001\u0002.!I!q]\u0013\u0002\u0002\u0013\u0005!\u0011\u001e\u0005\n\u0005k,\u0013\u0011!C!\u0005oD\u0011b!\u0002&\u0003\u0003%\taa\u0002\t\u0013\r-Q%!A\u0005B\r5\u0001\"CB\bK\u0005\u0005I\u0011IB\t\u000f%\u0019)\u0002GA\u0001\u0012\u0003\u00199BB\u0005\u0003\u0006a\t\t\u0011#\u0001\u0004\u001a!9\u00111\u0003\u001f\u0005\u0002\r\u001d\u0002\"\u0003BUy\u0005\u0005IQIB\u0015\u0011%\u0019Y\u0003PA\u0001\n\u0003\u001bi\u0003C\u0005\u00044q\n\t\u0011\"!\u00046!I11\t\u001f\u0002\u0002\u0013%1Q\t\u0005\b\u0007\u001bBB\u0011AB(\u0011\u001d\u0019y\u0006\u0007C\u0005\u0007C\u0012abQ8na\u0006\u001cG/[8o)\u0006\u001c8N\u0003\u0002G\u000f\u0006Q1m\\7qC\u000e$\u0018n\u001c8\u000b\u0005!K\u0015!\u0002;bg.\u001c(B\u0001&L\u0003\u0011!\u0018.\u001a:\u000b\u00031\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u001fV\u00032\u0001U)T\u001b\u00059\u0015B\u0001*H\u0005!!\u0016.\u001a:UCN\\\u0007C\u0001+\u0001\u001b\u0005)\u0005C\u0001,Z\u001b\u00059&B\u0001-L\u0003\u0015)H/\u001b7t\u0013\tQvKA\u0004M_\u001e<\u0017N\\4\u0002\u0007\r$\b0F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001\u0017*A\u0004gKR\u001c\u0007.\u001a:\n\u0005\t|&aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\n\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003\u0019\u0004\"a\u001a5\u000e\u0003%K!![%\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005\trN\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:\u0016\u00035\u0004\"\u0001\u00168\n\u0005=,%!E(gMN,G/T1q'V\u0004\b\u000f\\5fe\u0006\u0011rN\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:!\u0003\u0015\u0019H/\u0019;f+\u0005\u0019\bC\u0001;\"\u001d\t)xC\u0004\u0002w\u007f:\u0011qO \b\u0003qvt!!\u001f?\u000e\u0003iT!a_'\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015B\u0001&L\u0013\tA\u0015*\u0003\u0002G\u000f\u0006q1i\\7qC\u000e$\u0018n\u001c8UCN\\\u0007C\u0001+\u0019'\u0011A\u0012qA+\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q!!!\u0004\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00111\u0002\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\t\t\u0019!\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!a\u0007\u0011\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\t\u0003E\u0002z\u0003\u0017IA!a\t\u0002\f\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eTA!a\t\u0002\f\u0005!B)\u001a4bk2$X*\u0019=SKR\u0014\u0018pQ8v]R,\"!a\f\u0011\t\u0005%\u0011\u0011G\u0005\u0005\u0003g\tYAA\u0002J]R\fQ\u0003R3gCVdG/T1y%\u0016$(/_\"pk:$\b%\u0001\rEK\u001a\fW\u000f\u001c;SKR\u0014\u00180\u00138uKJ4\u0018\r\\%o\u001bN\f\u0011\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'tA\u0005\u0011B)\u001a4bk2$(+\u001a;ssB{G.[2z+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)%S\u0001\u0006gR|'/Z\u0005\u0005\u0003\u0013\n\u0019E\u0001\u000eUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0019&tW-\u0019:SKR\u0014\u00180A\nEK\u001a\fW\u000f\u001c;SKR\u0014\u0018\u0010U8mS\u000eL\bEA\nD_6\u0004\u0018m\u0019;j_:$\u0016m]6Ti\u0006$XmE\u0002\"\u0003\u000f\t1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006a1\r\\3b]\u0016\u00148\u000b^1ugR\u0011\u0011q\u000b\t\u0007\u0003\u0013\tI&!\u0018\n\t\u0005m\u00131\u0002\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019L\u0003\rawnZ\u0005\u0005\u0003O\n\tG\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8/\u0001\u0006ue\u0006t7/\u001b;j_:$b#!\u001c\u0002\n\u0006-\u0015QRAO\u0003[\u000b9,!2\u0002f\u0006\u001d\u0018\u0011\u001f\u000b\u0005\u0003_\ny\b\u0005\u0004\u0002r\u0005]\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002\f\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00141\u000f\u0002\u0007\rV$XO]3\u0011\u0007\u0005u\u0014%D\u0001\u0019\u0011\u001d\t\t\t\na\u0002\u0003\u0007\u000b!!Z2\u0011\t\u0005E\u0014QQ\u0005\u0005\u0003\u000f\u000b\u0019H\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")1\f\na\u0001;\")A\r\na\u0001M\"9\u0011q\u0012\u0013A\u0002\u0005E\u0015A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011qS&\u0002\rM,'O^3s\u0013\u0011\tY*!&\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"9\u0011q\u0014\u0013A\u0002\u0005\u0005\u0016!\u0005;jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feB!\u00111UAU\u001b\t\t)KC\u0002\u0002(&\u000bQ\u0001^8qS\u000eLA!a+\u0002&\n\tB+[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\t\u000f\u0005=F\u00051\u0001\u00022\u0006yA/[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u0005\u0003\u0002B\u0005M\u0016\u0002BA[\u0003\u0007\u0012q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003s#\u0003\u0019AA^\u0003\u0019\u0019wN\u001c4jOB!\u0011QXAa\u001b\t\tyLC\u0002\u0002:\u001eKA!a1\u0002@\nyA+[3s)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u0002H\u0012\u0002\r!!3\u0002\u0013QD'o\u001c;uY\u0016\u0014\b\u0003BAf\u0003Cl!!!4\u000b\u0007a\u000byM\u0003\u0003\u0002R\u0006M\u0017!C5oi\u0016\u0014h.\u00197t\u0015\u0011\t).a6\u0002\u000fM$xN]1hK*\u0019A*!7\u000b\t\u0005m\u0017Q\\\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0017aA8sO&!\u00111]Ag\u0005%!\u0006N]8ui2,'\u000fC\u0003lI\u0001\u0007Q\u000eC\u0004\u0002j\u0012\u0002\r!a;\u0002+QLWM]\"p[B\f7\r^5p]6+GO]5dgB\u0019A+!<\n\u0007\u0005=XIA\u000bUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\t\u000f\u0005MH\u00051\u0001\u0002v\u0006!A/[7f!\u0011\t90a@\u000e\u0005\u0005e(b\u0001-\u0002|*!\u0011Q`Al\u0003\u0019\u0019w.\\7p]&!!\u0011AA}\u0005\u0011!\u0016.\\3*\u0005\u0005*#\u0001C\"mK\u0006tGj\\4\u0014\u0013\u0015\n9!a\u001f\u0003\n\t=\u0001\u0003BA\u0005\u0005\u0017IAA!\u0004\u0002\f\t9\u0001K]8ek\u000e$\b\u0003BA\u0005\u0005#IAAa\u0005\u0002\f\ta1+\u001a:jC2L'0\u00192mK\u0006aA.Z1eKJ,\u0005o\\2iA\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003/\n!\u0002\\1tiN#\u0018\r^:!)\u0019\u0011yB!\t\u0003$A\u0019\u0011QP\u0013\t\u000f\u0005E#\u00061\u0001\u00020!9!q\u0003\u0016A\u0002\u0005]CC\u0006B\u0014\u0005W\u0011iCa\f\u00032\tM\"Q\u0007B\u001c\u0005s\u0011YD!\u0010\u0015\t\u0005=$\u0011\u0006\u0005\b\u0003\u0003c\u00039AAB\u0011\u0015YF\u00061\u0001^\u0011\u0015!G\u00061\u0001g\u0011\u001d\ty\t\fa\u0001\u0003#Cq!a(-\u0001\u0004\t\t\u000bC\u0004\u000202\u0002\r!!-\t\u000f\u0005eF\u00061\u0001\u0002<\"9\u0011q\u0019\u0017A\u0002\u0005%\u0007\"B6-\u0001\u0004i\u0007bBAuY\u0001\u0007\u00111\u001e\u0005\b\u0003gd\u0003\u0019AA{\u0003)!wn\u00117fC:dun\u001a\u000b\u001b\u0005\u0007\u00129E!\u0013\u0003L\t5#q\nB)\u0005'\u0012YF!\u0018\u0003n\t=$\u0011\u000f\u000b\u0005\u0003_\u0012)\u0005C\u0004\u0002\u00026\u0002\u001d!a!\t\u000bmk\u0003\u0019A/\t\u000f\u0005}U\u00061\u0001\u0002\"\"9\u0011\u0011K\u0017A\u0002\u0005=\u0002\"\u00023.\u0001\u00041\u0007bBAH[\u0001\u0007\u0011\u0011\u0013\u0005\u0006W6\u0002\r!\u001c\u0005\b\u0003sk\u0003\u0019\u0001B+!\u0011\tiLa\u0016\n\t\te\u0013q\u0018\u0002\u0016\u0007>l\u0007/Y2uS>tG+Y:lg\u000e{gNZ5h\u0011\u001d\ty+\fa\u0001\u0003cCqAa\u0018.\u0001\u0004\u0011\t'A\u0004qkRlu\u000eZ3\u0011\t\t\r$\u0011N\u0007\u0003\u0005KRA!!/\u0003h)!\u0011qSAl\u0013\u0011\u0011YG!\u001a\u00039M+w-\\3oi6+G/\u00193bi\u0006d\u0015-_8viB+H/T8eK\"9\u0011\u0011^\u0017A\u0002\u0005-\bbBAd[\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003gl\u0003\u0019AA{\u0003\u0001\u001a\bn\\;mI\u0012{G)^1m\u0007>l\u0007/Y2uS>tg+\u00197jI\u0006$\u0018n\u001c8\u0015\r\t]$Q\u0010BC!\u0011\tIA!\u001f\n\t\tm\u00141\u0002\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019G\fa\u0001\u0005\u007f\u0002B!a\u0018\u0003\u0002&!!1QA1\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005ef\u00061\u0001\u0003V\u0005Y!/Z2pe\u0012\u001cF/\u0019;t)1\u0011YI!%\u0003\u0016\n]%\u0011\u0015BS!\u0011\tIA!$\n\t\t=\u00151\u0002\u0002\u0005+:LG\u000fC\u0004\u0003\u0014>\u0002\r!a\u0007\u0002\tQ\f7o\u001b\u0005\u0006I>\u0002\rA\u001a\u0005\b\u00053{\u0003\u0019\u0001BN\u0003\u00111'o\\7\u0011\t\u0005%!QT\u0005\u0005\u0005?\u000bYA\u0001\u0003M_:<\u0007b\u0002BR_\u0001\u0007!1T\u0001\u0003i>DqAa*0\u0001\u0004\ti&A\u0003ti\u0006$8/\u0001\u0005u_N#(/\u001b8h)\t\tY\"\u0001\u0003d_BLHC\u0002B\u0010\u0005c\u0013\u0019\fC\u0005\u0002RE\u0002\n\u00111\u0001\u00020!I!qC\u0019\u0011\u0002\u0003\u0007\u0011qK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IL\u000b\u0003\u00020\tm6F\u0001B_!\u0011\u0011yL!3\u000e\u0005\t\u0005'\u0002\u0002Bb\u0005\u000b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t\u001d\u00171B\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bf\u0005\u0003\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!5+\t\u0005]#1X\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t]\u0007\u0003\u0002Bm\u0005Gl!Aa7\u000b\t\tu'q\\\u0001\u0005Y\u0006twM\u0003\u0002\u0003b\u0006!!.\u0019<b\u0013\u0011\t9Ca7\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u001eBy!\u0011\tIA!<\n\t\t=\u00181\u0002\u0002\u0004\u0003:L\b\"\u0003Bzm\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011 \t\u0007\u0005w\u001c\tAa;\u000e\u0005\tu(\u0002\u0002B\u0000\u0003\u0017\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019A!@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005o\u001aI\u0001C\u0005\u0003tb\n\t\u00111\u0001\u0003l\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00020\u00051Q-];bYN$BAa\u001e\u0004\u0014!I!1\u001f\u001e\u0002\u0002\u0003\u0007!1^\u0001\t\u00072,\u0017M\u001c'pOB\u0019\u0011Q\u0010\u001f\u0014\u000bq\u001aYBa\u0004\u0011\u0015\ru11EA\u0018\u0003/\u0012y\"\u0004\u0002\u0004 )!1\u0011EA\u0006\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\n\u0004 \t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\r]AC\u0001Bl\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011yba\f\u00042!9\u0011\u0011K A\u0002\u0005=\u0002b\u0002B\f\u007f\u0001\u0007\u0011qK\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00199da\u0010\u0011\r\u0005%\u0011\u0011LB\u001d!!\tIaa\u000f\u00020\u0005]\u0013\u0002BB\u001f\u0003\u0017\u0011a\u0001V;qY\u0016\u0014\u0004\"CB!\u0001\u0006\u0005\t\u0019\u0001B\u0010\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004HA!!\u0011\\B%\u0013\u0011\u0019YEa7\u0003\r=\u0013'.Z2u\u0003E9W\r\u001e+jKJdun\u001a+p\u00072,\u0017M\u001c\u000b\t\u0007#\u001a9f!\u0017\u0004\\A\u0019Aka\u0015\n\u0007\rUSI\u0001\bUS\u0016\u0014Hj\\4U_\u000ecW-\u00198\t\u000f\u0005\r$\t1\u0001\u0003\u0000!9\u00111\u001f\"A\u0002\u0005U\bbBB/\u0005\u0002\u0007!1T\u0001\u0004]><\u0018A\u00033jeRL(+\u00198hKR111MB3\u0007O\u0002\u0002\"!\u0003\u0004<\tm%1\u0014\u0005\b\u0003G\u001a\u0005\u0019\u0001B@\u0011\u001d\u0019if\u0011a\u0001\u00057\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\t\t-5Q\u000e\u0005\t\u0005gD\u0011\u0011!a\u0001g\u000611\u000f^1uK\u0002*\"!a;\u0002-QLWM]\"p[B\f7\r^5p]6+GO]5dg\u0002\"RbUB<\u0007s\u001aYh! \u0004\u0000\r\u0005\u0005\"B.\u000e\u0001\u0004i\u0006\"\u00023\u000e\u0001\u00041\u0007\"B6\u000e\u0001\u0004i\u0007\"B9\u000e\u0001\u0004\u0019\bbBAu\u001b\u0001\u0007\u00111\u001e\u0005\b\u0003gl\u0001\u0019AA{\u0003A!\u0018m]6De\u0016\fG/[8o)&lW-\u0006\u0002\u0003\u001c\u0006\tB/Y:l\u0007J,\u0017\r^5p]RKW.\u001a\u0011\u0002\u00151|w\rV8DY\u0016\fg.\u0006\u0002\u0004\u000eB1\u0011\u0011BA-\u0007#\na\u0002\\8h)>\u001cE.Z1o?\u0012*\u0017\u000f\u0006\u0003\u0003\f\u000eM\u0005\"\u0003Bz%\u0005\u0005\t\u0019ABG\u0003-awn\u001a+p\u00072,\u0017M\u001c\u0011)\u0007M\u0019I\n\u0005\u0003\u0002\n\rm\u0015\u0002BBO\u0003\u0017\u0011\u0001B^8mCRLG.Z\u0001\u0016[\u0006L(-Z+qI\u0006$X\rT8h)>\u001cE.Z1o)!\u0019iia)\u0004&\u000e%\u0006bBAH)\u0001\u0007\u0011\u0011\u0013\u0005\b\u0007O#\u0002\u0019\u0001BN\u0003%qwn^'jY2L7\u000fC\u0004\u0004,R\u0001\rAa'\u0002\u001dU\u0004H-\u0019;f\u0013:$XM\u001d<bYRq1qVB[\u0007o\u001bIla/\u0004>\u000e}F\u0003BBY\u0007g\u0003R!!\u001d\u0002xMCq!!!\u0016\u0001\b\t\u0019\tC\u0004\u0002tV\u0001\r!!>\t\u000f\u0005}U\u00031\u0001\u0002\"\"9\u0011qV\u000bA\u0002\u0005E\u0006bBAH+\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003s+\u0002\u0019AA^\u0011\u001d\t9-\u0006a\u0001\u0007\u0003\u0004b!!\u0003\u0002Z\u0005%\u0007")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private final OffsetMapSupplier offsetMapSupplier;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final long taskCreationTime;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog abstractLog, Time time, long l) {
        return CompactionTask$.MODULE$.getTierLogToClean(abstractLog, time, l);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public long taskCreationTime() {
        return this.taskCreationTime;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis, long updateInterval) {
        Option updatedNextLogToClean = (this.state() instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTierCompactable())) : None$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), updateInterval)))) {
                return new Some((Object)CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, $this.time, nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq((Option<TierLogToClean>)updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        return (this.ctx().isCancelled() ? Future$.MODULE$.successful((Object)this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, (Throttler)throttler.get(), this.offsetMapSupplier(), this.tierCompactionMetrics(), time, ec)).map((Function1 & Serializable & scala.Serializable)result -> {
            this.onSuccessfulTransition();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(CompactionTask.$anonfun$transition$2(this, result)));
            }
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new scala.Serializable(this, config, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$1(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$2(logCleaningAbortedException));
                    }
                    return (B1)this.$outer;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    E2EChecksumInvalidException e2EChecksumInvalidException = (E2EChecksumInvalidException)x1;
                    this.$outer.tierCompactionMetrics().e2eChecksumInvalidCount().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                        $anonfun$transition$3.$anonfun$applyOrElse$3(x$3);
                        return BoxedUnit.UNIT;
                    });
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$4(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$5(e2EChecksumInvalidException));
                    }
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), e2EChecksumInvalidException);
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$6(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$7(tierLogCompactionFencedException));
                    }
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$8(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$9(cancellationException));
                    }
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$10(this)), (Throwable)$anonfun$transition$3.$anonfun$applyOrElse$11(notTierablePartitionException));
                    }
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 != null) {
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask error_this = compactionTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$12(this)), $anonfun$transition$3.$anonfun$applyOrElse$13(x1));
                    }
                    this.$outer.cancelAndSetErrorState(x1);
                    return (B1)this.$outer;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (x1 instanceof E2EChecksumInvalidException) {
                    return true;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (x1 instanceof CancellationException) {
                    return true;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    return true;
                }
                return x1 != null;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$transition$3 $this) {
                return new StringBuilder(35).append($this.$outer.topicIdPartition()).append(": compaction operation was aborted.").toString();
            }

            public static final /* synthetic */ LogCleaningAbortedException $anonfun$applyOrElse$2(LogCleaningAbortedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(Counter x$3) {
                x$3.inc();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$4($anonfun$transition$3 $this) {
                return new StringBuilder(48).append($this.$outer.topicIdPartition()).append(": checksum mismatch while uploading new segment.").toString();
            }

            public static final /* synthetic */ E2EChecksumInvalidException $anonfun$applyOrElse$5(E2EChecksumInvalidException x5$1) {
                return x5$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$6($anonfun$transition$3 $this) {
                return new StringBuilder(40).append($this.$outer.topicIdPartition()).append(" was fenced, stopping compaction process").toString();
            }

            public static final /* synthetic */ TierLogCompactionFencedException $anonfun$applyOrElse$7(TierLogCompactionFencedException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$8($anonfun$transition$3 $this) {
                return new StringBuilder(64).append($this.$outer.topicIdPartition()).append(" was fenced by cancellation context, stopping compaction process").toString();
            }

            public static final /* synthetic */ CancellationException $anonfun$applyOrElse$9(CancellationException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$10($anonfun$transition$3 $this) {
                return new StringBuilder(47).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot use tier compaction").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$11(NotTierablePartitionException x8$1) {
                return x8$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$12($anonfun$transition$3 $this) {
                return new StringBuilder(67).append($this.$outer.topicIdPartition()).append(": unhandled exception in CompactionTask. Moving task to error state").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$13(Throwable x9$1) {
                return x9$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$2(kafka.common.LogCleaningAbortedException ), $anonfun$applyOrElse$3$adapted(com.yammer.metrics.core.Counter ), $anonfun$applyOrElse$4(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$5(kafka.tier.exceptions.E2EChecksumInvalidException ), $anonfun$applyOrElse$6(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$7(kafka.tier.exceptions.TierLogCompactionFencedException ), $anonfun$applyOrElse$8(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$9(java.util.concurrent.CancellationException ), $anonfun$applyOrElse$10(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$11(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$12(kafka.tier.tasks.compaction.CompactionTask$$anonfun$transition$3 ), $anonfun$applyOrElse$13(java.lang.Throwable )}, serializedLambda);
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(36).append("CompactionTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$transition$2(CompactionTask $this, CompactionTaskState result$1) {
        return new StringBuilder(23).append("Transitioned ").append($this.topicIdPartition()).append(" from ").append($this.state()).append(" to ").append(result$1).toString();
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, OffsetMapSupplier offsetMapSupplier, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics, Time time) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.offsetMapSupplier = offsetMapSupplier;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        super(tierCompactionMetrics.retryRateOpt());
        this.taskCreationTime = time.milliseconds();
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    scala.Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
            if (compactionTask$ == null) {
                throw null;
            }
            CompactionTask$ info_this = compactionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$transition$4(topicIdPartition)));
            }
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, offsetMapSupplier, (CompactionTasksConfig)config.compactionTaskConfig().get(), tierObjectStore, config.segmentMetadataLayoutPutMode(), tierCompactionMetrics, throttler, time, ec).map((Function1 & Serializable & scala.Serializable)state -> {
                CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                if (compactionTask$ == null) {
                    throw null;
                }
                CompactionTask$ info_this = compactionTask$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$transition$6(topicIdPartition)));
                }
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, OffsetMapSupplier offsetMapSupplier, CompactionTasksConfig config, TierObjectStore tierObjectStore, SegmentMetadataLayoutPutMode putMode, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Errors error = (Errors)((Left)either).value();
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Partition partition = (Partition)((Right)either).value();
                    return (CompactionTaskState)partition.log().map((Function1 & Serializable & scala.Serializable)log -> {
                        Some stats;
                        block47: {
                            int tierEpoch = log.tierPartitionState().tierEpoch();
                            if (tierEpoch > leaderEpoch) {
                                throw new TierLogCompactionFencedException(topicIdPartition, TierLogCompactionFencedException$.MODULE$.$lessinit$greater$default$2());
                            }
                            if (tierEpoch < leaderEpoch) {
                                throw new TierMetadataRetriableException(new StringBuilder(45).append("Leadership not established for ").append(topicIdPartition).append(". Backing off.").toString());
                            }
                            if (partition.isUncleanLeader()) {
                                throw new TierMetadataRetriableException(new StringBuilder(49).append(topicIdPartition).append(" undergoing unclean leader recovery. Backing off.").toString());
                            }
                            if (log.isTierMetadataStateRecovering()) {
                                throw new TierMetadataRetriableException(new StringBuilder(48).append(topicIdPartition).append(" undergoing tier metadata recovery. Backing off.").toString());
                            }
                            if (log.isFrozenLogStartOffsetState()) {
                                throw new TierMetadataRetriableException(new StringBuilder(46).append(topicIdPartition).append(" undergoing tiered data recovery. Backing off.").toString());
                            }
                            OffsetMap offsetMap = offsetMapSupplier.getOffsetMap();
                            stats = this.lastStats();
                            try {
                                void var37_44;
                                void var35_43;
                                Tuple2<Object, CleanerStats> tuple2;
                                if (!log.isTierCompactable()) {
                                    CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                                    if (compactionTask$ == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$3(topicIdPartition)));
                                    }
                                    break block47;
                                }
                                if (log.tieredLogSegments().isEmpty()) {
                                    CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                                    if (compactionTask$ == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$4(topicIdPartition)));
                                    }
                                    throw new TierMetadataRetriableException(new StringBuilder(60).append("Log for ").append(topicIdPartition).append(" has no eligible tiered segments for tier compaction").toString());
                                }
                                TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                                Function1 & Serializable & scala.Serializable checkDone = (Function1 & Serializable & scala.Serializable)x$4 -> {
                                    CleanLog.$anonfun$doCleanLog$5(ctx, x$4);
                                    return BoxedUnit.UNIT;
                                };
                                TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                                TierCleaner cleaner = new TierCleaner(offsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, putMode, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                                Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                                if (lockedOffset.isEmpty()) {
                                    CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                                    if (compactionTask$ == null) {
                                        throw null;
                                    }
                                    CompactionTask$ warn_this = compactionTask$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$6(topicIdPartition)));
                                    }
                                    throw new LogCleaningAbortedException();
                                }
                                cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong((Object)lockedOffset.get()));
                                try {
                                    block48: {
                                        long tierEndOffset = log.tierPartitionState().endOffset();
                                        if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                            OffsetMap localOffsetMap = offsetMapSupplier.getOffsetMap();
                                            try {
                                                void var30_32;
                                                CleanerStats stats2;
                                                CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
                                                if (compactionTask$ == null) {
                                                    throw null;
                                                }
                                                CompactionTask$ info_this = compactionTask$;
                                                if (info_this.logger().underlying().isInfoEnabled()) {
                                                    info_this.logger().underlying().info(info_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$7(topicIdPartition, cleanable, tierEndOffset)));
                                                }
                                                ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                                Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                                Tuple2 tuple22 = CleanLog.liftedTree1$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics()), offsetMapSupplier, localOffsetMap);
                                                if (tuple22 == null) {
                                                    throw new MatchError(null);
                                                }
                                                boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                                String failReason = (String)tuple22._2();
                                                if (var30_32 == false) {
                                                    CompactionTask$ compactionTask$2 = CompactionTask$.MODULE$;
                                                    if (compactionTask$2 == null) {
                                                        throw null;
                                                    }
                                                    CompactionTask$ warn_this = compactionTask$2;
                                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                                        void var31_33;
                                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$8(log, (String)var31_33)));
                                                    }
                                                    stats2.validationAborted();
                                                    break block48;
                                                }
                                                if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                                    CompactionTask$ compactionTask$3 = CompactionTask$.MODULE$;
                                                    if (compactionTask$3 == null) {
                                                        throw null;
                                                    }
                                                    CompactionTask$ warn_this = compactionTask$3;
                                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$9(log, tierEndOffset)));
                                                    }
                                                    stats2.validationAborted();
                                                    break block48;
                                                }
                                                Enumeration.Value value = cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2);
                                                Enumeration.Value value2 = ValidateLogResult$.MODULE$.Passed();
                                                if (!(value2 != null ? !value2.equals(value) : value != null)) {
                                                    CompactionTask$ compactionTask$4 = CompactionTask$.MODULE$;
                                                    if (compactionTask$4 == null) {
                                                        throw null;
                                                    }
                                                    CompactionTask$ info_this2 = compactionTask$4;
                                                    if (info_this2.logger().underlying().isInfoEnabled()) {
                                                        info_this2.logger().underlying().info(info_this2.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$10(topicIdPartition)));
                                                    }
                                                    stats2.validationPassed();
                                                    break block48;
                                                }
                                                Enumeration.Value value3 = ValidateLogResult$.MODULE$.Failed();
                                                if (!(value3 != null ? !value3.equals(value) : value != null)) {
                                                    CompactionTask$ compactionTask$5 = CompactionTask$.MODULE$;
                                                    if (compactionTask$5 == null) {
                                                        throw null;
                                                    }
                                                    CompactionTask$ warn_this = compactionTask$5;
                                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$11(log)));
                                                    }
                                                    stats2.validationFailed();
                                                    break block48;
                                                }
                                                Enumeration.Value value4 = ValidateLogResult$.MODULE$.Aborted();
                                                if (value4 == null) {
                                                    if (value != null) {
                                                        break block48;
                                                    }
                                                } else if (!value4.equals(value)) break block48;
                                                CompactionTask$ compactionTask$6 = CompactionTask$.MODULE$;
                                                if (compactionTask$6 == null) {
                                                    throw null;
                                                }
                                                CompactionTask$ warn_this = compactionTask$6;
                                                if (warn_this.logger().underlying().isWarnEnabled()) {
                                                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$doCleanLog$12(log)));
                                                }
                                                stats2.validationAborted();
                                            }
                                            finally {
                                                offsetMapSupplier.reclaimOffsetMap(localOffsetMap);
                                            }
                                        }
                                    }
                                    tuple2 = cleaner.clean(cleanable);
                                }
                                finally {
                                    log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                                }
                                Tuple2<Object, CleanerStats> tuple23 = tuple2;
                                if (tuple23 == null) {
                                    throw new MatchError(null);
                                }
                                long nextDirtyOffset = tuple23._1$mcJ$sp();
                                CleanerStats cleanerStats = (CleanerStats)tuple23._2();
                                if (var35_43 != -1L) {
                                    this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), (long)var35_43, (CleanerStats)var37_44);
                                }
                                stats = new Some((Object)var37_44);
                            }
                            finally {
                                offsetMapSupplier.reclaimOffsetMap(offsetMap);
                            }
                        }
                        return new CleanLog(leaderEpoch, (Option<CleanerStats>)stats);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return log.config().confluentLogConfig().tierCleanerDualCompaction && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanLog.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanLog.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanLog.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tThrottled time: %,.1f seconds (%.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)stats.throttledSecs()), BoxesRunTime.boxToDouble((double)((double)100 * stats.throttledSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanLog.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            CompactionTask$ compactionTask$ = CompactionTask$.MODULE$;
            if (compactionTask$ == null) {
                throw null;
            }
            CompactionTask$ info_this = compactionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(message));
            }
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$ compactionTask$2 = CompactionTask$.MODULE$;
                if (compactionTask$2 == null) {
                    throw null;
                }
                CompactionTask$ warn_this = compactionTask$2;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(CleanLog.$anonfun$recordStats$2(stats)));
                    return;
                }
                return;
            }
        }

        public String toString() {
            return new StringBuilder(22).append("CleanLog(leaderEpoch=").append(this.leaderEpoch()).append(")").toString();
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        public String productPrefix() {
            return "CleanLog";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.leaderEpoch()), (int)Statics.anyHash(this.lastStats())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof CleanLog)) break block3;
                    CleanLog cleanLog = (CleanLog)x$1;
                    if (this.leaderEpoch() != cleanLog.leaderEpoch()) break block3;
                    Option<CleanerStats> option = this.lastStats();
                    Option<CleanerStats> option2 = cleanLog.lastStats();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !cleanLog.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ String $anonfun$transition$4(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(33).append("Starting tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$transition$6(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(34).append("Completed tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$3(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(80).append("Log for ").append(topicIdPartition$2).append(" is not tier compact enabled, but is attempting to clean tiered segments").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$4(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(96).append("Log for ").append(topicIdPartition$2).append(" was scheduled in tier CompactionTask but has no eligible tiered segments for compaction").toString();
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$4) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$6(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(99).append("Log for ").append(topicIdPartition$2).append(" is still locked by previous compaction round. Abort current operation and will be retried.").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$7(TopicIdPartition topicIdPartition$2, TierLogToClean cleanable$1, long tierEndOffset$1) {
            return new StringBuilder(73).append("Starting dual compaction validation for ").append(topicIdPartition$2).append(" for offset range [").append(cleanable$1.firstCleanableOffset()).append(", end offset=").append(tierEndOffset$1).append("]").toString();
        }

        private static final /* synthetic */ Tuple2 liftedTree1$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, OffsetMapSupplier offsetMapSupplier$1, OffsetMap localOffsetMap$1) {
            Tuple2 tuple2;
            try {
                if (!localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, (OffsetMap)baseOffsetMap$1, stats$1)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(96).append("offset map is too small for storing all keys in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append("Offset map memory: ").append(offsetMapSupplier$1.offsetMapMemory()).append(", slots: ").append(localOffsetMap$1.slots()).append(".").toString());
            }
            catch (Throwable e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(84).append("exception encountered when building offset map for local data in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append(e).toString());
            }
            return tuple2;
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$8(AbstractLog log$2, String failReason$1) {
            return new StringBuilder(39).append("Abort dual compaction validation for ").append(log$2).append(". ").append(failReason$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$9(AbstractLog log$2, long tierEndOffset$1) {
            return new StringBuilder(110).append("Abort dual compaction validation for ").append(log$2).append(" because tierEndOffset changed. old tierEndOffset: ").append(tierEndOffset$1).append(", new tierEndOffset: ").append(log$2.tierPartitionState().endOffset()).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$10(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(topicIdPartition$2).append(" passed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$11(AbstractLog log$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(log$2).append(" failed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$12(AbstractLog log$2) {
            return new StringBuilder(56).append("Dual compaction validation is not able to complete for ").append(log$2).append(".").toString();
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public static final /* synthetic */ String $anonfun$recordStats$2(CleanerStats stats$2) {
            return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats$2.invalidMessagesRead())}));
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$((Product)this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, OffsetMapSupplier var8, TierCompactionMetrics var9, Time var10, ExecutionContext var11);
    }
}

