/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.utils.Logging;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\r\u001b\u0001\rB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00033\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015q\u0004\u0001\"\u0015@\u0011\u001dY\u0005A1A\u0005\n1Ca!\u0016\u0001!\u0002\u0013i\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003Y\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\r\u0011Q\u0006\u0001B.\t\u0011Yj!\u00111A\u0005\u0002EB\u0001b]\u0007\u0003\u0002\u0004%\t\u0001\u001e\u0005\to5\u0011\t\u0011)Q\u0005e!)\u0001(\u0004C\u0001u\")A0\u0004C!{\")a0\u0004C!\u007f\"9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002BBA\u0012\u0001\u0011\u0005Q\u0010C\u0004\u0002&\u0001!\t!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\"!E(gMN,G/T1q'V\u0004\b\u000f\\5fe*\u00111\u0004H\u0001\u000bG>l\u0007/Y2uS>t'BA\u000f\u001f\u0003\u0015!\u0018m]6t\u0015\ty\u0002%\u0001\u0003uS\u0016\u0014(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYc&D\u0001-\u0015\ti\u0003%A\u0003vi&d7/\u0003\u00020Y\t9Aj\\4hS:<\u0017a\u00028v[6\u000b\u0007o]\u000b\u0002eA\u0011QeM\u0005\u0003i\u0019\u00121!\u00138u\u0003!qW/\\'baN\u0004\u0013aD8gMN,G/T1q\u001b\u0016lwN]=\u0002!=4gm]3u\u001b\u0006\u0004X*Z7pef\u0004\u0013A\u0002\u001fj]&$h\bF\u0002;yu\u0002\"a\u000f\u0001\u000e\u0003iAQ\u0001M\u0003A\u0002IBQAN\u0003A\u0002I\n!\u0002\\8hO\u0016\u0014h*Y7f+\u0005\u0001\u0005CA!I\u001d\t\u0011e\t\u0005\u0002DM5\tAI\u0003\u0002FE\u00051AH]8pizJ!a\u0012\u0014\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f\u001a\n\u0001\"T!Y?^\u000b\u0015\nV\u000b\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005i&lWMC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u00135\u000b\u0005lX,B\u0013R\u0003\u0013\u0001E8gMN,G/T1q\r\u0006\u001cGo\u001c:z+\u0005A\u0006CA-\u000e\u001b\u0005\u0001!\u0001E(gMN,G/T1q\r\u0006\u001cGo\u001c:z'\tiA\fE\u0002^M\"l\u0011A\u0018\u0006\u0003?\u0002\fQ\u0001]8pYJR!!\u00192\u0002\u000f\r|W.\\8og*\u00111\rZ\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\f1a\u001c:h\u0013\t9gLA\fCCN,\u0007k\\8mK\u0012|%M[3di\u001a\u000b7\r^8ssB\u0011\u0011.]\u0007\u0002U*\u00111\u000e\\\u0001\u0004Y><'BA7o\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002pa\u000691\u000f^8sC\u001e,'BA\u0011c\u0013\t\u0011(NA\u0005PM\u001a\u001cX\r^'ba\u0006\u0019rN\u001a4tKRl\u0015\r]'f[>\u0014\u0018p\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003KYL!a\u001e\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bs>\t\t\u00111\u00013\u0003\rAH%\r\u000b\u00031nDQAN\tA\u0002I\naa\u0019:fCR,G#\u00015\u0002\t]\u0014\u0018\r\u001d\u000b\u0005\u0003\u0003\t9\u0001\u0005\u0003^\u0003\u0007A\u0017bAA\u0003=\na\u0001k\\8mK\u0012|%M[3di\"1\u0011\u0011B\nA\u0002!\fQA^1mk\u0016\f\u0011c\u001c4gg\u0016$X*\u00199GC\u000e$xN]=!\u00035ygMZ:fi6\u000b\u0007\u000fU8pYV\u0011\u0011\u0011\u0003\t\u0006\u0003'\tI\u0002[\u0007\u0003\u0003+Q1!a\u0006_\u0003\u0011IW\u000e\u001d7\n\t\u0005m\u0011Q\u0003\u0002\u0012\u000f\u0016tWM]5d\u001f\nTWm\u0019;Q_>d\u0017AD8gMN,G/T1q!>|G\u000eI\u0001\u000fS:LG/[1mSj,\u0007k\\8m)\t\t\t\"\u0001\u0007hKR|eMZ:fi6\u000b\u0007/\u0001\tsK\u000ed\u0017-[7PM\u001a\u001cX\r^'baR\u0019Q/!\u000b\t\r\u0005-b\u00031\u0001i\u0003%ygMZ:fi6\u000b\u0007/A\u0006sK\u000e|gNZ5hkJ,G#B;\u00022\u0005U\u0002BBA\u001a/\u0001\u0007!'\u0001\u0006oK^tU/\\'baNDa!a\u000e\u0018\u0001\u0004\u0011\u0014\u0001\u00058fo>3gm]3u\u001b\u0006\u00048+\u001b>f\u0003\u0015\u0019Gn\\:f)\u0005)\b")
public class OffsetMapSupplier
implements Logging {
    private final int numMaps;
    private final int offsetMapMemory;
    private final Duration MAX_WAIT;
    private final OffsetMapFactory offsetMapFactory;
    private final GenericObjectPool<OffsetMap> offsetMapPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numMaps() {
        return this.numMaps;
    }

    public int offsetMapMemory() {
        return this.offsetMapMemory;
    }

    @Override
    public String loggerName() {
        return OffsetMapSupplier.class.getName();
    }

    private Duration MAX_WAIT() {
        return this.MAX_WAIT;
    }

    private OffsetMapFactory offsetMapFactory() {
        return this.offsetMapFactory;
    }

    private GenericObjectPool<OffsetMap> offsetMapPool() {
        return this.offsetMapPool;
    }

    private synchronized GenericObjectPool<OffsetMap> initializePool() {
        if (this.numMaps() < 1) {
            throw new IllegalArgumentException(new StringBuilder(82).append("OffsetMapSupplier cannot initialize with max size less than 1. Value provided was ").append(this.numMaps()).toString());
        }
        GenericObjectPoolConfig offsetMapPoolConfig = new GenericObjectPoolConfig();
        offsetMapPoolConfig.setJmxEnabled(false);
        offsetMapPoolConfig.setMaxTotal(this.numMaps());
        offsetMapPoolConfig.setMaxWait(this.MAX_WAIT());
        return new GenericObjectPool((PooledObjectFactory)this.offsetMapFactory(), offsetMapPoolConfig);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized OffsetMap getOffsetMap() {
        try {
            void var1_1;
            OffsetMap offsetMap = (OffsetMap)this.offsetMapPool().borrowObject();
            while (offsetMap.memory() != this.offsetMapFactory().offsetMapMemory()) {
                this.offsetMapPool().invalidateObject((Object)offsetMap);
                offsetMap = (OffsetMap)this.offsetMapPool().borrowObject();
            }
            return var1_1;
        }
        catch (Exception e) {
            throw new TierMetadataRetriableException("Unable to get an offset map from the pool, retrying", e);
        }
    }

    public synchronized void reclaimOffsetMap(OffsetMap offsetMap) {
        offsetMap.clear();
        if (this.offsetMapPool().listAllObjects().size() > this.offsetMapPool().getMaxTotal()) {
            this.offsetMapPool().invalidateObject((Object)offsetMap);
            return;
        }
        this.offsetMapPool().returnObject((Object)offsetMap);
    }

    public synchronized void reconfigure(int newNumMaps, int newOffsetMapSize) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Reconfigure OffsetMapSupplier with numMaps: ").append(newNumMaps).append(" and memory: ").append(newOffsetMapSize).toString());
        if (newNumMaps < 1) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("OffsetMapSupplier cannot be configured with less than 1 map from new value of ").append(newNumMaps).append(". Ignoring update for number of maps").toString());
        } else {
            this.offsetMapPool().setMaxTotal(newNumMaps);
        }
        if (newOffsetMapSize < 0) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("OffsetMapSupplier cannot be configured with a map size less than 1 from new value of ").append(newOffsetMapSize).append(". Ignoring update for map size").toString());
            return;
        }
        this.offsetMapFactory().offsetMapMemory_$eq(newOffsetMapSize);
    }

    public synchronized void close() {
        this.offsetMapPool().close();
    }

    public OffsetMapSupplier(int numMaps, int offsetMapMemory) {
        this.numMaps = numMaps;
        this.offsetMapMemory = offsetMapMemory;
        Logging.$init$(this);
        this.MAX_WAIT = Duration.ofMillis(0L);
        this.offsetMapFactory = new OffsetMapFactory(this, offsetMapMemory);
        this.offsetMapPool = this.initializePool();
    }

    private class OffsetMapFactory
    extends BasePooledObjectFactory<OffsetMap> {
        private int offsetMapMemory;
        public final /* synthetic */ OffsetMapSupplier $outer;

        public int offsetMapMemory() {
            return this.offsetMapMemory;
        }

        public void offsetMapMemory_$eq(int x$1) {
            this.offsetMapMemory = x$1;
        }

        public OffsetMap create() {
            return new SkimpyOffsetMap(this.offsetMapMemory());
        }

        public PooledObject<OffsetMap> wrap(OffsetMap value) {
            return new DefaultPooledObject((Object)value);
        }

        public /* synthetic */ OffsetMapSupplier kafka$tier$tasks$compaction$OffsetMapSupplier$OffsetMapFactory$$$outer() {
            return this.$outer;
        }

        public OffsetMapFactory(OffsetMapSupplier $outer, int offsetMapMemory) {
            this.offsetMapMemory = offsetMapMemory;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

