/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.io.Serializable;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StartPartitionDeletion;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.delete.DeletionMetrics;
import kafka.tier.tasks.delete.DeletionTask;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i4Qa\u0003\u0007\u0001\u0019QA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"B#\u0001\t\u00031\u0005BB'\u0001\t#ra\n\u0003\u0004]\u0001\u0011Ec\"\u0018\u0005\u0007S\u0002!\tF\u00046\t\u000bM\u0004A\u0011\u0002;\u0003#\u0011+G.\u001a;j_:$\u0016m]6Rk\u0016,XM\u0003\u0002\u000e\u001d\u00051A-\u001a7fi\u0016T!a\u0004\t\u0002\u000bQ\f7o[:\u000b\u0005E\u0011\u0012\u0001\u0002;jKJT\u0011aE\u0001\u0006W\u000647.Y\n\u0003\u0001U\u00012AF\f\u001a\u001b\u0005q\u0011B\u0001\r\u000f\u00055!\u0016.\u001a:UCN\\\u0017+^3vKB\u0011!dG\u0007\u0002\u0019%\u0011A\u0004\u0004\u0002\r\t\u0016dW\r^5p]R\u000b7o[\u0001\u0004GRD8\u0001\u0001\t\u0003A\rj\u0011!\t\u0006\u0003EA\tqAZ3uG\",'/\u0003\u0002%C\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006AQ.\u0019=UCN\\7\u000f\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0002J]R\fA\u0001^5nKB\u0011a\u0006O\u0007\u0002_)\u0011\u0001'M\u0001\u0006kRLGn\u001d\u0006\u0003eM\naaY8n[>t'BA\n5\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005ez#\u0001\u0002+j[\u0016\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?%\u000511/\u001a:wKJL!\u0001Q\u001f\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006yA-\u001a7fi&|g.T3ue&\u001c7\u000f\u0005\u0002\u001b\u0007&\u0011A\t\u0004\u0002\u0010\t\u0016dW\r^5p]6+GO]5dg\u00061A(\u001b8jiz\"ba\u0012%J\u0015.c\u0005C\u0001\u000e\u0001\u0011\u0015ib\u00011\u0001 \u0011\u0015)c\u00011\u0001'\u0011\u0015ac\u00011\u0001.\u0011\u0015Qd\u00011\u0001<\u0011\u0015\te\u00011\u0001C\u0003%\u0019xN\u001d;UCN\\7\u000f\u0006\u0002P7B\u0019\u0001\u000bW\r\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u001f\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002XQ\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005\u0011a\u0015n\u001d;\u000b\u0005]C\u0003\"B\b\b\u0001\u0004y\u0015a\u00028foR\u000b7o\u001b\u000b\u00043y#\u0007\"B0\t\u0001\u0004\u0001\u0017\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\t\t'-D\u0001\u0011\u0013\t\u0019\u0007C\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\")Q\r\u0003a\u0001M\u000611\r[1oO\u0016\u0004\"AF4\n\u0005!t!aE*uCJ$8\t[1oO\u0016lU\r^1eCR\f\u0017AC7bsB\u0013xnY3tgR\u00111N\u001c\t\u0003O1L!!\u001c\u0015\u0003\u000f\t{w\u000e\\3b]\")q.\u0003a\u0001a\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0002\u0017c&\u0011!O\u0004\u0002\u000f\u0007\"\fgnZ3NKR\fG-\u0019;b\u00031!\u0018m]6Qe&|'/\u001b;z)\t)\b\u0010\u0005\u0002(m&\u0011q\u000f\u000b\u0002\u0005\u0019>tw\rC\u0003z\u0015\u0001\u0007\u0011$\u0001\u0003uCN\\\u0007")
public class DeletionTaskQueue
extends TierTaskQueue<DeletionTask> {
    private final CancellationContext ctx;
    private final ReplicaManager replicaManager;
    private final DeletionMetrics deletionMetrics;

    @Override
    public List<DeletionTask> sortTasks(List<DeletionTask> tasks) {
        return (List)tasks.sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToLong((long)this.taskPriority(task)), (Ordering)Ordering.Long$.MODULE$);
    }

    @Override
    public DeletionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata change) {
        Product product;
        if (change instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)change;
            product = new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager, startLeadership.leaderEpoch());
        } else if (change instanceof StartPartitionDeletion) {
            StartPartitionDeletion startPartitionDeletion = (StartPartitionDeletion)change;
            product = new DeletionTask.DeletedPartitionMetadata(startPartitionDeletion.tieredObjects());
        } else {
            throw new MatchError((Object)change);
        }
        Product stateMetadata = product;
        return new DeletionTask(this.ctx.subContext(), topicIdPartition, new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)stateMetadata), this.deletionMetrics);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        return true;
    }

    private long taskPriority(DeletionTask task) {
        DeletionTask.State state = task.state();
        if (state instanceof DeletionTask.CollectDeletableObjects) {
            return BoxesRunTime.unboxToLong((Object)task.lastProcessedMs().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }
        if (state instanceof DeletionTask.FailedState) {
            return -2L;
        }
        return -1L;
    }

    public DeletionTaskQueue(CancellationContext ctx, int maxTasks, Time time, ReplicaManager replicaManager, DeletionMetrics deletionMetrics) {
        this.ctx = ctx;
        this.replicaManager = replicaManager;
        this.deletionMetrics = deletionMetrics;
        super(ctx, maxTasks, time);
    }
}

