/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.Header;

public class TierPartitionStateJsonWrapper {
    private final Header header;
    private final List<TierObjectMetadata> entries;
    public static final String TOPIC_ID = "topicId";
    public static final String VERSION = "version";
    public static final String TIER_EPOCH = "tierEpoch";
    public static final String STATUS = "status";
    public static final String START_OFFSET = "startOffset";
    public static final String END_OFFSET = "endOffset";
    public static final String MATERIALIZATION_INFO = "MaterializationInfo";
    public static final String GLOBAL_MATERIALIZED_OFFSET_AND_EPOCH = "globalMaterializedOffsetAndEpoch";
    public static final String GLOBAL_MATERIALIZED_OFFSET = "globalMaterializedOffset";
    public static final String LOCAL_MATERIALIZED_OFFSET_AND_EPOCH = "localMaterializedOffsetAndEpoch";
    public static final String LOCAL_MATERIALIZED_OFFSET = "localMaterializedOffset";
    public static final String ERROR_OFFSET_AND_EPOCH = "errorOffsetAndEpoch";
    public static final String RESTORE_OFFSET_AND_EPOCH = "restoreOffsetAndEpoch";
    public static final String OFFSET = "offset";
    public static final String EPOCH = "epoch";
    public static final String COMPACT_FEATURE_FLAG = "compactFeatureFlag";
    public static final String COMPACT_CLEAN_CHECKPOINT = "compactCleanCheckpoint";
    public static final String LAST_COMPACT_STATS = "lastCompactStats";
    public static final String ACCUMULATED_COMPACT_STATS = "accumulatedCompactStats";
    public static final String BYTES_READ = "bytesRead";
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final String DIRTY_BYTES_READ = "dirtyBytesRead";
    public static final String HAS_STATE_CHANGE_TIMESTAMP = "hasStateChangeTimestamp";
    public static final String TIER_PARTITION_STATE_SNAPSHOT_FEATURE_FLAG = "tierPartitionStateSnapshotFeatureFlag";
    public static final String SNAPSHOT_INFO = "SnapshotInfo";
    public static final String LAST_SNAPSHOT_TIMESTAMP_MS = "lastSnapshotTimestampMs";
    public static final String LAST_SNAPSHOT_ID = "lastSnapshotId";
    public static final String TOPIC_ID_PARTITION = "topicIdPartition";
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String OBJECT_ID = "objectId";
    public static final String OBJECT_ID_AS_BASE_64 = "objectIdAsBase64";
    public static final String BASE_OFFSET = "baseOffset";
    public static final String VIRTUAL_BASE_OFFSET = "virtualBaseOffset";
    public static final String MAX_TIMESTAMP = "maxTimestamp";
    public static final String FIRST_BATCH_TIMESTAMP = "firstBatchTimestamp";
    public static final String SIZE = "size";
    public static final String STATE = "state";
    public static final String HAS_EPOCH_STATE = "hasEpochState";
    public static final String HAS_ABORTED_TXNS = "hasAbortedTxns";
    public static final String HAS_PRODUCER_STATE = "hasProducerState";
    public static final String UPLOAD_TYPE = "uploadType";
    public static final String OPAQUE_DATA = "opaqueData";
    public static final String INCLUDE_COMPACTION_FIELDS = "includeCompactionFields";
    public static final String INCLUDE_STATE_CHANGE_TIMESTAMP = "includeStateChangeTimestamp";
    public static final String STATE_CHANGE_TIMESTAMP = "stateChangeTimestamp";
    public static final String STATE_BEFORE_DELETION = "stateBeforeDeletion";
    public static final String SEGMENT_AND_METADATA_LAYOUT = "segmentAndMetadataLayout";
    public static final String FRAGMENT_DESCRIPTIONS_LIST = "fragmentDescriptionsList";
    public static final String FRAGMENT_TYPE_BYTE = "fragmentTypeByte";
    public static final String OBJECT_TYPE_BYTE = "objectTypeByte";
    public static final String FILE_POSITION = "filePosition";
    public static final String BUFFER = "buffer";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @JsonCreator
    public TierPartitionStateJsonWrapper(@JsonProperty(value="header") Header header, @JsonProperty(value="entries") List<TierObjectMetadata> entries) {
        this.header = header;
        this.entries = entries;
    }

    @JsonProperty(value="header", required=true)
    public Header header() {
        return this.header;
    }

    @JsonProperty(value="entries", required=true)
    public List<TierObjectMetadata> entries() {
        return this.entries;
    }

    public static void writeToJson(Path jsonFile, Header header, List<TierObjectMetadata> listEntries) {
        try (FileWriter fileWriter = new FileWriter(jsonFile.toString());){
            JSON_MAPPER.writeValue((Writer)fileWriter, (Object)new TierPartitionStateJsonWrapper(header, listEntries));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static TierPartitionStateJsonWrapper readFromJson(Path jsonFile) throws IOException {
        return (TierPartitionStateJsonWrapper)JSON_MAPPER.readValue(new File(jsonFile.toString()), TierPartitionStateJsonWrapper.class);
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        JSON_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

