/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class SoloTierTopicDataLossValidator
extends TierTopicDataLossValidator {
    private Status status = Status.STOPPED;

    public SoloTierTopicDataLossValidator(TierTopicManagerConfig config, TierTopic tierTopic, TierObjectStore tierObjectStore, ReplicaManager replicaManager, Supplier<ConfluentAdmin> adminClientSupplier, LeaderEndpointSupplier leaderEndpointSupplier, Time time, Metrics metrics) {
        super(config, tierTopic, tierObjectStore, replicaManager, adminClientSupplier, leaderEndpointSupplier, time, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TierTopicHeadDataLossDetectionResponse detectDataLossInTierTopicHead(TierTopicHeadDataLossDetectionRequest request, ValidationSource validationSource, Producer<byte[], byte[]> producer, long timeoutMs) throws InterruptedException, ExecutionException {
        this.markRunning();
        try {
            TierTopicHeadDataLossDetectionResponse tierTopicHeadDataLossDetectionResponse = super.detectDataLossInTierTopicHead(request, validationSource, producer, timeoutMs);
            return tierTopicHeadDataLossDetectionResponse;
        }
        finally {
            this.markStopped();
        }
    }

    private synchronized void markRunning() {
        switch (this.status) {
            case STOPPED: {
                this.status = Status.RUNNING;
                break;
            }
            case RUNNING: {
                throw new UnsupportedOperationException("At a time, no more than one instance of tier topic head data loss detection is allowed to run. Please retry later.");
            }
        }
    }

    private synchronized void markStopped() {
        switch (this.status) {
            case STOPPED: {
                throw new IllegalStateException("Can't transition to STOPPED status while already in STOPPED status.");
            }
            case RUNNING: {
                this.status = Status.STOPPED;
            }
        }
    }

    private static enum Status {
        STOPPED,
        RUNNING;

    }
}

