/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TierTopicConsumerRewindPolicy {
    SKIP_MISSING_PARTITIONS(0),
    FAIL_ON_MISSING_PARTITIONS(1);

    private final byte id;
    private static final Map<Byte, TierTopicConsumerRewindPolicy> BYTE_ENUM_MAP;
    private static final Map<String, TierTopicConsumerRewindPolicy> STR_ENUM_MAP;

    private TierTopicConsumerRewindPolicy(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static TierTopicConsumerRewindPolicy forId(byte id) {
        return BYTE_ENUM_MAP.getOrDefault(id, null);
    }

    public static TierTopicConsumerRewindPolicy forString(String str) {
        return STR_ENUM_MAP.getOrDefault(str, null);
    }

    static {
        BYTE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(TierTopicConsumerRewindPolicy.values()).collect(Collectors.toMap(TierTopicConsumerRewindPolicy::id, Function.identity())));
        STR_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(TierTopicConsumerRewindPolicy.values()).collect(Collectors.toMap(Enum::toString, Function.identity())));
    }
}

