/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.ClusterRebalanceCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.EvenClusterLoadPlan;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BalancerOperationFailedException;
import org.apache.kafka.common.errors.BrokerAdditionInProgressException;
import org.apache.kafka.common.errors.BrokerFailureFixInProgressException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.EvenClusterLoadTaskInProgressException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class ClusterRebalanceCommand$
implements Logging {
    public static ClusterRebalanceCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterRebalanceCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        block33: {
            int exitCode = 0;
            None$ clientOpt = None$.MODULE$;
            try {
                try {
                    ClusterRebalanceCommandOptions opts = new ClusterRebalanceCommandOptions(args);
                    opts.checkArgs();
                    clientOpt = new Some((Object)this.createAdminClient(opts));
                    if (opts.options.has((OptionSpec)opts.statusOpt())) {
                        try {
                            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus((ConfluentAdmin)clientOpt.get());
                            break block33;
                        }
                        catch (ApiException runBalancerCommand_e) {
                            if (runBalancerCommand_e instanceof TimeoutException) {
                                throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof BalancerOfflineException ? true : (runBalancerCommand_e instanceof BalancerLoadError ? true : (runBalancerCommand_e instanceof BrokerRemovalInProgressException ? true : (runBalancerCommand_e instanceof BrokerAdditionInProgressException ? true : (runBalancerCommand_e instanceof EvenClusterLoadTaskInProgressException ? true : (runBalancerCommand_e instanceof BrokerFailureFixInProgressException ? true : (runBalancerCommand_e instanceof RebalancePlanComputationException ? true : runBalancerCommand_e instanceof BalancerOperationFailedException))))))) {
                                throw new AdminCommandFailedException(runBalancerCommand_e.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            throw runBalancerCommand_e;
                        }
                        catch (Throwable runBalancerCommand_e) {
                            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                            throw runBalancerCommand_e;
                        }
                    }
                    if (opts.options.has((OptionSpec)opts.describeOpt())) {
                        try {
                            ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask((ConfluentAdmin)clientOpt.get());
                            break block33;
                        }
                        catch (ApiException runBalancerCommand_e) {
                            if (runBalancerCommand_e instanceof TimeoutException) {
                                throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof BalancerOfflineException ? true : (runBalancerCommand_e instanceof BalancerLoadError ? true : (runBalancerCommand_e instanceof BrokerRemovalInProgressException ? true : (runBalancerCommand_e instanceof BrokerAdditionInProgressException ? true : (runBalancerCommand_e instanceof EvenClusterLoadTaskInProgressException ? true : (runBalancerCommand_e instanceof BrokerFailureFixInProgressException ? true : (runBalancerCommand_e instanceof RebalancePlanComputationException ? true : runBalancerCommand_e instanceof BalancerOperationFailedException))))))) {
                                throw new AdminCommandFailedException(runBalancerCommand_e.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            throw runBalancerCommand_e;
                        }
                        catch (Throwable runBalancerCommand_e) {
                            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                            throw runBalancerCommand_e;
                        }
                    }
                    if (opts.options.has((OptionSpec)opts.rebalanceOpt())) {
                        List<String> list = this.createGoalList(opts);
                        try {
                            ConfluentAdmin confluentAdmin = (ConfluentAdmin)clientOpt.get();
                            ClusterRebalanceCommand$.MODULE$.triggerEvenClusterLoad(list, confluentAdmin);
                            break block33;
                        }
                        catch (ApiException runBalancerCommand_e) {
                            if (runBalancerCommand_e instanceof TimeoutException) {
                                throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof BalancerOfflineException ? true : (runBalancerCommand_e instanceof BalancerLoadError ? true : (runBalancerCommand_e instanceof BrokerRemovalInProgressException ? true : (runBalancerCommand_e instanceof BrokerAdditionInProgressException ? true : (runBalancerCommand_e instanceof EvenClusterLoadTaskInProgressException ? true : (runBalancerCommand_e instanceof BrokerFailureFixInProgressException ? true : (runBalancerCommand_e instanceof RebalancePlanComputationException ? true : runBalancerCommand_e instanceof BalancerOperationFailedException))))))) {
                                throw new AdminCommandFailedException(runBalancerCommand_e.getMessage(), (Throwable)runBalancerCommand_e);
                            }
                            throw runBalancerCommand_e;
                        }
                        catch (Throwable runBalancerCommand_e) {
                            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                            throw runBalancerCommand_e;
                        }
                    }
                    if (!opts.options.has((OptionSpec)opts.evenClusterLoadPlanOpt())) break block33;
                    List<String> list = this.createGoalList(opts);
                    try {
                        ConfluentAdmin confluentAdmin = (ConfluentAdmin)clientOpt.get();
                        ClusterRebalanceCommand$.MODULE$.computeEvenClusterLoadPlan(list, confluentAdmin);
                    }
                    catch (ApiException runBalancerCommand_e) {
                        if (runBalancerCommand_e instanceof TimeoutException) {
                            throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                        }
                        if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                            ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                            throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                        }
                        if (runBalancerCommand_e instanceof BalancerOfflineException ? true : (runBalancerCommand_e instanceof BalancerLoadError ? true : (runBalancerCommand_e instanceof BrokerRemovalInProgressException ? true : (runBalancerCommand_e instanceof BrokerAdditionInProgressException ? true : (runBalancerCommand_e instanceof EvenClusterLoadTaskInProgressException ? true : (runBalancerCommand_e instanceof BrokerFailureFixInProgressException ? true : (runBalancerCommand_e instanceof RebalancePlanComputationException ? true : runBalancerCommand_e instanceof BalancerOperationFailedException))))))) {
                            throw new AdminCommandFailedException(runBalancerCommand_e.getMessage(), (Throwable)runBalancerCommand_e);
                        }
                        throw runBalancerCommand_e;
                    }
                    catch (Throwable runBalancerCommand_e) {
                        Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                        throw runBalancerCommand_e;
                    }
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)new StringBuilder(78).append("Unexpected error while running the kafka-rebalance-cluster command-line tool: ").append(e.getMessage()).toString());
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(this.msgWithLogIdent(ClusterRebalanceCommand$.$anonfun$main$5(e)));
                    }
                    exitCode = 1;
                }
            }
            finally {
                clientOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                Exit.exit((int)exitCode);
            }
        }
    }

    public void runBalancerCommand(ClusterRebalanceCommandOptions opts, ConfluentAdmin client, Function1<ConfluentAdmin, BoxedUnit> adminOperation) {
        try {
            adminOperation.apply((Object)client);
            return;
        }
        catch (ApiException e) {
            if (e instanceof TimeoutException) {
                throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)e);
            }
            if (e instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)e;
                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)e);
            }
            if (e instanceof BalancerOfflineException ? true : (e instanceof BalancerLoadError ? true : (e instanceof BrokerRemovalInProgressException ? true : (e instanceof BrokerAdditionInProgressException ? true : (e instanceof EvenClusterLoadTaskInProgressException ? true : (e instanceof BrokerFailureFixInProgressException ? true : (e instanceof RebalancePlanComputationException ? true : e instanceof BalancerOperationFailedException))))))) {
                throw new AdminCommandFailedException(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
            throw e;
        }
    }

    public void describeBalancerStatus(ConfluentAdmin client) {
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        BalancerStatusDescription balancerStatusDescription = (BalancerStatusDescription)client.describeBalancerStatus().description().get();
        BalancerStatus balancerStatus = balancerStatusDescription.balancerStatus();
        String balancerStatusString = new StringBuilder(17).append("Balancer status: ").append(balancerStatus).toString();
        balancerStatusString = new StringBuilder(0).append(balancerStatusString).append(System.lineSeparator()).toString();
        balancerStatusString = new StringBuilder(32).append(balancerStatusString).append("Balancer is running on brokers: ").append(balancerStatusDescription.brokerIds()).toString();
        if (balancerStatusDescription.balancerOperationError().isPresent()) {
            balancerStatusString = new StringBuilder(0).append(balancerStatusString).append(lineSeparator).toString();
            balancerStatusString = new StringBuilder(2).append(balancerStatusString).append(((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).errorMessage()).toString();
        }
        Predef$.MODULE$.println((Object)balancerStatusString);
    }

    public void describeAnyUnevenLoadTask(ConfluentAdmin client) {
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        EvenClusterLoadStatusDescription balancerUnevenLoadTaskDescription = (EvenClusterLoadStatusDescription)client.describeEvenClusterLoadStatus().description().get();
        BalancerSelfHealMode healUnevenLoadTrigger = balancerUnevenLoadTaskDescription.healUnevenLoadTrigger();
        EvenClusterLoadStatus currentBalancerUnevenLoadStatus = balancerUnevenLoadTaskDescription.currentEvenClusterLoadStatus();
        boolean processedError = false;
        String unevenLoadTaskDescriptionString = new StringBuilder(27).append("Uneven load balance status:").append(lineSeparator).toString();
        unevenLoadTaskDescriptionString = new StringBuilder(23).append(unevenLoadTaskDescriptionString).append("HealUnevenLoadTrigger: ").append(healUnevenLoadTrigger).toString();
        if (currentBalancerUnevenLoadStatus != null) {
            unevenLoadTaskDescriptionString = new StringBuilder(9).append(unevenLoadTaskDescriptionString).append(lineSeparator).append("Current: ").append(currentBalancerUnevenLoadStatus).toString();
            if (this.eligibleToDisplayError(currentBalancerUnevenLoadStatus)) {
                unevenLoadTaskDescriptionString = new StringBuilder(2).append(unevenLoadTaskDescriptionString).append(lineSeparator).append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage()).toString();
                processedError = true;
            }
            if (this.shouldDisplayUnevenLoadStatusUpdateTime(currentBalancerUnevenLoadStatus)) {
                unevenLoadTaskDescriptionString = new StringBuilder(18).append(unevenLoadTaskDescriptionString).append(lineSeparator).append("Last Update Time: ").append(ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.currentStatusLastUpdatetimeMs())).toString();
            }
        } else {
            unevenLoadTaskDescriptionString = new StringBuilder(19).append(unevenLoadTaskDescriptionString).append(lineSeparator).append(" No current status.").toString();
        }
        if (balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus() != null) {
            unevenLoadTaskDescriptionString = new StringBuilder(10).append(unevenLoadTaskDescriptionString).append(lineSeparator).append("Previous: ").append(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus()).toString();
            if (!processedError && this.eligibleToDisplayError(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus())) {
                unevenLoadTaskDescriptionString = new StringBuilder(2).append(unevenLoadTaskDescriptionString).append(lineSeparator).append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage()).toString();
            }
            if (this.shouldDisplayUnevenLoadStatusUpdateTime(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus())) {
                unevenLoadTaskDescriptionString = new StringBuilder(18).append(unevenLoadTaskDescriptionString).append(lineSeparator).append("Last Update Time: ").append(ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.previousStatusLastUpdatetimeMs())).toString();
            }
        }
        Predef$.MODULE$.println((Object)unevenLoadTaskDescriptionString);
    }

    public void triggerEvenClusterLoad(List<String> goalList, ConfluentAdmin client) {
        Predef$.MODULE$.println((Object)"Triggering an even cluster load...");
        client.triggerEvenClusterLoad(goalList).result().get();
        Predef$.MODULE$.println((Object)"Triggered an even cluster load operation. You can check its status by calling this command again with the `--describe` option.");
    }

    public void computeEvenClusterLoadPlan(List<String> goalList, ConfluentAdmin client) {
        Predef$.MODULE$.println((Object)"Computing even cluster load plan...");
        String plan = ((EvenClusterLoadPlan)client.computeEvenClusterLoadPlan(goalList).result().get()).printableForm();
        Predef$.MODULE$.println((Object)plan);
    }

    private boolean eligibleToDisplayError(EvenClusterLoadStatus evenClusterLoadStatus) {
        return evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED);
    }

    public boolean shouldDisplayPreviousUnevenLoadStatus(EvenClusterLoadStatus evenClusterLoadStatus) {
        return evenClusterLoadStatus != null && !evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.STARTING);
    }

    private boolean shouldDisplayUnevenLoadStatusUpdateTime(EvenClusterLoadStatus evenClusterLoadStatus) {
        return this.shouldDisplayPreviousUnevenLoadStatus(evenClusterLoadStatus);
    }

    private ConfluentAdmin createAdminClient(ClusterRebalanceCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        props.setProperty("request.timeout.ms", (String)opts.options.valueOf(opts.requestTimeout()));
        return ConfluentAdmin.create((Properties)props);
    }

    private List<String> createGoalList(ClusterRebalanceCommandOptions opts) {
        if (opts.options.has(opts.goalListOpt())) {
            return Utils.createGoalList((String)((String)opts.options.valueOf(opts.goalListOpt())));
        }
        return (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public static final /* synthetic */ String $anonfun$main$5(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private ClusterRebalanceCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$2$adapted(ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask(client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$3$adapted(List eta$0$1$1, ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.triggerEvenClusterLoad(eta$0$1$1, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$4$adapted(List eta$0$2$1, ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.computeEvenClusterLoadPlan(eta$0$2$1, client);
        return BoxedUnit.UNIT;
    }
}

