/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import kafka.catalog.CatalogTopicConfigUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;
import scala.collection.Set;
import scala.jdk.javaapi.CollectionConverters;

public class BrokerConfigChangeListener
implements BrokerReconfigurable {
    private final Logger logger;
    private final ZKMetadataCollector zkMetadataCollector;

    public BrokerConfigChangeListener(ZKMetadataCollector zkMetadataCollector, int nodeId) {
        this.zkMetadataCollector = zkMetadataCollector;
        this.logger = new LogContext("[BrokerConfigChangeListener node-id=" + nodeId + "]").logger(BrokerConfigChangeListener.class);
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        if (this.zkMetadataCollector.collectorConfig().fullConfigsEnable) {
            return CollectionConverters.asScala(CatalogTopicConfigUtils.FULL_BROKER_DEFAULT_CONFIGS_TO_PROPAGATE);
        }
        return CollectionConverters.asScala(CatalogTopicConfigUtils.BROKER_DEFAULT_CONFIGS_TO_PROPAGATE);
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        try {
            this.zkMetadataCollector.onBrokerDefaultConfigChange(oldConfig, newConfig);
        }
        catch (Exception e) {
            this.logger.error("Error sending broker config change to metadata collector", (Throwable)e);
        }
    }
}

