/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005t!B/_\u0011\u0003\u0019g!B3_\u0011\u00031\u0007\"\u00029\u0002\t\u0003\th!\u0002:\u0002\u0001\u0002\u001c\bBCA\u000f\u0007\tU\r\u0011\"\u0001\u0002 !Q\u0011QF\u0002\u0003\u0012\u0003\u0006I!!\t\t\u0015\u0005=2A!f\u0001\n\u0003\t\t\u0004\u0003\u0006\u0002:\r\u0011\t\u0012)A\u0005\u0003gA!\"a\u000f\u0004\u0005+\u0007I\u0011AA\u001f\u0011)\t\tf\u0001B\tB\u0003%\u0011q\b\u0005\u000b\u0003'\u001a!Q3A\u0005\u0002\u0005U\u0003BCA,\u0007\tE\t\u0015!\u0003\u0002L!Q\u0011\u0011L\u0002\u0003\u0016\u0004%\t!a\u0017\t\u0015\u0005e4A!E!\u0002\u0013\ti\u0006\u0003\u0006\u0002|\r\u0011)\u001a!C!\u0003{B!\"a&\u0004\u0005#\u0005\u000b\u0011BA@\u0011)\tIj\u0001BK\u0002\u0013\u0005\u00131\u0014\u0005\u000b\u0003S\u001b!\u0011#Q\u0001\n\u0005u\u0005BCAV\u0007\tU\r\u0011\"\u0011\u0002.\"Q\u0011\u0011X\u0002\u0003\u0012\u0003\u0006I!a,\t\u0015\u0005m6A!f\u0001\n\u0003\ni\f\u0003\u0006\u0002P\u000e\u0011\t\u0012)A\u0005\u0003\u007fCa\u0001]\u0002\u0005\u0002\u0005}\u0007\"CA\u0000\u0007\u0005\u0005I\u0011\u0001B\u0001\u0011%\u0011)bAI\u0001\n\u0003\u00119\u0002C\u0005\u0003.\r\t\n\u0011\"\u0001\u00030!I!1G\u0002\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005s\u0019\u0011\u0013!C\u0001\u0005wA\u0011Ba\u0010\u0004#\u0003%\tA!\u0011\t\u0013\t\u00153!%A\u0005\u0002\t\u001d\u0003\"\u0003B&\u0007E\u0005I\u0011\u0001B'\u0011%\u0011\tfAI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003X\r\t\n\u0011\"\u0001\u0003Z!I!qM\u0002\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005W\u001a\u0011\u0011!C\u0001\u0003cA\u0011B!\u001c\u0004\u0003\u0003%\tAa\u001c\t\u0013\tU4!!A\u0005B\t]\u0004\"\u0003BC\u0007\u0005\u0005I\u0011\u0001BD\u0011%\u0011\tjAA\u0001\n\u0003\u0012\u0019\nC\u0005\u0003\u0016\u000e\t\t\u0011\"\u0011\u0003\u0018\"I!\u0011T\u0002\u0002\u0002\u0013\u0005#1T\u0004\u000b\u0005?\u000b\u0011\u0011!E\u0001A\n\u0005f!\u0003:\u0002\u0003\u0003E\t\u0001\u0019BR\u0011\u0019\u0001(\u0006\"\u0001\u0003:\"I!Q\u0013\u0016\u0002\u0002\u0013\u0015#q\u0013\u0005\n\u0005wS\u0013\u0011!CA\u0005{C\u0011B!7+\u0003\u0003%\tIa7\t\u0013\tU(&!A\u0005\n\t]\bb\u0002B^\u0003\u0011\u0005!\u0011 \u0005\b\u0005w\u000bA\u0011\u0001C\u0005\u0011\u001d\u0011Y,\u0001C\u0001\t'AqAa/\u0002\t\u0003!i\u0002C\u0004\u0005&\u0005!I\u0001b\n\t\u000f\u0011m\u0012\u0001\"\u0001\u0005>!I!1X\u0001\u0002\u0002\u0013\u0005E\u0011\n\u0005\n\u00053\f\u0011\u0011!CA\t+B\u0011B!>\u0002\u0003\u0003%IAa>\u0007\u000b\u0015t\u0006I!@\t\u0015\t}\u0018H!f\u0001\n\u0003\t\t\u0004\u0003\u0006\u0004\u0002e\u0012\t\u0012)A\u0005\u0003gA!ba\u0001:\u0005+\u0007I\u0011AB\u0003\u0011)\u0019\u0019\"\u000fB\tB\u0003%1q\u0001\u0005\u000b\u0007+I$Q3A\u0005\u0002\r]\u0001BCB\u000es\tE\t\u0015!\u0003\u0004\u001a!Q1QD\u001d\u0003\u0016\u0004%\taa\b\t\u0015\rM\u0012H!E!\u0002\u0013\u0019\t\u0003\u0003\u0006\u00046e\u0012)\u001a!C\u0001\u0007oA!b!\u0010:\u0005#\u0005\u000b\u0011BB\u001d\u0011\u0019\u0001\u0018\b\"\u0001\u0004@!I11J\u001dC\u0002\u0013%1Q\n\u0005\t\u0007KJ\u0004\u0015!\u0003\u0004P!9!QS\u001d\u0005B\r\u001d\u0004B\u00029:\t\u0003\u0019I\u0007\u0003\u0004qs\u0011\u00051Q\u0012\u0005\b\u0007;KD\u0011ABP\u0011\u001d\u0019I+\u000fC\u0001\u0007WCqa!-:\t\u0003\u0019\u0019\fC\u0004\u00048f\"\ta!/\t\u000f\ru\u0016\b\"\u0001\u0004@\"I1\u0011\\\u001d\u0012\u0002\u0013\u0005!Q\n\u0005\n\u0003\u007fL\u0014\u0011!C\u0001\u00077D\u0011B!\u0006:#\u0003%\tAa\f\t\u0013\t5\u0012(%A\u0005\u0002\r\u001d\b\"\u0003B\u001asE\u0005I\u0011ABv\u0011%\u0011I$OI\u0001\n\u0003\u0019y\u000fC\u0005\u0003@e\n\n\u0011\"\u0001\u0004t\"I!qM\u001d\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005WJ\u0014\u0011!C\u0001\u0003cA\u0011B!\u001c:\u0003\u0003%\taa>\t\u0013\tU\u0014(!A\u0005B\t]\u0004\"\u0003BCs\u0005\u0005I\u0011AB~\u0011%\u0011\t*OA\u0001\n\u0003\u0012\u0019\nC\u0005\u0003\u001af\n\t\u0011\"\u0011\u0004\u0000\u00061!I]8lKJT!a\u00181\u0002\u000f\rdWo\u001d;fe*\t\u0011-A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0011\fQ\"\u00010\u0003\r\t\u0013xn[3s'\r\tq-\u001c\t\u0003Q.l\u0011!\u001b\u0006\u0002U\u0006)1oY1mC&\u0011A.\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!t\u0017BA8j\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t1M\u0001\u0006TKJ4XM]%oM>\u001cba\u0001;}\u0003/i\u0007CA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007u\f\u0019\"D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\nS:$XM\u001d8bYNTA!a\u0001\u0002\u0006\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007\u0005\fYA\u0003\u0003\u0002\u000e\u0005=\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0012\u0005\u0019qN]4\n\u0007\u0005UaPA\u000fD_:4G.^3oi\u0006+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p!\rA\u0017\u0011D\u0005\u0004\u00037I'a\u0002)s_\u0012,8\r^\u0001\u0010G2,8\u000f^3s%\u0016\u001cx.\u001e:dKV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)!\u0011qEA\u0005\u0003\u0019\u0019w.\\7p]&!\u00111FA\u0013\u0005=\u0019E.^:uKJ\u0014Vm]8ve\u000e,\u0017\u0001E2mkN$XM\u001d*fg>,(oY3!\u0003!\u0011'o\\6fe&#WCAA\u001a!\rA\u0017QG\u0005\u0004\u0003oI'aA%oi\u0006I!M]8lKJLE\rI\u0001\nK:$\u0007o\\5oiN,\"!a\u0010\u0011\r\u0005\u0005\u0013qIA&\u001b\t\t\u0019EC\u0002\u0002Fa\fA!\u001e;jY&!\u0011\u0011JA\"\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\r\u0012QJ\u0005\u0005\u0003\u001f\n)C\u0001\u0005F]\u0012\u0004x.\u001b8u\u0003))g\u000e\u001a9pS:$8\u000fI\u0001\u0014S:$XM\u001d\"s_.,'/\u00128ea>Lg\u000e^\u000b\u0003\u0003\u0017\nA#\u001b8uKJ\u0014%o\\6fe\u0016sG\r]8j]R\u0004\u0013aE3be2L8\u000b^1si2K7\u000f^3oKJ\u001cXCAA/!\u0019\t\t%a\u0018\u0002d%!\u0011\u0011MA\"\u0005\r\u0019V\r\u001e\t\u0005\u0003K\n\u0019H\u0004\u0003\u0002h\u0005=\u0004cAA5S6\u0011\u00111\u000e\u0006\u0004\u0003[\u0012\u0017A\u0002\u001fs_>$h(C\u0002\u0002r%\fa\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9S\u0006!R-\u0019:msN#\u0018M\u001d;MSN$XM\\3sg\u0002\n\u0001\u0003\u001b;uaN+'O^3s\u0005&tG-\u001a:\u0016\u0005\u0005}\u0004\u0003BAA\u0003'k!!a!\u000b\t\u0005\u001d\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0003iiR\u0004(bA1\u0002\f*!\u0011QRAH\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\u0012\u0006\u0011\u0011n\\\u0005\u0005\u0003+\u000b\u0019IA\u000bLC\u001a\\\u0017\r\u0013;uaN+'O^3s\u0005&tG-\u001a:\u0002#!$H\u000f]*feZ,'OQ5oI\u0016\u0014\b%\u0001\tbk\u0012LG\u000fT8h!J|g/\u001b3feV\u0011\u0011Q\u0014\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UA\u0003\u0003\u0015\tW\u000fZ5u\u0013\u0011\t9+!)\u0003!\u0005+H-\u001b;M_\u001e\u0004&o\u001c<jI\u0016\u0014\u0018!E1vI&$Hj\\4Qe>4\u0018\u000eZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAAX!\u0011\t\t,!.\u000e\u0005\u0005M&\u0002BAV\u0003KIA!a.\u00024\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002/%tG/\u001a:Ce>\\WM]\"mS\u0016tGoQ8oM&<WCAA`a\u0011\t\t-a3\u0011\u0011\u0005\u0005\u00131YA2\u0003\u000fLA!!2\u0002D\t\u0019Q*\u00199\u0011\t\u0005%\u00171\u001a\u0007\u0001\t-\ti-FA\u0001\u0002\u0003\u0015\t!!5\u0003\u0007}#\u0013'\u0001\rj]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001cuN\u001c4jO\u0002\nB!a5\u0002ZB\u0019\u0001.!6\n\u0007\u0005]\u0017NA\u0004O_RD\u0017N\\4\u0011\u0007!\fY.C\u0002\u0002^&\u00141!\u00118z)Q\t\t/!:\u0002h\u0006%\u00181^Aw\u0003_\f\t0a=\u0002vB\u0019\u00111]\u0002\u000e\u0003\u0005Aq!!\b\u0017\u0001\u0004\t\t\u0003C\u0004\u00020Y\u0001\r!a\r\t\u000f\u0005mb\u00031\u0001\u0002@!9\u00111\u000b\fA\u0002\u0005-\u0003bBA--\u0001\u0007\u0011Q\f\u0005\b\u0003w2\u0002\u0019AA@\u0011\u001d\tIJ\u0006a\u0001\u0003;Cq!a+\u0017\u0001\u0004\ty\u000bC\u0004\u0002<Z\u0001\r!a>1\t\u0005e\u0018Q \t\t\u0003\u0003\n\u0019-a\u0019\u0002|B!\u0011\u0011ZA\u007f\t1\ti-!>\u0002\u0002\u0003\u0005)\u0011AAi\u0003\u0011\u0019w\u000e]=\u0015)\u0005\u0005(1\u0001B\u0003\u0005\u000f\u0011IAa\u0003\u0003\u000e\t=!\u0011\u0003B\n\u0011%\tib\u0006I\u0001\u0002\u0004\t\t\u0003C\u0005\u00020]\u0001\n\u00111\u0001\u00024!I\u00111H\f\u0011\u0002\u0003\u0007\u0011q\b\u0005\n\u0003':\u0002\u0013!a\u0001\u0003\u0017B\u0011\"!\u0017\u0018!\u0003\u0005\r!!\u0018\t\u0013\u0005mt\u0003%AA\u0002\u0005}\u0004\"CAM/A\u0005\t\u0019AAO\u0011%\tYk\u0006I\u0001\u0002\u0004\ty\u000bC\u0005\u0002<^\u0001\n\u00111\u0001\u0002x\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\rU\u0011\t\tCa\u0007,\u0005\tu\u0001\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\nj\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0011\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00032)\"\u00111\u0007B\u000e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u000e+\t\u0005}\"1D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iD\u000b\u0003\u0002L\tm\u0011AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005\u0007RC!!\u0018\u0003\u001c\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B%U\u0011\tyHa\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\n\u0016\u0005\u0003;\u0013Y\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\tU#\u0006BAX\u00057\tabY8qs\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003\\A\"!Q\fB3!!\t\t%a1\u0003`\t\r\u0004cA;\u0003b%\u0019\u0011Q\u000f<\u0011\t\u0005%'Q\r\u0003\f\u0003\u001b\u0004\u0013\u0011!A\u0001\u0006\u0003\t\t.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005?\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002Z\nE\u0004\"\u0003B:G\u0005\u0005\t\u0019AA\u001a\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0010\t\u0007\u0005w\u0012\t)!7\u000e\u0005\tu$b\u0001B@S\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r%Q\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\n\n=\u0005c\u00015\u0003\f&\u0019!QR5\u0003\u000f\t{w\u000e\\3b]\"I!1O\u0013\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111G\u0001\ti>\u001cFO]5oOR\u0011!qL\u0001\u0007KF,\u0018\r\\:\u0015\t\t%%Q\u0014\u0005\n\u0005gB\u0013\u0011!a\u0001\u00033\f!bU3sm\u0016\u0014\u0018J\u001c4p!\r\t\u0019OK\n\u0005U\t\u0015V\u000e\u0005\r\u0003(\n5\u0016\u0011EA\u001a\u0003\u007f\tY%!\u0018\u0002\u0000\u0005u\u0015q\u0016BY\u0003Cl!A!+\u000b\u0007\t-\u0016.A\u0004sk:$\u0018.\\3\n\t\t=&\u0011\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:L\u0004\u0007\u0002BZ\u0005o\u0003\u0002\"!\u0011\u0002D\u0006\r$Q\u0017\t\u0005\u0003\u0013\u00149\fB\u0006\u0002N*\n\t\u0011!A\u0003\u0002\u0005EGC\u0001BQ\u0003\u0015\t\u0007\u000f\u001d7z)Q\t\tOa0\u0003B\n\r'Q\u0019Bd\u0005\u0013\u0014YM!4\u0003P\"9\u0011QD\u0017A\u0002\u0005\u0005\u0002bBA\u0018[\u0001\u0007\u00111\u0007\u0005\b\u0003wi\u0003\u0019AA \u0011\u001d\t\u0019&\fa\u0001\u0003\u0017Bq!!\u0017.\u0001\u0004\ti\u0006C\u0004\u0002|5\u0002\r!a \t\u000f\u0005eU\u00061\u0001\u0002\u001e\"9\u00111V\u0017A\u0002\u0005=\u0006bBA^[\u0001\u0007!\u0011\u001b\u0019\u0005\u0005'\u00149\u000e\u0005\u0005\u0002B\u0005\r\u00171\rBk!\u0011\tIMa6\u0005\u0019\u00055'qZA\u0001\u0002\u0003\u0015\t!!5\u0002\u000fUt\u0017\r\u001d9msR!!Q\u001cBy!\u0015A'q\u001cBr\u0013\r\u0011\t/\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011+!\u0014)/!\t\u00024\u0005}\u00121JA/\u0003\u007f\ni*a,\u0003j&\u0019!q]5\u0003\rQ+\b\u000f\\3:a\u0011\u0011YOa<\u0011\u0011\u0005\u0005\u00131YA2\u0005[\u0004B!!3\u0003p\u0012Y\u0011Q\u001a\u0018\u0002\u0002\u0003\u0005)\u0011AAi\u0011%\u0011\u0019PLA\u0001\u0002\u0004\t\t/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\tA\u000f\u0006\u0005\u0003|\u0012\rAQ\u0001C\u0004!\t!\u0017hE\u0003:O\u0006]Q.\u0001\u0002jI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013\u0015tG\rU8j]R\u001cXCAB\u0004!\u0019\u0011Yh!\u0003\u0004\u000e%!11\u0002B?\u0005\r\u0019V-\u001d\t\u0004I\u000e=\u0011bAB\t=\nAQI\u001c3Q_&tG/\u0001\u0006f]\u0012\u0004v.\u001b8ug\u0002\nAA]1dWV\u00111\u0011\u0004\t\u0006Q\n}\u00171M\u0001\u0006e\u0006\u001c7\u000eI\u0001\tM\u0016\fG/\u001e:fgV\u00111\u0011\u0005\t\u0007\u0007G\u0019Ic!\f\u000e\u0005\r\u0015\"\u0002BB\u0014\u0003K\tqAZ3biV\u0014X-\u0003\u0003\u0004,\r\u0015\"\u0001\u0003$fCR,(/Z:\u0011\t\r\r2qF\u0005\u0005\u0007c\u0019)CA\u000bTkB\u0004xN\u001d;fIZ+'o]5p]J\u000bgnZ3\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0013\u0001\u0002;bON,\"a!\u000f\u0011\u0011\u0005\u001541HA2\u0003GJA!!2\u0002x\u0005)A/Y4tAQa!1`B!\u0007\u0007\u001a)ea\u0012\u0004J!9!q #A\u0002\u0005M\u0002bBB\u0002\t\u0002\u00071q\u0001\u0005\b\u0007+!\u0005\u0019AB\r\u0011\u001d\u0019i\u0002\u0012a\u0001\u0007CAqa!\u000eE\u0001\u0004\u0019I$\u0001\u0007f]\u0012\u0004v.\u001b8ug6\u000b\u0007/\u0006\u0002\u0004PAA1\u0011KB,\u00073\u001ai!\u0004\u0002\u0004T)!1Q\u000bB?\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002F\u000eM\u0003\u0003BB.\u0007Cj!a!\u0018\u000b\t\r}\u0013QE\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019\u0019g!\u0018\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u001b\u0015tG\rU8j]R\u001cX*\u00199!)\t\t\u0019\u0007\u0006\u0007\u0003|\u000e-4QNB9\u0007k\u001aI\bC\u0004\u0003\u0000\"\u0003\r!a\r\t\u000f\r=\u0004\n1\u0001\u0002d\u0005!\u0001n\\:u\u0011\u001d\u0019\u0019\b\u0013a\u0001\u0003g\tA\u0001]8si\"91q\u000f%A\u0002\re\u0013\u0001\u00047jgR,g.\u001a:OC6,\u0007bBB>\u0011\u0002\u00071QP\u0001\taJ|Go\\2pYB!1qPBE\u001b\t\u0019\tI\u0003\u0003\u0004\u0004\u000e\u0015\u0015\u0001B1vi\"TAaa\"\u0002&\u0005A1/Z2ve&$\u00180\u0003\u0003\u0004\f\u000e\u0005%\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m)!\u0011Ypa$\u0004\u001a\u000em\u0005bBBI\u0013\u0002\u000711S\u0001\u0004E\u0016\u0004\bc\u00013\u0004\u0016&\u00191q\u00130\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"91qO%A\u0002\re\u0003bBB>\u0013\u0002\u00071QP\u0001\u0005]>$W\r\u0006\u0003\u0004\"\u000e\u001d\u0006\u0003BA\u0012\u0007GKAa!*\u0002&\t!aj\u001c3f\u0011\u001d\u00199H\u0013a\u0001\u00073\nqaZ3u\u001d>$W\r\u0006\u0003\u0004.\u000e=\u0006#\u00025\u0003`\u000e\u0005\u0006bBB<\u0017\u0002\u00071\u0011L\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\u0011\u0019\u0019j!.\t\u000f\r]D\n1\u0001\u0004Z\u0005AQM\u001c3Q_&tG\u000f\u0006\u0003\u0004\u000e\rm\u0006bBB<\u001b\u0002\u00071\u0011L\u0001\ri>\u001cVM\u001d<fe&sgm\u001c\u000b\fy\u000e\u00057QYBj\u0007+\u001c9\u000eC\u0004\u0004D:\u0003\r!a\u0019\u0002\u0013\rdWo\u001d;fe&#\u0007bBBd\u001d\u0002\u00071\u0011Z\u0001\u0007G>tg-[4\u0011\t\r-7qZ\u0007\u0003\u0007\u001bT1!a\u0002a\u0013\u0011\u0019\tn!4\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003wr\u0005\u0019AA@\u0011%\tIJ\u0014I\u0001\u0002\u0004\ti\nC\u0004\u0002,:\u0003\r!a,\u0002-Q|7+\u001a:wKJLeNZ8%I\u00164\u0017-\u001e7uIQ\"BBa?\u0004^\u000e}7\u0011]Br\u0007KD\u0011Ba@Q!\u0003\u0005\r!a\r\t\u0013\r\r\u0001\u000b%AA\u0002\r\u001d\u0001\"CB\u000b!B\u0005\t\u0019AB\r\u0011%\u0019i\u0002\u0015I\u0001\u0002\u0004\u0019\t\u0003C\u0005\u00046A\u0003\n\u00111\u0001\u0004:U\u00111\u0011\u001e\u0016\u0005\u0007\u000f\u0011Y\"\u0006\u0002\u0004n*\"1\u0011\u0004B\u000e+\t\u0019\tP\u000b\u0003\u0004\"\tmQCAB{U\u0011\u0019IDa\u0007\u0015\t\u0005e7\u0011 \u0005\n\u0005gB\u0016\u0011!a\u0001\u0003g!BA!#\u0004~\"I!1\u000f.\u0002\u0002\u0003\u0007\u0011\u0011\u001c\u000b\u0005\u0005\u0013#\t\u0001C\u0005\u0003tq\u000b\t\u00111\u0001\u0002Z\"9!q \u0019A\u0002\u0005M\u0002bBB\u0002a\u0001\u00071q\u0001\u0005\b\u0007+\u0001\u0004\u0019AB\r))\u0011Y\u0010b\u0003\u0005\u000e\u0011=A\u0011\u0003\u0005\b\u0005\u007f\f\u0004\u0019AA\u001a\u0011\u001d\u0019\u0019!\ra\u0001\u0007\u000fAqa!\u00062\u0001\u0004\u0019I\u0002C\u0004\u0004\u001eE\u0002\ra!\t\u0015\u0015\tmHQ\u0003C\f\t3!Y\u0002C\u0004\u0003\u0000J\u0002\r!a\r\t\u000f\r\r!\u00071\u0001\u0004\b!91Q\u0003\u001aA\u0002\re\u0001bBB\u001be\u0001\u00071\u0011\b\u000b\t\u0005w$y\u0002\"\t\u0005$!9!q`\u001aA\u0002\u0005M\u0002bBB\\g\u0001\u00071Q\u0002\u0005\b\u0007+\u0019\u0004\u0019AB\r\u0003E\u0019X\u000f\u001d9peR,GMR3biV\u0014Xm\u001d\u000b\u0005\tS!Y\u0003\u0005\u0005\u0002B\u0005\r\u00171MB\u0017\u0011\u001d\u0019i\u0002\u000ea\u0001\t[\u0001\u0002\"!\u0011\u0002D\u0006\rDq\u0006\t\u0005\tc!9$\u0004\u0002\u00054)!AQGA\u0005\u0003!iW\r^1eCR\f\u0017\u0002\u0002C\u001d\tg\u0011ABV3sg&|gNU1oO\u0016\faC\u001a:p[\n\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u000b\u0005\u0005w$y\u0004C\u0004\u0005BU\u0002\r\u0001b\u0011\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u0011\t\u0011EBQI\u0005\u0005\t\u000f\"\u0019D\u0001\nCe>\\WM\u001d*fO&\u001cHO]1uS>tG\u0003\u0004B~\t\u0017\"i\u0005b\u0014\u0005R\u0011M\u0003b\u0002B\u0000m\u0001\u0007\u00111\u0007\u0005\b\u0007\u00071\u0004\u0019AB\u0004\u0011\u001d\u0019)B\u000ea\u0001\u00073Aqa!\b7\u0001\u0004\u0019\t\u0003C\u0004\u00046Y\u0002\ra!\u000f\u0015\t\u0011]Cq\f\t\u0006Q\n}G\u0011\f\t\u000eQ\u0012m\u00131GB\u0004\u00073\u0019\tc!\u000f\n\u0007\u0011u\u0013N\u0001\u0004UkBdW-\u000e\u0005\n\u0005g<\u0014\u0011!a\u0001\u0005w\u0004")
public class Broker
implements Product,
scala.Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker broker) {
        return Broker$.MODULE$.unapply(broker);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, features, map);
    }

    public static Broker fromBrokerRegistration(BrokerRegistration brokerRegistration) {
        return Broker$.MODULE$.fromBrokerRegistration(brokerRegistration);
    }

    public static Broker apply(int n, EndPoint endPoint, Option<String> option) {
        return Broker$.MODULE$.apply(n, endPoint, option);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(n, seq, option, features);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option) {
        return Broker$.MODULE$.apply(n, seq, option);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull(Predef$.MODULE$.$conforms())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.endPoints().toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), List$.MODULE$.canBuildFrom())).asJava();
        Map interBrokerClientConfigs = ConfluentConfigs.clientConfigsForEndpoint(config.originals(), config.values(), (Endpoint)interBrokerEndpoint);
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)config.earlyStartListeners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Set$.MODULE$.canBuildFrom())).asJava(), httpServerBinder, auditLogProvider, metrics, interBrokerClientConfigs);
    }

    public AuditLogProvider toServerInfo$default$4() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof Broker)) break block3;
                Broker broker = (Broker)x$1;
                if (this.id() != broker.id()) break block3;
                Seq<EndPoint> seq = this.endPoints();
                Seq<EndPoint> seq2 = broker.endPoints();
                if (seq != null ? !seq.equals(seq2) : seq2 != null) break block3;
                Option<String> option = this.rack();
                Option<String> option2 = broker.rack();
                if (option != null ? !option.equals(option2) : option2 != null) break block3;
                Features<SupportedVersionRange> features = this.features();
                Features<SupportedVersionRange> features2 = broker.features();
                if (features != null ? !features.equals(features2) : features2 != null) break block3;
                scala.collection.immutable.Map<String, String> map = this.tags();
                scala.collection.immutable.Map<String, String> map2 = broker.tags();
                if ((map != null ? !map.equals(map2) : map2 != null) || !broker.canEqual(this)) break block3;
            }
            return true;
        }
        return false;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((TraversableOnce)endPoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    scala.Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final java.util.Set<String> earlyStartListeners;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;
        private final Map<String, ?> interBrokerClientConfig;

        public java.util.List<String> additionalRoleDefFiles() {
            return super.additionalRoleDefFiles();
        }

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public java.util.Set<String> earlyStartListeners() {
            return this.earlyStartListeners;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Map<String, ?> interBrokerClientConfig() {
            return this.interBrokerClientConfig;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, earlyStartListeners, httpServerBinder, auditLogProvider, metrics, interBrokerClientConfig);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public java.util.Set<String> copy$default$5() {
            return this.earlyStartListeners();
        }

        public KafkaHttpServerBinder copy$default$6() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$7() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$8() {
            return this.metrics();
        }

        public Map<String, ?> copy$default$9() {
            return this.interBrokerClientConfig();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.earlyStartListeners();
                }
                case 5: {
                    return this.httpServerBinder();
                }
                case 6: {
                    return this.auditLogProvider();
                }
                case 7: {
                    return this.metrics();
                }
                case 8: {
                    return this.interBrokerClientConfig();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.earlyStartListeners())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)Statics.anyHash(this.interBrokerClientConfig())), (int)9);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ServerInfo)) break block3;
                    ServerInfo serverInfo = (ServerInfo)x$1;
                    ClusterResource clusterResource = this.clusterResource();
                    ClusterResource clusterResource2 = serverInfo.clusterResource();
                    if ((clusterResource != null ? !clusterResource.equals(clusterResource2) : clusterResource2 != null) || this.brokerId() != serverInfo.brokerId()) break block3;
                    Collection collection = this.endpoints();
                    Collection collection2 = serverInfo.endpoints();
                    if (collection != null ? !((Object)collection).equals(collection2) : collection2 != null) break block3;
                    Endpoint endpoint = this.interBrokerEndpoint();
                    Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
                    if (endpoint != null ? !endpoint.equals(endpoint2) : endpoint2 != null) break block3;
                    Collection collection3 = this.earlyStartListeners();
                    Collection collection4 = serverInfo.earlyStartListeners();
                    if (collection3 != null ? !((Object)collection3).equals(collection4) : collection4 != null) break block3;
                    KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
                    KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
                    if (kafkaHttpServerBinder != null ? !kafkaHttpServerBinder.equals(kafkaHttpServerBinder2) : kafkaHttpServerBinder2 != null) break block3;
                    AuditLogProvider auditLogProvider = this.auditLogProvider();
                    AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
                    if (auditLogProvider != null ? !auditLogProvider.equals(auditLogProvider2) : auditLogProvider2 != null) break block3;
                    Metrics metrics = this.metrics();
                    Metrics metrics2 = serverInfo.metrics();
                    if (metrics != null ? !metrics.equals(metrics2) : metrics2 != null) break block3;
                    Map<String, ?> map = this.interBrokerClientConfig();
                    Map<String, ?> map2 = serverInfo.interBrokerClientConfig();
                    if ((map != null ? !((Object)map).equals(map2) : map2 != null) || !serverInfo.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.earlyStartListeners = earlyStartListeners;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            this.interBrokerClientConfig = interBrokerClientConfig;
            Product.$init$((Product)this);
        }
    }
}

