/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerChannelContext;
import kafka.controller.KRaftAbstractControllerBrokerRequestBatch$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}h!\u0002\u0017.\u0003\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0001\r\u0001B\u0001B\u0003%\u0011\rC\u0003e\u0001\u0011\u0005Q\rC\u0004m\u0001\t\u0007I\u0011A7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\u0002MDq!!\r\u0001A\u0003%A\u000fC\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026!A\u0011\u0011\n\u0001!\u0002\u0013\t9\u0004C\u0005\u0002L\u0001\u0011\r\u0011\"\u0001\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0001\u0002Z!A\u00111\u000e\u0001!\u0002\u0013\tY\u0006C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002p!I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\t\u0003'\u0003\u0001\u0015)\u0003\u0002r!Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011BAL\u0011-\tI\n\u0001a\u0001\u0002\u0004%I!a'\t\u0015\u0005}\u0005\u00011A\u0001B\u0003&!\nC\u0004\u0002\"\u00021\t!a)\t\u0013\u0005m\u0007!%A\u0005\u0002\u0005u\u0007bBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\ti\u0010\u0001C\u0001\u0003kDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003,\u0001!\tA!\f\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!q\u0007\u0001\u0005\u0002\t\u0015\u0003b\u0002B\u001c\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011i\t\u0001D\u0001\u0005\u001fCqAa(\u0001\t\u0013\u0011\t\u000bC\u0004\u0003(\u00021\tA!+\t\u000f\tU\u0006\u0001\"\u0003\u00038\"9!Q\u0018\u0001\u0007\u0002\t}\u0006b\u0002Bv\u0001\u0011\u0005!Q^\u0004\n\u0005cl\u0013\u0011!E\u0001\u0005g4\u0001\u0002L\u0017\u0002\u0002#\u0005!Q\u001f\u0005\u0007I&\"\tAa>\t\u0013\te\u0018&%A\u0005\u0002\tm(!K&SC\u001a$\u0018IY:ue\u0006\u001cGoQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007N\u0003\u0002/_\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003A\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001ge\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012a!\u00118z%\u00164\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f0\u0003\u0015)H/\u001b7t\u0013\tq4HA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t\tE)D\u0001C\u0015\t\u0019u&\u0001\u0004tKJ4XM]\u0005\u0003\u000b\n\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001R.\u001a;bI\u0006$\u0018\r\u0015:pm&$WM\u001d\t\u0004i!S\u0015BA%6\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002L\u00196\tQ&\u0003\u0002N[\tA2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7D_:$X\r\u001f;\u0002/5,G/\u00193bi\u00064VM]:j_:\u0004&o\u001c<jI\u0016\u0014\bc\u0001\u001bI!B\u0011\u0011KW\u0007\u0002%*\u00111\u000bV\u0001\u0007G>lWn\u001c8\u000b\u0005\r+&B\u0001\u0019W\u0015\t9\u0006,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0006\u0019qN]4\n\u0005m\u0013&aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\u0005\u0002L=&\u0011q,\f\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018aD6sC\u001a$8i\u001c8ue>dG.\u001a:\u0011\u0005Q\u0012\u0017BA26\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDC\u00024hQ&T7\u000e\u0005\u0002L\u0001!)qH\u0002a\u0001\u0001\")aI\u0002a\u0001\u000f\")aJ\u0002a\u0001\u001f\")AL\u0002a\u0001;\"9\u0001M\u0002I\u0001\u0002\u0004\t\u0017\u0001D2p]R\u0014x\u000e\u001c7fe&#W#\u00018\u0011\u0005Qz\u0017B\u000196\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002-1,\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;NCB,\u0012\u0001\u001e\t\u0005kjtG0D\u0001w\u0015\t9\b0A\u0004nkR\f'\r\\3\u000b\u0005e,\u0014AC2pY2,7\r^5p]&\u00111P\u001e\u0002\u0004\u001b\u0006\u0004\b#B;{{\u0006\u0015\u0001c\u0001@\u0002\u00025\tqP\u0003\u0002T+&\u0019\u00111A@\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qAA\u0016\u001d\u0011\tI!!\n\u000f\t\u0005-\u0011\u0011\u0005\b\u0005\u0003\u001b\tyB\u0004\u0003\u0002\u0010\u0005ua\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/\t\u0014A\u0002\u001fs_>$h(C\u0001Z\u0013\t9\u0006,\u0003\u00021-&\u00111+V\u0005\u0004\u0003Gy\u0018aB7fgN\fw-Z\u0005\u0005\u0003O\tI#A\fMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000fR1uC*\u0019\u00111E@\n\t\u00055\u0012q\u0006\u0002\u001b\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003O\tI#A\fmK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH/T1qA\u0005)2\u000f^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u001b\u0006\u0004XCAA\u001c!\u0015)(P\\A\u001d!\u0015)(0`A\u001e!\u0011\ti$a\u0011\u000f\t\u0005%\u0011qH\u0005\u0005\u0003\u0003\nI#\u0001\fTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$H)\u0019;b\u0013\u0011\t)%a\u0012\u00033M#x\u000e\u001d*fa2L7-\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003\u0003\nI#\u0001\fti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$X*\u00199!\u0003y)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0014%o\\6feN+G/\u0006\u0002\u0002PA!Q/!\u0015o\u0013\r\t\u0019F\u001e\u0002\u0004'\u0016$\u0018aH;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"s_.,'oU3uA\u0005)S\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b+\u0019:uSRLwN\\%oM>l\u0015\r]\u000b\u0003\u00037\u0002R!\u001e>~\u0003;\u0002B!a\u0018\u0002f9!\u0011\u0011BA1\u0013\u0011\t\u0019'!\u000b\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003O\nIG\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\u0005\r\u0014\u0011F\u0001'kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u!\u0006\u0014H/\u001b;j_:LeNZ8NCB\u0004\u0013AC;qI\u0006$X\rV=qKV\u0011\u0011\u0011\u000f\t\u0005\u0003g\nyH\u0004\u0003\u0002v\u0005mTBAA<\u0015\r\tIh`\u0001\te\u0016\fX/Z:ug&!\u0011QPA<\u0003Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\u0018\u0002BAA\u0003\u0007\u0013A\u0001V=qK*!\u0011QPA<\u00039)\b\u000fZ1uKRK\b/Z0%KF$B!!#\u0002\u0010B\u0019A'a#\n\u0007\u00055UG\u0001\u0003V]&$\b\"CAI%\u0005\u0005\t\u0019AA9\u0003\rAH%M\u0001\fkB$\u0017\r^3UsB,\u0007%\u0001\tnKR\fG-\u0019;b\u0013:\u001cH/\u00198dKV\t!*\u0001\u000bnKR\fG-\u0019;b\u0013:\u001cH/\u00198dK~#S-\u001d\u000b\u0005\u0003\u0013\u000bi\n\u0003\u0005\u0002\u0012V\t\t\u00111\u0001K\u0003EiW\r^1eCR\f\u0017J\\:uC:\u001cW\rI\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\n\u0006\u0015\u0016\u0011VAf\u0011\u0019\t9k\u0006a\u0001]\u0006A!M]8lKJLE\rC\u0004\u0002,^\u0001\r!!,\u0002\u000fI,\u0017/^3tiB\"\u0011qVA]!\u0019\t\u0019(!-\u00026&!\u00111WAB\u0005\u001d\u0011U/\u001b7eKJ\u0004B!a.\u0002:2\u0001A\u0001DA^\u0003S\u000b\t\u0011!A\u0003\u0002\u0005u&aA0%iE!\u0011qXAc!\r!\u0014\u0011Y\u0005\u0004\u0003\u0007,$a\u0002(pi\"Lgn\u001a\t\u0005\u0003k\n9-\u0003\u0003\u0002J\u0006]$AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\t\u0013\u00055w\u0003%AA\u0002\u0005=\u0017\u0001C2bY2\u0014\u0017mY6\u0011\u000fQ\n\t.!6\u0002\n&\u0019\u00111[\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA;\u0003/LA!!7\u0002x\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0016g\u0016tGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyN\u000b\u0003\u0002P\u0006\u00058FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055X'\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u00119,wOQ1uG\"$\"!!#\u0002\u001bM,G/\u00169eCR,G+\u001f9f)\u0011\tI)a?\t\u000f\u00055$\u00041\u0001\u0002r\u0005)1\r\\3be\u0006\u0001\u0013\r\u001a3MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)1\tIIa\u0001\u0003\u0010\tM!Q\u0004B\u0014\u0011\u001d\u0011)\u0001\ba\u0001\u0005\u000f\t\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u000b\t%!1\u00028\u000e\u0003aL1A!\u0004y\u0005\r\u0019V-\u001d\u0005\u0007\u0005#a\u0002\u0019A?\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9!Q\u0003\u000fA\u0002\t]\u0011a\u00077fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002L\u00053I1Aa\u0007.\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"9!q\u0004\u000fA\u0002\t\u0005\u0012!\u0005:fa2L7-Y!tg&<g.\\3oiB\u00191Ja\t\n\u0007\t\u0015RFA\tSKBd\u0017nY1BgNLwM\\7f]RDaA!\u000b\u001d\u0001\u0004\t\u0017!B5t\u001d\u0016<\u0018aH1eIN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e$pe\n\u0013xn[3sgRA\u0011\u0011\u0012B\u0018\u0005c\u0011\u0019\u0004C\u0004\u0003\u0006u\u0001\rAa\u0002\t\r\tEQ\u00041\u0001~\u0011\u0019\u0011)$\ba\u0001C\u0006yA-\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g.\u0001\u0012bI\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR4uN\u001d\"s_.,'o\u001d\u000b\u0007\u0003\u0013\u0013YD!\u0010\t\u000f\t\u0015a\u00041\u0001\u0003\b!9!q\b\u0010A\u0002\t\u0005\u0013A\u00039beRLG/[8ogB)!\u0011\u0002B\"{&\u0019\u00111\u000b=\u0015\t\u0005%%q\t\u0005\b\u0005\u000by\u0002\u0019\u0001B\u0004)Y\tIIa\u0013\u0003N\tE#Q\u000bB-\u0005;\u0012\tGa\u001e\u0003|\t}\u0004b\u0002B\u0003A\u0001\u0007!q\u0001\u0005\u0007\u0005\u001f\u0002\u0003\u0019\u00018\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"DaAa\u0015!\u0001\u0004i\u0018!\u00039beRLG/[8o\u0011\u0019\u00119\u0006\ta\u0001]\u00061A.Z1eKJDaAa\u0017!\u0001\u0004q\u0017a\u00037fC\u0012,'/\u00129pG\"DaAa\u0018!\u0001\u0004q\u0017A\u00049beRLG/[8o\u000bB|7\r\u001b\u0005\b\u0005G\u0002\u0003\u0019\u0001B3\u0003\u0011I7O]:\u0011\u000b\t\u001d$\u0011\u000f8\u000f\t\t%$Q\u000e\b\u0005\u0003'\u0011Y'C\u00017\u0013\r\u0011y'N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019H!\u001e\u0003\t1K7\u000f\u001e\u0006\u0004\u0005_*\u0004b\u0002B=A\u0001\u0007!qA\u0001\te\u0016\u0004H.[2bg\"9!Q\u0010\u0011A\u0002\t\u001d\u0011AE3gM\u0016\u001cG/\u001b<f\u001f\n\u001cXM\u001d<feNDqA!!!\u0001\u0004\u00119!A\bpM\u001ad\u0017N\\3SKBd\u0017nY1t\u0003]\u0019XM\u001c3MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\n\n\u001d%\u0011\u0012\u0005\u0007\u0005\u001f\n\u0003\u0019\u00018\t\r\t-\u0015\u00051\u0001^\u00039\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e\f!\u0004[1oI2,G*Z1eKJ\fe\u000eZ%teJ+7\u000f]8og\u0016$b!!#\u0003\u0012\nm\u0005b\u0002BJE\u0001\u0007!QS\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011Q\u000fBL\u0013\u0011\u0011I*a\u001e\u0003)1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKN\u0004xN\\:f\u0011\u0019\u0011iJ\ta\u0001]\u00061!M]8lKJ\f!d]3oIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN$b!!#\u0003$\n\u0015\u0006B\u0002B(G\u0001\u0007a\u000e\u0003\u0004\u0003\f\u000e\u0002\r!X\u0001\u001dQ\u0006tG\r\\3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)\u0019\tIIa+\u00034\"9!1\u0013\u0013A\u0002\t5\u0006\u0003BA;\u0005_KAA!-\u0002x\t1R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z:q_:\u001cX\r\u0003\u0004\u0003\u001e\u0012\u0002\rA\\\u0001\u0018g\u0016tGm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiN$b!!#\u0003:\nm\u0006B\u0002B(K\u0001\u0007a\u000e\u0003\u0004\u0003\f\u0016\u0002\r!X\u0001\u001aQ\u0006tG\r\\3Ti>\u0004(+\u001a9mS\u000e\f'+Z:q_:\u001cX\r\u0006\u0005\u0002\n\n\u0005'1\u001aBg\u0011\u001d\u0011\u0019M\na\u0001\u0005\u000b\f1c\u001d;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016\u0004B!!\u001e\u0003H&!!\u0011ZA<\u0005M\u0019Fo\u001c9SKBd\u0017nY1SKN\u0004xN\\:f\u0011\u0019\t9K\na\u0001]\"9!q\u001a\u0014A\u0002\tE\u0017\u0001\t9beRLG/[8o\u000bJ\u0014xN]:G_J$U\r\\3uS:<Gk\u001c9jGN\u0004rAa5\u0003\\v\u0014yN\u0004\u0003\u0003V\n]\u0007cAA\nk%\u0019!\u0011\\\u001b\u0002\rA\u0013X\rZ3g\u0013\rY(Q\u001c\u0006\u0004\u00053,\u0004\u0003\u0002Bq\u0005Ol!Aa9\u000b\u0007\t\u0015x0\u0001\u0005qe>$xnY8m\u0013\u0011\u0011IOa9\u0003\r\u0015\u0013(o\u001c:t\u0003U\u0019XM\u001c3SKF,Xm\u001d;t)>\u0014%o\\6feN$B!!#\u0003p\"1!qJ\u0014A\u00029\f\u0011f\u0013*bMR\f%m\u001d;sC\u000e$8i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA&*'\tI3\u0007\u0006\u0002\u0003t\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"A!@+\u0007\u0005\f\t\u000f")
public abstract class KRaftAbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final Function0<ControllerChannelContext> metadataProvider;
    private final Function0<MetadataVersion> metadataVersionProvider;
    private final StateChangeLogger stateChangeLogger;
    private final boolean kraftController;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private AbstractControlRequest.Type updateType;
    private ControllerChannelContext metadataInstance;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return KRaftAbstractControllerBrokerRequestBatch$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    private AbstractControlRequest.Type updateType() {
        return this.updateType;
    }

    private void updateType_$eq(AbstractControlRequest.Type x$1) {
        this.updateType = x$1;
    }

    private ControllerChannelContext metadataInstance() {
        return this.metadataInstance;
    }

    private void metadataInstance_$eq(ControllerChannelContext x$1) {
        this.metadataInstance = x$1;
    }

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
        this.metadataInstance_$eq((ControllerChannelContext)this.metadataProvider.apply());
    }

    public void setUpdateType(AbstractControlRequest.Type updateType) {
        this.updateType_$eq(updateType);
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
        this.metadataInstance_$eq(null);
        this.updateType_$eq(AbstractControlRequest.Type.UNKNOWN);
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        Option<ClusterLinkTopicState> mirrorState = this.metadataInstance().mirrorTopicState(topicPartition.topic());
        long mirrorStartOffset = BoxesRunTime.unboxToLong((Object)mirrorState.map((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToLong((long)KRaftAbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$1(topicPartition, state))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        MirrorTopicError mirrorTopicError = (MirrorTopicError)mirrorState.map((Function1 & Serializable & scala.Serializable)state -> {
            TopicLinkState topicLinkState = state.state();
            TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            return MirrorTopicError.forCode((short)state.mirrorTopicError().code(), (!(topicLinkState != null ? !topicLinkState.equals(topicLinkFailedMirror$) : topicLinkFailedMirror$ != null) ? 1 : 0) != 0);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MirrorTopicError.NO_ERROR);
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$6(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, mirrorState, mirrorStartOffset, mirrorTopicError, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.metadataInstance().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.metadataInstance().leaderEpoch(topicPartition);
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$2(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$addUpdateMetadataRequestForBrokers$2(this, brokerIds, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 >= 0));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, int controllerEpoch, TopicPartition partition, int leader, int leaderEpoch, int partitionEpoch, List<Object> isrs, Seq<Object> replicas, Seq<Object> effectiveObservers, Seq<Object> offlineReplicas) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> x$14 >= 0));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isrs.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setZkVersion(partitionEpoch).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)effectiveObservers.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setOfflineReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int leaderAndIsrRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 1 : 0))))));
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, stateChangeLog, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1);
        Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.leaderAndIsrRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.leaderAndIsrRequestMap().clear();
    }

    public abstract void handleLeaderAndIsrResponse(LeaderAndIsrResponse var1, int var2);

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        stateChangeLog.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" ").append("for ").append(this.updateMetadataRequestPartitionInfoMap().size()).append(" partitions").toString());
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short updateMetadataRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)8 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? (short)7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_2_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_0_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_9_0) ? (short)1 : 0)))))));
        Buffer liveBrokers = this.metadataInstance().liveOrShuttingDownBrokers().iterator().map((Function1 & Serializable & scala.Serializable)broker -> {
            Seq seq;
            if (updateMetadataRequestVersion == 0) {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                Node node = broker.node(listenerName);
                seq = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
            } else {
                seq = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()), Seq$.MODULE$.canBuildFrom());
            }
            Seq endpoints = seq;
            return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
        }).toBuffer();
        ObjectRef mirrorTopicMetadata = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        partitionStates.foreach((Function1 & Serializable & scala.Serializable)partitionState -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4(this, mirrorTopicMetadata, partitionState);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.metadataInstance().liveOrShuttingDownBrokerIds())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)((SeqLike)partitionStates.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.topicName(), Buffer$.MODULE$.canBuildFrom())).distinct()).filter(arg_0 -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$9$adapted(this.metadataInstance().topicIds(), arg_0))).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, this.metadataInstance().topicIds().apply(topic)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List brokerHealthStates = ((TraversableOnce)liveBrokers.map((Function1 & Serializable & scala.Serializable)x0$1 -> new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(x0$1.id()), Buffer$.MODULE$.canBuildFrom())).toList();
            Nil$ cells = Nil$.MODULE$;
            UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion, this.controllerId(), controllerEpoch, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokerHealthStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem)).asJava(), metadataVersion.isLinkCoordinatorSupported(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)cells).asJava(), $this.kraftController, this.updateType());
            this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$12(this, broker, r);
                return BoxedUnit.UNIT;
            });
        });
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public abstract void handleUpdateMetadataResponse(UpdateMetadataResponse var1, int var2);

    /*
     * WARNING - void declaration
     */
    private void sendStopReplicaRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short stopReplicaRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_6_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)1 : 0)));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(brokerId, partitionStates) -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$2(this, traceEnabled, stateChangeLog, stopReplicaRequestVersion, controllerEpoch, BoxesRunTime.unboxToInt((Object)brokerId), partitionStates);
            return BoxedUnit.UNIT;
        };
        Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.stopReplicaRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.stopReplicaRequestMap().clear();
    }

    public abstract void handleStopReplicaResponse(StopReplicaResponse var1, int var2, scala.collection.immutable.Map<TopicPartition, Errors> var3);

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch, stateChangeLog);
            this.updateType_$eq(AbstractControlRequest.Type.UNKNOWN);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ long $anonfun$addLeaderAndIsrRequestForBrokers$1(TopicPartition topicPartition$1, ClusterLinkTopicState state) {
        if (topicPartition$1.partition() < state.mirrorStartOffsets().size()) {
            return BoxesRunTime.unboxToLong((Object)state.mirrorStartOffsets().apply(topicPartition$1.partition()));
        }
        return -1L;
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$6(KRaftAbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, Option mirrorState$1, long mirrorStartOffset$1, MirrorTopicError mirrorTopicError$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setPartitionEpoch(leaderAndIsr.partitionEpoch()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setAddingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setRemovingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew$1 || alreadyNew).setClusterLinkId((String)mirrorState$1.map((Function1 & Serializable & scala.Serializable)state -> CoreUtils$.MODULE$.toJavaUUID(state.linkId()).toString()).orNull(Predef$.MODULE$.$conforms())).setClusterLinkSourceTopicId((Uuid)mirrorState$1.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.sourceTopicId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setClusterLinkTopicState((String)mirrorState$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.state().name()).orNull(Predef$.MODULE$.$conforms())).setLinkedLeaderEpoch(BoxesRunTime.unboxToInt((Object)leaderAndIsr.clusterLinkState().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.linkedLeaderEpoch())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setMirrorStartOffset(mirrorStartOffset$1).setMirrorTopicError(mirrorTopicError$1.code());
        if (((MetadataVersion)$this.metadataVersionProvider.apply()).isAtLeast(MetadataVersion.IBP_3_2_IV0)) {
            partitionState.setLeaderRecoveryState(leaderAndIsr.leaderRecoveryState().value());
        }
        return result.put((Object)topicPartition$1, (Object)partitionState);
    }

    public static final /* synthetic */ Option $anonfun$addStopReplicaRequestForBrokers$2(KRaftAbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyDelete = result.get((Object)topicPartition$2).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.deletePartition()));
        return result.put((Object)topicPartition$2, (Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(alreadyDelete || deletePartition$1));
    }

    public static final /* synthetic */ void $anonfun$addUpdateMetadataRequestForBrokers$2(KRaftAbstractControllerBrokerRequestBatch $this, Seq brokerIds$1, TopicPartition partition) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        boolean beingDeleted = $this.metadataInstance().isTopicQueuedUpForDeletion(partition.topic());
        Option<LeaderIsrAndControllerEpoch> option = $this.metadataInstance().partitionLeadershipInfo(partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = $this.metadataInstance().partitionReplicaAssignment(partition);
            Seq<Object> effectiveObservers = $this.metadataInstance().partitionEffectiveObservers(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> !$this.metadataInstance().isReplicaOnline(x$12, partition));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            $this.addUpdateMetadataRequestForBrokers((Seq<Object>)brokerIds$1, controllerEpoch, partition, updatedLeaderAndIsr.leader(), updatedLeaderAndIsr.leaderEpoch(), updatedLeaderAndIsr.partitionEpoch(), updatedLeaderAndIsr.isr(), replicas, effectiveObservers, (Seq<Object>)offlineReplicas);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(scala.collection.mutable.Set leaderIds$1, int broker$2, IntRef numBecomeLeaders$1, StateChangeLogger stateChangeLog$1, TopicPartition topicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState state) {
        String typeOfRequest;
        String string;
        leaderIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)state.leader()));
        if (broker$2 == state.leader()) {
            ++numBecomeLeaders$1.elem;
            string = "become-leader";
        } else {
            string = typeOfRequest = "become-follower";
        }
        if (stateChangeLog$1.isTraceEnabled()) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$10(KRaftAbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.handleLeaderAndIsrResponse(leaderAndIsrResponse, broker$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(KRaftAbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)broker))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            scala.collection.mutable.Set leaderIds = Set$.MODULE$.empty();
            IntRef numBecomeLeaders = IntRef.create((int)0);
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, state) -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(leaderIds, broker, numBecomeLeaders, stateChangeLog$1, topicPartition, state);
                return BoxedUnit.UNIT;
            };
            Map map = Implicits$.MODULE$.MapExtensionMethods(leaderAndIsrPartitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            stateChangeLog$1.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Sending LeaderAndIsr request to broker ").append(broker).append(" with ").append(numBecomeLeaders$1.elem).append(" become-leader ").append("and ").append(leaderAndIsrPartitionStates.size() - numBecomeLeaders$1.elem).append(" become-follower partitions").toString());
            Set leaders = (Set)((SetLike)$this.metadataInstance().liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.node($this.config.interBrokerListenerName()), scala.collection.Set$.MODULE$.canBuildFrom());
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableOnce)leaderAndIsrPartitionStates.keys().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.topic(), Iterable$.MODULE$.canBuildFrom())).toSet().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), false, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava(), $this.kraftController, $this.updateType());
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$10($this, broker, r);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(KRaftAbstractControllerBrokerRequestBatch $this, ObjectRef mirrorTopicMetadata$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        if (!((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem).contains((Object)partitionState.topicName())) {
            $this.metadataInstance().mirrorTopicState(partitionState.topicName()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.toMirrorTopicState()).foreach((Function1 & Serializable & scala.Serializable)mirrorState -> {
                mirrorTopicMetadata$1.elem = ((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionState.topicName()), (Object)mirrorState));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$12(KRaftAbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.handleUpdateMetadataResponse(updateMetadataResponse, broker$3);
    }

    private final void responseCallback$1(int brokerId, Function1 isPartitionDeleted, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                return;
            }
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.handleStopReplicaResponse(stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$5(scala.collection.mutable.Map stopReplicaTopicState$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        return ((StopReplicaRequestData.StopReplicaTopicState)stopReplicaTopicState$1.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$8(scala.collection.mutable.Map partitionStates$2, TopicPartition tp) {
        return partitionStates$2.get((Object)tp).exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.deletePartition()));
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$10(KRaftAbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$1$2, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                return;
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$11(IntRef numPartitionStateWithDelete$1, scala.collection.mutable.Map topicStatesWithDelete$1, IntRef numPartitionStateWithoutDelete$1, scala.collection.mutable.Map topicStatesWithoutDelete$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        scala.collection.mutable.Map map;
        if (partitionState.deletePartition()) {
            ++numPartitionStateWithDelete$1.elem;
            map = topicStatesWithDelete$1;
        } else {
            ++numPartitionStateWithoutDelete$1.elem;
            map = topicStatesWithoutDelete$1;
        }
        return ((StopReplicaRequestData.StopReplicaTopicState)map.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$14(TopicPartition x$20) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$15(KRaftAbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$2$1, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                return;
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$2(KRaftAbstractControllerBrokerRequestBatch $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$2, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, scala.collection.mutable.Map partitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            if (traceEnabled$1) {
                void forKeyValue$extension_f2;
                void forKeyValue$extension_$this2;
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> {
                    stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Sending StopReplica request ").append(partitionState).append(" to ").append("broker ").append(brokerId$2).append(" for partition ").append(topicPartition).toString());
                    return BoxedUnit.UNIT;
                };
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
            }
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaRequestVersion$1 >= 3) {
                void forKeyValue$extension_f3;
                void forKeyValue$extension_$this3;
                scala.collection.mutable.Map stopReplicaTopicState = Map$.MODULE$.empty();
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(stopReplicaTopicState, topicPartition, partitionState));
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this3), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f3, arg_0, arg_1));
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Sending StopReplica request for ").append(partitionStates.size()).append(" ").append("replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(stopReplicaTopicState.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$8(partitionStates, tp));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
                        TopicPartition pe = (TopicPartition)e.getKey();
                        TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                            return;
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            IntRef numPartitionStateWithDelete = IntRef.create((int)0);
            IntRef numPartitionStateWithoutDelete = IntRef.create((int)0);
            scala.collection.mutable.Map topicStatesWithDelete = Map$.MODULE$.empty();
            scala.collection.mutable.Map topicStatesWithoutDelete = Map$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$11(numPartitionStateWithDelete, topicStatesWithDelete, numPartitionStateWithoutDelete, topicStatesWithoutDelete, topicPartition, partitionState));
            Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            if (topicStatesWithDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Sending StopReplica request (delete = true) for ").append(numPartitionStateWithDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, true, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithDelete.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$14(x$20));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
                        TopicPartition pe = (TopicPartition)e.getKey();
                        TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                            return;
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if (topicStatesWithoutDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Sending StopReplica request (delete = false) for ").append(numPartitionStateWithoutDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithoutDelete.values().toBuffer()).asJava(), $this.kraftController);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, $this.sendRequest$default$3());
                return;
            }
            return;
        }
    }

    public KRaftAbstractControllerBrokerRequestBatch(KafkaConfig config, Function0<ControllerChannelContext> metadataProvider, Function0<MetadataVersion> metadataVersionProvider, StateChangeLogger stateChangeLogger, boolean kraftController) {
        this.config = config;
        this.metadataProvider = metadataProvider;
        this.metadataVersionProvider = metadataVersionProvider;
        this.stateChangeLogger = stateChangeLogger;
        this.kraftController = kraftController;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
        this.updateType = AbstractControlRequest.Type.UNKNOWN;
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(KRaftAbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, stateChangeLog$1, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)broker), leaderAndIsrPartitionStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$9$adapted(Map eta$0$1$1, String key) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains((Object)key));
    }
}

