/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractControlResponse;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003@\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011)\u0003!Q1A\u0005\u0002-C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t'\u0002\u0011)\u0019!C\u0001)\"A1\f\u0001B\u0001B\u0003%Q\u000b\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0001^\u0011!\u0019\u0007A!A!\u0002\u0013q\u0006\u0002\u00033\u0001\u0005\u000b\u0007I\u0011A3\t\u0011-\u0004!\u0011!Q\u0001\n\u0019D\u0001\u0002\u001c\u0001\u0003\u0006\u0004%\t!\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005]\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005{\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!A\u0011Q\u0007\u0001C\u0002\u0013%Q\u0007C\u0004\u00028\u0001\u0001\u000b\u0011\u0002\u001c\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA'\u0001\u0011\u0005\u0013Q\t\u0002\u0012%\u0016\fX/Z:u'\u0016tG\r\u00165sK\u0006$'B\u0001\u000f\u001e\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\"]A\u0011!\u0005L\u0007\u0002G)\u0011A%J\u0001\u0005kRLGN\u0003\u0002'O\u000511/\u001a:wKJT!A\b\u0015\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0005\u0003[\r\u0012!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011qFM\u0007\u0002a)\u0011\u0011'H\u0001\u0006kRLGn]\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\u0007d_:$(o\u001c7mKJLE-F\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001@!\t\u0001\u0015)D\u0001\u001c\u0013\t\u00115DA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA\u0005)\u0011/^3vKV\ta\t\u0005\u0002A\u000f&\u0011\u0001j\u0007\u0002\u001b\u0007>tGO]8m\u001b\u0016$\u0018\rZ1uC\u0006\u001b7-^7vY\u0006$xN]\u0001\u0007cV,W/\u001a\u0011\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\u0005a\u0005CA'Q\u001b\u0005q%BA((\u0003\u001d\u0019G.[3oiNL!!\u0015(\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\n!B\u0019:pW\u0016\u0014hj\u001c3f+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-(\u0003\u0019\u0019w.\\7p]&\u0011!l\u0016\u0002\u0005\u001d>$W-A\u0006ce>\\WM\u001d(pI\u0016\u0004\u0013AB2p]\u001aLw-F\u0001_!\ty\u0016-D\u0001a\u0015\t1S$\u0003\u0002cA\nY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKV\ta\r\u0005\u0002hS6\t\u0001N\u0003\u00022/&\u0011!\u000e\u001b\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0010sKF,Xm\u001d;SCR,\u0017I\u001c3Rk\u0016,X\rV5nK6+GO]5dgV\ta\u000e\u0005\u0002pq6\t\u0001O\u0003\u0002re\u0006!1m\u001c:f\u0015\t\u0019H/A\u0004nKR\u0014\u0018nY:\u000b\u0005U4\u0018AB=b[6,'OC\u0001x\u0003\r\u0019w.\\\u0005\u0003sB\u0014Q\u0001V5nKJ\fqD]3rk\u0016\u001cHOU1uK\u0006sG-U;fk\u0016$\u0016.\\3NKR\u0014\u0018nY:!\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002{B\u0011\u0001I`\u0005\u0003\u007fn\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002\t9\fW.\u001a\t\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005E\u0001cAA\u0006q5\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fy\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0014a\na\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\nq\u00051A(\u001b8jiz\"b#a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u00020\u0005E\u00121\u0007\t\u0003\u0001\u0002AQ\u0001\u000e\u000bA\u0002YBQ!\u0010\u000bA\u0002}BQ\u0001\u0012\u000bA\u0002\u0019CQA\u0013\u000bA\u00021CQa\u0015\u000bA\u0002UCQ\u0001\u0018\u000bA\u0002yCQ\u0001\u001a\u000bA\u0002\u0019DQ\u0001\u001c\u000bA\u00029DQa\u001f\u000bA\u0002uDq!a\u0001\u0015\u0001\u0004\t)!A\bt_\u000e\\W\r\u001e+j[\u0016|W\u000f^'t\u0003A\u0019xnY6fiRKW.Z8vi6\u001b\b%\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003{\u00012aNA \u0013\r\t\t\u0005\u000f\u0002\u0005+:LG/A\u0006ce>\\WM\u001d*fC\u0012LHCAA$!\r9\u0014\u0011J\u0005\u0004\u0003\u0017B$a\u0002\"p_2,\u0017M\\\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:\u0004")
public class RequestSendThread
extends ShutdownableThread
implements Logging {
    private final int controllerId;
    private final ControllerContext controllerContext;
    private final ControlMetadataAccumulator queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public ControlMetadataAccumulator queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    public void doWork() {
        void var3_3;
        void var2_2;
        QueueItem item = this.queue().take();
        if (item == null) {
            return;
        }
        ControlMetadataBatch batch = item.batch();
        Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> callback = item.callback();
        long l = item.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ArrayBuffer responses = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        var2_2.requests(this.stateChangeLogger()).foreach((Function1 & Serializable & scala.Serializable)requestBuilder -> {
            RequestSendThread.$anonfun$doWork$1(this, responses, requestBuilder);
            return BoxedUnit.UNIT;
        });
        if (var3_3 != null) {
            var3_3.apply((Object)var2_2, (Object)new ControlMetadataBatchResult((Seq<AbstractControlResponse>)responses));
            return;
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ void $anonfun$doWork$1(RequestSendThread $this, ArrayBuffer responses$1, AbstractControlRequest.Builder requestBuilder) {
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while ($this.isRunning() && !isSendSuccessful) {
                try {
                    if (!$this.brokerReady()) {
                        isSendSuccessful = false;
                        $this.backoff$1();
                        continue;
                    }
                    ClientRequest clientRequest = $this.networkClient().newClientRequest($this.brokerNode().idString(), (AbstractRequest.Builder)requestBuilder, $this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)$this.networkClient(), (ClientRequest)clientRequest, (Time)$this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext().epoch()).append(" fails to send request ").append(requestBuilder).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    $this.networkClient().close($this.brokerNode().idString());
                    isSendSuccessful = false;
                    $this.backoff$1();
                }
            }
            if (clientResponse != null) {
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(requestBuilder.apiKey()).toString());
                        }
                    }
                }
                AbstractControlResponse response = (AbstractControlResponse)clientResponse.responseBody();
                responses$1.$plus$eq((Object)response);
                $this.stateChangeLogger().withControllerEpoch($this.controllerContext().epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received response ").append(response).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append($this.brokerNode()).toString());
            }
        }
        catch (Throwable e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Controller ").append($this.controllerId()).append(" fails to send a request to broker ").append($this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            $this.networkClient().close($this.brokerNode().idString());
        }
    }

    public RequestSendThread(int controllerId, ControllerContext controllerContext, ControlMetadataAccumulator queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerContext = controllerContext;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, true, new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        Logging.$init$(this);
        this.logIdent_$eq(this.logPrefix);
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

