/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleanerMetrics$;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B+W\u0001mC\u0001B\u001c\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\t{\u0002\u0011)\u0019!C\u0001}\"I\u00111\u0004\u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005}\u0001BCA\u001e\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011Q\b\u0001\u0003\u0006\u0004%\t!a\u0010\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\t\t\u0005\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017Bq!!\u0016\u0001\t\u0003\t9\u0006\u0003\u0006\u0002f\u0001\u0011\r\u0011\"\u0001W\u0003OB\u0001\"a\u001e\u0001A\u0003%\u0011\u0011\u000e\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003wB\u0011\"! \u0001\u0001\u0004%I!a \t\u000f\u0005-\u0005\u0001)Q\u0005_\"I\u0011Q\u0013\u0001C\u0002\u0013\u0005\u0011q\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u001a\"I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111\u0015\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0001\"a.\u0001A\u0003&\u0011Q\u0015\u0005\n\u0003s\u0003!\u0019!C\u0005\u0003wC\u0001\"a1\u0001A\u0003%\u0011Q\u0018\u0005\u000b\u0003\u000b\u0004!\u0019!C\u0001-\u0006\u001d\u0007\u0002CAj\u0001\u0001\u0006I!!3\t\u0015\u0005U\u0007A1A\u0005\u0002Y\u000b9\u000e\u0003\u0005\u0003(\u0002\u0001\u000b\u0011BAm\u0011!\u0011I\u000b\u0001C\u0001-\n-\u0006\u0002\u0003B_\u0001\u0011\u0005aKa0\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003^!A!1\u0019\u0001!\n\u0013\u0011i\u0006C\u0004\u0003F\u0002!\tA!\u0018\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003^!9!\u0011\u001a\u0001\u0005B\t-\u0007b\u0002Bj\u0001\u0011\u0005#Q\u001b\u0005\b\u0005C\u0004A\u0011\tBr\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005[DqA!=\u0001\t\u0003\u0011\u0019\u0010C\u0005\u0003\u0000\u0002\t\n\u0011\"\u0001\u0004\u0002!91q\u0003\u0001\u0005\u0002\re\u0001bBB\u0013\u0001\u0011\u00051q\u0005\u0005\b\u0007[\u0001A\u0011AB\u0018\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007wAqaa\u0010\u0001\t\u0003\u0019\t\u0005C\u0004\u0004N\u0001!\taa\u0014\t\u0013\re\u0003!%A\u0005\u0002\rm\u0003bBB0\u0001\u0011\u00051\u0011\r\u0005\t\u0007W\u0002A\u0011\u0001-\u0002|!A1Q\u000e\u0001\u0005\u0002Y\u0013yLB\u0004\u0002j\u0002\u0001a+a;\t\u0015\u0005e\bG!A!\u0002\u0013\tY\u0010C\u0004\u0002VA\"\tA!\u0001\t\u000f\t\u0015\u0001\u0007\"\u0015\u0003\b!I!q\u0004\u0019C\u0002\u0013\u0005!\u0011\u0005\u0005\t\u0005S\u0001\u0004\u0015!\u0003\u0003$!I!1\u0006\u0019A\u0002\u0013\u0005!Q\u0006\u0005\n\u0005k\u0001\u0004\u0019!C\u0001\u0005oA\u0001Ba\u000f1A\u0003&!q\u0006\u0005\n\u0005\u007f\u0001\u0004\u0019!C\u0001\u0005\u0003B\u0011B!\u00131\u0001\u0004%\tAa\u0013\t\u0011\t=\u0003\u0007)Q\u0005\u0005\u0007BqAa\u00151\t\u0013\u0011)\u0006C\u0004\u0003\\A\"\tE!\u0018\t\u000f\t}\u0003\u0007\"\u0003\u0003b!9!\u0011\u000e\u0019\u0005\n\t\u0005\u0004b\u0002B>a\u0011%!Q\u0010\u0005\b\u0005\u0013\u0003D\u0011\u0002BF\u000f\u001d\u0019yG\u0016E\u0001\u0007c2a!\u0016,\t\u0002\rM\u0004bBA+\u0007\u0012\u00051Q\u000f\u0005\n\u0007o\u001a%\u0019!C\u0001\u0005\u0017D\u0001b!\u001fDA\u0003%!Q\u001a\u0005\b\u0007w\u001aE\u0011AB?\u0011)\u0019\ti\u0011b\u0001\n\u0003161\u0011\u0005\t\u0007\u001f\u001b\u0005\u0015!\u0003\u0004\u0006\"I1\u0011S\"C\u0002\u0013%11\u0011\u0005\t\u0007'\u001b\u0005\u0015!\u0003\u0004\u0006\"Q1QS\"C\u0002\u0013\u0005aka!\t\u0011\r]5\t)A\u0005\u0007\u000bC!b!'D\u0005\u0004%\tAVBB\u0011!\u0019Yj\u0011Q\u0001\n\r\u0015\u0005\"CBO\u0007\n\u0007I\u0011BBB\u0011!\u0019yj\u0011Q\u0001\n\r\u0015\u0005BCBQ\u0007\n\u0007I\u0011\u0001,\u0004$\"A1qU\"!\u0002\u0013\u0019)\u000bC\u0005\u0004*\u000e\u000b\n\u0011\"\u0001\u0004,\nQAj\\4DY\u0016\fg.\u001a:\u000b\u0005]C\u0016a\u00017pO*\t\u0011,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001a&\r\u001b\t\u0003;\u0002l\u0011A\u0018\u0006\u0002?\u0006)1oY1mC&\u0011\u0011M\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0016!B;uS2\u001c\u0018BA4e\u0005\u001daunZ4j]\u001e\u0004\"!\u001b7\u000e\u0003)T!a\u001b-\u0002\rM,'O^3s\u0013\ti'N\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005A\\X\"A9\u000b\u0005]\u0013(BA:u\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002vm\u000691\u000f^8sC\u001e,'BA-x\u0015\tA\u00180\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0006\u0019qN]4\n\u0005q\f(!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003}\u0004b!!\u0001\u0002\b\u0005-QBAA\u0002\u0015\r\t)AX\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0005\u0003\u0007\u00111aU3r!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!![8\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\u0010\t!a)\u001b7f\u0003!awn\u001a#jeN\u0004\u0013\u0001\u00027pON,\"!!\t\u0011\u000f\r\f\u0019#a\n\u00024%\u0019\u0011Q\u00053\u0003\tA{w\u000e\u001c\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006<\u0002\r\r|W.\\8o\u0013\u0011\t\t$a\u000b\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QGA\u001c\u001b\u00051\u0016bAA\u001d-\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011\u0011\t\t\u0004a\u0006\r\u0013bAA#c\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0003uS6,\u0007\u0003BA'\u0003#j!!a\u0014\u000b\u0007\u0015\fY#\u0003\u0003\u0002T\u0005=#\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA-\u00037\ni&a\u0018\u0002b\u0005\r\u0004cAA\u001b\u0001!)a.\u0003a\u0001_\")Q0\u0003a\u0001\u007f\"9\u0011QD\u0005A\u0002\u0005\u0005\u0002bBA\u001f\u0013\u0001\u0007\u0011\u0011\t\u0005\n\u0003\u0013J\u0001\u0013!a\u0001\u0003\u0017\nA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u001b\u0011\t\u0005-\u00141O\u0007\u0003\u0003[RA!a\u001c\u0002r\u00059Q.\u001a;sS\u000e\u001c(BA6w\u0013\u0011\t)(!\u001c\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0007G>tg-[4\u0016\u0003=\f!bY8oM&<w\fJ3r)\u0011\t\t)a\"\u0011\u0007u\u000b\u0019)C\u0002\u0002\u0006z\u0013A!\u00168ji\"A\u0011\u0011R\u0007\u0002\u0002\u0003\u0007q.A\u0002yIE\nqaY8oM&<\u0007\u0005K\u0002\u000f\u0003\u001f\u00032!XAI\u0013\r\t\u0019J\u0018\u0002\tm>d\u0017\r^5mK\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014XCAAM!\u0011\t)$a'\n\u0007\u0005ueKA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\u0013G>l\u0007/Y2uS>t7\t];NKR,'/\u0006\u0002\u0002&B)Q,a*\u0002,&\u0019\u0011\u0011\u00160\u0003\r=\u0003H/[8o!\r\u0019\u0017QV\u0005\u0004\u0003_#'a\u0004+ie\u0016\fGm]\"qk6+G/\u001a:\u0002-\r|W\u000e]1di&|gn\u00119v\u001b\u0016$XM]0%KF$B!!!\u00026\"I\u0011\u0011\u0012\n\u0002\u0002\u0003\u0007\u0011QU\u0001\u0014G>l\u0007/Y2uS>t7\t];NKR,'\u000fI\u0001\u000fG2,\u0017M\\3s\u001b\u0016$(/[2t+\t\ti\f\u0005\u0003\u00026\u0005}\u0016bAAa-\n\tBj\\4DY\u0016\fg.\u001a:NKR\u0014\u0018nY:\u0002\u001f\rdW-\u00198fe6+GO]5dg\u0002\n\u0011\u0002\u001e5s_R$H.\u001a:\u0016\u0005\u0005%\u0007\u0003BAf\u0003\u001fl!!!4\u000b\u0005\u0015\u0014\u0018\u0002BAi\u0003\u001b\u0014\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%\u0001\u0005dY\u0016\fg.\u001a:t+\t\tI\u000e\u0005\u0004\u0002\\\u0006\u0005\u0018Q]\u0007\u0003\u0003;TA!a8\u0002\u0004\u00059Q.\u001e;bE2,\u0017\u0002BAr\u0003;\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0019\u0011q\u001d\u0019\u000e\u0003\u0001\u0011Qb\u00117fC:,'\u000f\u00165sK\u0006$7\u0003\u0002\u0019\u0002n\n\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f\t(\u0001\u0003vi&d\u0017\u0002BA|\u0003c\u0014!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006AA\u000f\u001b:fC\u0012LE\rE\u0002^\u0003{L1!a@_\u0005\rIe\u000e\u001e\u000b\u0005\u0003K\u0014\u0019\u0001C\u0004\u0002zJ\u0002\r!a?\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0003\nA!!1\u0002B\r\u001d\u0011\u0011iA!\u0006\u0011\u0007\t=a,\u0004\u0002\u0003\u0012)\u0019!1\u0003.\u0002\rq\u0012xn\u001c;?\u0013\r\u00119BX\u0001\u0007!J,G-\u001a4\n\t\tm!Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t]a,A\u0004dY\u0016\fg.\u001a:\u0016\u0005\t\r\u0002\u0003BA\u001b\u0005KI1Aa\nW\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\nY\u0006\u001cHo\u0015;biN,\"Aa\f\u0011\t\u0005U\"\u0011G\u0005\u0004\u0005g1&\u0001D\"mK\u0006tWM]*uCR\u001c\u0018!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\ne\u0002\"CAEo\u0005\u0005\t\u0019\u0001B\u0018\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0004q\u0005=\u0015!\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ugV\u0011!1\t\t\u0005\u0003k\u0011)%C\u0002\u0003HY\u0013Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018!\u00067bgR\u0004&/Z\"mK\u0006t7\u000b^1ug~#S-\u001d\u000b\u0005\u0003\u0003\u0013i\u0005C\u0005\u0002\nj\n\t\u00111\u0001\u0003D\u0005\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\rY\u0014qR\u0001\nG\",7m\u001b#p]\u0016$B!!!\u0003X!9!\u0011\f\u001fA\u0002\u0005\u001d\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007I><vN]6\u0015\u0005\u0005\u0005\u0015\u0001\u0006;ss\u000ecW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0003dA\u0019QL!\u001a\n\u0007\t\u001ddLA\u0004C_>dW-\u00198\u0002#\rdW-\u00198GS2$\b.[3ti2{w\rK\u0003@\u0005[\u0012I\bE\u0003^\u0005_\u0012\u0019(C\u0002\u0003ry\u0013a\u0001\u001e5s_^\u001c\b\u0003BA\u001b\u0005kJ1Aa\u001eW\u0005QaunZ\"mK\u0006t\u0017N\\4Fq\u000e,\u0007\u000f^5p]\u000e\u0012!1O\u0001\tG2,\u0017M\u001c'pOR!\u0011\u0011\u0011B@\u0011\u001d\u0011\t\t\u0011a\u0001\u0005\u0007\u000b\u0011b\u00197fC:\f'\r\\3\u0011\t\u0005U\"QQ\u0005\u0004\u0005\u000f3&A\u0003'pOR{7\t\\3b]\u0006Y!/Z2pe\u0012\u001cF/\u0019;t)1\t\tI!$\u0003\u0012\nU%q\u0014BR\u0011\u001d\u0011y)\u0011a\u0001\u0003w\f!!\u001b3\t\u000f\tM\u0015\t1\u0001\u0003\n\u0005!a.Y7f\u0011\u001d\u00119*\u0011a\u0001\u00053\u000bAA\u001a:p[B\u0019QLa'\n\u0007\tueL\u0001\u0003M_:<\u0007b\u0002BQ\u0003\u0002\u0007!\u0011T\u0001\u0003i>DqA!*B\u0001\u0004\u0011y#A\u0003ti\u0006$8/A\u0005dY\u0016\fg.\u001a:tA\u0005)R.\u0019=Pm\u0016\u00148\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cH\u0003\u0002BW\u0005g\u00032!\u0018BX\u0013\r\u0011\tL\u0018\u0002\u0007\t>,(\r\\3\t\u000f\tU&\u00041\u0001\u00038\u0006\ta\rE\u0004^\u0005s\u000b)O!,\n\u0007\tmfLA\u0005Gk:\u001cG/[8oc\u0005yA-Z1e)\"\u0014X-\u00193D_VtG/\u0006\u0002\u0002|\u000691\u000f^1siV\u0004\u0018\u0001E:ikR$wn\u001e8DY\u0016\fg.\u001a:t\u0003!\u0019\b.\u001e;e_^t\u0017!\u0004:f[>4X-T3ue&\u001c7/A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\t5\u0007CBA\u0001\u0005\u001f\u0014I!\u0003\u0003\u0003R\u0006\r!aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003\u0003\u00139\u000eC\u0004\u0003Z\u0006\u0002\rAa7\u0002\u00139,woQ8oM&<\u0007cA5\u0003^&\u0019!q\u001c6\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\u0002\n\u0015(\u0011\u001e\u0005\b\u0005O\u0014\u0003\u0019\u0001Bn\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0003Z\n\u0002\rAa7\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t\tIa<\t\u000f\te3\u00051\u0001\u0002(\u0005\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\r\u0005\u0005%Q\u001fB}\u0011\u001d\u00119\u0010\na\u0001\u0003\u0017\tq\u0001Z1uC\u0012K'\u000fC\u0005\u0003|\u0012\u0002\n\u00111\u0001\u0003~\u0006\t\u0002/\u0019:uSRLwN\u001c+p%\u0016lwN^3\u0011\u000bu\u000b9+a\n\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\u0019A\u000b\u0003\u0003~\u000e\u00151FAB\u0004!\u0011\u0019Iaa\u0005\u000e\u0005\r-!\u0002BB\u0007\u0007\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rEa,\u0001\u0006b]:|G/\u0019;j_:LAa!\u0006\u0004\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\t\u0003\u0003\u001bYb!\b\u0004\"!9!\u0011\f\u0014A\u0002\u0005\u001d\u0002bBB\u0010M\u0001\u0007\u00111B\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\b\u0007G1\u0003\u0019AA\u0006\u0003)!Wm\u001d;M_\u001e$\u0015N]\u0001\u0014Q\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0005\u0003\u0003\u001bI\u0003C\u0004\u0004,\u001d\u0002\rA!\u0003\u0002\u0007\u0011L'/A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011\u0011QB\u0019\u0007g\u0019)\u0004C\u0004\u0003x\"\u0002\r!a\u0003\t\u000f\te\u0003\u00061\u0001\u0002(!91q\u0007\u0015A\u0002\te\u0015AB8gMN,G/A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005\u00055Q\b\u0005\b\u00053J\u0003\u0019AA\u0014\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!!!\u0004D!91Q\t\u0016A\u0002\r\u001d\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\u0005\u00051\u0011JA\u0014\u0013\u0011\u0019Y%a\u0001\u0003\u0011%#XM]1cY\u0016\fA\"Y<bSR\u001cE.Z1oK\u0012$\u0002Ba\u0019\u0004R\rM3Q\u000b\u0005\b\u00053Z\u0003\u0019AA\u0014\u0011\u001d\u00199d\u000ba\u0001\u00053C\u0011ba\u0016,!\u0003\u0005\rA!'\u0002\u00135\f\u0007pV1ji6\u001b\u0018AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\ru#\u0006\u0002BM\u0007\u000b\ta\u0005]1vg\u0016\u001cE.Z1oS:<gi\u001c:O_:\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\t\u0019\u0019\u0007\u0005\u0004\u0002\u0002\r%3Q\r\t\b;\u000e\u001d\u0014qEA\u001a\u0013\r\u0019IG\u0018\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u00031\u0019G.Z1oKJ\u001cu.\u001e8u\u0003)aunZ\"mK\u0006tWM\u001d\t\u0004\u0003k\u00195CA\"])\t\u0019\t(A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQb\u00197fC:,'oQ8oM&<GcA8\u0004\u0000!9\u0011\u0011P$A\u0002\tm\u0017!J'bq\n+hMZ3s+RLG.\u001b>bi&|g\u000eU3sG\u0016tG/T3ue&\u001cg*Y7f+\t\u0019)\t\u0005\u0003\u0004\b\u000e5UBABE\u0015\u0011\u0019Y)a\u0005\u0002\t1\fgnZ\u0005\u0005\u00057\u0019I)\u0001\u0014NCb\u0014UO\u001a4feV#\u0018\u000e\\5{CRLwN\u001c)fe\u000e,g\u000e^'fiJL7MT1nK\u0002\nad\u00117fC:,'OU3d_BL\b+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0002?\rcW-\u00198feJ+7m\u001c9z!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%\u0001\fNCb\u001cE.Z1o)&lW-T3ue&\u001cg*Y7f\u0003]i\u0015\r_\"mK\u0006tG+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000fNCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LX*\u001a;sS\u000e\u001ch*Y7f\u0003yi\u0015\r_\"p[B\f7\r^5p]\u0012+G.Y=NKR\u0014\u0018nY:OC6,\u0007%A\rEK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,\u0017A\u0007#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013aC'fiJL7MT1nKN,\"a!*\u0011\r\u0005\u0005!qZBC\u00031iU\r\u001e:jG:\u000bW.Z:!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111Q\u0016\u0016\u0005\u0003\u0017\u001a)\u0001")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private Option<ThreadsCpuMeter> compactionCpuMeter;
    private final LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    private Option<ThreadsCpuMeter> compactionCpuMeter() {
        return this.compactionCpuMeter;
    }

    private void compactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.compactionCpuMeter = x$1;
    }

    public LogCleanerMetrics kafka$log$LogCleaner$$cleanerMetrics() {
        return this.kafka$log$LogCleaner$$cleanerMetrics;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public double maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
        this.compactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)((SeqLike)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getId()), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq())));
    }

    private void shutdownCleaners() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    public void shutdown() {
        try {
            this.shutdownCleaners();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdownCleaners();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$1() {
        return (long)this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1))) / 1000L;
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$3() {
        return this.cleanerManager().cleanBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$4() {
        return this.cleanerManager().cleanableBytesLast().get();
    }

    public final /* synthetic */ long kafka$log$LogCleaner$$$anonfun$new$5() {
        return this.cleanerManager().uncleanableBytesLast().get();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$6() {
        return (int)((double)100 * this.cleanerManager().dirtiestLogCleanableRatio());
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$2) {
        return x$2.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        return (int)(this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$2))) * (double)100);
    }

    public final /* synthetic */ double kafka$log$LogCleaner$$$anonfun$new$9() {
        return BoxesRunTime.unboxToDouble((Object)this.compactionCpuMeter().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) * (double)100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$12() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$17(CleanerThread x$7) {
        return x$7.lastStats().bufferUtilization();
    }

    public static final /* synthetic */ int $anonfun$new$16(LogCleaner $this) {
        return (int)($this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$17(x$7))) * (double)100);
    }

    public static final /* synthetic */ int $anonfun$new$18(LogCleaner $this) {
        ArrayBuffer stats = (ArrayBuffer)$this.cleaners().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$23(CleanerThread x$11) {
        return x$11.lastStats().elapsedSecs();
    }

    public static final /* synthetic */ int $anonfun$new$22(LogCleaner $this) {
        return (int)$this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$23(x$11)));
    }

    public static final /* synthetic */ double $anonfun$new$25(CleanerThread x$12) {
        return x$12.lastPreCleanStats().maxCompactionDelayMs();
    }

    public static final /* synthetic */ int $anonfun$new$24(LogCleaner $this) {
        return (int)($this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$25(x$12))) / (double)1000);
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$16 -> x$16 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.compactionCpuMeter = None$.MODULE$;
        this.kafka$log$LogCleaner$$cleanerMetrics = new LogCleanerMetrics(LogCleanerMetrics$.MODULE$.$lessinit$greater$default$1());
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxCompactionDelayGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsCleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanablePartitionsUncleanableBytesLastRunGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxDirtyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setMaxBufferUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final double value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$log$LogCleaner$$cleanerMetrics().setCleanerRecopyPercentGauge(new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxBufferUtilizationPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$16(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$18(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCleanTimeMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$22(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.MaxCompactionDelayMetricsName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$24(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$17 -> (TopicPartition)x$17._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tOffset Map is Full: %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stats.offsetMapFull())}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            }, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastStats = new CleanerStats(LogCleaner.this.kafka$log$LogCleaner$$time, LogCleaner.this.kafka$log$LogCleaner$$cleanerMetrics());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

