/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxCpuMetricsCollector$SystemCpuTime$;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011=aAB@\u0002\u0002\u0001\tY\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037A!\"!\r\u0001\u0005\u000b\u0007I\u0011AA\u001a\u0011)\ty\u0005\u0001B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0003#\u0002!Q1A\u0005\u0002\u0005M\u0003BCA1\u0001\t\u0005\t\u0015!\u0003\u0002V!Q\u00111\r\u0001\u0003\u0006\u0004%\t!!\u001a\t\u0015\u00055\u0004A!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002p\u0001\u0011)\u0019!C\u0001\u0003KB!\"!\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA4\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kB\u0011\"!\"\u0001\u0005\u0004%I!a\"\t\u0011\u0005u\u0005\u0001)A\u0005\u0003\u0013C\u0011\"a(\u0001\u0005\u0004%I!a\"\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u0003\u0013C\u0011\"a)\u0001\u0005\u0004%I!a\"\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003\u0013C\u0011\"a*\u0001\u0005\u0004%I!!+\t\u0011\u0005}\u0006\u0001)A\u0005\u0003WC\u0011\"!1\u0001\u0001\u0004%I!a1\t\u0013\u0005-\u0007\u00011A\u0005\n\u00055\u0007\u0002CAm\u0001\u0001\u0006K!!2\t\u0013\u0005U\b\u00011A\u0005\n\u0005]\b\"CA\u0000\u0001\u0001\u0007I\u0011\u0002B\u0001\u0011!\u0011)\u0001\u0001Q!\n\u0005e\b\"\u0003B\u0005\u0001\u0001\u0007I\u0011BA|\u0011%\u0011Y\u0001\u0001a\u0001\n\u0013\u0011i\u0001\u0003\u0005\u0003\u0012\u0001\u0001\u000b\u0015BA}\u0011%\u0011)\u0002\u0001a\u0001\n\u0013\t9\u0010C\u0005\u0003\u0018\u0001\u0001\r\u0011\"\u0003\u0003\u001a!A!Q\u0004\u0001!B\u0013\tI\u0010C\u0005\u0003\"\u0001\u0011\r\u0011\"\u0003\u0002*\"A!1\u0005\u0001!\u0002\u0013\tY\u000bC\u0005\u0003&\u0001\u0001\r\u0011\"\u0003\u0002D\"I!q\u0005\u0001A\u0002\u0013%!\u0011\u0006\u0005\t\u0005[\u0001\u0001\u0015)\u0003\u0002F\"I!1\u0007\u0001A\u0002\u0013%\u00111\u0019\u0005\n\u0005k\u0001\u0001\u0019!C\u0005\u0005oA\u0001Ba\u000f\u0001A\u0003&\u0011Q\u0019\u0005\n\u0005\u007f\u0001!\u0019!C\u0005\u0003SC\u0001B!\u0011\u0001A\u0003%\u00111\u0016\u0005\n\u0005\u0007\u0002\u0001\u0019!C\u0005\u0003\u0007D\u0011B!\u0012\u0001\u0001\u0004%IAa\u0012\t\u0011\t-\u0003\u0001)Q\u0005\u0003\u000bD\u0011B!\u0015\u0001\u0001\u0004%I!a1\t\u0013\tM\u0003\u00011A\u0005\n\tU\u0003\u0002\u0003B-\u0001\u0001\u0006K!!2\t\u0013\tu\u0003\u00011A\u0005\n\u0005]\b\"\u0003B0\u0001\u0001\u0007I\u0011\u0002B1\u0011!\u0011)\u0007\u0001Q!\n\u0005e\b\"\u0003B5\u0001\t\u0007I\u0011\u0002B6\u0011!\u0011I\b\u0001Q\u0001\n\t5\u0004\"\u0003B>\u0001\t\u0007I\u0011\u0002B6\u0011!\u0011i\b\u0001Q\u0001\n\t5\u0004\"\u0003B@\u0001\t\u0007I\u0011BAU\u0011!\u0011\t\t\u0001Q\u0001\n\u0005-\u0006\"\u0003BB\u0001\u0001\u0007I\u0011BAb\u0011%\u0011)\t\u0001a\u0001\n\u0013\u00119\t\u0003\u0005\u0003\f\u0002\u0001\u000b\u0015BAc\u0011%\u0011\t\n\u0001a\u0001\n\u0013\t\u0019\rC\u0005\u0003\u0014\u0002\u0001\r\u0011\"\u0003\u0003\u0016\"A!\u0011\u0014\u0001!B\u0013\t)M\u0002\u0004\u0003\u001e\u0002\u0001%q\u0014\u0005\u000b\u0005[s$Q3A\u0005\u0002\u0005\r\u0007B\u0003BX}\tE\t\u0015!\u0003\u0002F\"Q!\u0011\u0017 \u0003\u0016\u0004%\t!a1\t\u0015\tMfH!E!\u0002\u0013\t)\r\u0003\u0006\u00036z\u0012)\u001a!C\u0001\u0003\u0007D!Ba.?\u0005#\u0005\u000b\u0011BAc\u0011)\u0011IL\u0010BK\u0002\u0013\u0005\u00111\u0019\u0005\u000b\u0005ws$\u0011#Q\u0001\n\u0005\u0015\u0007B\u0003B_}\tU\r\u0011\"\u0001\u0002D\"Q!q\u0018 \u0003\u0012\u0003\u0006I!!2\t\u0015\t\u0005gH!f\u0001\n\u0003\t\u0019\r\u0003\u0006\u0003Dz\u0012\t\u0012)A\u0005\u0003\u000bD!B!2?\u0005+\u0007I\u0011AAb\u0011)\u00119M\u0010B\tB\u0003%\u0011Q\u0019\u0005\u000b\u0005\u0013t$Q3A\u0005\u0002\u0005\r\u0007B\u0003Bf}\tE\t\u0015!\u0003\u0002F\"Q!Q\u001a \u0003\u0016\u0004%\t!a1\t\u0015\t=gH!E!\u0002\u0013\t)\r\u0003\u0006\u0003Rz\u0012)\u001a!C\u0001\u0003\u0007D!Ba5?\u0005#\u0005\u000b\u0011BAc\u0011\u001d\t\u0019H\u0010C\u0001\u0005+D\u0011Ba<?\u0005\u0004%\t!a1\t\u0011\tEh\b)A\u0005\u0003\u000bD\u0011Ba=?\u0003\u0003%\tA!>\t\u0013\r-a(%A\u0005\u0002\r5\u0001\"CB\u0012}E\u0005I\u0011AB\u0007\u0011%\u0019)CPI\u0001\n\u0003\u0019i\u0001C\u0005\u0004(y\n\n\u0011\"\u0001\u0004\u000e!I1\u0011\u0006 \u0012\u0002\u0013\u00051Q\u0002\u0005\n\u0007Wq\u0014\u0013!C\u0001\u0007\u001bA\u0011b!\f?#\u0003%\ta!\u0004\t\u0013\r=b(%A\u0005\u0002\r5\u0001\"CB\u0019}E\u0005I\u0011AB\u0007\u0011%\u0019\u0019DPI\u0001\n\u0003\u0019i\u0001C\u0005\u00046y\n\t\u0011\"\u0011\u00048!I11\t \u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0007\u000br\u0014\u0011!C\u0001\u0007\u000fB\u0011b!\u0015?\u0003\u0003%\tea\u0015\t\u0013\r\u0005d(!A\u0005\u0002\r\r\u0004\"CB7}\u0005\u0005I\u0011IB8\u0011%\u0019\tHPA\u0001\n\u0003\u001a\u0019\bC\u0005\u0004vy\n\t\u0011\"\u0011\u0004x\u001dI11\u0010\u0001\u0002\u0002#\u00051Q\u0010\u0004\n\u0005;\u0003\u0011\u0011!E\u0001\u0007\u007fBq!a\u001dk\t\u0003\u0019i\tC\u0005\u0004r)\f\t\u0011\"\u0012\u0004t!I1q\u00126\u0002\u0002\u0013\u00055\u0011\u0013\u0005\n\u0007OS\u0017\u0011!CA\u0007SCqaa/\u0001\t\u0003\u0019i\fC\u0004\u0004@\u0002!\ta!0\t\u000f\r\u0005\u0007\u0001\"\u0001\u0004>\"911\u0019\u0001\u0005\n\r\u0015\u0007\"CBf\u0001\u0011\u0005\u0011\u0011ABg\u0011\u001d\u0019y\r\u0001C\u0001\u0007{Cqa!5\u0001\t\u0003\u0019i\fC\u0004\u0004T\u0002!\ta!0\t\u000f\rU\u0007\u0001\"\u0003\u0004X\"91Q\u001c\u0001\u0005\u0002\r}\u0007bBBq\u0001\u0011\u000511]\u0004\u000b\u0007\u007f\f\t!!A\t\u0002\u0011\u0005a!C@\u0002\u0002\u0005\u0005\t\u0012\u0001C\u0002\u0011\u001d\t\u0019h\u001fC\u0001\t\u000bA\u0011\u0002b\u0002|#\u0003%\t\u0001\"\u0003\t\u0013\u0011510%A\u0005\u0002\u0011%!\u0001\u0007'j]VD8\t];NKR\u0014\u0018nY:D_2dWm\u0019;pe*!\u00111AA\u0003\u0003\u001diW\r\u001e:jGNT!!a\u0002\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q!!a\u0005\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005]\u0011\u0011\u0003\u0002\u0007\u0003:L(+\u001a4\u0002\u0011A\u0014xn\u0019*p_R\u0004B!!\b\u0002,9!\u0011qDA\u0014!\u0011\t\t#!\u0005\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003\u0013\ta\u0001\u0010:p_Rt\u0014\u0002BA\u0015\u0003#\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'\u0002BA\u0015\u0003#\tA\u0001^5nKV\u0011\u0011Q\u0007\t\u0005\u0003o\tY%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0015)H/\u001b7t\u0015\u0011\ty$!\u0011\u0002\r\r|W.\\8o\u0015\u0011\t9!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0013aA8sO&!\u0011QJA\u001d\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r1|wmZ3s+\t\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\u0011\tY&a\u0012\u0002\u000bMdg\r\u000e6\n\t\u0005}\u0013\u0011\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005AS\r\u001f9p]\u0016tG/[1mYf$UmY1zS:<w+\u001b8e_^\u001c\u0016N_3J]N+7m\u001c8egV\u0011\u0011q\r\t\u0005\u0003\u001f\tI'\u0003\u0003\u0002l\u0005E!aA%oi\u0006IS\r\u001f9p]\u0016tG/[1mYf$UmY1zS:<w+\u001b8e_^\u001c\u0016N_3J]N+7m\u001c8eg\u0002\n\u0001C[5gM&,7\u000fU3s'\u0016\u001cwN\u001c3\u0002#)LgMZ5fgB+'oU3d_:$\u0007%\u0001\u0004=S:LGO\u0010\u000b\r\u0003o\nY(! \u0002\u0000\u0005\u0005\u00151\u0011\t\u0004\u0003s\u0002QBAA\u0001\u0011\u001d\tIB\u0003a\u0001\u00037Aq!!\r\u000b\u0001\u0004\t)\u0004C\u0004\u0002R)\u0001\r!!\u0016\t\u0013\u0005\r$\u0002%AA\u0002\u0005\u001d\u0004\"CA8\u0015A\u0005\t\u0019AA4\u0003-aw.\u00193Bm\u001e\u0004\u0016\r\u001e5\u0016\u0005\u0005%\u0005\u0003BAF\u00033k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u0005M&dWM\u0003\u0003\u0002\u0014\u0006U\u0015a\u00018j_*\u0011\u0011qS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u00065%\u0001\u0002)bi\"\fA\u0002\\8bI\u00063x\rU1uQ\u0002\n\u0001b\u001d;biB\u000bG\u000f[\u0001\ngR\fG\u000fU1uQ\u0002\n1\u0002]5e'R\fG\u000fU1uQ\u0006a\u0001/\u001b3Ti\u0006$\b+\u0019;iA\u0005YAn\\1e\u0003Z<Gj\\2l+\t\tY\u000b\u0005\u0003\u0002.\u0006mVBAAX\u0015\u0011\t\t,a-\u0002\u000b1|7m[:\u000b\t\u0005U\u0016qW\u0001\u000bG>t7-\u001e:sK:$(\u0002BA]\u0003+\u000bA!\u001e;jY&!\u0011QXAX\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006aAn\\1e\u0003Z<Gj\\2lA\u0005\u0019B.Y:u\u0019>\fG-\u0011<h+B$\u0017\r^3NgV\u0011\u0011Q\u0019\t\u0005\u0003\u001f\t9-\u0003\u0003\u0002J\u0006E!\u0001\u0002'p]\u001e\fq\u0003\\1ti2{\u0017\rZ!wOV\u0003H-\u0019;f\u001bN|F%Z9\u0015\t\u0005=\u0017Q\u001b\t\u0005\u0003\u001f\t\t.\u0003\u0003\u0002T\u0006E!\u0001B+oSRD\u0011\"a6\u0015\u0003\u0003\u0005\r!!2\u0002\u0007a$\u0013'\u0001\u000bmCN$Hj\\1e\u0003Z<W\u000b\u001d3bi\u0016l5\u000f\t\u0015\b+\u0005u\u0017\u0011_Az!\u0011\ty.!<\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f1\"\u00198o_R\fG/[8og*!\u0011q]Au\u0003\u0011Q7-\u001b9\u000b\u0005\u0005-\u0018a\u00018fi&!\u0011q^Aq\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002(\u0006iAn\\1e\u0003Z<wJ\\3NS:,\"!!?\u0011\t\u0005=\u00111`\u0005\u0005\u0003{\f\tB\u0001\u0004E_V\u0014G.Z\u0001\u0012Y>\fG-\u0011<h\u001f:,W*\u001b8`I\u0015\fH\u0003BAh\u0005\u0007A\u0011\"a6\u0018\u0003\u0003\u0005\r!!?\u0002\u001d1|\u0017\rZ!wO>sW-T5oA!:\u0001$!8\u0002r\u0006M\u0018A\u00047pC\u0012\feo\u001a$jm\u0016l\u0015N\\\u0001\u0013Y>\fG-\u0011<h\r&4X-T5o?\u0012*\u0017\u000f\u0006\u0003\u0002P\n=\u0001\"CAl5\u0005\u0005\t\u0019AA}\u0003=aw.\u00193Bm\u001e4\u0015N^3NS:\u0004\u0003fB\u000e\u0002^\u0006E\u00181_\u0001\u0012Y>\fG-\u0011<h\r&4G/Z3o\u001b&t\u0017!\u00067pC\u0012\feo\u001a$jMR,WM\\'j]~#S-\u001d\u000b\u0005\u0003\u001f\u0014Y\u0002C\u0005\u0002Xv\t\t\u00111\u0001\u0002z\u0006\u0011Bn\\1e\u0003Z<g)\u001b4uK\u0016tW*\u001b8!Q\u001dq\u0012Q\\Ay\u0003g\fQb]=ti\u0016l7\t];M_\u000e\\\u0017AD:zgR,Wn\u00119v\u0019>\u001c7\u000eI\u0001\ri>$\u0018\r\\\"qkRKW.Z\u0001\u0011i>$\u0018\r\\\"qkRKW.Z0%KF$B!a4\u0003,!I\u0011q\u001b\u0012\u0002\u0002\u0003\u0007\u0011QY\u0001\u000ei>$\u0018\r\\\"qkRKW.\u001a\u0011)\u000f\r\ni.!=\u00032\u0005\u0012!\u0011E\u0001\u000ei>$\u0018\r\\%eY\u0016$\u0016.\\3\u0002#Q|G/\u00197JI2,G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002P\ne\u0002\"CAlK\u0005\u0005\t\u0019AAc\u00039!x\u000e^1m\u0013\u0012dW\rV5nK\u0002BsAJAo\u0003c\u0014\t$A\bfINK8\u000f^3n\u0007B+Fj\\2l\u0003A)GmU=ti\u0016l7\tU+M_\u000e\\\u0007%A\u0007jI2Lgn\u001a&jM\u001aLWm]\u0001\u0012S\u0012d\u0017N\\4KS\u001a4\u0017.Z:`I\u0015\fH\u0003BAh\u0005\u0013B\u0011\"a6+\u0003\u0003\u0005\r!!2\u0002\u001d%$G.\u001b8h\u0015&4g-[3tA!:1&!8\u0002r\n=\u0013E\u0001B \u00031!x\u000e^1m\u0015&4g-[3t\u0003A!x\u000e^1m\u0015&4g-[3t?\u0012*\u0017\u000f\u0006\u0003\u0002P\n]\u0003\"CAl[\u0005\u0005\t\u0019AAc\u00035!x\u000e^1m\u0015&4g-[3tA!:a&!8\u0002r\n=\u0013A\b7bgRLE\r\\3TsN$X-\\+uS2L'0\u0019;j_:4\u0016\r\\;f\u0003\tb\u0017m\u001d;JI2,7+_:uK6,F/\u001b7ju\u0006$\u0018n\u001c8WC2,Xm\u0018\u0013fcR!\u0011q\u001aB2\u0011%\t9\u000eMA\u0001\u0002\u0004\tI0A\u0010mCN$\u0018\n\u001a7f'f\u001cH/Z7Vi&d\u0017N_1uS>tg+\u00197vK\u0002Bs!MAo\u0003c\u0014y%\u0001\u0007ta\u0006\u001cW\rU1ui\u0016\u0014h.\u0006\u0002\u0003nA!!q\u000eB;\u001b\t\u0011\tH\u0003\u0003\u0003t\u0005]\u0016!\u0002:fO\u0016D\u0018\u0002\u0002B<\u0005c\u0012q\u0001U1ui\u0016\u0014h.A\u0007ta\u0006\u001cW\rU1ui\u0016\u0014h\u000eI\u0001\u001ba\u0006\u0014XM\u001c;iKNL7/\u00128dY>\u001cX\r\u001a)biR,'O\\\u0001\u001ca\u0006\u0014XM\u001c;iKNL7/\u00128dY>\u001cX\r\u001a)biR,'O\u001c\u0011\u0002\u001dA\u0014xnY3tg\u000e\u0003X\u000fT8dW\u0006y\u0001O]8dKN\u001c8\t];M_\u000e\\\u0007%A\tmCN$8+_:uK6T\u0015N\u001a4jKN\fQ\u0003\\1tiNK8\u000f^3n\u0015&4g-[3t?\u0012*\u0017\u000f\u0006\u0003\u0002P\n%\u0005\"CAls\u0005\u0005\t\u0019AAc\u0003Ia\u0017m\u001d;TsN$X-\u001c&jM\u001aLWm\u001d\u0011)\u000fi\ni.!=\u0003\u0010\u0006\u0012!qP\u0001\u0013Y\u0006\u001cH\u000f\u0015:pG\u0016\u001c8OS5gM&,7/\u0001\fmCN$\bK]8dKN\u001c(*\u001b4gS\u0016\u001cx\fJ3r)\u0011\tyMa&\t\u0013\u0005]G(!AA\u0002\u0005\u0015\u0017a\u00057bgR\u0004&o\\2fgNT\u0015N\u001a4jKN\u0004\u0003fB\u001f\u0002^\u0006E(q\u0012\u0002\u000e'f\u001cH/Z7DaV$\u0016.\\3\u0014\u000fy\niA!)\u0003(B!\u0011q\u0002BR\u0013\u0011\u0011)+!\u0005\u0003\u000fA\u0013x\u000eZ;diB!\u0011q\u0002BU\u0013\u0011\u0011Y+!\u0005\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\tU\u001cXM]\u0001\u0006kN,'\u000fI\u0001\u0005]&\u001cW-A\u0003oS\u000e,\u0007%\u0001\u0004tsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\u0011IG\r\\3\u0002\u000b%$G.\u001a\u0011\u0002\r%|w+Y5u\u0003\u001dIwnV1ji\u0002\n1!\u001b:r\u0003\u0011I'/\u001d\u0011\u0002\u000fM|g\r^%sc\u0006A1o\u001c4u\u0013J\f\b%A\u0003ti\u0016\fG.\u0001\u0004ti\u0016\fG\u000eI\u0001\u0006OV,7\u000f^\u0001\u0007OV,7\u000f\u001e\u0011\u0002\u0013\u001d,Xm\u001d;OS\u000e,\u0017AC4vKN$h*[2fAQ1\"q\u001bBn\u0005;\u0014yN!9\u0003d\n\u0015(q\u001dBu\u0005W\u0014i\u000fE\u0002\u0003Zzj\u0011\u0001\u0001\u0005\b\u0005[\u001b\u0006\u0019AAc\u0011\u001d\u0011\tl\u0015a\u0001\u0003\u000bDqA!.T\u0001\u0004\t)\rC\u0004\u0003:N\u0003\r!!2\t\u000f\tu6\u000b1\u0001\u0002F\"9!\u0011Y*A\u0002\u0005\u0015\u0007b\u0002Bc'\u0002\u0007\u0011Q\u0019\u0005\b\u0005\u0013\u001c\u0006\u0019AAc\u0011\u001d\u0011im\u0015a\u0001\u0003\u000bDqA!5T\u0001\u0004\t)-A\u0003u_R\fG.\u0001\u0004u_R\fG\u000eI\u0001\u0005G>\u0004\u0018\u0010\u0006\f\u0003X\n](\u0011 B~\u0005{\u0014yp!\u0001\u0004\u0004\r\u00151qAB\u0005\u0011%\u0011iK\u0016I\u0001\u0002\u0004\t)\rC\u0005\u00032Z\u0003\n\u00111\u0001\u0002F\"I!Q\u0017,\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\n\u0005s3\u0006\u0013!a\u0001\u0003\u000bD\u0011B!0W!\u0003\u0005\r!!2\t\u0013\t\u0005g\u000b%AA\u0002\u0005\u0015\u0007\"\u0003Bc-B\u0005\t\u0019AAc\u0011%\u0011IM\u0016I\u0001\u0002\u0004\t)\rC\u0005\u0003NZ\u0003\n\u00111\u0001\u0002F\"I!\u0011\u001b,\u0011\u0002\u0003\u0007\u0011QY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019yA\u000b\u0003\u0002F\u000eE1FAB\n!\u0011\u0019)ba\b\u000e\u0005\r]!\u0002BB\r\u00077\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\ru\u0011\u0011C\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0011\u0007/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIe\nqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\re\u0002\u0003BB\u001e\u0007\u0003j!a!\u0010\u000b\t\r}\u0012QS\u0001\u0005Y\u0006tw-\u0003\u0003\u0002.\ru\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007\u0013\u001ay\u0005\u0005\u0003\u0002\u0010\r-\u0013\u0002BB'\u0003#\u00111!\u00118z\u0011%\t9nYA\u0001\u0002\u0004\t9'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019)\u0006\u0005\u0004\u0004X\ru3\u0011J\u0007\u0003\u00073RAaa\u0017\u0002\u0012\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r}3\u0011\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004f\r-\u0004\u0003BA\b\u0007OJAa!\u001b\u0002\u0012\t9!i\\8mK\u0006t\u0007\"CAlK\u0006\u0005\t\u0019AB%\u0003!A\u0017m\u001d5D_\u0012,GCAA4\u0003!!xn\u0015;sS:<GCAB\u001d\u0003\u0019)\u0017/^1mgR!1QMB=\u0011%\t9\u000e[A\u0001\u0002\u0004\u0019I%A\u0007TsN$X-\\\"qkRKW.\u001a\t\u0004\u00053T7#\u00026\u0004\u0002\n\u001d\u0006CGBB\u0007\u0013\u000b)-!2\u0002F\u0006\u0015\u0017QYAc\u0003\u000b\f)-!2\u0002F\n]WBABC\u0015\u0011\u00199)!\u0005\u0002\u000fI,h\u000e^5nK&!11RBC\u0005I\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0019\u0015\u0005\ru\u0014!B1qa2LHC\u0006Bl\u0007'\u001b)ja&\u0004\u001a\u000em5QTBP\u0007C\u001b\u0019k!*\t\u000f\t5V\u000e1\u0001\u0002F\"9!\u0011W7A\u0002\u0005\u0015\u0007b\u0002B[[\u0002\u0007\u0011Q\u0019\u0005\b\u0005sk\u0007\u0019AAc\u0011\u001d\u0011i,\u001ca\u0001\u0003\u000bDqA!1n\u0001\u0004\t)\rC\u0004\u0003F6\u0004\r!!2\t\u000f\t%W\u000e1\u0001\u0002F\"9!QZ7A\u0002\u0005\u0015\u0007b\u0002Bi[\u0002\u0007\u0011QY\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Yka.\u0011\r\u0005=1QVBY\u0013\u0011\u0019y+!\u0005\u0003\r=\u0003H/[8o!a\tyaa-\u0002F\u0006\u0015\u0017QYAc\u0003\u000b\f)-!2\u0002F\u0006\u0015\u0017QY\u0005\u0005\u0007k\u000b\tBA\u0004UkBdW-\r\u0019\t\u0013\ref.!AA\u0002\t]\u0017a\u0001=%a\u0005!2/_:uK6\u001c\u0005/^+uS2L'0\u0019;j_:$\"!!?\u0002a\u0015D\bo\u001c8f]RL\u0017\r\u001c7z\t\u0016\u001c\u0017-_5oONK8\u000f^3n\u0007B,X\u000b^5mSj\fG/[8o\u0003Z,'/Y4f\u0003U\u0001(o\\2fgN\u001c\u0005/^+uS2L'0\u0019;j_:\fQcY;se\u0016tG\u000f\u0015:pG\u0016\u001c8OS5gM&,7\u000f\u0006\u0003\u0002F\u000e\u001d\u0007bBBee\u0002\u0007\u0011\u0011R\u0001\u0005a\u0006$\b.\u0001\u000bdkJ\u0014XM\u001c;TsN$X-\u001c&jM\u001aLWm\u001d\u000b\u0003\u0005/\fQb\u001c8f\u001b&tGj\\1e\u0003Z<\u0017A\u00044jm\u0016l\u0015N\u001c'pC\u0012\feoZ\u0001\u0012M&4G/Z3o\u001b&tGj\\1e\u0003Z<\u0017!D;qI\u0006$X\rT8bI\u00063x\r\u0006\u0003\u0004f\re\u0007bBBno\u0002\u0007\u0011QY\u0001\u0004]><\u0018AB;tC\ndW\r\u0006\u0002\u0004f\u0005!R.Y=cKJ+w-[:uKJlU\r\u001e:jGN$B!a4\u0004f\"91q]=A\u0002\r%\u0018\u0001\u0003:fO&\u001cHO]=\u0011\t\r-81`\u0007\u0003\u0007[TAaa<\u0004r\u0006!1m\u001c:f\u0015\u0011\t\u0019aa=\u000b\t\rU8q_\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\re\u0018aA2p[&!1Q`Bw\u0005=iU\r\u001e:jGN\u0014VmZ5tiJL\u0018\u0001\u0007'j]VD8\t];NKR\u0014\u0018nY:D_2dWm\u0019;peB\u0019\u0011\u0011P>\u0014\u0007m\fi\u0001\u0006\u0002\u0005\u0002\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"\u0001b\u0003+\t\u0005\u001d4\u0011C\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b")
public class LinuxCpuMetricsCollector {
    private volatile LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime$module;
    private final Time time;
    private final Logger logger;
    private final int exponentiallyDecayingWindowSizeInSeconds;
    private final int jiffiesPerSecond;
    private final Path loadAvgPath;
    private final Path statPath;
    private final Path pidStatPath;
    private final ReentrantLock loadAvgLock;
    @GuardedBy(value="loadAvgLock")
    private long lastLoadAvgUpdateMs;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgOneMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFiveMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFifteenMin;
    private final ReentrantLock systemCpuLock;
    @GuardedBy(value="systemCpuLock")
    private long totalCpuTime;
    @GuardedBy(value="systemCpuLock")
    private long totalIdleTime;
    private final ReentrantLock edSystemCPULock;
    @GuardedBy(value="edSystemCPULock")
    private long idlingJiffies;
    @GuardedBy(value="edSystemCPULock")
    private long totalJiffies;
    @GuardedBy(value="edSystemCPULock")
    private double lastIdleSystemUtilizationValue;
    private final Pattern spacePattern;
    private final Pattern parenthesisEnclosedPattern;
    private final ReentrantLock processCpuLock;
    @GuardedBy(value="processCpuLock")
    private long lastSystemJiffies;
    @GuardedBy(value="processCpuLock")
    private long lastProcessJiffies;

    public static int $lessinit$greater$default$5() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$4();
    }

    public LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime() {
        if (this.SystemCpuTime$module == null) {
            this.SystemCpuTime$lzycompute$1();
        }
        return this.SystemCpuTime$module;
    }

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public int exponentiallyDecayingWindowSizeInSeconds() {
        return this.exponentiallyDecayingWindowSizeInSeconds;
    }

    public int jiffiesPerSecond() {
        return this.jiffiesPerSecond;
    }

    private Path loadAvgPath() {
        return this.loadAvgPath;
    }

    private Path statPath() {
        return this.statPath;
    }

    private Path pidStatPath() {
        return this.pidStatPath;
    }

    private ReentrantLock loadAvgLock() {
        return this.loadAvgLock;
    }

    private long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    private void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    private double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    private void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    private double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    private void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    private double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    private void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    private ReentrantLock systemCpuLock() {
        return this.systemCpuLock;
    }

    private long totalCpuTime() {
        return this.totalCpuTime;
    }

    private void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    private long totalIdleTime() {
        return this.totalIdleTime;
    }

    private void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    private ReentrantLock edSystemCPULock() {
        return this.edSystemCPULock;
    }

    private long idlingJiffies() {
        return this.idlingJiffies;
    }

    private void idlingJiffies_$eq(long x$1) {
        this.idlingJiffies = x$1;
    }

    private long totalJiffies() {
        return this.totalJiffies;
    }

    private void totalJiffies_$eq(long x$1) {
        this.totalJiffies = x$1;
    }

    private double lastIdleSystemUtilizationValue() {
        return this.lastIdleSystemUtilizationValue;
    }

    private void lastIdleSystemUtilizationValue_$eq(double x$1) {
        this.lastIdleSystemUtilizationValue = x$1;
    }

    private Pattern spacePattern() {
        return this.spacePattern;
    }

    private Pattern parenthesisEnclosedPattern() {
        return this.parenthesisEnclosedPattern;
    }

    private ReentrantLock processCpuLock() {
        return this.processCpuLock;
    }

    private long lastSystemJiffies() {
        return this.lastSystemJiffies;
    }

    private void lastSystemJiffies_$eq(long x$1) {
        this.lastSystemJiffies = x$1;
    }

    private long lastProcessJiffies() {
        return this.lastProcessJiffies;
    }

    private void lastProcessJiffies_$eq(long x$1) {
        this.lastProcessJiffies = x$1;
    }

    public double systemCpuUtilization() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.systemCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idleTime = systemJiffies.idle() + systemJiffies.ioWait();
                        if (this.totalCpuTime() == 0L) {
                            this.totalCpuTime_$eq(total);
                            this.totalIdleTime_$eq(idleTime);
                            d2 = 0.0;
                            break block6;
                        }
                        long currWindowCpuTime = total - this.totalCpuTime();
                        long currWindowIdleTime = idleTime - this.totalIdleTime();
                        this.totalCpuTime_$eq(total);
                        this.totalIdleTime_$eq(idleTime);
                        double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
                        d = 100.0 - idlePercentage;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.systemCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double exponentiallyDecayingSystemCpuUtilizationAverage() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.edSystemCPULock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idle = systemJiffies.idle() + systemJiffies.ioWait();
                        long totalJiffiesElapsed = total - this.totalJiffies();
                        if (totalJiffiesElapsed == 0L) {
                            d2 = 100.0 - this.lastIdleSystemUtilizationValue();
                            break block6;
                        }
                        long idlingJiffiesElapsed = idle - this.idlingJiffies();
                        double elapsedTime = (double)totalJiffiesElapsed / (double)this.jiffiesPerSecond();
                        double correction = 1.0 - Math.exp(-elapsedTime / (double)this.exponentiallyDecayingWindowSizeInSeconds());
                        double currentIdleSystemUtilisationAverage = (double)idlingJiffiesElapsed * 100.0 / (double)totalJiffiesElapsed;
                        this.lastIdleSystemUtilizationValue_$eq(this.lastIdleSystemUtilizationValue() + correction * (currentIdleSystemUtilisationAverage - this.lastIdleSystemUtilizationValue()));
                        this.idlingJiffies_$eq(idle);
                        this.totalJiffies_$eq(total);
                        d = 100.0 - this.lastIdleSystemUtilizationValue();
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.edSystemCPULock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double processCpuUtilization() {
        double d;
        block8: {
            double d2;
            block7: {
                try {
                    try {
                        this.processCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long processJiffies = this.currentProcessJiffies(this.pidStatPath());
                        if (this.lastProcessJiffies() == 0L || this.lastSystemJiffies() == 0L) {
                            this.lastSystemJiffies_$eq(systemJiffies.total());
                            this.lastProcessJiffies_$eq(processJiffies);
                            d2 = 0.0;
                            break block7;
                        }
                        long currentWindowSystemJiffies = systemJiffies.total() - this.lastSystemJiffies();
                        long currentWindowProcessJiffies = processJiffies - this.lastProcessJiffies();
                        this.lastSystemJiffies_$eq(systemJiffies.total());
                        this.lastProcessJiffies_$eq(processJiffies);
                        if (currentWindowSystemJiffies == 0L) {
                            d2 = 0.0;
                            break block7;
                        }
                        d = (double)currentWindowProcessJiffies * 100.0 / (double)currentWindowSystemJiffies;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics for the process", t);
                        d = -1.0;
                    }
                    break block8;
                }
                finally {
                    this.processCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    private long currentProcessJiffies(Path path) {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).head();
        line = this.parenthesisEnclosedPattern().matcher(line).replaceFirst("process_name");
        String[] cpu = this.spacePattern().split(line);
        return new StringOps(Predef$.MODULE$.augmentString(cpu[13])).toLong() + new StringOps(Predef$.MODULE$.augmentString(cpu[14])).toLong();
    }

    public SystemCpuTime currentSystemJiffies() {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).head();
        String[] cpu = this.spacePattern().split(line);
        return new SystemCpuTime(this, new StringOps(Predef$.MODULE$.augmentString(cpu[1])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[2])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[3])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[4])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[5])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[6])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[7])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[8])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[9])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[10])).toLong());
    }

    public double oneMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgOneMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fiveMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFiveMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fifteenMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFifteenMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    private boolean updateLoadAvg(long now) {
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String[] loadAvgArr = ((String)((BufferLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.loadAvgPath())).asScala()).apply(0)).split("\\s+");
            this.loadAvgOneMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[0])).toDouble());
            this.loadAvgFiveMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[1])).toDouble());
            this.loadAvgFifteenMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[2])).toDouble());
            this.lastLoadAvgUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            return false;
        }
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-5m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-15m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-process-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            return;
        }
    }

    private final void SystemCpuTime$lzycompute$1() {
        synchronized (this) {
            if (this.SystemCpuTime$module == null) {
                this.SystemCpuTime$module = new LinuxCpuMetricsCollector$SystemCpuTime$(this);
            }
            return;
        }
    }

    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)"KafkaServer", (String)name);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.oneMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.fiveMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5() {
        return this.fifteenMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7() {
        return this.systemCpuUtilization();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9() {
        return this.exponentiallyDecayingSystemCpuUtilizationAverage();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11() {
        return this.processCpuUtilization();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Logger logger, int exponentiallyDecayingWindowSizeInSeconds, int jiffiesPerSecond) {
        this.time = time;
        this.logger = logger;
        this.exponentiallyDecayingWindowSizeInSeconds = exponentiallyDecayingWindowSizeInSeconds;
        this.jiffiesPerSecond = jiffiesPerSecond;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.pidStatPath = Paths.get(procRoot, "self", "stat");
        this.loadAvgLock = new ReentrantLock();
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.systemCpuLock = new ReentrantLock();
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
        this.edSystemCPULock = new ReentrantLock();
        this.idlingJiffies = 0L;
        this.totalJiffies = 0L;
        this.lastIdleSystemUtilizationValue = 0.0;
        this.spacePattern = Pattern.compile("\\s+");
        this.parenthesisEnclosedPattern = Pattern.compile("\\(.*?\\)");
        this.processCpuLock = new ReentrantLock();
        this.lastSystemJiffies = 0L;
        this.lastProcessJiffies = 0L;
    }

    public class SystemCpuTime
    implements Product,
    Serializable {
        private final long user;
        private final long nice;
        private final long system;
        private final long idle;
        private final long ioWait;
        private final long irq;
        private final long softIrq;
        private final long steal;
        private final long guest;
        private final long guestNice;
        private final long total;
        public final /* synthetic */ LinuxCpuMetricsCollector $outer;

        public long user() {
            return this.user;
        }

        public long nice() {
            return this.nice;
        }

        public long system() {
            return this.system;
        }

        public long idle() {
            return this.idle;
        }

        public long ioWait() {
            return this.ioWait;
        }

        public long irq() {
            return this.irq;
        }

        public long softIrq() {
            return this.softIrq;
        }

        public long steal() {
            return this.steal;
        }

        public long guest() {
            return this.guest;
        }

        public long guestNice() {
            return this.guestNice;
        }

        public long total() {
            return this.total;
        }

        public SystemCpuTime copy(long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            return new SystemCpuTime(this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer(), user, nice, system, idle, ioWait, irq, softIrq, steal, guest, guestNice);
        }

        public long copy$default$1() {
            return this.user();
        }

        public long copy$default$10() {
            return this.guestNice();
        }

        public long copy$default$2() {
            return this.nice();
        }

        public long copy$default$3() {
            return this.system();
        }

        public long copy$default$4() {
            return this.idle();
        }

        public long copy$default$5() {
            return this.ioWait();
        }

        public long copy$default$6() {
            return this.irq();
        }

        public long copy$default$7() {
            return this.softIrq();
        }

        public long copy$default$8() {
            return this.steal();
        }

        public long copy$default$9() {
            return this.guest();
        }

        public String productPrefix() {
            return "SystemCpuTime";
        }

        public int productArity() {
            return 10;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.user());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.nice());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.system());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.idle());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this.ioWait());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this.irq());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this.softIrq());
                }
                case 7: {
                    return BoxesRunTime.boxToLong((long)this.steal());
                }
                case 8: {
                    return BoxesRunTime.boxToLong((long)this.guest());
                }
                case 9: {
                    return BoxesRunTime.boxToLong((long)this.guestNice());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemCpuTime;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.user())), (int)Statics.longHash((long)this.nice())), (int)Statics.longHash((long)this.system())), (int)Statics.longHash((long)this.idle())), (int)Statics.longHash((long)this.ioWait())), (int)Statics.longHash((long)this.irq())), (int)Statics.longHash((long)this.softIrq())), (int)Statics.longHash((long)this.steal())), (int)Statics.longHash((long)this.guest())), (int)Statics.longHash((long)this.guestNice())), (int)10);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof SystemCpuTime && ((SystemCpuTime)x$1).kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() == this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer())) break block3;
                    SystemCpuTime systemCpuTime = (SystemCpuTime)x$1;
                    if (this.user() != systemCpuTime.user() || this.nice() != systemCpuTime.nice() || this.system() != systemCpuTime.system() || this.idle() != systemCpuTime.idle() || this.ioWait() != systemCpuTime.ioWait() || this.irq() != systemCpuTime.irq() || this.softIrq() != systemCpuTime.softIrq() || this.steal() != systemCpuTime.steal() || this.guest() != systemCpuTime.guest() || this.guestNice() != systemCpuTime.guestNice() || !systemCpuTime.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LinuxCpuMetricsCollector kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() {
            return this.$outer;
        }

        public SystemCpuTime(LinuxCpuMetricsCollector $outer, long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            this.user = user;
            this.nice = nice;
            this.system = system;
            this.idle = idle;
            this.ioWait = ioWait;
            this.irq = irq;
            this.softIrq = softIrq;
            this.steal = steal;
            this.guest = guest;
            this.guestNice = guestNice;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.total = user + nice + system + idle + ioWait + irq + softIrq + steal;
        }
    }
}

