/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0010!\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!b\u0001\n\u0003\u0001\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000ba\u0003A\u0011A-\t\u000f\u0001\u0004!\u0019!C\u0005C\"1A\u000e\u0001Q\u0001\n\tDq!\u001c\u0001C\u0002\u0013%\u0011\r\u0003\u0004o\u0001\u0001\u0006IA\u0019\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u0019!\b\u0001)A\u0005c\"9Q\u000f\u0001b\u0001\n\u0013\u0001\bB\u0002<\u0001A\u0003%\u0011\u000fC\u0004x\u0001\t\u0007I\u0011\u00029\t\ra\u0004\u0001\u0015!\u0003r\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\bbB@\u0001\u0005\u0004%I\u0001\u001d\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003r\u0011!\t\u0003A1A\u0005\u0002\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\u0007\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0002\u0002CA%\u0001\u0001\u0006I!!\r\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0002\u001a\u0019&tW\u000f\u001f#jg.lU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'O\u0003\u0002\"E\u00059Q.\u001a;sS\u000e\u001c(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\r\r|gNZ5h!\tq\u0013'D\u00010\u0015\t\u0001$%\u0001\u0004tKJ4XM]\u0005\u0003e=\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006A\u0001O]8d%>|G\u000f\u0005\u00026y9\u0011aG\u000f\t\u0003o!j\u0011\u0001\u000f\u0006\u0003s\u0011\na\u0001\u0010:p_Rt\u0014BA\u001e)\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mB\u0013\u0001\u0002;j[\u0016,\u0012!\u0011\t\u0003\u00052k\u0011a\u0011\u0006\u0003\t\u0016\u000bQ!\u001e;jYNT!AR$\u0002\r\r|W.\\8o\u0015\t\u0019\u0003J\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'D\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r1|wmZ3s+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+K\u0003\u0015\u0019HN\u001a\u001bk\u0013\t16K\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0019a\u0014N\\5u}Q)!\fX/_?B\u00111\fA\u0007\u0002A!)Af\u0002a\u0001[!)1g\u0002a\u0001i!)qh\u0002a\u0001\u0003\")qj\u0002a\u0001#\u0006A1\u000f^1u!\u0006$\b.F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-\u0001\u0003gS2,'BA4i\u0003\rq\u0017n\u001c\u0006\u0002S\u0006!!.\u0019<b\u0013\tYGM\u0001\u0003QCRD\u0017!C:uCR\u0004\u0016\r\u001e5!\u0003%iw.\u001e8u!\u0006$\b.\u0001\u0006n_VtG\u000fU1uQ\u0002\n\u0011d\u0015+B)~#UIV%D\u000b~s\u0015)T#`\r&+E\nR0J\tV\t\u0011\u000f\u0005\u0002(e&\u00111\u000f\u000b\u0002\u0004\u0013:$\u0018AG*U\u0003R{F)\u0012,J\u0007\u0016{f*Q'F?\u001aKU\t\u0014#`\u0013\u0012\u0003\u0013AG'P+:#v\fR#W\u0013\u000e+uLT!N\u000b~3\u0015*\u0012'E?&#\u0015aG'P+:#v\fR#W\u0013\u000e+uLT!N\u000b~3\u0015*\u0012'E?&#\u0005%A\fN\u001fVsEk\u0018#J%~s\u0015)T#`\r&+E\nR0J\t\u0006ARjT+O)~#\u0015JU0O\u00036+uLR%F\u0019\u0012{\u0016\n\u0012\u0011\u0002\u000f\u0011,g/[2fgV\t1\u0010\u0005\u00036yR\"\u0014BA??\u0005\ri\u0015\r]\u0001\tI\u00164\u0018nY3tA\u0005QQ.\u0019=GS\u0016dG-\u00133\u0002\u00175\f\u0007PR5fY\u0012LE\rI\u000b\u0003\u0003\u000b\u0001RaJA\u0004\u0003\u0017I1!!\u0003)\u0005\u0015\t%O]1z!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tQ\u0006!A.\u00198h\u0013\ri\u0014qB\u0001\t[\u0016$(/[2tA\u0005\u0011B-\u001b:fGR\u0014V\r^;s]\u001aKW\r\u001c3t+\t\tY\u0002E\u0003\u0002\u001e\u0005\u001d\u0012/\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&!\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G/A\neSJ,7\r\u001e*fiV\u0014hNR5fY\u0012\u001c\b%A\u0005qe\u001648\u000b^1uKV\u0011\u0011\u0011\u0007\t\b\u0003g\tI\u0004NA\u001e\u001b\t\t)D\u0003\u0003\u00028\u0005\r\u0012aB7vi\u0006\u0014G.Z\u0005\u0004{\u0006U\u0002#B\u0014\u0002\b\u0005u\u0002cB\u0014\u0002@\u0005\r\u00131I\u0005\u0004\u0003\u0003B#A\u0002+va2,'\u0007E\u0002(\u0003\u000bJ1!a\u0012)\u0005\u0011auN\\4\u0002\u0015A\u0014XM^*uCR,\u0007%\u0001\u0006nKR\u0014\u0018n\u0019*bi\u0016$b!a\u0014\u0002V\u0005e\u0003cA\u0014\u0002R%\u0019\u00111\u000b\u0015\u0003\r\u0011{WO\u00197f\u0011\u0019\t9\u0006\ba\u0001i\u00051A-\u001a<jG\u0016Da!a\u0017\u001d\u0001\u0004\t\u0018!B5oI\u0016D\u0018AB;tC\ndW\r\u0006\u0002\u0002bA\u0019q%a\u0019\n\u0007\u0005\u0015\u0004FA\u0004C_>dW-\u00198\u0002)5\f\u0017PY3SK\u001eL7\u000f^3s\u001b\u0016$(/[2t)\u0011\tY'!\u001d\u0011\u0007\u001d\ni'C\u0002\u0002p!\u0012A!\u00168ji\"9\u00111\u000f\u0010A\u0002\u0005U\u0014\u0001\u0003:fO&\u001cHO]=\u0011\t\u0005]\u0014qQ\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005!1m\u001c:f\u0015\r\t\u0013q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003\u000b\u000b1aY8n\u0013\u0011\tI)!\u001f\u0003\u001f5+GO]5dgJ+w-[:uef\u0004")
public class LinuxDiskMetricsCollector {
    private final KafkaConfig config;
    private final Time time;
    private final Logger logger;
    private final Path statPath;
    private final Path mountPath;
    private final int STAT_DEVICE_NAME_FIELD_ID;
    private final int MOUNT_DEVICE_NAME_FIELD_ID;
    private final int MOUNT_DIR_NAME_FIELD_ID;
    private final Map<String, String> devices;
    private final int maxFieldId;
    private final String[] metrics;
    private final Set<Object> directReturnFields;
    private final scala.collection.mutable.Map<String, Tuple2<Object, Object>[]> prevState;

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    private Path statPath() {
        return this.statPath;
    }

    private Path mountPath() {
        return this.mountPath;
    }

    private int STAT_DEVICE_NAME_FIELD_ID() {
        return this.STAT_DEVICE_NAME_FIELD_ID;
    }

    private int MOUNT_DEVICE_NAME_FIELD_ID() {
        return this.MOUNT_DEVICE_NAME_FIELD_ID;
    }

    private int MOUNT_DIR_NAME_FIELD_ID() {
        return this.MOUNT_DIR_NAME_FIELD_ID;
    }

    public Map<String, String> devices() {
        return this.devices;
    }

    private int maxFieldId() {
        return this.maxFieldId;
    }

    public String[] metrics() {
        return this.metrics;
    }

    private Set<Object> directReturnFields() {
        return this.directReturnFields;
    }

    private scala.collection.mutable.Map<String, Tuple2<Object, Object>[]> prevState() {
        return this.prevState;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized double metricRate(String device, int index) {
        if (!this.prevState().contains((Object)device) || index >= this.metrics().length || index < 0) {
            return -1.0;
        }
        try {
            void var11_8;
            void var9_7;
            Buffer validLines = (Buffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).map((Function1 & Serializable & scala.Serializable)line -> line.trim().split("\\s+"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)fields -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$metricRate$2(this, index, device, fields)));
            if (validLines.isEmpty()) {
                return -1.0;
            }
            long now = this.time().milliseconds();
            long value = new StringOps(Predef$.MODULE$.augmentString(((String[])validLines.head())[index + this.STAT_DEVICE_NAME_FIELD_ID() + 1])).toLong();
            if (this.directReturnFields().contains((Object)BoxesRunTime.boxToInteger((int)index))) {
                return value;
            }
            Tuple2 tuple2 = ((Tuple2[])this.prevState().apply((Object)device))[index];
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long prevTime = tuple2._1$mcJ$sp();
            long prevValue = tuple2._2$mcJ$sp();
            if (var9_7 == 0L) {
                ((Tuple2[])this.prevState().apply((Object)device))[index] = new Tuple2.mcJJ.sp(now, value);
                return 0.0;
            }
            long windowTime = now - var9_7;
            if (windowTime <= 0L) {
                return -1.0;
            }
            long windowValue = value - var11_8;
            ((Tuple2[])this.prevState().apply((Object)device))[index] = new Tuple2.mcJJ.sp(now, value);
            return (double)windowValue / ((double)windowTime / (double)1000);
        }
        catch (Throwable t) {
            this.logger().warn("Unable to retrieve disk metrics", t);
            return -1.0;
        }
    }

    public boolean usable() {
        return this.statPath().toFile().exists() && ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).nonEmpty() && this.mountPath().toFile().exists() && ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.mountPath())).asScala()).nonEmpty();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            this.devices().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$maybeRegisterMetrics$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                LinuxDiskMetricsCollector.$anonfun$maybeRegisterMetrics$2(this, registry, x$4);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$devices$2(LinuxDiskMetricsCollector $this, String[] fields) {
        return fields.length > RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper($this.MOUNT_DIR_NAME_FIELD_ID()), $this.MOUNT_DEVICE_NAME_FIELD_ID());
    }

    public static final /* synthetic */ boolean $anonfun$devices$3(LinuxDiskMetricsCollector $this, String[] fields) {
        return !fields[$this.MOUNT_DIR_NAME_FIELD_ID()].equals("/") && ((TraversableOnce)$this.config.logDirs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(fields[$this.MOUNT_DIR_NAME_FIELD_ID()])))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$new$2(LinuxDiskMetricsCollector $this, Tuple2 x$2) {
        if (x$2 != null) {
            String device = (String)x$2._1();
            $this.prevState().update((Object)device, Array$.MODULE$.fill($this.metrics().length, (Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L), ClassTag$.MODULE$.apply(Tuple2.class)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$metricRate$2(LinuxDiskMetricsCollector $this, int index$1, String device$1, String[] fields) {
        return fields.length > index$1 + $this.STAT_DEVICE_NAME_FIELD_ID() + 1 && fields[$this.STAT_DEVICE_NAME_FIELD_ID()].equals(device$1);
    }

    private static final void registerGauge$1(String name, LinkedHashMap tags, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)"KafkaServer", (String)name, (LinkedHashMap)tags);
        registry$1.newGauge(metricName, gauge);
    }

    public static final /* synthetic */ boolean $anonfun$maybeRegisterMetrics$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public final /* synthetic */ double kafka$metrics$LinuxDiskMetricsCollector$$$anonfun$maybeRegisterMetrics$4(String device$2, int index$2) {
        return this.metricRate(device$2, index$2);
    }

    public static final /* synthetic */ void $anonfun$maybeRegisterMetrics$2(LinuxDiskMetricsCollector $this, MetricsRegistry registry$1, Tuple2 x$4) {
        if (x$4 != null) {
            String device = (String)x$4._1();
            String dir = (String)x$4._2();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.metrics())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                String name = $this.metrics()[index];
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                tags.put("device", device);
                tags.put("metric", name);
                tags.put("mount-point", dir);
                LinuxDiskMetricsCollector.registerGauge$1("linux-diskstats", tags, (Gauge)new Gauge<Object>($this, device, index){
                    private final /* synthetic */ LinuxDiskMetricsCollector $outer;
                    private final String device$2;
                    private final int index$2;

                    public final double value() {
                        return this.$outer.kafka$metrics$LinuxDiskMetricsCollector$$$anonfun$maybeRegisterMetrics$4(this.device$2, this.index$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.device$2 = device$2;
                        this.index$2 = index$2;
                    }
                }, registry$1);
            });
            return;
        }
        throw new MatchError(null);
    }

    public LinuxDiskMetricsCollector(KafkaConfig config, String procRoot, Time time, Logger logger) {
        this.config = config;
        this.time = time;
        this.logger = logger;
        this.statPath = Paths.get(procRoot, "diskstats");
        this.mountPath = Paths.get(procRoot, "mounts");
        this.STAT_DEVICE_NAME_FIELD_ID = 2;
        this.MOUNT_DEVICE_NAME_FIELD_ID = 0;
        this.MOUNT_DIR_NAME_FIELD_ID = 1;
        this.devices = this.usable() ? ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.mountPath())).asScala()).map((Function1 & Serializable & scala.Serializable)line -> line.trim().split("\\s+"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)fields -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$devices$2(this, fields)))).filter((Function1 & Serializable & scala.Serializable)fields -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$devices$3(this, fields)))).map((Function1 & Serializable & scala.Serializable)fields -> new Tuple2((Object)((Object)Paths.get(fields[this.MOUNT_DEVICE_NAME_FIELD_ID()], new String[0]).getFileName()).toString(), (Object)fields[this.MOUNT_DIR_NAME_FIELD_ID()]), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
        this.maxFieldId = this.usable() ? ((String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).head()).trim().split("\\s+").length - this.STAT_DEVICE_NAME_FIELD_ID() - 1 : 0;
        this.metrics = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"reads-completed", "reads-merged", "sectors-read", "time-spent-reading-ms", "writes-completed", "writes-merged", "sectors-written", "time-spent-writing-ms", "IOs-currently-in-progress", "time-spent-doing-IOs-ms", "weighted-time-spent-doing-IOs-ms", "discards-completed", "discards-merged", "sectors-discarded", "time-spent-discarding-ms", "flush-requests-completed", "time-spent-flushing-ms"})).slice(0, this.maxFieldId());
        this.directReturnFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8}));
        this.prevState = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.devices().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LinuxDiskMetricsCollector.$anonfun$new$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            LinuxDiskMetricsCollector.$anonfun$new$2(this, x$2);
            return BoxedUnit.UNIT;
        });
    }
}

