/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public final class PrincipalConvertToJson$ {
    public static PrincipalConvertToJson$ MODULE$;
    private final String PrincipalClassKey;
    private final String PrincipalTypeKey;
    private final String PrincipalNameKey;
    private final String AuthenticationIdKey;
    private final String TokenAuthenticatedKey;
    private final String UserKey;
    private final String UserResourceIdKey;
    private final String TenantNameKey;
    private final String ClusterIdKey;
    private final String EnvironmentIdKey;
    private final String OrganizationIdKey;
    private final String IsServiceAccountKey;
    private final String IsApiKeyAuthenticatedKey;
    private final String IsHealthcheckTenantKey;

    static {
        new PrincipalConvertToJson$();
    }

    public String PrincipalClassKey() {
        return this.PrincipalClassKey;
    }

    public String PrincipalTypeKey() {
        return this.PrincipalTypeKey;
    }

    public String PrincipalNameKey() {
        return this.PrincipalNameKey;
    }

    public String AuthenticationIdKey() {
        return this.AuthenticationIdKey;
    }

    public String TokenAuthenticatedKey() {
        return this.TokenAuthenticatedKey;
    }

    public String UserKey() {
        return this.UserKey;
    }

    public String UserResourceIdKey() {
        return this.UserResourceIdKey;
    }

    public String TenantNameKey() {
        return this.TenantNameKey;
    }

    public String ClusterIdKey() {
        return this.ClusterIdKey;
    }

    public String EnvironmentIdKey() {
        return this.EnvironmentIdKey;
    }

    public String OrganizationIdKey() {
        return this.OrganizationIdKey;
    }

    public String IsServiceAccountKey() {
        return this.IsServiceAccountKey;
    }

    public String IsApiKeyAuthenticatedKey() {
        return this.IsApiKeyAuthenticatedKey;
    }

    public String IsHealthcheckTenantKey() {
        return this.IsHealthcheckTenantKey;
    }

    public JsonNode convert(KafkaPrincipal principal) {
        ObjectNode principalNode = new ObjectNode(JsonNodeFactory.instance);
        principalNode.set(this.PrincipalClassKey(), (JsonNode)new TextNode(principal.getClass().getSimpleName()));
        principalNode.set(this.PrincipalTypeKey(), (JsonNode)new TextNode(principal.getPrincipalType()));
        principalNode.set(this.PrincipalNameKey(), (JsonNode)new TextNode(principal.getName()));
        principalNode.set(this.TokenAuthenticatedKey(), (JsonNode)BooleanNode.valueOf((boolean)principal.tokenAuthenticated()));
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            PrincipalConvertToJson$.setIfNonEmpty$1(this.AuthenticationIdKey(), multiTenantPrincipal.authenticationId(), principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.UserKey(), multiTenantPrincipal.user(), principalNode);
            TenantMetadata tenantMetadata = multiTenantPrincipal.tenantMetadata();
            PrincipalConvertToJson$.setIfNonEmpty$1(this.UserResourceIdKey(), tenantMetadata.userResourceId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.TenantNameKey(), tenantMetadata.tenantName, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.ClusterIdKey(), tenantMetadata.clusterId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.OrganizationIdKey(), tenantMetadata.organizationId, principalNode);
            PrincipalConvertToJson$.setIfNonEmpty$1(this.EnvironmentIdKey(), tenantMetadata.environmentId, principalNode);
            principalNode.set(this.IsServiceAccountKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isServiceAccount));
            principalNode.set(this.IsApiKeyAuthenticatedKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isApiKeyAuthenticated));
            return principalNode.set(this.IsHealthcheckTenantKey(), (JsonNode)BooleanNode.valueOf((boolean)tenantMetadata.isHealthcheckTenant));
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            return PrincipalConvertToJson$.setIfNonEmpty$1(this.AuthenticationIdKey(), confluentPrincipal.authenticationId(), principalNode);
        }
        return principalNode;
    }

    private static final ObjectNode setIfNonEmpty$1(String field, String value, ObjectNode principalNode$1) {
        if (value != null && !value.isEmpty()) {
            return (ObjectNode)principalNode$1.set(field, (JsonNode)new TextNode(value));
        }
        return principalNode$1;
    }

    private PrincipalConvertToJson$() {
        MODULE$ = this;
        this.PrincipalClassKey = "class";
        this.PrincipalTypeKey = "type";
        this.PrincipalNameKey = "name";
        this.AuthenticationIdKey = "authenticationId";
        this.TokenAuthenticatedKey = "tokenAuthenticated";
        this.UserKey = "user";
        this.UserResourceIdKey = "userResourceIdKey";
        this.TenantNameKey = "tenantName";
        this.ClusterIdKey = "clusterId";
        this.EnvironmentIdKey = "environmentId";
        this.OrganizationIdKey = "organizationId";
        this.IsServiceAccountKey = "isServiceAccount";
        this.IsApiKeyAuthenticatedKey = "isApiKeyAuthenticated";
        this.IsHealthcheckTenantKey = "isHealthcheckTenant";
    }
}

