/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import kafka.restore.messages.KafkaRequest;
import kafka.restore.messages.MessageRequest;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.schedulers.AbstractAsyncServiceScheduler;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.KafkaConnectionPool;

public class KafkaManager
extends AbstractAsyncServiceScheduler {
    private static final int DEFAULT_REQUEST_QUEUE_CAPACITY = 50000;
    private final KafkaConnectionPool kafkaConnectionPool;

    public KafkaManager(AsyncServiceSchedulerResultsReceiver resultsReceiver, KafkaConnectionPool kafkaConnectionPool, int requestQueueSize) {
        super(resultsReceiver, requestQueueSize);
        this.kafkaConnectionPool = kafkaConnectionPool;
    }

    public KafkaManager(AsyncServiceSchedulerResultsReceiver resultsReceiver, KafkaConnectionPool kafkaConnectionPool) {
        this(resultsReceiver, kafkaConnectionPool, 50000);
    }

    @Override
    public MessageStatusCode submitRequest(MessageRequest request) {
        if (request == null) {
            throw new NullPointerException("request cannot be null.");
        }
        if (request instanceof KafkaRequest) {
            return super.submitRequest(request);
        }
        throw new UnsupportedOperationException("Request must be FetchFtpsRequest, KafkaTierPartitionEventRequest, or KafkaTierPartitionStatusRequest");
    }

    @Override
    protected void processRequestFromRequestQueue(MessageRequest request) {
        if (!(request instanceof KafkaRequest)) {
            throw new RuntimeException("Illegal request type " + request.getClass().toString() + " was added to request queue");
        }
        this.kafkaConnectionPool.submitKafkaRequest((KafkaRequest)request);
    }

    @Override
    public synchronized boolean pause() {
        boolean success = super.pause();
        if (success) {
            this.kafkaConnectionPool.shutdown();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean resume() {
        boolean success = super.resume();
        if (success) {
            this.kafkaConnectionPool.startUp();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean startUp() {
        boolean success = super.startUp();
        if (success) {
            this.kafkaConnectionPool.startUp();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean shutdown() {
        boolean success = super.shutdown();
        this.kafkaConnectionPool.shutdown();
        return success;
    }
}

