/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import java.util.Map;
import java.util.UUID;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaUnfreezeRequest;
import kafka.restore.messages.RestoreFtpsResponse;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class FtpsFetchedToPartitionRestoredTransition
extends AbstractTransition {
    public FtpsFetchedToPartitionRestoredTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FTPS_FETCHED;
    }

    @Override
    public State getTargetState() {
        return State.PARTITION_RESTORED;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof RestoreFtpsResponse)) {
            return false;
        }
        RestoreFtpsResponse response = (RestoreFtpsResponse)event.getData("message_response");
        Map<UUID, SegmentStateAndPath> segmentPathMap = response.getSegmentAndPathMap();
        KafkaUnfreezeRequest request = null;
        if (segmentPathMap != null && segmentPathMap.size() != 0) {
            return false;
        }
        request = new KafkaUnfreezeRequest(0, response.getTopic(), response.getPartition(), (NodeConfig)fsm.getMetadata("partition_leader"));
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", response.getTopic(), response.getPartition(), this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

