/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.RequestLogger;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dr!B\u0016-\u0011\u0003\td!B\u001a-\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%IA\u0010\u0005\u0007\u001b\u0006\u0001\u000b\u0011B \t\u000f9\u000b!\u0019!C\u0005\u001f\"1\u0001,\u0001Q\u0001\nACq!W\u0001A\u0002\u0013%!\fC\u0004_\u0003\u0001\u0007I\u0011B0\t\r\u0015\f\u0001\u0015)\u0003\\\u0011\u0015Q\u0017\u0001\"\u0001l\u0011\u0015q\u0017\u0001\"\u0001p\u0011%\t\u0019\"AI\u0001\n\u0003\t)BB\u00034Y\u0001\t\t\u0005\u0003\u0006\u0002\\5\u0011\t\u0011)A\u0005\u0003;B!\"a\u0019\u000e\u0005\u0003\u0005\u000b\u0011BA3\u0011)\tY'\u0004B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003[j!\u0011!Q\u0001\n\u0005u\u0003BCA8\u001b\t\u0015\r\u0011\"\u0001\u0002r!Q\u00111R\u0007\u0003\u0002\u0003\u0006I!a\u001d\t\u0015\u00055UB!b\u0001\n\u0003\ty\t\u0003\u0006\u0002&6\u0011\t\u0011)A\u0005\u0003#C!\"a*\u000e\u0005\u000b\u0007I\u0011AAU\u0011%\tY+\u0004B\u0001B\u0003%q\t\u0003\u0006\u0002.6\u0011\t\u0011)A\u0005\u0003_C!\"!.\u000e\u0005\u0003\u0005\u000b\u0011BA\\\u0011)\ty-\u0004B\u0001B\u0003%\u0011\u0011\u0004\u0005\u0007w5!\t!!5\t\u0013\u0005%XB1A\u0005\n\u0005-\b\u0002CA{\u001b\u0001\u0006I!!<\t\u0013\u0005EQB1A\u0005\n\u0005]\b\u0002CA}\u001b\u0001\u0006I!!\u0003\t\u0013\u0005mXB1A\u0005\n\u0005u\b\u0002\u0003B\u0003\u001b\u0001\u0006I!a@\t\u0011\t\u001dQ\u00021A\u0005\niC\u0011B!\u0003\u000e\u0001\u0004%IAa\u0003\t\u000f\t=Q\u0002)Q\u00057\"9!1C\u0007\u0005\u0002\tU\u0001\u0002\u0003B\f\u001b\u0011\u0005AF!\u0007\t\u000f\t}Q\u0002\"\u0003\u0003\u0016!9!\u0011E\u0007\u0005\u0002\tU\u0001b\u0002B\u0012\u001b\u0011\u0005!Q\u0003\u0005\b\u0005KiA\u0011\u0001B\u000b\u0003MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001a\u0002\u001b\u0005a#aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u00148CA\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!M\u0001\u0015i\"\u0014X-\u00193SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003}\u00022\u0001Q#H\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\f)\"\u0014X-\u00193M_\u000e\fG\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002K]\u00059a.\u001a;x_J\\\u0017B\u0001'J\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fQ\u0003\u001e5sK\u0006$'+Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u000buQJ,\u0017\rZ\"veJ,g\u000e\u001e*fcV,7\u000f^\u000b\u0002!B\u0019\u0001)R)\u0011\u0005I+fB\u0001%T\u0013\t!\u0016*\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005Y;&a\u0002*fcV,7\u000f\u001e\u0006\u0003)&\u000bQ\u0003\u001e5sK\u0006$7)\u001e:sK:$(+Z9vKN$\b%A\tcsB\f7o\u001d+ie\u0016\fGm\u00115fG.,\u0012a\u0017\t\u0003mqK!!X\u001c\u0003\u000f\t{w\u000e\\3b]\u0006)\"-\u001f9bgN$\u0006N]3bI\u000eCWmY6`I\u0015\fHC\u00011d!\t1\u0014-\u0003\u0002co\t!QK\\5u\u0011\u001d!\u0007\"!AA\u0002m\u000b1\u0001\u001f\u00132\u0003I\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m\u001b\u0011)\u0005%9\u0007C\u0001\u001ci\u0013\tIwG\u0001\u0005w_2\fG/\u001b7f\u0003Q\u0019X\r\u001e\"za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dWR\u0011\u0001\r\u001c\u0005\u0006[*\u0001\raW\u0001\fEf\u0004\u0018m]:DQ\u0016\u001c7.A\txe\u0006\u0004\u0018i]=oG\u000e\u000bG\u000e\u001c2bG.,\"\u0001\u001d<\u0015\tE|\u0018q\u0002\t\u0005mI$\b-\u0003\u0002to\tIa)\u001e8di&|g.\r\t\u0003kZd\u0001\u0001B\u0003x\u0017\t\u0007\u0001PA\u0001U#\tIH\u0010\u0005\u00027u&\u00111p\u000e\u0002\b\u001d>$\b.\u001b8h!\t1T0\u0003\u0002\u007fo\t\u0019\u0011I\\=\t\u000f\u0005\u00051\u00021\u0001\u0002\u0004\u00059\u0012m]=oG\u000e{W\u000e\u001d7fi&|gnQ1mY\n\f7m\u001b\t\bm\u0005\u0015\u0011\u0011\u0002;a\u0013\r\t9a\u000e\u0002\n\rVt7\r^5p]J\u00022AMA\u0006\u0013\r\ti\u0001\f\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u0005\b\u0003#Y\u0001\u0019AA\u0005\u00031\u0011X-];fgRdunY1m\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"!a\u0006+\t\u0005e\u0011q\u0006\t\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u0015\u0002cAA\u0010o5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0001\u0014A\u0002\u001fs_>$h(C\u0002\u0002(]\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0016\u0003[\u0011aa\u0015;sS:<'bAA\u0014o-\u0012\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003%)hn\u00195fG.,GMC\u0002\u0002<]\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty$!\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmE\u0004\u000e\u0003\u0007\nI%a\u0014\u0011\u0007\u0001\u000b)%C\u0002\u0002H\u0005\u0013aa\u00142kK\u000e$\bc\u0001!\u0002L%\u0019\u0011QJ!\u0003\u0011I+hN\\1cY\u0016\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+r\u0013!B;uS2\u001c\u0018\u0002BA-\u0003'\u0012q\u0001T8hO&tw-\u0001\u0002jIB\u0019a'a\u0018\n\u0007\u0005\u0005tGA\u0002J]R\faaY8oM&<\u0007c\u0001\u001a\u0002h%\u0019\u0011\u0011\u000e\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\nG2,8\u000f^3s\u0013\u0012\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0013C\u001e<'/Z4bi\u0016LE\r\\3NKR,'/\u0006\u0002\u0002tA!\u0011QOAD\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014\u0001B2pe\u0016TA!! \u0002\u0000\u00059Q.\u001a;sS\u000e\u001c(\u0002BAA\u0003\u0007\u000ba!_1n[\u0016\u0014(BAAC\u0003\r\u0019w.\\\u0005\u0005\u0003\u0013\u000b9HA\u0003NKR,'/A\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014\b%A\nu_R\fG\u000eS1oI2,'\u000f\u00165sK\u0006$7/\u0006\u0002\u0002\u0012B!\u00111SAQ\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015AB1u_6L7M\u0003\u0003\u0002\u001c\u0006u\u0015AC2p]\u000e,(O]3oi*\u0019\u0011qT\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\u000b)JA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0015i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm\u001d\u0011\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\tq)A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003\u0011\t\u0007/[:\u0011\u0007I\n\t,C\u0002\u000242\u0012\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003\u0011!\u0018.\\3\u0011\t\u0005e\u00161Z\u0007\u0003\u0003wSA!!\u0016\u0002>*!\u0011qXAa\u0003\u0019\u0019w.\\7p]*\u0019q&a1\u000b\t\u0005\u0015\u0017qY\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0017aA8sO&!\u0011QZA^\u0005\u0011!\u0016.\\3\u0002\u00119|G-\u001a(b[\u0016$b#a5\u0002V\u0006]\u0017\u0011\\An\u0003;\fy.!9\u0002d\u0006\u0015\u0018q\u001d\t\u0003e5Aq!a\u0017\u001c\u0001\u0004\ti\u0006C\u0004\u0002dm\u0001\r!!\u001a\t\u000f\u0005-4\u00041\u0001\u0002\u001a!9\u0011QN\u000eA\u0002\u0005u\u0003bBA87\u0001\u0007\u00111\u000f\u0005\b\u0003\u001b[\u0002\u0019AAI\u0011\u0019\t9k\u0007a\u0001\u000f\"9\u0011QV\u000eA\u0002\u0005=\u0006bBA[7\u0001\u0007\u0011q\u0017\u0005\n\u0003\u001f\\\u0002\u0013!a\u0001\u00033\t\u0001c\u001d5vi\u0012|wO\\\"p[BdW\r^3\u0016\u0005\u00055\b\u0003BAx\u0003cl!!!'\n\t\u0005M\u0018\u0011\u0014\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003E\u0019\b.\u001e;e_^t7i\\7qY\u0016$X\rI\u000b\u0003\u0003\u0013\tQB]3rk\u0016\u001cH\u000fT8dC2\u0004\u0013!\u0004:fcV,7\u000f\u001e'pO\u001e,'/\u0006\u0002\u0002\u0000B\u0019!G!\u0001\n\u0007\t\rAFA\u0007SKF,Xm\u001d;M_\u001e<WM]\u0001\u000fe\u0016\fX/Z:u\u0019><w-\u001a:!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u0019\u0001M!\u0004\t\u000f\u0011\u001c\u0013\u0011!a\u00017\u0006A1\u000f^8qa\u0016$\u0007\u0005\u000b\u0002%O\u0006\u0019!/\u001e8\u0015\u0003\u0001\fA\u0001]8mYR\u0019\u0001Ma\u0007\t\u000f\tua\u00051\u0001\u0002^\u0005IA/[7f_V$Xj]\u0001\u0011G>l\u0007\u000f\\3uKNCW\u000f\u001e3po:\fAa\u001d;pa\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private final RequestLogger requestLogger;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$10() {
        return KafkaRequestHandler$.MODULE$.$lessinit$greater$default$10();
    }

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> function2, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(function2, requestLocal);
    }

    public static void setBypassThreadCheck(boolean bl) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bl);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private RequestLogger requestLogger() {
        return this.requestLogger;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.CallbackRequest) {
            RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
            RequestChannel.Request originalRequest = callbackRequest.originalRequest();
            try {
                try {
                    if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                        long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                        originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                    } else {
                        originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        KafkaRequestHandler.$anonfun$poll$4(this, callbackRequest);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                this.requestChannel().tryCompleteActions();
                if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                    originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                }
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
            }
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        this.apis.handle(request, this.requestLogger(), this.requestLocal());
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                request.releaseBuffer();
            }
            return;
        }
        if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received a wakeup request outside of typical usage.");
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public static final /* synthetic */ void $anonfun$poll$4(KafkaRequestHandler $this, RequestChannel.CallbackRequest x3$1) {
        x3$1.fun().apply((Object)$this.requestLocal());
    }

    public KafkaRequestHandler(int id, KafkaConfig config, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time, String nodeName) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(31).append("[Kafka Request Handler ").append(id).append(" on ").append(new StringOps(Predef$.MODULE$.augmentString(nodeName)).capitalize()).append(" ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.requestLogger = new DefaultRequestLogger(config, clusterId);
        this.stopped = false;
    }
}

