/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AsyncSend;
import kafka.server.BrokerTopicStats;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetchResponseAllocator;
import kafka.server.link.ClusterLinkFetcher;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$AwaitingFetchResponse$;
import kafka.server.link.ClusterLinkFetcherThread$AwaitingListOffsetResponse$;
import kafka.server.link.ClusterLinkFetcherThread$FetcherShutdown$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeFetch$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTransitionTierStates$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTruncate$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.FetchResponseSize;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u001e=\u0001\rC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Qa\u0010\u0001B\u0001B\u0003%q0!\u0002\t\u0015\u00055\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003/A!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005=\u0002BCA\u001b\u0001\t\u0005\t\u0015!\u0003\u00028!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005-\u0003A!A!\u0002\u0013\ti\u0005\u0003\u0006\u0002T\u0001\u0011\t\u0011)A\u0005\u0003+B!\"a\u0017\u0001\u0005\u0003\u0005\u000b\u0011BA/\u0011)\t\u0019\u0007\u0001B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003W\u0002!\u0011!Q\u0001\n\u00055\u0004bCA:\u0001\t\u0015\r\u0011\"\u0011=\u0003kB!\"! \u0001\u0005\u0003\u0005\u000b\u0011BA<\u0011)\ty\b\u0001B\u0001B\u0003%\u0011\u0011\u0011\u0005\u000b\u0003\u000f\u0003!\u0011!Q\u0001\n\u0005%\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\n\u0003\u000b\u0004!\u0019!C!\u0003\u000fD\u0001\"a4\u0001A\u0003%\u0011\u0011\u001a\u0005\n\u0003#\u0004!\u0019!C!\u0003'D\u0001\"a7\u0001A\u0003%\u0011Q\u001b\u0005\n\u0003;\u0004!\u0019!C!\u0003?D\u0001\"!=\u0001A\u0003%\u0011\u0011\u001d\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003kD\u0001B!\u0003\u0001A\u0003%\u0011q\u001f\u0005\n\u0005\u0017\u0001\u0001\u0019!C\t\u0005\u001bA\u0011B!\u0006\u0001\u0001\u0004%\tBa\u0006\t\u0011\t\r\u0002\u0001)Q\u0005\u0005\u001fA\u0011B!\f\u0001\u0001\u0004%\tBa\f\t\u0013\t-\u0003\u00011A\u0005\u0012\t5\u0003\u0002\u0003B)\u0001\u0001\u0006KA!\r\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!\u0011\f\u0001\u0005R\tm\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005w\u0002A\u0011\u000bB,\u0011\u001d\u0011i\b\u0001C)\u0005/BqAa \u0001\t#\u0012\t\t\u0003\u0005\u0003\u0018\u0002!\tE\u0010BM\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqAa3\u0001\t#\u0011i\rC\u0004\u0003\\\u0002!\tFa\u0016\t\u000f\tu\u0007\u0001\"\u0015\u0003`\"9!1\u001e\u0001\u0005\n\t]\u0003b\u0002Bw\u0001\u0011\u0005#q\u001e\u0005\b\u0005c\u0004A\u0011\tB,\u0011\u001d\u0011\u0019\u0010\u0001C)\u0005/BqA!>\u0001\t\u0003\u0011i\u0001C\u0004\u0003x\u0002!\tE!?\u0003E\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM],ji\"\u001c\u0006.\u0019:fIRC'/Z1e\u0015\tid(\u0001\u0003mS:\\'BA A\u0003\u0019\u0019XM\u001d<fe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0005CA#G\u001b\u0005a\u0014BA$=\u0005I\u0019E.^:uKJd\u0015N\\6GKR\u001c\u0007.\u001a:\u0002\t9\fW.Z\u000b\u0002\u0015B\u00111\n\u0016\b\u0003\u0019J\u0003\"!\u0014)\u000e\u00039S!a\u0014\"\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0003\u0016!\u00028b[\u0016\u0004\u0013A\u00027j].LE\r\u0005\u0002[E6\t1L\u0003\u0002];\u000611m\\7n_:T!!\u00110\u000b\u0005}\u0003\u0017AB1qC\u000eDWMC\u0001b\u0003\ry'oZ\u0005\u0003Gn\u0013A!V;jI\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\t\u0003M\u001el\u0011\u0001U\u0005\u0003QB\u00131!\u00138u\u0003-1W\r^2iKJ\u0004vn\u001c7\u0011\u0005-dW\"\u0001 \n\u00055t$a\u0003$fi\u000eDWM\u001d)p_2\f\u0001b\u00197jK:$\u0018\nZ\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0002\u000bqa\u00197vgR,'/\u0003\u0002ve\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018\u0001D:iCJ,G\r\u00165sK\u0006$\u0007CA#y\u0013\tIHH\u0001\u0010DYV\u001cH/\u001a:MS:\\7\u000b[1sK\u00124U\r^2iKJ$\u0006N]3bI\u0006Y\u0011m]=oGN+g\u000eZ3s!\tYG0\u0003\u0002~}\tI\u0011i]=oGN+g\u000eZ\u0001\fCNLhn\u0019'fC\u0012,'\u000fE\u0002F\u0003\u0003I1!a\u0001=\u0005y\u0019E.^:uKJd\u0015N\\6Bgft7\rT3bI\u0016\u0014XI\u001c3Q_&tG/\u0003\u0003\u0002\b\u0005%\u0011A\u00027fC\u0012,'/C\u0002\u0002\fy\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0007ce>\\WM]\"p]\u001aLw\rE\u0002l\u0003#I1!a\u0005?\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw\rE\u0002F\u00033I1!a\u0007=\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0014G2,8\u000f^3s\u0019&t7.T3uC\u0012\fG/\u0019\t\u0004\u000b\u0006\u0005\u0012bAA\u0012y\t\u00192\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0006qa-\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bcA#\u0002*%\u0019\u00111\u0006\u001f\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u00042a[A\u0019\u0013\r\t\u0019D\u0010\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0001\u0003]1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007-\fI$C\u0002\u0002<y\u0012\u0001\u0003U1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI.\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0001\u0006sKBd\u0017nY1NOJ\u00042a[A(\u0013\r\t\tF\u0010\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\rY\u0017qK\u0005\u0004\u00033r$\u0001\u0004*fa2L7-Y)v_R\f\u0017AE2mkN$XM\u001d'j].lU\r\u001e:jGN\u00042!RA0\u0013\r\t\t\u0007\u0010\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0003uS6,\u0007\u0003BA!\u0003OJA!!\u001b\u0002D\t!A+[7f\u0003Y1W\r^2i%\u0016\u001c\bo\u001c8tK\u0006cGn\\2bi>\u0014\bcA#\u0002p%\u0019\u0011\u0011\u000f\u001f\u0003C\rcWo\u001d;fe2Kgn\u001b$fi\u000eD'+Z:q_:\u001cX-\u00117m_\u000e\fGo\u001c:\u0002#\rdWo\u001d;fe2Kgn[\"mS\u0016tG/\u0006\u0002\u0002xA\u0019Q)!\u001f\n\u0007\u0005mDH\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]R\f!c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8uA\u0005QAn\\4D_:$X\r\u001f;\u0011\t\u0005\u0005\u00131Q\u0005\u0005\u0003\u000b\u000b\u0019E\u0001\u0006M_\u001e\u001cuN\u001c;fqR\fa\u0001^3oC:$\b\u0003\u00024\u0002\f*K1!!$Q\u0005\u0019y\u0005\u000f^5p]\u00061A(\u001b8jiz\"\"'a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi+a,\u00022\u0006M\u0016QWA\\\u0003s\u000bY,!0\u0002@\u0006\u0005\u00171\u0019\t\u0003\u000b\u0002AQ\u0001S\u000eA\u0002)CQ\u0001W\u000eA\u0002eCQ\u0001Z\u000eA\u0002\u0015DQ![\u000eA\u0002)DQA\\\u000eA\u0002)CQa\\\u000eA\u0002ADQA^\u000eA\u0002]DQA_\u000eA\u0002mDQA`\u000eA\u0002}Dq!!\u0004\u001c\u0001\u0004\ty\u0001C\u0004\u0002\u0016m\u0001\r!a\u0006\t\u000f\u0005u1\u00041\u0001\u0002 !9\u0011QE\u000eA\u0002\u0005\u001d\u0002bBA\u00177\u0001\u0007\u0011q\u0006\u0005\b\u0003kY\u0002\u0019AA\u001c\u0011\u001d\tid\u0007a\u0001\u0003\u007fAq!a\u0013\u001c\u0001\u0004\ti\u0005C\u0004\u0002Tm\u0001\r!!\u0016\t\u000f\u0005m3\u00041\u0001\u0002^!9\u00111M\u000eA\u0002\u0005\u0015\u0004bBA67\u0001\u0007\u0011Q\u000e\u0005\b\u0003gZ\u0002\u0019AA<\u0011\u001d\tyh\u0007a\u0001\u0003\u0003Cq!a\"\u001c\u0001\u0004\tI)A\u000bgKR\u001c\u0007\u000eV5feN#\u0018\r^3NC\u000eD\u0017N\\3\u0016\u0005\u0005%\u0007cA6\u0002L&\u0019\u0011Q\u001a \u0003!QKWM]*uCR,W*Y2iS:,\u0017A\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.\u001a\u0011\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001cXCAAk!\rY\u0017q[\u0005\u0004\u00033t$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0010I\u0016$\u0017nY1uK\u0012$\u0006N]3bIV\u0011\u0011\u0011\u001d\t\u0006M\u0006-\u00151\u001d\t\u0005\u0003K\fi/\u0004\u0002\u0002h*!\u0011\u0011^Av\u0003\u0011)H/\u001b7\u000b\u0005}j\u0016\u0002BAx\u0003O\u0014!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006\u0001B-\u001a3jG\u0006$X\r\u001a+ie\u0016\fG\rI\u0001\u000eg\",H\u000fZ8x]2\u000bGo\u00195\u0016\u0005\u0005]\b\u0003BA}\u0005\u000bi!!a?\u000b\t\u0005u\u0018q`\u0001\u000bG>t7-\u001e:sK:$(\u0002BAu\u0005\u0003Q!Aa\u0001\u0002\t)\fg/Y\u0005\u0005\u0005\u000f\tYP\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002\u001dMDW\u000f\u001e3po:d\u0015\r^2iA\u0005\t2\u000f[;uI><h.\u00138ji&\fG/\u001a3\u0016\u0005\t=\u0001c\u00014\u0003\u0012%\u0019!1\u0003)\u0003\u000f\t{w\u000e\\3b]\u0006)2\u000f[;uI><h.\u00138ji&\fG/\u001a3`I\u0015\fH\u0003\u0002B\r\u0005?\u00012A\u001aB\u000e\u0013\r\u0011i\u0002\u0015\u0002\u0005+:LG\u000fC\u0005\u0003\"\u0015\n\t\u00111\u0001\u0003\u0010\u0005\u0019\u0001\u0010J\u0019\u0002%MDW\u000f\u001e3po:Le.\u001b;jCR,G\r\t\u0015\u0004M\t\u001d\u0002c\u00014\u0003*%\u0019!1\u0006)\u0003\u0011Y|G.\u0019;jY\u0016\fABZ3uG\",'o\u0015;bi\u0016,\"A!\r\u0011\t\tM\"Q\t\b\u0005\u0005k\u0011\tE\u0004\u0003\u00038\t}b\u0002\u0002B\u001d\u0005{q1!\u0014B\u001e\u0013\u0005\t\u0015BA A\u0013\tid(C\u0002\u0003Dq\n\u0001d\u00117vgR,'\u000fT5oW\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u00119E!\u0013\u0003\u0019\u0019+Go\u00195feN#\u0018\r^3\u000b\u0007\t\rC(\u0001\tgKR\u001c\u0007.\u001a:Ti\u0006$Xm\u0018\u0013fcR!!\u0011\u0004B(\u0011%\u0011\t\u0003KA\u0001\u0002\u0004\u0011\t$A\u0007gKR\u001c\u0007.\u001a:Ti\u0006$X\r\t\u0015\u0004S\t\u001d\u0012A\u00023p/>\u00148\u000e\u0006\u0002\u0003\u001a\u0005iQ.Y=cKR\u0013XO\\2bi\u0016$\"A!\u0018\u0011\r\t}#\u0011\u000eB7\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005O\u0002\u0016AC2pY2,7\r^5p]&!!1\u000eB1\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007i\u0013y'C\u0002\u0003rm\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\rdQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLxJ\u001a4tKR\u001cH\u0003\u0002B\r\u0005oBqA!\u001f-\u0001\u0004\u0011i&A\bu_BL7\rU1si&$\u0018n\u001c8t\u0003)i\u0017-\u001f2f\r\u0016$8\r[\u0001\u001a[\u0006L(-\u001a+sC:\u001c\u0018\u000e^5p]RKWM]*uCR,7/A\rueVt7-\u0019;f)>,\u0005o\\2i\u000b:$wJ\u001a4tKR\u001cH\u0003\u0002B\r\u0005\u0007CqA!\"0\u0001\u0004\u00119)A\rmCR,7\u000f^#q_\u000eD7OR8s!\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u0003BE\u0005\u0017\u0013iGa$\u000e\u0005\t\u0015\u0014\u0002\u0002BG\u0005K\u00121!T1q!\u0011\u0011\tJa%\u000e\u0003\u0001IAA!&\u0002\n\tIQ\t]8dQ\u0012\u000bG/Y\u0001\u0014aJ|7-Z:t\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0007\u00053\u0011YJ!/\t\u000f\tu\u0005\u00071\u0001\u0003 \u0006\t2/Z:tS>t\u0007+\u0019:uSRLwN\\:\u0011\u0011\t\u0005&1\u0015B7\u0005Kk!!a@\n\t\t5\u0015q \t\u0005\u0005O\u0013\u0019L\u0004\u0003\u0003*\n=VB\u0001BV\u0015\r\u0011ikW\u0001\te\u0016\fX/Z:ug&!!\u0011\u0017BV\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011)La.\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\u0011\tLa+\t\u000f\tm\u0006\u00071\u0001\u0003>\u0006aa-\u001a;dQJ+\u0017/^3tiB!!q\u0015B`\u0013\u0011\u0011\tMa.\u0003\u000f\t+\u0018\u000e\u001c3fe\u0006yqN\\!ts:\u001c'+Z:q_:\u001cX\r\u0006\u0003\u0003\u001a\t\u001d\u0007b\u0002Bec\u0001\u0007!qB\u0001\u0012e\u0016\fX/Z:u'V\u001c7-Z:tMVd\u0017AE;qI\u0006$XMR3uG\",'o\u0015;bi\u0016$BAa\u0004\u0003P\"9!\u0011\u001b\u001aA\u0002\tM\u0017\u0001E:uCR,GK]1og\u001a|'/\\3s!\u001d1'Q\u001bB\u0019\u00053L1Aa6Q\u0005%1UO\\2uS>t\u0017\u0007E\u0003g\u0003\u0017\u0013\t$A\u0005tS\u001et\u0017\r\\!mY\u00061r/Y5u\r>\u0014(+Z1esB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003\u001a\t\u0005\bb\u0002Bri\u0001\u0007!Q]\u0001\nE\u0006\u001c7n\u001c4g\u001bN\u00042A\u001aBt\u0013\r\u0011I\u000f\u0015\u0002\u0005\u0019>tw-A\u000fnCf\u0014W\r\u0015:pG\u0016\u001c8oV1ji&tw\rU1si&$\u0018n\u001c8t\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0003\u0010\u0005i\u0011m^1jiNCW\u000f\u001e3po:\f!b\u001c8TQV$Hm\\<o\u0003%I7O\u00117pG.,G-\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0005")
public class ClusterLinkFetcherWithSharedThread
extends ClusterLinkFetcher {
    private final String name;
    private final int fetcherId;
    private final FetcherPool fetcherPool;
    private final BrokerEndPoint sourceBroker;
    private final ClusterLinkSharedFetcherThread sharedThread;
    private final AsyncSend asyncSender;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Time time;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final TierStateMachine fetchTierStateMachine;
    private final BrokerTopicStats brokerTopicStats;
    private final Option<ShutdownableThread> dedicatedThread;
    private final CountDownLatch shutdownLatch;
    private volatile boolean shutdownInitiated;
    private volatile ClusterLinkFetcherThread.FetcherState fetcherState;

    public String name() {
        return this.name;
    }

    @Override
    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    @Override
    public TierStateMachine fetchTierStateMachine() {
        return this.fetchTierStateMachine;
    }

    @Override
    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    @Override
    public Option<ShutdownableThread> dedicatedThread() {
        return this.dedicatedThread;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public boolean shutdownInitiated() {
        return this.shutdownInitiated;
    }

    public void shutdownInitiated_$eq(boolean x$1) {
        this.shutdownInitiated = x$1;
    }

    public ClusterLinkFetcherThread.FetcherState fetcherState() {
        return this.fetcherState;
    }

    public void fetcherState_$eq(ClusterLinkFetcherThread.FetcherState x$1) {
        this.fetcherState = x$1;
    }

    @Override
    public void doWork() {
        this.asyncSender.maybeSendPendingRequest();
        long now = this.time.milliseconds();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions && ((ClusterLinkFetcherThread.AwaitingPartitions)x0$1).deadlineMs() <= now) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        if (this.shutdownInitiated()) {
            if (this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)state -> {
                ClusterLinkFetcherThread.FetcherState fetcherState = state;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState == null ? clusterLinkFetcherThread$FetcherShutdown$ != null : !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$)) {
                    return new Some((Object)ClusterLinkFetcherThread$FetcherShutdown$.MODULE$);
                }
                return None$.MODULE$;
            })) {
                this.onShutdown();
                return;
            }
            return;
        }
        if (!this.isBlocked()) {
            try {
                ClusterLinkFetcherThread.FetcherState fetcherState;
                ClusterLinkFetcherThread.FetcherState fetcherState2 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTruncate$ clusterLinkFetcherThread$MaybeTruncate$ = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
                if (!(fetcherState2 != null ? !fetcherState2.equals(clusterLinkFetcherThread$MaybeTruncate$) : clusterLinkFetcherThread$MaybeTruncate$ != null)) {
                    this.maybeTruncate();
                }
                if ((fetcherState = this.fetcherState()) instanceof ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets) {
                    ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets maybeCheckpointRecoveryOffsets = (ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets)fetcherState;
                    this.checkpointRecoveryOffsets(maybeCheckpointRecoveryOffsets.partitions());
                }
                ClusterLinkFetcherThread.FetcherState fetcherState3 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeFetch$ clusterLinkFetcherThread$MaybeFetch$ = ClusterLinkFetcherThread$MaybeFetch$.MODULE$;
                if (!(fetcherState3 != null ? !fetcherState3.equals(clusterLinkFetcherThread$MaybeFetch$) : clusterLinkFetcherThread$MaybeFetch$ != null)) {
                    this.maybeFetch();
                }
                ClusterLinkFetcherThread.FetcherState fetcherState4 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTransitionTierStates$ clusterLinkFetcherThread$MaybeTransitionTierStates$ = ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$;
                if (!(fetcherState4 != null ? !fetcherState4.equals(clusterLinkFetcherThread$MaybeTransitionTierStates$) : clusterLinkFetcherThread$MaybeTransitionTierStates$ != null)) {
                    this.maybeTransitionTierStates();
                }
                ClusterLinkFetcherThread.FetcherState fetcherState5 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$ clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ = ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$;
                if (!(fetcherState5 == null ? clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ != null : !fetcherState5.equals(clusterLinkFetcherThread$MaybeProcessWaitingPartitions$)) || this.fetcherState() instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                    this.maybeProcessWaitingPartitions();
                }
                this.completeDelayedFetchRequests();
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected exception in fetcher thread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$10 -> new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$));
                return;
            }
        }
    }

    @Override
    public ArrayBuffer<TopicPartition> maybeTruncate() {
        ArrayBuffer<TopicPartition> truncatingPartitions = super.maybeTruncate();
        if (this.asyncSender.hasPendingRequest()) {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$11 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse(truncatingPartitions)));
        } else {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$12 -> new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(truncatingPartitions)));
        }
        return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
        super.checkpointRecoveryOffsets(topicPartitions);
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$13 -> new Some((Object)ClusterLinkFetcherThread$MaybeFetch$.MODULE$));
    }

    @Override
    public void maybeFetch() {
        super.maybeFetch();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return None$.MODULE$;
            }
            if ($this.asyncSender.hasPendingRequest()) {
                return new Some((Object)ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$);
            }
            return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
        });
    }

    @Override
    public void maybeTransitionTierStates() {
        super.maybeTransitionTierStates();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$14 -> new Some((Object)ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$));
    }

    @Override
    public void truncateToEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> latestEpochsForPartitions) {
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetchEpochEndOffsets(latestEpochsForPartitions, (Function1<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)endOffsets -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$1(this, latestEpochsForPartitions, endOffsets);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, t);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void processFetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchRequest.Builder fetchRequest) {
        FetchResponseSize fetchSize = this.acquireFetchBuffer();
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetch(fetchRequest, (Function1<Map<TopicPartition, FetchResponseData.PartitionData>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseData -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$1(this, sessionPartitions, fetchSize, responseData);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$2(this, fetchRequest, fetchSize, t);
            return BoxedUnit.UNIT;
        });
    }

    private void onAsyncResponse(boolean requestSuccessful) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse) {
                ArrayBuffer<TopicPartition> partitions = ((ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse)x0$1).partitions();
                if (requestSuccessful) {
                    return new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(partitions));
                }
            }
            if (ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$.equals(x0$1) && requestSuccessful) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
            }
            if (ClusterLinkFetcherThread$AwaitingListOffsetResponse$.MODULE$.equals(x0$1) && requestSuccessful) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            if (x0$1.isAwaitingResponse()) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            if (!this.shutdownInitiated()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Ignoring unexpected response in state ").append(this.fetcherState()).append(", requestSuccessful=").append(requestSuccessful).toString());
            }
            return None$.MODULE$;
        });
    }

    public boolean updateFetcherState(Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>> stateTransformer) {
        boolean bl;
        this.partitionMapLock().lockInterruptibly();
        try {
            bl = ((Option)stateTransformer.apply((Object)this.fetcherState())).exists((Function1 & Serializable & scala.Serializable)newState -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherWithSharedThread.$anonfun$updateFetcherState$1(this, newState)));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return bl;
    }

    @Override
    public void signalAll() {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)state -> {
            if (state instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        this.clusterLinkClient().networkClient().wakeup();
        super.signalAll();
    }

    @Override
    public void waitForReadyPartitions(long backoffMs) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$15 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingPartitions($this.time.milliseconds() + backoffMs)));
    }

    private void maybeProcessWaitingPartitions() {
        Set<TopicPartition> waitingPartitions = this.fetchWaitingPartitions();
        if (waitingPartitions.nonEmpty()) {
            ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetchLatestOffsets(waitingPartitions, (Function1<Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)latestOffsets -> {
                ClusterLinkFetcherWithSharedThread.$anonfun$maybeProcessWaitingPartitions$1(this, latestOffsets);
                return BoxedUnit.UNIT;
            }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                ClusterLinkFetcherWithSharedThread.$anonfun$maybeProcessWaitingPartitions$2(this, waitingPartitions, t);
                return BoxedUnit.UNIT;
            });
        }
        if (this.asyncSender.hasPendingRequest()) {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)x$16 -> new Some((Object)ClusterLinkFetcherThread$AwaitingListOffsetResponse$.MODULE$));
            return;
        }
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable & scala.Serializable)currentState -> {
            ClusterLinkFetcherThread.FetcherState fetcherState = currentState;
            ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$ clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ = ClusterLinkFetcherThread$MaybeProcessWaitingPartitions$.MODULE$;
            if (!(fetcherState != null ? !fetcherState.equals(clusterLinkFetcherThread$MaybeProcessWaitingPartitions$) : clusterLinkFetcherThread$MaybeProcessWaitingPartitions$ != null)) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
    }

    @Override
    public boolean initiateShutdown() {
        this.shutdownInitiated_$eq(true);
        return super.initiateShutdown();
    }

    @Override
    public void awaitShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Awaiting shared fetcher thread shutdown.");
        this.clusterLinkClient().networkClient().wakeup();
        this.shutdownLatch().await();
        this.sharedThread.threadPool().removeFetcher(this.sourceBroker.id(), this, this.sharedThread);
        super.awaitShutdown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed shared fetcher thread shutdown.");
    }

    @Override
    public void onShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shared fetcher thread is shutting down.");
        this.shutdownLatch().countDown();
    }

    public boolean isBlocked() {
        return this.fetcherState().isBlocked();
    }

    public String toString() {
        return new StringBuilder(77).append("ClusterLinkFetcherWithSharedThread(fetcherId=").append(this.fetcherId).append(", sourceBrokerId=").append(this.sourceBroker.id()).append(", fetcherPool=").append(this.fetcherPool.name()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$1(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Map endOffsets) {
        $this.onAsyncResponse(true);
        $this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)latestEpochsForPartitions$1, (Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)endOffsets);
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$2(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Throwable t) {
        $this.onAsyncResponse(false);
        if (t instanceof IOException ? true : t instanceof NetworkException) {
            $this.clusterLinkMetadata.requestUpdate();
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).append(", request for metadata").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$1(ClusterLinkFetcherWithSharedThread $this, java.util.Map sessionPartitions$1, FetchResponseSize fetchSize$1, Map responseData) {
        try {
            $this.onAsyncResponse(true);
            $this.processFetchResponse(sessionPartitions$1, (Map<TopicPartition, FetchResponseData.PartitionData>)responseData);
        }
        finally {
            $this.releaseFetchBuffer(fetchSize$1);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$2(ClusterLinkFetcherWithSharedThread $this, FetchRequest.Builder fetchRequest$1, FetchResponseSize fetchSize$1, Throwable t) {
        try {
            $this.onAsyncResponse(false);
            $this.processFetchFailure(fetchRequest$1, t);
        }
        finally {
            $this.releaseFetchBuffer(fetchSize$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateFetcherState$1(ClusterLinkFetcherWithSharedThread $this, ClusterLinkFetcherThread.FetcherState newState) {
        block5: {
            block4: {
                if (!$this.shutdownInitiated()) break block4;
                ClusterLinkFetcherThread.FetcherState fetcherState = newState;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState != null ? !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$) : clusterLinkFetcherThread$FetcherShutdown$ != null) break block5;
            }
            ClusterLinkFetcherThread.FetcherState fetcherState = newState;
            ClusterLinkFetcherThread.FetcherState fetcherState2 = $this.fetcherState();
            if (fetcherState == null ? fetcherState2 != null : !fetcherState.equals(fetcherState2)) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating fetcher state from old=").append($this.fetcherState()).append(" to new=").append(newState).toString());
                $this.fetcherState_$eq(newState);
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$maybeProcessWaitingPartitions$1(ClusterLinkFetcherWithSharedThread $this, Map latestOffsets) {
        $this.onAsyncResponse(true);
        $this.handleSourceOffsets((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)latestOffsets);
    }

    public static final /* synthetic */ void $anonfun$maybeProcessWaitingPartitions$2(ClusterLinkFetcherWithSharedThread $this, Set waitingPartitions$1, Throwable t) {
        $this.onAsyncResponse(false);
        if (t instanceof IOException ? true : t instanceof NetworkException) {
            $this.clusterLinkMetadata.requestUpdate();
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Failed to fetch latest offsets for ").append(waitingPartitions$1).append(", request for metadata").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Failed to fetch latest offsets for ").append(waitingPartitions$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public ClusterLinkFetcherWithSharedThread(String name, Uuid linkId, int fetcherId, FetcherPool fetcherPool, String clientId, BrokerEndPoint sourceBroker, ClusterLinkSharedFetcherThread sharedThread, AsyncSend asyncSender, ClusterLinkAsyncLeaderEndPoint asyncLeader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, ClusterLinkFetchResponseAllocator fetchResponseAllocator, ClusterLinkNetworkClient clusterLinkClient, LogContext logContext, Option<String> tenant) {
        this.name = name;
        this.fetcherId = fetcherId;
        this.fetcherPool = fetcherPool;
        this.sourceBroker = sourceBroker;
        this.sharedThread = sharedThread;
        this.asyncSender = asyncSender;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.time = time;
        this.clusterLinkClient = clusterLinkClient;
        super(name, fetcherId, fetcherPool, asyncLeader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, clusterLinkMetrics, time, fetchResponseAllocator, clusterLinkClient, (Option<LogContext>)new Some((Object)logContext), tenant);
        this.fetchTierStateMachine = new ConfluentReplicaFetcherTierStateMachine(this.leader(), replicaMgr, exponentialBackoff);
        this.brokerTopicStats = replicaMgr.brokerTopicStats();
        this.dedicatedThread = None$.MODULE$;
        this.shutdownLatch = new CountDownLatch(1);
        this.shutdownInitiated = false;
        this.fetcherState = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
    }
}

