/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.utils.ConfluentUtils;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ZkSupport;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$Mirror$;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicFilterJson;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ClusterLinkUtils$
implements Logging {
    public static ClusterLinkUtils$ MODULE$;
    private final Set<Object> ConfluentCloudInternalPorts;
    private final int MaxCreateClusterLinksTimeoutMs;
    private final String MirrorTopicCreationReadAccessErrMsg;
    private final String MirrorTopicCreationAccessNotKnownErrMsg;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Set<Object> ConfluentCloudInternalPorts() {
        return this.ConfluentCloudInternalPorts;
    }

    private int MaxCreateClusterLinksTimeoutMs() {
        return this.MaxCreateClusterLinksTimeoutMs;
    }

    public String MirrorTopicCreationReadAccessErrMsg() {
        return this.MirrorTopicCreationReadAccessErrMsg;
    }

    public String MirrorTopicCreationAccessNotKnownErrMsg() {
        return this.MirrorTopicCreationAccessNotKnownErrMsg;
    }

    public void validateLinkName(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    public Endpoint linkListenerEndpoint(Option<String> tenantPrefix, ClusterLinkConfig config, AuthorizerServerInfo serverInfo, Map<String, String> localReverseConnectionListenerMap) {
        String localListenerName = tenantPrefix.isEmpty() ? config.localListenerName() : this.mapRequestListenerToLocalAdminListener(config.localListenerName(), localReverseConnectionListenerMap);
        return serverInfo.endpoints().stream().filter(x$1 -> {
            Optional optional = x$1.listenerName();
            Optional<String> optional2 = Optional.of(localListenerName);
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(localListenerName).append(" not found").toString()));
    }

    public String mapRequestListenerToLocalAdminListener(String requestListenerName, Map<String, String> localReverseConnectionListenerMap) {
        Option mappedListenerName = localReverseConnectionListenerMap.get((Object)requestListenerName);
        if (mappedListenerName instanceof Some) {
            return (String)((Some)mappedListenerName).value();
        }
        if (None$.MODULE$.equals(mappedListenerName)) {
            throw new IllegalStateException(new StringBuilder(40).append("Failed to find mapped listener name for ").append(requestListenerName).toString());
        }
        throw new MatchError((Object)mappedListenerName);
    }

    public Option<InvalidRequestException> checkTimeoutMs(int timeoutMs) {
        if (timeoutMs > this.MaxCreateClusterLinksTimeoutMs()) {
            return new Some((Object)new InvalidRequestException(String.format("Timeout of %d(ms) is above maximum allowed of %d(ms).", new Integer(timeoutMs), new Integer(this.MaxCreateClusterLinksTimeoutMs()))));
        }
        return None$.MODULE$;
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public String environmentId(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        Option<LogicalClusterMetadata> logicalClusterMetadata = this.lkcMetadata(tenant, multiTenantMetadata);
        if (logicalClusterMetadata instanceof Some) {
            LogicalClusterMetadata lkcMetadata = (LogicalClusterMetadata)((Some)logicalClusterMetadata).value();
            if (lkcMetadata == null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$environmentId$1()));
                }
                return "";
            }
            return lkcMetadata.environmentId();
        }
        if (None$.MODULE$.equals(logicalClusterMetadata)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$environmentId$2()));
            }
            return "";
        }
        throw new MatchError(logicalClusterMetadata);
    }

    public Option<String> orgId(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        Option<LogicalClusterMetadata> logicalClusterMetadata = this.lkcMetadata(tenant, multiTenantMetadata);
        if (logicalClusterMetadata instanceof Some) {
            LogicalClusterMetadata lkcMetadata = (LogicalClusterMetadata)((Some)logicalClusterMetadata).value();
            if (lkcMetadata == null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$orgId$1()));
                }
                return None$.MODULE$;
            }
            return new Some((Object)lkcMetadata.organizationId());
        }
        if (None$.MODULE$.equals(logicalClusterMetadata)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$orgId$2()));
            }
            return None$.MODULE$;
        }
        throw new MatchError(logicalClusterMetadata);
    }

    private Option<LogicalClusterMetadata> lkcMetadata(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        boolean ready = multiTenantMetadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isUp()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$lkcMetadata$2(ready)));
        }
        if (ready) {
            return multiTenantMetadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.metadata((String)tenant.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
        }
        return None$.MODULE$;
    }

    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Uuid> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo, String tenantPrefix) {
        Option mirrorTopic = Option$.MODULE$.apply((Object)topic.mirrorTopic());
        Option option = Option$.MODULE$.apply((Object)topic.linkName());
        if (option instanceof Some) {
            String linkName = (String)((Some)option).value();
            this.validateLinkName(linkName);
            if (mirrorTopic instanceof Some) {
                String unprefixedSourceTopicName;
                String mt = (String)((Some)mirrorTopic).value();
                String withoutTenantPrefixTopicName = topic.name().substring(tenantPrefix.length());
                Option clusterLinkPrefix = linkConfig.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.clusterLinkPrefix());
                clusterLinkPrefix.foreach((Function1 & Serializable & scala.Serializable)linkPrefix -> {
                    ClusterLinkUtils$.$anonfun$resolveCreateTopic$2(withoutTenantPrefixTopicName, linkPrefix);
                    return BoxedUnit.UNIT;
                });
                int clusterLinkPrefixLength = ((String)clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length();
                String unprefixedTopicName = withoutTenantPrefixTopicName.substring(clusterLinkPrefixLength);
                String string = unprefixedSourceTopicName = mt.substring(tenantPrefix.length());
                if (string == null ? unprefixedTopicName != null : !string.equals(unprefixedTopicName)) {
                    String expectedMirrorName = new StringBuilder(0).append((String)clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(unprefixedSourceTopicName).toString();
                    if (clusterLinkPrefix.isDefined()) {
                        throw new UnsupportedVersionException(new StringBuilder(100).append("Renaming the topic suffix, after the prefix, for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                    }
                    throw new UnsupportedVersionException(new StringBuilder(70).append("Topic renaming for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                }
            } else {
                if (None$.MODULE$.equals(mirrorTopic)) {
                    throw new InvalidRequestException("Mirror topic not set.");
                }
                throw new MatchError((Object)mirrorTopic);
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(41).append("Cluster link with name '").append(topic.linkName()).append("' does not exist.").toString());
            }
            if (linkConfig instanceof Some) {
                MirrorTopicConfigSyncRules topicConfigSyncRules = ((ClusterLinkConfig)((Object)((Some)linkConfig).value())).topicConfigSyncRules();
                topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
                if (topicInfo instanceof Some) {
                    ClusterLinkTopicInfo clusterLinkTopicInfo;
                    CompletableFuture ti = (CompletableFuture)((Some)topicInfo).value();
                    try {
                        if (!ti.isDone()) {
                            throw new IllegalStateException("Mirror information must have been resolved.");
                        }
                        clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (TimeoutException e) {
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$resolveCreateTopic$5()), (Throwable)e);
                        }
                        throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                    }
                    ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                    if (info.description().authorizedOperations() == null) {
                        throw new TopicAuthorizationException(this.MirrorTopicCreationAccessNotKnownErrMsg());
                    }
                    if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                        throw new TopicAuthorizationException(this.MirrorTopicCreationReadAccessErrMsg());
                    }
                    ConfigEntry topicType = info.config().get("confluent.topic.type");
                    if (topicType != null && topicType.value().equals(TopicType.VIRTUAL.logConfigValue())) {
                        throw new InvalidConfigurationException(new StringBuilder(53).append("Cannot mirror topic '").append(topic.name()).append("' because it is a VIRTUAL topic.").toString());
                    }
                    Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                    Uuid x$2 = (Uuid)linkId.get();
                    Uuid x$3 = info.description().topicId();
                    Seq<Object> x$42 = info.mirrorStartOffsets();
                    long x$5 = info.stoppedSequenceNumber();
                    long x$6 = ClusterLinkTopicState$Mirror$.MODULE$.apply$default$5();
                    return new ClusterLinkUtils.ResolveCreateTopic(newConfigs, (Option<ClusterLinkTopicState>)new Some((Object)new ClusterLinkTopicState.Mirror(linkName, x$2, x$3, x$5, x$6, x$42)), info.description().partitions().size());
                }
                if (None$.MODULE$.equals(topicInfo)) {
                    if (!validateOnly) {
                        throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                    }
                    return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
                }
                throw new MatchError(topicInfo);
            }
            if (None$.MODULE$.equals(linkConfig)) {
                throw new InvalidRequestException(new StringBuilder(62).append("Cannot create mirror topic, cluster link ").append(linkName).append(" is in a FAILED state").toString());
            }
            throw new MatchError(linkConfig);
        }
        if (None$.MODULE$.equals(option)) {
            if (mirrorTopic.nonEmpty()) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
            }
            return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
        }
        throw new MatchError((Object)option);
    }

    public String resolveCreateTopic$default$7() {
        return "";
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        if (partitions instanceof Some) {
            int n;
            CompletableFuture parts = (CompletableFuture)((Some)partitions).value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException(new StringBuilder(76).append("Cannot set '").append(numPartitions).append("' partitions for topic '").append(topic).append("', ").append("exceeds linked topic's '").append(mirrorNumPartitions).append("' partitions.").toString());
            }
            return;
        }
        if (None$.MODULE$.equals(partitions)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
            return;
        }
        throw new MatchError(partitions);
    }

    public Seq<ClusterLinkFilterInfo> clusterLinkTopicFilters(Option<TopicFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return (Seq)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.filters()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix)), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<GroupClusterLinkFilterInfo> clusterLinkGroupFilters(Option<GroupFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        return (Seq)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.filters()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)filter -> {
            ClusterLinkFilterInfo clFilter = MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix));
            return new GroupClusterLinkFilterInfo(clFilter, filter.effectiveTopicTypes(linkMode));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String tenantAndClusterLinkPrefix(Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return new StringBuilder(0).append((String)tenantPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    private ClusterLinkFilterInfo clusterLinkFilter(ClusterLinkFilter filter, String prefix) {
        PatternType patternType = SecurityUtils.patternType((String)filter.patternType());
        if (new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty()) {
            if (PatternType.LITERAL.equals(patternType)) {
                String string = filter.name();
                String string2 = "*";
                if (string != null && string.equals(string2)) {
                    PatternType patternType2 = patternType;
                    PatternType patternType3 = PatternType.LITERAL;
                    if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
                        return new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), filter);
                    }
                }
                return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
            }
            if (PatternType.PREFIXED.equals(patternType)) {
                return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
            }
            throw new IllegalStateException(new StringBuilder(24).append("Unexpected pattern type ").append(filter.patternType()).toString());
        }
        return new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), filter);
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        if (policy instanceof Some) {
            AlterConfigPolicy pol = (AlterConfigPolicy)((Some)policy).value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            if (pol instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)pol;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(policy)) {
            return props;
        }
        throw new MatchError(policy);
    }

    public boolean canHandleClusterLinkRequests(MetadataSupport metadataSupport, KafkaConfig config) {
        if (metadataSupport instanceof ZkSupport) {
            KafkaController controller = ((ZkSupport)metadataSupport).controller();
            if (config.migrationEnabled()) {
                return true;
            }
            return controller.isActive();
        }
        if (metadataSupport instanceof RaftSupport) {
            return true;
        }
        throw new MatchError((Object)metadataSupport);
    }

    public Tuple2<Option<Errors>, Option<Function1<String, Object>>> canHandleDescribeClusterLinksRequest(short version, MetadataSupport metadataSupport, KafkaConfig config, ClusterLinkFactory.AdminManager adminManager, Option<Set<String>> linkNames) {
        if (version <= 3) {
            if (!this.canHandleClusterLinkRequests(metadataSupport, config)) {
                return new Tuple2((Object)new Some((Object)Errors.NOT_CONTROLLER), (Object)None$.MODULE$);
            }
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$canHandleDescribeClusterLinksRequest$1(x$7))));
        }
        Option<ClusterLinkMetadataManager> option = adminManager.clusterLinkManager().clusterLinkMetadataManager();
        if (option instanceof Some) {
            ClusterLinkMetadataManager mm = (ClusterLinkMetadataManager)((Some)option).value();
            if (mm.isLinkCoordinatorEnabled() && !mm.isLinkCoordinatorInitialized()) {
                return new Tuple2((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)None$.MODULE$);
            }
            if (linkNames instanceof Some) {
                if (((Set)((Some)linkNames).value()).forall((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)mm.isLinkCoordinator(name)))) {
                    return new Tuple2((Object)None$.MODULE$, (Object)new Some((Function1 & Serializable & scala.Serializable)linkName -> BoxesRunTime.boxToBoolean((boolean)mm.isLinkCoordinator(linkName))));
                }
                return new Tuple2((Object)new Some((Object)Errors.NOT_COORDINATOR), (Object)None$.MODULE$);
            }
            if (None$.MODULE$.equals(linkNames)) {
                return new Tuple2((Object)None$.MODULE$, (Object)new Some((Function1 & Serializable & scala.Serializable)linkName -> BoxesRunTime.boxToBoolean((boolean)mm.isLinkCoordinator(linkName))));
            }
            throw new MatchError(linkNames);
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Option<Errors> canHandleDescribeMirrorsRequest(boolean includeTransitionErrors, MetadataSupport metadataSupport, KafkaConfig config, ClusterLinkFactory.AdminManager adminManager, Set<String> mirrorTopics) {
        if (!includeTransitionErrors) {
            if (!this.canHandleClusterLinkRequests(metadataSupport, config)) {
                return new Some((Object)Errors.NOT_CONTROLLER);
            }
            return None$.MODULE$;
        }
        Option<ClusterLinkMetadataManager> option = adminManager.clusterLinkManager().clusterLinkMetadataManager();
        if (option instanceof Some) {
            ClusterLinkMetadataManager mm = (ClusterLinkMetadataManager)((Some)option).value();
            if (mm.isLinkCoordinatorEnabled() && !mm.isLinkCoordinatorInitialized()) {
                return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            }
            if (mirrorTopics.forall((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)mm.isLinkCoordinatorForMirrorTopic(topic)))) {
                return None$.MODULE$;
            }
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        if (None$.MODULE$.equals(option)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        throw new MatchError(option);
    }

    public void validateMirrorTopicConfig(String topic, Set<String> configKeys, ClusterLinkFactory.LinkManager clusterLinkManager, boolean isIncremental) {
        clusterLinkManager.clusterLinkMetadataManager().foreach((Function1 & Serializable & scala.Serializable)metadataManager -> {
            ClusterLinkUtils$.$anonfun$validateMirrorTopicConfig$1(topic, isIncremental, clusterLinkManager, configKeys, metadataManager);
            return BoxedUnit.UNIT;
        });
    }

    public Throwable taskExceptionCauseOrException(Throwable throwable) {
        KafkaException kafkaException;
        if (throwable instanceof ExecutionException ? true : throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        if (throwable instanceof ApiException) {
            return (ApiException)throwable;
        }
        if (throwable instanceof KafkaException && (kafkaException = (KafkaException)throwable).getCause() != null && kafkaException.getCause() instanceof ApiException) {
            return kafkaException.getCause();
        }
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    public ApiException apiException(Throwable throwable, String message) {
        e = this.taskExceptionCauseOrException(throwable);
        v0 = err = Errors.forException((Throwable)e);
        var6_5 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var6_5 != null : v0.equals(var6_5) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var7_6 = e.getMessage();
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == e ? e.getMessage() : new StringBuilder(14).append(e.getMessage()).append(", root cause: ").append(rootCause).toString();
        }
        errMessage = v2;
        apiError = ObjectRef.create((Object)new ApiError(err, errMessage));
        v3 = ((ApiError)apiError.elem).error();
        var10_10 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var10_10) == false : var10_10 != null)) {
            if (e instanceof AuthenticationException) {
                apiError.elem = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
            } else if (e instanceof ConfigException) {
                apiError.elem = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
            }
        }
        errorMessage = new StringBuilder(15).append(message).append(" due to error: ").append(((ApiError)apiError.elem).messageWithFallback()).toString();
        v4 = ((ApiError)apiError.elem).error();
        var12_12 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var12_12) == false : var12_12 != null)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$1(errorMessage)), ClusterLinkUtils$.$anonfun$apiException$2(e));
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$3(errorMessage)), ClusterLinkUtils$.$anonfun$apiException$4(e));
        }
        if (((ApiError)apiError.elem).exception() instanceof InvalidClusterLinkException) {
            if (e instanceof InvalidClusterLinkException) {
                var13_13 = (InvalidClusterLinkException)e;
                return new InvalidClusterLinkException(var13_13.clusterLinkError(), var13_13.linkErrorMessage(), errorMessage);
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$5(apiError, e)));
            }
            return ((ApiError)apiError.elem).error().exception(errorMessage);
        }
        return ((ApiError)apiError.elem).error().exception(errorMessage);
    }

    public Tuple2<Set<String>, Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, Option<TopicFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        Seq<ClusterLinkFilterInfo> filters = this.clusterLinkTopicFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix);
        return this.doFilterTopics(toFilter, filters);
    }

    public Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> toFilter, Option<GroupFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        Seq<GroupClusterLinkFilterInfo> filters = this.clusterLinkGroupFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix, linkMode);
        return this.doFilterGroups(toFilter, filters);
    }

    public Tuple2<Set<String>, Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set filtered = (Set)toFilter.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterTopics$1(filters, usedFilters, item)));
        return new Tuple2((Object)filtered, filters.diff((GenSeq)usedFilters));
    }

    public Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> groups, Seq<GroupClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set filtered = (Set)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> {
            Seq matchedFilters = (Seq)filters.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$2(group, x$11)));
            if (matchedFilters.isEmpty()) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            usedFilters.$plus$plus$eq((TraversableOnce)matchedFilters.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.filterInfo(), Seq$.MODULE$.canBuildFrom()));
            Set includeTopicTypes = ((TraversableOnce)((Seq)matchedFilters.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$4(x$13)))).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.topicTypes(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set excludeTopicTypes = ((TraversableOnce)((Seq)matchedFilters.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$6(x$15)))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.topicTypes(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set topicTypes = (Set)includeTopicTypes.diff((GenSet)excludeTopicTypes);
            if (!topicTypes.isEmpty()) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new MatchedGroup((String)group, (Set<Enumeration.Value>)topicTypes)));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom());
        return new Tuple2((Object)filtered, ((SeqLike)filters.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.filterInfo(), Seq$.MODULE$.canBuildFrom())).diff((GenSeq)usedFilters));
    }

    public ClusterLinkConfig.LinkMode doFilterGroups$default$5() {
        return ClusterLinkConfig.LinkMode.DESTINATION;
    }

    public boolean isInternalNetworkOrPort(InetSocketAddress socketAddress) {
        return this.ConfluentCloudInternalPorts().contains((Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort())) && (socketAddress.getAddress().isSiteLocalAddress() || socketAddress.getAddress().isLoopbackAddress());
    }

    public boolean isCCloudIntranetHost(java.util.Map<String, ?> brokerConfigs, String host) {
        return ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, (String)host);
    }

    public boolean isOutboundBootstrapCCloudHost(java.util.Map<String, ?> brokerConfigs, ConnectionMode connectionMode, List<String> bootstrapServers) {
        Option firstHost = ((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(bootstrapServers).asScala()).filter((Function1 & Serializable & scala.Serializable)bootstrap -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$isOutboundBootstrapCCloudHost$1(bootstrap)))).map((Function1 & Serializable & scala.Serializable)bootstrap -> Utils.getHost((String)bootstrap), Buffer$.MODULE$.canBuildFrom())).headOption();
        if (firstHost instanceof Some) {
            String host = (String)((Some)firstHost).value();
            ConnectionMode connectionMode2 = connectionMode;
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (!(connectionMode2 != null ? !connectionMode2.equals(connectionMode$Outbound$) : connectionMode$Outbound$ != null)) {
                if (host != null && ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)host)) {
                    return true;
                }
            }
            return false;
        }
        if (None$.MODULE$.equals(firstHost)) {
            return false;
        }
        throw new MatchError((Object)firstHost);
    }

    public boolean isRetriableFailure(Throwable cause) {
        if (cause instanceof RetriableException) {
            return true;
        }
        if (cause instanceof ConfigException) {
            String namingMessage = cause.getMessage();
            if (namingMessage == null) {
                return false;
            }
            return namingMessage.startsWith("No resolvable bootstrap urls");
        }
        return false;
    }

    public OffsetSpec toOffsetSpec(long timestamp, OffsetSpec defaultSpec) {
        if (Long.MIN_VALUE == timestamp) {
            return defaultSpec;
        }
        if (timestamp >= 0L) {
            return OffsetSpec.forTimestamp((long)timestamp);
        }
        if (-2L == timestamp) {
            return OffsetSpec.earliest();
        }
        if (-1L == timestamp) {
            return OffsetSpec.latest();
        }
        if (-3L == timestamp) {
            throw new InvalidConfigurationException("Mirroring from max timestamp is not supported.");
        }
        throw new InvalidConfigurationException(new StringBuilder(46).append("Unsupported start offset spec for mirroring: ").append(timestamp).append(".").toString());
    }

    public boolean isAuthenticationException(KafkaException kafkaException) {
        return kafkaException instanceof AuthenticationException || kafkaException.getCause() != null && kafkaException.getCause() instanceof AuthenticationException;
    }

    public TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        KafkaException kafkaException;
        Throwable throwable = ex.getCause();
        if (throwable instanceof KafkaException && this.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
            TaskErrorCode errCode = localAdminUsed ? BrokerAuthenticationTaskErrorCode$.MODULE$ : AuthenticationTaskErrorCode$.MODULE$;
            return new TaskErrorCodeAndMsg(errCode, new StringBuilder(30).append(errMsgPrefix).append(" due to authentication issues.").toString());
        }
        if (throwable instanceof AuthorizationException) {
            TaskErrorCode errCode = localAdminUsed ? BrokerAuthorizationTaskErrorCode$.MODULE$ : AuthorizationTaskErrorCode$.MODULE$;
            return new TaskErrorCodeAndMsg(errCode, new StringBuilder(29).append(errMsgPrefix).append(" due to authorization issues.").toString());
        }
        return new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(23).append(errMsgPrefix).append(" for an unknown reason.").toString());
    }

    public static final /* synthetic */ String $anonfun$environmentId$1() {
        return "Lkc metadata is null";
    }

    public static final /* synthetic */ String $anonfun$environmentId$2() {
        return "Lkc metadata is not available";
    }

    public static final /* synthetic */ String $anonfun$orgId$1() {
        return "Lkc metadata is null";
    }

    public static final /* synthetic */ String $anonfun$orgId$2() {
        return "Lkc metadata is not available";
    }

    public static final /* synthetic */ String $anonfun$lkcMetadata$2(boolean ready$1) {
        return new StringBuilder(29).append("multiTenantMetadata is ready ").append(ready$1).toString();
    }

    public static final /* synthetic */ void $anonfun$resolveCreateTopic$2(String withoutTenantPrefixTopicName$1, String linkPrefix) {
        if (!withoutTenantPrefixTopicName$1.startsWith(linkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Mirror topic name should start with cluster link prefix ").append(linkPrefix).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$resolveCreateTopic$5() {
        return "Received timeout exception while fetching topic information over cluster link";
    }

    public static final /* synthetic */ boolean $anonfun$canHandleDescribeClusterLinksRequest$1(String x$7) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$validateMirrorTopicConfig$1(String topic$1, boolean isIncremental$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Set configKeys$1, ClusterLinkMetadataManager metadataManager) {
        if (metadataManager.hasTopic(topic$1)) {
            Option clusterLinkTopicState = metadataManager.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})))).get((Object)topic$1);
            if (clusterLinkTopicState.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.mirrorIsEstablished()))) {
                if (!isIncremental$1) {
                    throw new InvalidRequestException(new StringBuilder(72).append("Non-incremental configuration updates for mirror topic '").append(topic$1).append("' are disallowed").toString());
                }
                Uuid linkId = ((ClusterLinkTopicState)clusterLinkTopicState.get()).linkId();
                if (clusterLinkManager$1.linkConfig(linkId).isEmpty()) {
                    throw new ClusterLinkNotFoundException(new StringBuilder(71).append("The cluster link with ID ").append(linkId).append(" does not exist, or is temporarily unavailable").toString());
                }
                ((ClusterLinkConfig)((Object)clusterLinkManager$1.linkConfig(linkId).get())).topicConfigSyncRules().validateMirrorPropsForTopicAlteration(topic$1, (Set<String>)configKeys$1);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$5(ObjectRef apiError$1, Throwable e$2) {
        return new StringBuilder(88).append(((ApiError)apiError$1.elem).exception()).append(" is an instance of ClusterLinkAvailabilityException but ").append(e$2).append(" is not which should not happen.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterTopics$1(Seq filters$1, Buffer usedFilters$1, String item) {
        Seq matchedFilters = (Seq)filters$1.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((TraversableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isInclude()));
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$2(String group$1, GroupClusterLinkFilterInfo x$11) {
        return x$11.filterInfo().matchesIncludeOrExclude(group$1);
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$4(GroupClusterLinkFilterInfo x$13) {
        return x$13.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$6(GroupClusterLinkFilterInfo x$15) {
        return !x$15.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$isOutboundBootstrapCCloudHost$1(String bootstrap) {
        return bootstrap != null && !bootstrap.isEmpty();
    }

    private ClusterLinkUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ConfluentCloudInternalPorts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9071, 9072, 9073, 9074, 9075, 9076, 9080, 8090}));
        this.MaxCreateClusterLinksTimeoutMs = 300000;
        this.MirrorTopicCreationReadAccessErrMsg = "Mirror topic creation requires READ access on the source topic.";
        this.MirrorTopicCreationAccessNotKnownErrMsg = "Mirror topic creation failed because access on the source topic is not known.";
    }
}

