/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.server.link.LRUCache$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\n\u0015\u0001mA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0004B\u0001\t\u0007I\u0011\u0002\"\t\r-\u0003\u0001\u0015!\u0003D\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u00159\u0007\u0001\"\u0011i\u000f\u0015!H\u0003#\u0001v\r\u0015\u0019B\u0003#\u0001w\u0011\u0015y\u0003\u0003\"\u0001x\u0011\u0015A\b\u0003\"\u0001z\u0005!a%+V\"bG\",'BA\u000b\u0017\u0003\u0011a\u0017N\\6\u000b\u0005]A\u0012AB:feZ,'OC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001H\u001b\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0005dCB\f7-\u001b;z!\tqR%\u0003\u0002'?\t\u0019\u0011J\u001c;\u0002\u000bQ$H.T:\u0011\u0005yI\u0013B\u0001\u0016 \u0005\u0011auN\\4\u0002\u00079|w\u000fE\u0002\u001f[!J!AL\u0010\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014A\u0002\u001fj]&$h\b\u0006\u00032}}\u0002\u0005c\u0001\u001a\u0001g5\tA\u0003\u0005\u00025k1\u0001A!\u0002\u001c\u0001\u0005\u00049$!\u0001+\u0012\u0005aZ\u0004C\u0001\u0010:\u0013\tQtDA\u0004O_RD\u0017N\\4\u0011\u0005ya\u0014BA\u001f \u0005\r\te.\u001f\u0005\u0006G\u0011\u0001\r\u0001\n\u0005\u0006O\u0011\u0001\r\u0001\u000b\u0005\u0006W\u0011\u0001\r\u0001L\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u0007B!A)S\u001a)\u001b\u0005)%B\u0001$H\u0003\u001diW\u000f^1cY\u0016T!\u0001S\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002K\u000b\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\faaY1dQ\u0016\u0004\u0013aA1eIR\u0011a*\u0015\t\u0003==K!\u0001U\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006%\u001e\u0001\raM\u0001\u0005SR,W.\u0001\u0005d_:$\u0018-\u001b8t)\t)\u0006\f\u0005\u0002\u001f-&\u0011qk\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0006\u00021\u00014\u0003\r9W\r\u001e\u000b\u00037z\u00032A\b/)\u0013\tivD\u0001\u0004PaRLwN\u001c\u0005\u0006%&\u0001\raM\u0001\u0006G2,\u0017M\u001d\u000b\u0002\u001d\u00069\u0011n]#naRLX#A+\u0002\tML'0Z\u000b\u0002I\u0005!\u0001.Z1e+\u0005\u0019\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003%\u0004\"A[9\u000f\u0005-|\u0007C\u00017 \u001b\u0005i'B\u00018\u001b\u0003\u0019a$o\\8u}%\u0011\u0001oH\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002q?\u0005AAJU+DC\u000eDW\r\u0005\u00023!M\u0011\u0001#\b\u000b\u0002k\u0006)\u0011\r\u001d9msV\u0011!0 \u000b\u0006wz|\u0018\u0011\u0001\t\u0004e\u0001a\bC\u0001\u001b~\t\u00151$C1\u00018\u0011\u0015\u0019#\u00031\u0001%\u0011\u00159#\u00031\u0001)\u0011\u0015Y#\u00031\u0001-\u0001")
public class LRUCache<T> {
    private final int capacity;
    private final long ttlMs;
    private final Function0<Object> now;
    private final LinkedHashMap<T, Object> cache;

    public static <T> LRUCache<T> apply(int n, long l, Function0<Object> function0) {
        if (LRUCache$.MODULE$ == null) {
            throw null;
        }
        return new LRUCache<T>(n, l, function0);
    }

    private LinkedHashMap<T, Object> cache() {
        return this.cache;
    }

    public void add(T item) {
        if (this.cache().size() >= this.capacity) {
            this.cache().$minus$eq(((Tuple2)this.cache().head())._1());
        }
        this.cache().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(item), (Object)BoxesRunTime.boxToLong((long)this.now.apply$mcJ$sp())));
    }

    public boolean contains(T item) {
        Option cachedItemOpt = this.cache().get(item);
        if (cachedItemOpt instanceof Some) {
            long cachedItem = BoxesRunTime.unboxToLong((Object)((Some)cachedItemOpt).value());
            if (this.now.apply$mcJ$sp() > cachedItem + this.ttlMs) {
                this.cache().remove(item);
                return false;
            }
            return true;
        }
        if (None$.MODULE$.equals(cachedItemOpt)) {
            return false;
        }
        throw new MatchError((Object)cachedItemOpt);
    }

    public Option<Object> get(T item) {
        return this.cache().get(item);
    }

    public void clear() {
        this.cache().clear();
    }

    public boolean isEmpty() {
        return this.cache().isEmpty();
    }

    public int size() {
        return this.cache().size();
    }

    public T head() {
        return (T)((Tuple2)this.cache().head())._1();
    }

    public String toString() {
        return this.cache().mkString(", ");
    }

    public LRUCache(int capacity, long ttlMs, Function0<Object> now) {
        this.capacity = capacity;
        this.ttlMs = ttlMs;
        this.now = now;
        this.cache = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

