/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.MergedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u001dw!B\u0016-\u0011\u0003\u0019d!B\u001b-\u0011\u00031\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031e\u0001B\u001b-\u00011D\u0001b\u001f\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\ty\u0012\u0011\t\u0011)A\u0005{\"Q\u00111\u0001\u0003\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005-AA!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u001a\u0011\u0011\t\u0011)A\u0005\u00037A!\"!\t\u0005\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\t\u0019\u0004\u0002B\u0001B\u0003%\u0011Q\u0007\u0005\u000b\u0003\u0007\"!\u00111A\u0005\u0002\u0005\u0015\u0003BCA'\t\t\u0005\r\u0011\"\u0001\u0002P!Q\u00111\f\u0003\u0003\u0002\u0003\u0006K!a\u0012\t\u0015\u0005uCA!A!\u0002\u0013\ty\u0006\u0003\u0006\u0002f\u0011\u0011\t\u0011)A\u0005\u0003OB!\"!\u001c\u0005\u0005\u0003\u0005\u000b\u0011BA8\u0011)\t)\b\u0002B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003{\"!\u0011!Q\u0001\n\u0005}\u0004BCAF\t\t\u0005\t\u0015!\u0003\u0002\u000e\"Q\u00111\u0014\u0003\u0003\u0002\u0003\u0006I!!$\t\u0015\u0005uEA!A!\u0002\u0013\ty\n\u0003\u0006\u0002@\u0012\u0011\t\u0011)A\u0005\u0003\u0003D!\"a4\u0005\u0005\u0003\u0005\u000b\u0011BAi\u0011)\ty\u000e\u0002B\u0001B\u0003%\u0011\u0011\u001d\u0005\u000b\u0003_$!\u0011!Q\u0001\n\u0005E\bBB\"\u0005\t\u0003\ty\u0010C\u0005\u0003,\u0011\u0011\r\u0011\"\u0001\u0003.!A!Q\u0007\u0003!\u0002\u0013\u0011y\u0003C\u0005\u00038\u0011\u0001\r\u0011\"\u0001\u0003:!I!\u0011\t\u0003A\u0002\u0013\u0005!1\t\u0005\t\u0005\u000f\"\u0001\u0015)\u0003\u0003<!I!\u0011\n\u0003C\u0002\u0013\u0005!1\n\u0005\t\u0005G\"\u0001\u0015!\u0003\u0003N!9!Q\r\u0003\u0005B\t\u001d\u0004b\u0002B5\t\u0011\u0005#1\u000e\u0005\b\u0005\u0003#A\u0011\u0002BB\u0011\u001d\u0011\u0019\n\u0002C\u0001\u0005+CqA!)\u0005\t\u0003\u0011\u0019\u000bC\u0004\u0003<\u0012!IA!0\t\u000f\t\u0005G\u0001\"\u0003\u0003D\"9!Q\u0019\u0003\u0005B\t\r\u0017a\u0006\"s_.,'/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0015\tic&\u0001\u0005nKR\fG-\u0019;b\u0015\ty\u0003'\u0001\u0004tKJ4XM\u001d\u0006\u0002c\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001b\u0002\u001b\u0005a#a\u0006\"s_.,'/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s'\r\tq'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\nU\"A \u000b\u0005\u0001\u0003\u0014!B;uS2\u001c\u0018B\u0001\"@\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001a\u0002\u001b\u001d,G\u000fV8qS\u000e$U\r\u001c;b)\u00119UKY4\u0011\u0007aB%*\u0003\u0002Js\t1q\n\u001d;j_:\u0004\"aS*\u000e\u00031S!!\u0014(\u0002\u000b%l\u0017mZ3\u000b\u0005Ez%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016'\u0003\u0015Q{\u0007/[2EK2$\u0018\rC\u0003W\u0007\u0001\u0007q+A\u0005u_BL7MT1nKB\u0011\u0001l\u0018\b\u00033v\u0003\"AW\u001d\u000e\u0003mS!\u0001\u0018\u001a\u0002\rq\u0012xn\u001c;?\u0013\tq\u0016(\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010:\u0011\u0015\u00197\u00011\u0001e\u0003!qWm^%nC\u001e,\u0007CA&f\u0013\t1GJA\u0007NKR\fG-\u0019;b\u00136\fw-\u001a\u0005\u0006Q\u000e\u0001\r![\u0001\u0006I\u0016dG/\u0019\t\u0003\u0017*L!a\u001b'\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b'\u0011!Q.^\u001f\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n1qJ\u00196fGR\u0004\"A^=\u000e\u0003]T!\u0001\u001f'\u0002\u0013A,(\r\\5tQ\u0016\u0014\u0018B\u0001>x\u0005EiU\r^1eCR\f\u0007+\u001e2mSNDWM]\u0001\nG2,8\u000f^3s\u0013\u0012\fAaY8oMB\u0011ap`\u0007\u0002]%\u0019\u0011\u0011\u0001\u0018\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0007Q\n9!C\u0002\u0002\n1\u0012qc\u0013*bMRLU.Y4f\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u00151|w-T1oC\u001e,'\u000f\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002M\u0001\u0004Y><\u0017\u0002BA\f\u0003#\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042A`A\u000f\u0013\r\tyB\f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u00055b*A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\u0019\u0003O\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u0011qGA \u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:T1!!\f1\u0013\u0011\t\t%!\u000f\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fa\u0003Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]\u000b\u0003\u0003\u000f\u00022\u0001NA%\u0013\r\tY\u0005\f\u0002\u0017\tft\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0006QB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'o\u0018\u0013fcR!\u0011\u0011KA,!\rA\u00141K\u0005\u0004\u0003+J$\u0001B+oSRD\u0011\"!\u0017\u000e\u0003\u0003\u0005\r!a\u0012\u0002\u0007a$\u0013'A\fes:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3sA\u0005YB-\u001f8b[&\u001c7\t\\5f]R\fVo\u001c;b!V\u0014G.[:iKJ\u00042\u0001NA1\u0013\r\t\u0019\u0007\f\u0002\u001c\tft\u0017-\\5d\u00072LWM\u001c;Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0002\u001dM\u001c'/Y7Qk\nd\u0017n\u001d5feB\u0019A'!\u001b\n\u0007\u0005-DF\u0001\bTGJ\fW\u000eU;cY&\u001c\b.\u001a:\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u0004VO\u00197jg\",'\u000fE\u00025\u0003cJ1!a\u001d-\u0005a!U\r\\3hCRLwN\u001c+pW\u0016t\u0007+\u001e2mSNDWM]\u0001\rC\u000ed\u0007+\u001e2mSNDWM\u001d\t\u0004i\u0005e\u0014bAA>Y\ta\u0011i\u00197Qk\nd\u0017n\u001d5fe\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC\u001d\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\n\u0006\r%AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\f\u0011CZ1uC24\u0015-\u001e7u\u0011\u0006tG\r\\3s!\u0011\ty)a&\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bQAZ1vYRT!a\f(\n\t\u0005e\u0015\u0011\u0013\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001f[\u0016$\u0018\rZ1uCB+(\r\\5tQ&twMR1vYRD\u0015M\u001c3mKJ\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feB!\u0001\bSAQ!\u0011\t\u0019+!/\u000f\t\u0005\u0015\u00161\u0017\b\u0005\u0003O\u000byK\u0004\u0003\u0002*\u00065fb\u0001.\u0002,&\t\u0011'\u0003\u00020a%\u0019\u0011\u0011\u0017\u0018\u0002\t1Lgn[\u0005\u0005\u0003k\u000b9,\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL(bAAY]%!\u00111XA_\u0005-a\u0015N\\6NC:\fw-\u001a:\u000b\t\u0005U\u0016qW\u0001\u0012i&,'/\u001a3D_>\u0014H-\u001b8bi>\u0014\b\u0003\u0002\u001dI\u0003\u0007\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\u0004\u0014\u0001\u0002;jKJLA!!4\u0002H\n\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0003)\u0012\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:PaR\u0004B\u0001\u000f%\u0002TB!\u0011Q[An\u001b\t\t9N\u0003\u0003\u0002Z\u0006\u001d\u0017!\u00062bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.Z\u0005\u0005\u0003;\f9NA\u0014CC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014\u0018a\b;jKJ$v\u000e]5d':\f\u0007o\u001d5pi\u000e{wN\u001d3j]\u0006$xN](qiB!\u0001\bSAr!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003\u000f\f\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0003[\f9O\u0001\u000fUS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_R\u001cun\u001c:eS:\fGo\u001c:\u0002'E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014x\n\u001d;\u0011\taB\u00151\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A\u001f\u0003\u0015\tXo\u001c;b\u0013\u0011\ti0a>\u0003!E+x\u000e^1D_>\u0014H-\u001b8bi>\u0014HC\u000bB\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018\te!1\u0004B\u000f\u0005?\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006\t\u0003i\u0011AQa_\u000eA\u0002]CQ\u0001`\u000eA\u0002uDq!a\u0001\u001c\u0001\u0004\t)\u0001C\u0004\u0002\fm\u0001\r!!\u0004\t\u000f\u0005e1\u00041\u0001\u0002\u001c!9\u0011\u0011E\u000eA\u0002\u0005\r\u0002bBA\u001a7\u0001\u0007\u0011Q\u0007\u0005\b\u0003\u0007Z\u0002\u0019AA$\u0011\u001d\tif\u0007a\u0001\u0003?Bq!!\u001a\u001c\u0001\u0004\t9\u0007C\u0004\u0002nm\u0001\r!a\u001c\t\u000f\u0005U4\u00041\u0001\u0002x!9\u0011QP\u000eA\u0002\u0005}\u0004bBAF7\u0001\u0007\u0011Q\u0012\u0005\b\u00037[\u0002\u0019AAG\u0011\u001d\tij\u0007a\u0001\u0003?Cq!a0\u001c\u0001\u0004\t\t\rC\u0004\u0002Pn\u0001\r!!5\t\u000f\u0005}7\u00041\u0001\u0002b\"9\u0011q^\u000eA\u0002\u0005E\u0018\u0001\u00032s_.,'/\u00133\u0016\u0005\t=\u0002c\u0001\u001d\u00032%\u0019!1G\u001d\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005iqLZ5sgR\u0004VO\u00197jg\",\"Aa\u000f\u0011\u0007a\u0012i$C\u0002\u0003@e\u0012qAQ8pY\u0016\fg.A\t`M&\u00148\u000f\u001e)vE2L7\u000f[0%KF$B!!\u0015\u0003F!I\u0011\u0011L\u0010\u0002\u0002\u0003\u0007!1H\u0001\u000f?\u001aL'o\u001d;Qk\nd\u0017n\u001d5!\u0003I1\u0017N]:u!V\u0014G.[:i\rV$XO]3\u0016\u0005\t5\u0003C\u0002B(\u00053\u0012i&\u0004\u0002\u0003R)!!1\u000bB+\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005/\n\u0018\u0001B;uS2LAAa\u0017\u0003R\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u00079\u0014y&C\u0002\u0003b=\u0014AAV8jI\u0006\u0019b-\u001b:tiB+(\r\\5tQ\u001a+H/\u001e:fA\u0005!a.Y7f)\u00059\u0016\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)!\t\tF!\u001c\u0003p\tE\u0004\"\u00025%\u0001\u0004I\u0007\"B2%\u0001\u0004!\u0007b\u0002B:I\u0001\u0007!QO\u0001\t[\u0006t\u0017NZ3tiB!!q\u000fB?\u001b\t\u0011IHC\u0002\u0003|1\u000ba\u0001\\8bI\u0016\u0014\u0018\u0002\u0002B@\u0005s\u0012a\u0002T8bI\u0016\u0014X*\u00198jM\u0016\u001cH/A\u0007u_>\u0003H/[8oC2Le\u000e\u001e\u000b\u0005\u0005\u000b\u0013i\t\u0005\u0003\u0003\b\n%UB\u0001B+\u0013\u0011\u0011YI!\u0016\u0003\u0017=\u0003H/[8oC2Le\u000e\u001e\u0005\b\u0005\u001f+\u0003\u0019\u0001BI\u0003\u0019y\u0007\u000f^5p]B!\u0001\b\u0013B\u0018\u0003\u0015\u0012X\r\\8bIV\u0003H-\u0019;fI\u001aKG.Z:XSRDw.\u001e;D_:4\u0017nZ\"iC:<W\r\u0006\u0003\u0002R\t]\u0005b\u0002BMM\u0001\u0007!1T\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0005\u000f\u0013i*\u0003\u0003\u0003 \nU#A\u0003)s_B,'\u000f^5fg\u0006\tR\u000f\u001d3bi\u0016\u001cun\u001c:eS:\fGo\u001c:\u0015\u0019\u0005E#Q\u0015BT\u0005S\u0013YK!.\t\u000b5;\u0003\u0019\u00013\t\u000b!<\u0003\u0019A5\t\u000bY;\u0003\u0019A,\t\u000f\t5v\u00051\u0001\u00030\u0006AQ\r\\3di&|g\u000eE\u00059\u0005c\u0013yCa\f\u0002R%\u0019!1W\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004b\u0002B\\O\u0001\u0007!\u0011X\u0001\fe\u0016\u001c\u0018n\u001a8bi&|g\u000eE\u00059\u0005c\u0013yC!%\u0002R\u0005\u0011\u0012N\\5uS\u0006d\u0017N_3NC:\fw-\u001a:t)\u0011\t\tFa0\t\u000b\rD\u0003\u0019\u00013\u0002A\u0019Lg.[:i\u0013:LG/[1mSjLgn\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0003\u0003#\nQa\u00197pg\u0016\u0004")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftImageMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final CredentialProvider credentialProvider;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String string, MetadataImage metadataImage, MetadataDelta metadataDelta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(string, metadataImage, metadataDelta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tieredCoordinator.foreach((Function1 & Serializable & scala.Serializable)tieredCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$2) -> {
                                tieredCoord.handleEmigration(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(64).append("Error updating ").append("tiered storage coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)quotaCoordinator -> {
                            this.updateCoordinator(newImage, delta, "_confluent-quotas", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                quotaCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)quotaTopicPartitionId), (Option<Object>)coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating ").append("quota coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)backupObjectLifecycleManagerCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$4) -> {
                                backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(81).append("Error updating ").append("backup object lifecycle manager coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tierTopicSnapshotCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)tierSnapshotCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$5) -> tierSnapshotCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$6) -> {
                                tierSnapshotCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(69).append("Error updating ").append("tier topic snapshot coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                            this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> {
                                manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt((Object)partitionId), (Option<Object>)leaderEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(58).append("Error updating ").append("cluster link manager with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                Option$.MODULE$.apply((Object)delta.scramDelta()).foreach((Function1 & Serializable & scala.Serializable)scramDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$26(this, scramDelta);
                    return BoxedUnit.UNIT;
                });
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
            if (topicsDelta.topicWasDeleted(topicName)) {
                topicsDelta.image().getTopic(topicName).partitions().entrySet().forEach(entry -> {
                    if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                        resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                        return;
                    }
                });
            }
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable & scala.Serializable)topicDelta -> {
            LocalReplicaChanges $anonfun$updateCoordinator$3_changes = topicDelta.localChanges(this.brokerId());
            $anonfun$updateCoordinator$3_changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
            $anonfun$updateCoordinator$3_changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
            $anonfun$updateCoordinator$3_changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics((Option<String>)None$.MODULE$), (Function1<MergedLog, Object>)(Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(this.brokerId(), newImage.topics(), log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.startup(x$7.startup$default$1());
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.conf.groupCoordinatorConfig().offsetsTopicPartitions())));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("_confluent-quotas").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.confluentConfig().quotasTopicPartitions()))));
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$26(BrokerMetadataPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> {
            ScramMechanism mechanism = x0$1;
            x1$1.forEach((x0$2, x1$2) -> {
                String userName = x0$2;
                Optional change = x1$2;
                if (change.isPresent()) {
                    $this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential(mechanism));
                    return;
                }
                $this.credentialProvider.removeCredentials(mechanism, userName);
            });
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                    resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftImageMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, CredentialProvider credentialProvider, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.credentialProvider = credentialProvider;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.tierTopicSnapshotCoordinatorOpt = tierTopicSnapshotCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

