/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.ssl;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kafka.server.KafkaConfig;
import kafka.server.ssl.MtlsWithServerCertConfigs$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ListenerName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}<QAF\f\t\u0002y1Q\u0001I\f\t\u0002\u0005BQ\u0001K\u0001\u0005\u0002%B\u0001BK\u0001C\u0002\u0013\u0005qc\u000b\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u0017\t\u0011u\n!\u0019!C\u0001/-BaAP\u0001!\u0002\u0013a\u0003\u0002C \u0002\u0005\u0004%\taF\u0016\t\r\u0001\u000b\u0001\u0015!\u0003-\u0011\u001d\t\u0015A1A\u0005\u0002\tCaAU\u0001!\u0002\u0013\u0019\u0005bB*\u0002\u0005\u0004%\tA\u0011\u0005\u0007)\u0006\u0001\u000b\u0011B\"\u0007\t\u0001:\u0002!\u0016\u0005\t96\u0011)\u0019!C\u0001;\"A!-\u0004B\u0001B\u0003%a\fC\u0003)\u001b\u0011\u00051\rC\u0003g\u001b\u0011%!\tC\u0003h\u001b\u0011%\u0001\u000eC\u0003t\u001b\u0011%A\u000fC\u0003v\u001b\u0011\u0005a\u000fC\u0003x\u001b\u0011\u0005\u00010A\rNi2\u001cx+\u001b;i'\u0016\u0014h/\u001a:DKJ$8i\u001c8gS\u001e\u001c(B\u0001\r\u001a\u0003\r\u00198\u000f\u001c\u0006\u00035m\taa]3sm\u0016\u0014(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001A\u0011q$A\u0007\u0002/\tIR\n\u001e7t/&$\bnU3sm\u0016\u00148)\u001a:u\u0007>tg-[4t'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\tq\u0002\u0015:pm&$WM]\"p]\u001aLwm]\u000b\u0002YA\u0019QF\r\u001b\u000e\u00039R!a\f\u0019\u0002\u0013%lW.\u001e;bE2,'BA\u0019%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g9\u00121aU3u!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017\u0001\u0005)s_ZLG-\u001a:D_:4\u0017nZ:!\u0003I\u00196\u000f\\&fsN$xN]3D_:4\u0017nZ:\u0002'M\u001bHnS3zgR|'/Z\"p]\u001aLwm\u001d\u0011\u0002)M\u001bH\u000e\u0016:vgR\u001cHo\u001c:f\u0007>tg-[4t\u0003U\u00196\u000f\u001c+skN$8\u000f^8sK\u000e{gNZ5hg\u0002\nAc]:m\u0007>tg-[4t)>|e/\u001a:sS\u0012,W#A\"\u0011\u0007\u0011;\u0005*D\u0001F\u0015\t1\u0005(\u0001\u0003vi&d\u0017BA\u001aF!\tI\u0005K\u0004\u0002K\u001dB\u00111\nJ\u0007\u0002\u0019*\u0011Q*H\u0001\u0007yI|w\u000e\u001e \n\u0005=#\u0013A\u0002)sK\u0012,g-\u0003\u0002<#*\u0011q\nJ\u0001\u0016gNd7i\u001c8gS\u001e\u001cHk\\(wKJ\u0014\u0018\u000eZ3!\u0003\t\u001a8\u000f\u001c\"d\u0003B\u0004(o\u001c<fI6{G-Z\"p]\u001aLwm\u001d+p\u001fZ,'O]5eK\u0006\u00193o\u001d7CG\u0006\u0003\bO]8wK\u0012lu\u000eZ3D_:4\u0017nZ:U_>3XM\u001d:jI\u0016\u00043cA\u0007#-B\u0011qKW\u0007\u00021*\u0011\u0011lG\u0001\u0006kRLGn]\u0005\u00037b\u0013q\u0001T8hO&tw-\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001_!\ty\u0006-D\u0001\u001a\u0013\t\t\u0017DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007\u0005\u0006\u0002eKB\u0011q$\u0004\u0005\u00069B\u0001\rAX\u0001\u0016[Rd7oQ8oM&<7\u000fV8Pm\u0016\u0014(/\u001b3f\u000391\u0017N\u001c3Ni2K7\u000f^3oKJ$2\u0001S5o\u0011\u0015Q'\u00031\u0001l\u00035a\u0017n\u001d;f]\u0016\u0014h*Y7fgB\u0019A\t\u001c%\n\u00055,%\u0001\u0002'jgRDQa\u001c\nA\u0002A\fq\"\u001a=dYV$W\rT5ti\u0016tWM\u001d\t\u0004GED\u0015B\u0001:%\u0005\u0019y\u0005\u000f^5p]\u0006!R\u000e\u001e7t'\u0006\u001cH\u000eT5ti\u0016tWM\u001d(b[\u0016,\u0012\u0001]\u0001$[Rd\u0015n\u001d;f]\u0016\u0014Hk\\,bi\u000eDgi\u001c:SK\u000e|gNZ5hkJ\fG/[8o)\u0005A\u0015aE7uYN\u001cuN\u001c4jO>3XM\u001d:jI\u0016\u001cX#A=\u0011\t\u0011S\b\n`\u0005\u0003w\u0016\u00131!T1q!\t)T0\u0003\u0002\u007fm\t1qJ\u00196fGR\u0004")
public class MtlsWithServerCertConfigs
implements Logging {
    private final KafkaConfig brokerConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> sslBcApprovedModeConfigsToOverride() {
        return MtlsWithServerCertConfigs$.MODULE$.sslBcApprovedModeConfigsToOverride();
    }

    public static Set<String> sslConfigsToOverride() {
        return MtlsWithServerCertConfigs$.MODULE$.sslConfigsToOverride();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Set<String> mtlsConfigsToOverride() {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig().bcApprovedModeEnabled())) {
            return MtlsWithServerCertConfigs$.MODULE$.sslBcApprovedModeConfigsToOverride();
        }
        return MtlsWithServerCertConfigs$.MODULE$.sslConfigsToOverride();
    }

    private String findMtListener(List<String> listenerNames, Option<String> excludeListener) {
        String firstMtListener = listenerNames.get(0);
        if (excludeListener instanceof Some) {
            String listener = (String)((Some)excludeListener).value();
            return (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listenerNames).asScala()).find((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)MtlsWithServerCertConfigs.$anonfun$findMtListener$1(listener, l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> firstMtListener);
        }
        if (None$.MODULE$.equals(excludeListener)) {
            return firstMtListener;
        }
        throw new MatchError(excludeListener);
    }

    private Option<String> mtlsSaslListenerName() {
        Map<String, Object> configs = this.brokerConfig().originals();
        if (ConfluentConfigs.getMTlsEnable(configs)) {
            return new Some((Object)ConfluentConfigs.getMTlsListenerName(configs).toUpperCase(Locale.ROOT));
        }
        return None$.MODULE$;
    }

    public String mtListenerToWatchForReconfiguration() {
        List multiTenantSslListenerNames = ConfluentConfigs.multitenantSslListenerNames(this.brokerConfig().values(), (ListenerName)this.brokerConfig().interBrokerListenerName());
        if (!multiTenantSslListenerNames.isEmpty()) {
            return this.findMtListener(multiTenantSslListenerNames, this.mtlsSaslListenerName());
        }
        return "EXTERNAL";
    }

    public Map<String, Object> mtlsConfigOverrides() {
        HashMap<String, Object> configOverrides = new HashMap<String, Object>(null){};
        this.collectCertstoreProps$1(this.brokerConfig().originals(), configOverrides);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("configOverrides: ").append(configOverrides.keySet()).toString());
        List multiTenantSslListenerNames = ConfluentConfigs.multitenantSslListenerNames(this.brokerConfig().values(), (ListenerName)this.brokerConfig().interBrokerListenerName());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("multiTenantSslListenerNames: ").append(multiTenantSslListenerNames).toString());
        if (!multiTenantSslListenerNames.isEmpty()) {
            Option<String> mtlsExtendedSaslListenerOpt = this.mtlsSaslListenerName();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("mtlsExtendedSaslListenerOpt: ").append(mtlsExtendedSaslListenerOpt).toString());
            String mtListener = this.findMtListener(multiTenantSslListenerNames, mtlsExtendedSaslListenerOpt);
            String listenerPrefix = new ListenerName(mtListener).configPrefix();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("listenerPrefix: ").append(listenerPrefix).toString());
            Map<String, Object> listenerConfigs = this.brokerConfig().originalsWithPrefix(listenerPrefix, true);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("listenerConfigs: ").append(listenerConfigs.keySet()).toString());
            if (mtlsExtendedSaslListenerOpt.isDefined() && ((String)mtlsExtendedSaslListenerOpt.get()).equalsIgnoreCase(mtListener)) {
                MtlsWithServerCertConfigs$.MODULE$.SslTruststoreConfigs().foreach((Function1 & Serializable & scala.Serializable)config -> listenerConfigs.remove(config));
            }
            this.collectCertstoreProps$1(listenerConfigs, configOverrides);
        }
        return configOverrides;
    }

    public static final /* synthetic */ boolean $anonfun$findMtListener$1(String listener$1, String l) {
        return !l.equalsIgnoreCase(listener$1);
    }

    private final void collectCertstoreProps$1(Map configs, Map configOverrides) {
        this.mtlsConfigsToOverride().forEach(config -> {
            if (configs.containsKey(config)) {
                configOverrides.put(config, configs.get(config));
                return;
            }
        });
    }

    public MtlsWithServerCertConfigs(KafkaConfig brokerConfig) {
        this.brokerConfig = brokerConfig;
        Logging.$init$(this);
    }
}

