/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.MetadataSnapshotUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;

public class TierMetadataSnapshotUploadInitiate
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 72;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotUploadInitiate metadata;

    public TierMetadataSnapshotUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset, int brokerId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotUploadInitiate.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotUploadInitiate.buildMetadataSnapshotInitiate(builder, tierEpoch, objectId, stateOffset, brokerId);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotUploadInitiate.getRootAsMetadataSnapshotUploadInitiate((ByteBuffer)builder.dataBuffer());
    }

    public TierMetadataSnapshotUploadInitiate(TopicIdPartition topicIdPartition, MetadataSnapshotUploadInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    static int buildMetadataSnapshotInitiate(FlatBufferBuilder builder, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset, int brokerId) {
        MetadataSnapshotUploadInitiate.startMetadataSnapshotUploadInitiate((FlatBufferBuilder)builder);
        MetadataSnapshotUploadInitiate.addVersion((FlatBufferBuilder)builder, (byte)1);
        MetadataSnapshotUploadInitiate.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpoch);
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)objectId.getMostSignificantBits(), (long)objectId.getLeastSignificantBits());
        MetadataSnapshotUploadInitiate.addObjectId((FlatBufferBuilder)builder, (int)objectIdOffset);
        int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)stateOffset.offset(), (int)stateOffset.epoch().orElse(-1));
        MetadataSnapshotUploadInitiate.addStateOffsetAndEpoch((FlatBufferBuilder)builder, (int)offsetAndEpochId);
        MetadataSnapshotUploadInitiate.addBrokerId((FlatBufferBuilder)builder, (int)brokerId);
        return MetadataSnapshotUploadInitiate.endMetadataSnapshotUploadInitiate((FlatBufferBuilder)builder);
    }

    public static int initialBufferSize() {
        return 72;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotUploadInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public int brokerId() {
        return this.metadata.brokerId();
    }

    public String toString() {
        return "MetadataSnapshotUploadInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", snapshotId=" + this.messageId() + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", brokerId=" + this.brokerId() + ")";
    }
}

