/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.PartitionDeletePreInitiate;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionDeletePreInitiate
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 48;
    private final TopicIdPartition topicIdPartition;
    private final PartitionDeletePreInitiate metadata;

    public TierPartitionDeletePreInitiate(TopicIdPartition topicIdPartition, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(48).forceDefaults(true);
        PartitionDeletePreInitiate.startPartitionDeletePreInitiate((FlatBufferBuilder)builder);
        PartitionDeletePreInitiate.addVersion((FlatBufferBuilder)builder, (byte)0);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        PartitionDeletePreInitiate.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        int entryId = PartitionDeletePreInitiate.endPartitionDeletePreInitiate((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionDeletePreInitiate.getRootAsPartitionDeletePreInitiate((ByteBuffer)builder.dataBuffer());
    }

    public TierPartitionDeletePreInitiate(TopicIdPartition topicIdPartition, PartitionDeletePreInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 48;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionDeletePreInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    public String toString() {
        return "TierPartitionDeletePreInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ")";
    }
}

