/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.InitLeader;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;

public class TierTopicInitLeader
extends AbstractTierMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 72;
    private final TopicIdPartition topicIdPartition;
    private final InitLeader metadata;

    public TierTopicInitLeader(TopicIdPartition topicIdPartition, int tierEpoch, UUID messageId, int brokerId, Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch) {
        if (tierEpoch < 0) {
            throw new IllegalArgumentException("Illegal tierEpoch: " + tierEpoch);
        }
        this.topicIdPartition = topicIdPartition;
        FlatBufferBuilder builder = new FlatBufferBuilder(TierTopicInitLeader.initialBufferSize()).forceDefaults(true);
        InitLeader.startInitLeader((FlatBufferBuilder)builder);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        InitLeader.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        InitLeader.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpoch);
        InitLeader.addBrokerId((FlatBufferBuilder)builder, (int)brokerId);
        InitLeader.addVersion((FlatBufferBuilder)builder, (byte)1);
        partitionCreationOffsetAndEpoch.ifPresent(raftOffsetAndEpoch -> {
            int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)raftOffsetAndEpoch.offset(), (int)raftOffsetAndEpoch.epoch());
            InitLeader.addPartitionCreationOffsetAndEpoch((FlatBufferBuilder)builder, (int)offsetAndEpochId);
        });
        int entryId = InitLeader.endInitLeader((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.metadata = InitLeader.getRootAsInitLeader((ByteBuffer)builder.dataBuffer());
    }

    public TierTopicInitLeader(TopicIdPartition topicIdPartition, int tierEpoch, UUID messageId, int brokerId) {
        this(topicIdPartition, tierEpoch, messageId, brokerId, Optional.empty());
    }

    public TierTopicInitLeader(TopicIdPartition topicIdPartition, InitLeader metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 72;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.InitLeader;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return kafka.tier.state.OffsetAndEpoch.EMPTY;
    }

    private byte version() {
        return this.metadata.version();
    }

    public int brokerId() {
        return this.metadata.brokerId();
    }

    public Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch() {
        return Optional.ofNullable(this.metadata.partitionCreationOffsetAndEpoch()).map(v -> new org.apache.kafka.raft.OffsetAndEpoch(v.offset(), v.epoch()));
    }

    public String toString() {
        return "TierTopicInitLeader(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", brokerId=" + this.brokerId() + ", partitionCreationOffsetAndEpoch=" + this.partitionCreationOffsetAndEpoch() + ")";
    }
}

