/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;

public final class CompactedSegmentUpload
extends TierSegmentUpload<ByteBuffer> {
    public CompactedSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<ByteBuffer> producerStateSnapshotOpt, Optional<ByteBuffer> txnIdxOpt, Optional<ByteBuffer> epochStateOpt) {
        super(putMode, objectMetadata, segment, offsetIdx, timestampIdx, producerStateSnapshotOpt, txnIdxOpt, epochStateOpt);
    }

    public CompactedSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx) {
        this(putMode, objectMetadata, segment, offsetIdx, timestampIdx, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public CompactedSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, ByteBuffer producerStateSnapshot) {
        this(putMode, objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.empty(), Optional.empty());
    }

    public CompactedSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, ByteBuffer producerStateSnapshot, ByteBuffer txnIdx) {
        this(putMode, objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.empty());
    }

    public CompactedSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, ByteBuffer producerStateSnapshot, ByteBuffer txnIdx, ByteBuffer epochState) {
        this(putMode, objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.ofNullable(epochState));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompactedSegmentUpload that = (CompactedSegmentUpload)obj;
        return Objects.equals(super.objectMetadata(), that.objectMetadata()) && Objects.equals(super.segment(), that.segment()) && Objects.equals(super.offsetIdx(), that.offsetIdx()) && Objects.equals(super.timestampIdx(), that.timestampIdx()) && Objects.equals(super.producerStateSnapshotOpt(), that.producerStateSnapshotOpt()) && Objects.equals(super.txnIdxOpt(), that.txnIdxOpt()) && Objects.equals(super.epochStateOpt(), that.epochStateOpt());
    }

    public int hashCode() {
        return Objects.hash(super.objectMetadata(), super.segment(), super.offsetIdx(), super.timestampIdx(), super.producerStateSnapshotOpt(), super.txnIdxOpt(), super.epochStateOpt());
    }

    public String toString() {
        return "CompactedSegmentUpload[putMode=" + super.putMode() + ", objectMetadata=" + super.objectMetadata() + ", segment=" + super.segment() + ", offsetIdx=" + super.offsetIdx() + ", timestampIdx=" + super.timestampIdx() + ", producerStateSnapshotOpt=" + super.producerStateSnapshotOpt() + ", txnIdxOpt=" + super.txnIdxOpt() + ", epochStateOpt=" + super.epochStateOpt() + ", " + ']';
    }
}

