/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLogger;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\b\u0001\"\u0003x\u0011\u0015I\b\u0001\"\u0003{\u0011\u0015a\b\u0001\"\u0003~\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\u0007=\u0002!I!!\u0005\u0003-Q+7\u000f\u001e*bMR\u0014V-];fgRD\u0015M\u001c3mKJT!\u0001E\t\u0002\u000bQ|w\u000e\\:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001+m\t\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f#\u000511/\u001a:wKJL!\u0001I\u000f\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0005\u0002#K5\t1E\u0003\u0002%#\u0005)Q\u000f^5mg&\u0011ae\t\u0002\b\u0019><w-\u001b8h\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:1\u0005%\n\u0004c\u0001\u0016._5\t1F\u0003\u0002-#\u0005!!/\u00194u\u0013\tq3FA\u0006SC\u001a$X*\u00198bO\u0016\u0014\bC\u0001\u00192\u0019\u0001!\u0011BM\u0001\u0002\u0002\u0003\u0005)\u0011A\u001a\u0003\u0007}#\u0013'\u0005\u00025oA\u0011a#N\u0005\u0003m]\u0011qAT8uQ&tw\r\u0005\u0002\u0017q%\u0011\u0011h\u0006\u0002\u0004\u0003:L\u0018A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0003y}j\u0011!\u0010\u0006\u0003}E\tqA\\3uo>\u00148.\u0003\u0002A{\tq!+Z9vKN$8\t[1o]\u0016d\u0017\u0001\u0002;j[\u0016\u0004\"a\u0011'\u000e\u0003\u0011S!\u0001J#\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002\u0013\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\tiEI\u0001\u0003US6,\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB\u0011A\u0004U\u0005\u0003#v\u0011\u0011#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q)AKV.];B\u0011Q\u000bA\u0007\u0002\u001f!)q%\u0002a\u0001/B\u0012\u0001L\u0017\t\u0004U5J\u0006C\u0001\u0019[\t%\u0011d+!A\u0001\u0002\u000b\u00051\u0007C\u0003;\u000b\u0001\u00071\bC\u0003B\u000b\u0001\u0007!\tC\u0003O\u000b\u0001\u0007q*\u0001\u0004iC:$G.\u001a\u000b\u0005A\u000ed\u0017\u000f\u0005\u0002\u0017C&\u0011!m\u0006\u0002\u0005+:LG\u000fC\u0003e\r\u0001\u0007Q-A\u0004sKF,Xm\u001d;\u0011\u0005\u0019LgB\u0001\u001fh\u0013\tAW(\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005)\\'a\u0002*fcV,7\u000f\u001e\u0006\u0003QvBQ!\u001c\u0004A\u00029\fQB]3rk\u0016\u001cH\u000fT8hO\u0016\u0014\bC\u0001\u000fp\u0013\t\u0001XDA\u0007SKF,Xm\u001d;M_\u001e<WM\u001d\u0005\u0006e\u001a\u0001\ra]\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u00039QL!!^\u000f\u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002#!\fg\u000e\u001a7f\u0003BLg+\u001a:tS>t7\u000f\u0006\u0002aq\")Am\u0002a\u0001K\u0006Q\u0001.\u00198eY\u00164v\u000e^3\u0015\u0005\u0001\\\b\"\u00023\t\u0001\u0004)\u0017A\u00065b]\u0012dWMQ3hS:\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\u0005\u0001t\b\"\u00023\n\u0001\u0004)\u0017\u0001\u00065b]\u0012dW-\u00128e#V|'/^7Fa>\u001c\u0007\u000eF\u0002a\u0003\u0007AQ\u0001\u001a\u0006A\u0002\u0015\f1\u0002[1oI2,g)\u001a;dQR\u0019\u0001-!\u0003\t\u000b\u0011\\\u0001\u0019A3\u0002'!\fg\u000e\u001a7f\r\u0016$8\r[*oCB\u001c\bn\u001c;\u0015\u0007\u0001\fy\u0001C\u0003e\u0019\u0001\u0007Q\rF\u0003a\u0003'\t)\u0002C\u0003e\u001b\u0001\u0007Q\rC\u0004\u0002\u00185\u0001\r!!\u0007\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f!\u001d1\u00121DA\u0010\u0003WI1!!\b\u0018\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#R\u0001\taJ|Go\\2pY&!\u0011\u0011FA\u0012\u0005)\t\u0005/['fgN\fw-\u001a\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G#\u0002\u0011I,\u0017/^3tiNLA!!\u000e\u00020\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLogger requestLogger, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Handling request:").append(request.requestDesc(true)).append(" with context ").append(request.context()).toString());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (ApiKeys.VOTE.equals(apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported api key: ").append(request.header().apiKey()).toString());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    AbstractResponse errorResponse = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class)).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, (AbstractResponse)this.apiVersionManager.apiVersionResponse(0, request.header().apiVersion() < 4), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
    }
}

