/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.FeatureZNode$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.SocketServerConfigs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;
    private final String FeaturesKey;
    private final String TagsKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    private String RackKey() {
        return this.RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    private String FeaturesKey() {
        return this.FeaturesKey;
    }

    private String TagsKey() {
        return this.TagsKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack2, Features<SupportedVersionRange> features, Map<String, String> tags) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HostKey()), (Object)host), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PortKey()), (Object)BoxesRunTime.boxToInteger((int)port)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EndpointsKey()), CollectionConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.connectionString(), Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.JmxPortKey()), (Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TimestampKey()), (Object)Long.toString(Time.SYSTEM.milliseconds())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TagsKey()), CollectionConverters$.MODULE$.mapAsJavaMapConverter(tags).asJava())}));
        rack2.foreach((Function1 & Serializable & scala.Serializable)rack -> {
            if (version >= 3) {
                return jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackKey()), rack));
            }
            return BoxedUnit.UNIT;
        });
        if (version >= 4) {
            jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerSecurityProtocolMapKey()), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)advertisedEndpoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName().value()), (Object)endPoint.securityProtocol().name), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()));
        }
        if (version >= 5) {
            jsonMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey()), (Object)features.toMap()));
        }
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = (EndPoint)broker.endPoints().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new EndPoint(null, -1, null, null));
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack(), broker.features(), (Map<String, String>)broker.tags());
    }

    private java.util.Map<String, java.util.Map<String, Short>> featuresAsJavaMap(JsonObject brokerInfo) {
        return FeatureZNode$.MODULE$.asJavaMap((Map<String, Map<String, Object>>)((Map)brokerInfo.get(this.FeaturesKey()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$.MODULE$.decodeMap(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, scala.collection.Map$.MODULE$.canBuildFrom()), scala.collection.Map$.MODULE$.canBuildFrom())))).map((Function1 & Serializable & scala.Serializable)theMap -> ((TraversableOnce)theMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionsInfo = (Map)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)((TraversableOnce)versionsInfo.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        int version = x0$2._2$mcI$sp();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)BoxesRunTime.boxToShort((short)((short)version)));
                    }
                    throw new MatchError(null);
                }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$))));
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            .colon.colon colon2;
            JsonObject brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            int jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                colon2 = new .colon.colon((Object)endPoint, (List)Nil$.MODULE$);
            } else {
                HashMap hashMap;
                Option<JsonValue> option = brokerInfo.get(this.ListenerSecurityProtocolMapKey());
                if (None$.MODULE$.equals(option)) {
                    hashMap = SocketServerConfigs.DEFAULT_NAME_TO_SECURITY_PROTO;
                } else if (option instanceof Some) {
                    JsonValue m = (JsonValue)((Some)option).value();
                    HashMap result = new HashMap();
                    ((IterableLike)m.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, scala.collection.Map$.MODULE$.canBuildFrom()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            String k = (String)x0$1._1();
                            String v = (String)x0$1._2();
                            return result.put(new ListenerName(k), SecurityProtocol.forName((String)v));
                        }
                        throw new MatchError(null);
                    });
                    hashMap = result;
                } else {
                    throw new MatchError(option);
                }
                HashMap securityProtocolMap = hashMap;
                String listenersString = ((TraversableOnce)brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).mkString(",");
                colon2 = (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(SocketServerConfigs.listenerListToEndPoints((String)listenersString, (java.util.Map)securityProtocolMap)).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> EndPoint$.MODULE$.fromJava((Endpoint)x$4), Buffer$.MODULE$.canBuildFrom());
            }
            .colon.colon endpoints = colon2;
            Option rack = brokerInfo.get(this.RackKey()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$)));
            java.util.Map<String, java.util.Map<String, Short>> features = this.featuresAsJavaMap(brokerInfo);
            scala.collection.immutable.Map tags = (scala.collection.immutable.Map)brokerInfo.get(this.TagsKey()).map((Function1 & Serializable & scala.Serializable)x$6 -> (scala.collection.immutable.Map)x$6.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, scala.collection.immutable.Map$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.collection.immutable.Map$.MODULE$.empty());
            return new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack, (Features<SupportedVersionRange>)Features.fromSupportedFeaturesMap(features), (scala.collection.immutable.Map<String, String>)tags), version, jmxPort);
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
            throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
        this.FeaturesKey = "features";
        this.TagsKey = "tags";
    }
}

