/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ClusterLinkZNode$;
import kafka.zk.ClusterLinksZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.migration.ClusterLinkMetadata;
import org.apache.kafka.metadata.migration.ClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0006\r\u0001MA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)A\b\u0001C\u0001{!)!\t\u0001C!\u0007\")1\u000b\u0001C!)\")q\f\u0001C\u0005A\")1\u000e\u0001C!Y\")a\u000f\u0001C\u0005o\"1a\u000f\u0001C\u0005\u0003/Aq!a\u000b\u0001\t\u0003\niC\u0001\u000f[W\u000ecWo\u001d;fe2Kgn['jOJ\fG/[8o\u00072LWM\u001c;\u000b\u00055q\u0011!C7jOJ\fG/[8o\u0015\ty\u0001#\u0001\u0002{W*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001!B\u0004\u000b\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tA\u0001\\1oO*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0017\u0005\u0019y%M[3diB\u0011QDJ\u0007\u0002=)\u0011Qb\b\u0006\u0003A\u0005\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003#\tR!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO&\u0011qE\b\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u0003S1j\u0011A\u000b\u0006\u0003WA\tQ!\u001e;jYNL!!\f\u0016\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u00021c5\ta\"\u0003\u00023\u001d\ti1*\u00194lCj[7\t\\5f]R\f1\u0002\\5oW\u0016s7m\u001c3feB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y&t7N\u0003\u0002:!\u000511/\u001a:wKJL!a\u000f\u001c\u00031\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u00128d_\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0004}\u0001\u000b\u0005CA \u0001\u001b\u0005a\u0001\"\u0002\u0018\u0004\u0001\u0004y\u0003\"B\u001a\u0004\u0001\u0004!\u0014aE5uKJ\fG/Z\"mkN$XM\u001d'j].\u001cHC\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0011)f.\u001b;\t\u000b-#\u0001\u0019\u0001'\u0002\u000fYL7/\u001b;peB\u0011Q\n\u0015\b\u0003;9K!a\u0014\u0010\u00025\rcWo\u001d;fe2Kgn['jOJ\fG/[8o\u00072LWM\u001c;\n\u0005E\u0013&AE\"mkN$XM\u001d'j].4\u0016n]5u_JT!a\u0014\u0010\u0002#\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eF\u0002V1v\u0003\"!\b,\n\u0005]s\"A\u0007.l\u001b&<'/\u0019;j_:dU-\u00193feND\u0017\u000e]*uCR,\u0007\"B-\u0006\u0001\u0004Q\u0016aE2mkN$XM\u001d'j].lU\r^1eCR\f\u0007CA\u000f\\\u0013\tafDA\nDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\rC\u0003_\u000b\u0001\u0007Q+\u0001\rnS\u001e\u0014\u0018\r^5p]2+\u0017\rZ3sg\"L\u0007o\u0015;bi\u0016\fA\u0003\u001e:z\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\G\u0003B1eK\u001a\u00042!\u00122V\u0013\t\u0019gI\u0001\u0004PaRLwN\u001c\u0005\u00063\u001a\u0001\rA\u0017\u0005\u0006=\u001a\u0001\r!\u0016\u0005\u0006O\u001a\u0001\r\u0001[\u0001\u0013GJ,\u0017\r^3U_BdUM^3m!\u0006$\b\u000e\u0005\u0002FS&\u0011!N\u0012\u0002\b\u0005>|G.Z1o\u0003E!W\r\\3uK\u000ecWo\u001d;fe2Kgn\u001b\u000b\u0004+6,\b\"\u00028\b\u0001\u0004y\u0017A\u00027j].LE\r\u0005\u0002qg6\t\u0011O\u0003\u0002sC\u000511m\\7n_:L!\u0001^9\u0003\tU+\u0018\u000e\u001a\u0005\u0006=\u001e\u0001\r!V\u0001\u0012e\u0016\u001cWO]:jm\u0016\u001c\u0005.\u001b7ee\u0016tGc\u0001=\u0002\u0014A\u0019\u0011\u0010 @\u000e\u0003iT!a\u001f$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002~u\n\u00191+Z9\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\r6\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0011\u0012A\u0002\u001fs_>$h(C\u0002\u0002\f\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\r\"1\u0011Q\u0003\u0005A\u0002y\fA\u0001]1uQR)A)!\u0007\u0002\u001c!1\u0011QC\u0005A\u0002yDq!!\b\n\u0001\u0004\ty\"A\u0002bG\u000e\u0004R!!\t\u0002(yl!!a\t\u000b\u0007\u0005\u0015\"0A\u0004nkR\f'\r\\3\n\t\u0005%\u00121\u0005\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\u0012de\u0016\fG/Z\"mkN$XM\u001d'j].\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8\u0015\u0007\u0011\u000by\u0003C\u0003o\u0015\u0001\u0007q\u000e")
public class ZkClusterLinkMigrationClient
implements ClusterLinkMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final ClusterLinkConfigEncoder linkEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateClusterLinks(ClusterLinkMigrationClient.ClusterLinkVisitor visitor) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            ZkClusterLinkMigrationClient.$anonfun$iterateClusterLinks$1(this, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createClusterLink(ClusterLinkMetadata clusterLinkMetadata, ZkMigrationLeadershipState migrationLeadershipState) {
        Option<ZkMigrationLeadershipState> option = this.tryCreateClusterLink(clusterLinkMetadata, migrationLeadershipState, false);
        if (option instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            Option<ZkMigrationLeadershipState> option2 = this.tryCreateClusterLink(clusterLinkMetadata, migrationLeadershipState, true);
            if (option2 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option2).value();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new MigrationClientException(new StringBuilder(31).append("Failed to create cluster link ").append(clusterLinkMetadata.linkName()).append(".").toString());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private Option<ZkMigrationLeadershipState> tryCreateClusterLink(ClusterLinkMetadata clusterLinkMetadata, ZkMigrationLeadershipState migrationLeadershipState, boolean createTopLevelPath) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkClusterLinkMigrationClient.$anonfun$tryCreateClusterLink$1(this, createTopLevelPath, clusterLinkMetadata, migrationLeadershipState);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteClusterLink(Uuid linkId, ZkMigrationLeadershipState migrationLeadershipState) {
        void var7_7;
        String path = ClusterLinkZNode$.MODULE$.path(CoreUtils$.MODULE$.toJavaUUID(linkId));
        Seq deleteRequests = (Seq)((TraversableLike)this.recursiveChildren(path).map((Function1 & Serializable & scala.Serializable)child -> new DeleteRequest((String)child, ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, migrationLeadershipState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Map resultCodes = ((TraversableOnce)var7_7.map((Function1 & Serializable & scala.Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return migrationLeadershipState.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(50).append("Failed to delete link ").append(linkId).append(". ZK operations had results ").append(resultCodes).toString());
    }

    private Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, GetChildrenRequest$.MODULE$.apply$default$3()), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            ZkClusterLinkMigrationClient.$anonfun$recursiveChildren$1(this, path, acc, child);
            return BoxedUnit.UNIT;
        });
    }

    public void createClusterLinkChangeNotification(Uuid linkId) {
        this.zkClient.createConfigChangeNotification(new StringBuilder(13).append("cluster-links").append('/').append(CoreUtils$.MODULE$.toJavaUUID(linkId).toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$iterateClusterLinks$6(scala.collection.mutable.Map linkConfigs$1, ClusterLinkMigrationClient.ClusterLinkVisitor visitor$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            Uuid linkId = (Uuid)x0$2._1();
            ClusterLinkData cld = (ClusterLinkData)x0$2._2();
            Properties linkConfig = (Properties)linkConfigs$1.apply((Object)linkId);
            ClusterLinkMetadata linkMetadata = new ClusterLinkMetadata(cld.linkName(), cld.linkId(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(cld.clusterId())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(cld.tenantPrefix())), Optional.ofNullable(linkConfig.getProperty("cluster.link.prefix")), linkConfig);
            visitor$1.visitClusterLink(linkMetadata, cld.isDeleted());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateClusterLinks$1(ZkClusterLinkMigrationClient $this, ClusterLinkMigrationClient.ClusterLinkVisitor visitor$1) {
        Map clusterLinks = ((TraversableOnce)$this.zkClient.getAllClusterLinks().map((Function1 & Serializable & scala.Serializable)cld -> new Tuple2((Object)cld.linkId(), cld), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map linkConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        $this.zkClient.getEntitiesConfigs("cluster-links", (Set<String>)$this.zkClient.getAllEntitiesWithConfig("cluster-links").toSet()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String linkJavaUuidStr = (String)x0$1._1();
                Properties props = (Properties)x0$1._2();
                Uuid linkId = CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString(linkJavaUuidStr);
                if (clusterLinks.contains((Object)linkId)) {
                    return linkConfigs.put((Object)linkId, (Object)$this.linkEncoder.decode(props));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(null);
        });
        Set linksWithoutConfig = (Set)clusterLinks.keys().toSet().diff((GenSet)linkConfigs.keys().toSet());
        if (linksWithoutConfig.nonEmpty()) {
            throw new MigrationClientException(new StringBuilder(49).append("Unable to find cluster link properties for links ").append(((TraversableLike)clusterLinks.filter((Function1 & Serializable & scala.Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)linksWithoutConfig.contains(keyVal._1())))).map((Function1 & Serializable & scala.Serializable)x$1 -> ((ClusterLinkData)x$1._2()).linkName(), Iterable$.MODULE$.canBuildFrom())).toString());
        }
        clusterLinks.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ZkClusterLinkMigrationClient.$anonfun$iterateClusterLinks$6(linkConfigs, visitor$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$tryCreateClusterLink$4(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((KeeperException.Code)x0$1._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryCreateClusterLink$1(ZkClusterLinkMigrationClient $this, boolean createTopLevelPath$1, ClusterLinkMetadata clusterLinkMetadata$1, ZkMigrationLeadershipState migrationLeadershipState$1) {
        void var12_12;
        ClusterLinkData data;
        String path;
        CreateRequest createClusterLinkZNode;
        Tuple2<Object, Seq<AsyncResponse>> tuple2;
        if (createTopLevelPath$1) {
            String x$1 = ClusterLinksZNode$.MODULE$.path();
            boolean x$2 = false;
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(x$1, x$3, x$2);
        }
        if ((tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)(createClusterLinkZNode = new CreateRequest(path = ClusterLinkZNode$.MODULE$.path(CoreUtils$.MODULE$.toJavaUUID(clusterLinkMetadata$1.linkId())), ClusterLinkZNode$.MODULE$.encode(data = new ClusterLinkData(clusterLinkMetadata$1.linkName(), clusterLinkMetadata$1.linkId(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata$1.clusterId())), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata$1.tenantPrefix())), false)), $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5())), (List)Nil$.MODULE$), migrationLeadershipState$1)) == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Map resultCodes = ((TraversableOnce)var12_12.map((Function1 & Serializable & scala.Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (!createTopLevelPath$1 && ((Enum)resultCodes.apply((Object)path)).equals(KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((Enum)resultCodes.apply((Object)path)).equals(KeeperException.Code.NODEEXISTS)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Cluster link ").append(clusterLinkMetadata$1.linkName()).append("already exists in Zookeeper. Skipping ").append("the create request.").toString());
            return new Some((Object)migrationLeadershipState$1);
        }
        if (resultCodes.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkClusterLinkMigrationClient.$anonfun$tryCreateClusterLink$4(x0$1)))) {
            void var11_11;
            return new Some((Object)migrationLeadershipState$1.withMigrationZkVersion((int)var11_11));
        }
        throw KeeperException.create((KeeperException.Code)((CreateResponse)var12_12.head()).resultCode(), (String)path);
    }

    public static final /* synthetic */ void $anonfun$recursiveChildren$1(ZkClusterLinkMigrationClient $this, String path$1, ArrayBuffer acc$1, String child) {
        $this.recursiveChildren(new StringBuilder(1).append(path$1).append("/").append(child).toString(), (ArrayBuffer<String>)acc$1);
        acc$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append(path$1).append("/").append(child).toString()}));
    }

    public ZkClusterLinkMigrationClient(KafkaZkClient zkClient, ClusterLinkConfigEncoder linkEncoder) {
        this.zkClient = zkClient;
        this.linkEncoder = linkEncoder;
        Logging.$init$(this);
    }
}

