/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.DynamicConfig$User$;
import kafka.server.ZkAdminManager$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zk.migration.ZkConfigMigrationClient$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\f\u0019\u0001}A\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0004W\u0001\t\u0007I\u0011A,\t\rm\u0003\u0001\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u00159\b\u0001\"\u0003y\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!<\u0001\t\u0003\nyoB\u0004\u0002\u0000bA\tA!\u0001\u0007\r]A\u0002\u0012\u0001B\u0002\u0011\u0019yE\u0003\"\u0001\u0003\f!9!Q\u0002\u000b\u0005\u0002\t=!a\u0006.l\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0015\tI\"$A\u0005nS\u001e\u0014\u0018\r^5p]*\u00111\u0004H\u0001\u0003u.T\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0005\u000b\u001b\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!\u000b\u001a\u000e\u0003)R!!G\u0016\u000b\u00051j\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005uq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003+\r{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007H\u0001\u0006kRLGn]\u0005\u0003sY\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\taT(D\u0001\u001b\u0013\tq$DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0010a\u0006\u001c8o^8sI\u0016s7m\u001c3feB\u0011\u0011\tR\u0007\u0002\u0005*\u00111)L\u0001\tg\u0016\u001cWO]5us&\u0011QI\u0011\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006Q\"p[\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0016s7m\u001c3feB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0005Y&t7N\u0003\u0002M9\u000511/\u001a:wKJL!AT%\u00031\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u00128d_\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0005#N#V\u000b\u0005\u0002S\u00015\t\u0001\u0004C\u0003;\t\u0001\u00071\bC\u0003@\t\u0001\u0007\u0001\tC\u0003G\t\u0001\u0007q)A\u0007bI6LgNW6DY&,g\u000e^\u000b\u00021B\u0011A(W\u0005\u00035j\u0011Q\"\u00113nS:T6n\u00117jK:$\u0018AD1e[&t'l[\"mS\u0016tG\u000fI\u0001\u0017MJ|WNW6D_:4\u0017nZ#oi&$\u0018PT1nKR\u0019al[7\u0011\u0005}CgB\u00011g!\t\tG-D\u0001c\u0015\t\u0019g$\u0001\u0004=e>|GO\u0010\u0006\u0002K\u0006)1oY1mC&\u0011q\rZ\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hI\")An\u0002a\u0001=\u0006QQM\u001c;jift\u0015-\\3\t\u000b9<\u0001\u0019A8\u00025\r|gNZ5h)f\u0004X-S:DYV\u001cH/\u001a:MS:\\\u0017N\\4\u0011\u0005A\fX\"\u00013\n\u0005I$'a\u0002\"p_2,\u0017M\\\u0001\u0015i>T6nQ8oM&<WI\u001c;jift\u0015-\\3\u0015\u0007y+h\u000fC\u0003m\u0011\u0001\u0007a\fC\u0003o\u0011\u0001\u0007q.\u0001\u000eck&dGm\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\t\u0006$\u0018\rF\u0003z\u00037\ty\u0002E\u0002{\u0003+q1a_A\b\u001d\ra\u00181\u0002\b\u0004{\u0006\u001dab\u0001@\u0002\u00069\u0019q0a\u0001\u000f\u0007\u0005\f\t!C\u00012\u0013\ty\u0003'\u0003\u0002\u001e]%\u0019\u0011\u0011B\u0017\u0002\r\r|W.\\8o\u0013\ra\u0013Q\u0002\u0006\u0004\u0003\u0013i\u0013\u0002BA\t\u0003'\t\u0011c\u00117jK:$\u0018+^8uCJ+7m\u001c:e\u0015\ra\u0013QB\u0005\u0005\u0003/\tIB\u0001\u0006F]RLG/\u001f#bi\u0006TA!!\u0005\u0002\u0014!1\u0011QD\u0005A\u0002y\u000b!\"\u001a8uSRLH+\u001f9f\u0011\u0019\t\t#\u0003a\u0001=\u0006I!P\\8eK:\u000bW.Z\u0001\u0014SR,'/\u0019;f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u0003O\ti\u0003E\u0002q\u0003SI1!a\u000be\u0005\u0011)f.\u001b;\t\u000f\u0005=\"\u00021\u0001\u00022\u00059a/[:ji>\u0014\b\u0003BA\u001a\u0003\u0003rA!!\u000e\u0002>9!\u0011qGA\u001e\u001d\ri\u0018\u0011H\u0005\u0003Y5J!!G\u0016\n\u0007\u0005}\"&A\u000bD_:4\u0017nZ'jOJ\fG/[8o\u00072LWM\u001c;\n\t\u0005\r\u0013Q\t\u0002\u0013\u00072LWM\u001c;Rk>$\u0018MV5tSR|'OC\u0002\u0002@)\nA#\u001b;fe\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cH\u0003BA\u0014\u0003\u0017Bq!!\u0014\f\u0001\u0004\ty%\u0001\bd_:4\u0017nZ\"p]N,X.\u001a:\u0011\t\u0005M\u0012\u0011K\u0005\u0005\u0003'\n)EA\nCe>\\WM]\"p]\u001aLwMV5tSR|'/A\nji\u0016\u0014\u0018\r^3U_BL7mQ8oM&<7\u000f\u0006\u0003\u0002(\u0005e\u0003bBA'\u0019\u0001\u0007\u00111\f\t\b\u0003;\n9GXA6\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0005\u0015D%\u0001\u0003vi&d\u0017\u0002BA5\u0003?\u0012!BQ5D_:\u001cX/\\3s!\u0019\ti'a\u001c_=6\u0011\u00111M\u0005\u0005\u0003c\n\u0019GA\u0002NCB\f\u0001C]3bIR{\u0007/[2D_:4\u0017nZ:\u0015\r\u0005\u001d\u0012qOA>\u0011\u0019\tI(\u0004a\u0001=\u0006IAo\u001c9jG:\u000bW.\u001a\u0005\b\u0003\u001bj\u0001\u0019AA?!\u0019\ti&a \u0002l%!\u0011\u0011QA0\u0005!\u0019uN\\:v[\u0016\u0014\u0018\u0001D<sSR,7i\u001c8gS\u001e\u001cHCCAD\u0003\u001b\u000bi*!)\u0002&B\u0019\u0011&!#\n\u0007\u0005-%F\u0001\u000e[W6KwM]1uS>tG*Z1eKJ\u001c\b.\u001b9Ti\u0006$X\rC\u0004\u0002\u0010:\u0001\r!!%\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKB!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u00065\u0011AB2p]\u001aLw-\u0003\u0003\u0002\u001c\u0006U%AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\b\u0003?s\u0001\u0019AA6\u0003%\u0019wN\u001c4jO6\u000b\u0007\u000fC\u0004\u0002$:\u0001\r!a\"\u0002\u000bM$\u0018\r^3\t\r\u0005\u001df\u00021\u0001p\u0003a\u0019'/Z1uK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\\u0001\u000eI\u0016dW\r^3D_:4\u0017nZ:\u0015\r\u0005\u001d\u0015QVAX\u0011\u001d\tyi\u0004a\u0001\u0003#Cq!a)\u0010\u0001\u0004\t9)A\txe&$Xm\u00117jK:$\u0018+^8uCN$\"\"a\"\u00026\u0006e\u0016QYAe\u0011\u001d\t9\f\u0005a\u0001\u0003W\na!\u001a8uSRL\bbBA^!\u0001\u0007\u0011QX\u0001\u0007cV|G/Y:\u0011\u000f\u00055\u0014q\u000e0\u0002@B\u0019\u0011%!1\n\u0007\u0005\r'E\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u000f\u0004\u0002\u0019AA6\u0003\u0015\u00198M]1n\u0011\u001d\t\u0019\u000b\u0005a\u0001\u0003\u000f\u000bA\u0003\u001e:z/JLG/Z#oi&$\u0018pQ8oM&<GCDAh\u0003+\f9.a7\u0002f\u0006%\u00181\u001e\t\u0006a\u0006E\u0017qQ\u0005\u0004\u0003'$'AB(qi&|g\u000e\u0003\u0004\u0002\u001eE\u0001\rA\u0018\u0005\u0007\u00033\f\u0002\u0019\u00010\u0002\tA\fG\u000f\u001b\u0005\b\u0003;\f\u0002\u0019AAp\u0003\u0015\u0001(o\u001c9t!\u0011\ti'!9\n\t\u0005\r\u00181\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBBAt#\u0001\u0007q.\u0001\u0004de\u0016\fG/\u001a\u0005\b\u0003G\u000b\u0002\u0019AAD\u0011\u0019\t9+\u0005a\u0001_\u0006)\"/Z1e\u00072,8\u000f^3s\u0019&t7nQ8oM&<GCBA\u0014\u0003c\fi\u0010C\u0004\u0002tJ\u0001\r!!>\u0002\r1Lgn[%e!\u0011\t90!?\u000e\u0005\u00055\u0011\u0002BA~\u0003\u001b\u0011A!V;jI\"9\u0011Q\n\nA\u0002\u0005u\u0014a\u0006.l\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u!\t\u0011FcE\u0002\u0015\u0005\u000b\u00012\u0001\u001dB\u0004\u0013\r\u0011I\u0001\u001a\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0011\u0001I4fiN\u000bg.\u001b;ju\u0016$7\t\\5f]R\fVo\u001c;b5:{G-\u001a(b[\u0016$bA!\u0005\u0003\u0014\tU\u0001\u0003\u00029\u0002RzCq!a.\u0017\u0001\u0004\tY\u0007\u0003\u0004\u0003\u0018Y\u0001\rAX\u0001\nG>l\u0007o\u001c8f]R\u0004")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final ClusterLinkConfigEncoder zkClusterLinkConfigEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> getSanitizedClientQuotaZNodeName(java.util.Map<String, String> map, String string) {
        return ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(map, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkConfigEntityName(String entityName, boolean configTypeIsClusterLinking) {
        if (entityName.equals("<default>")) {
            return "";
        }
        if (configTypeIsClusterLinking) {
            return CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString(entityName).toString();
        }
        return entityName;
    }

    private String toZkConfigEntityName(String entityName, boolean configTypeIsClusterLinking) {
        if (entityName.isEmpty()) {
            return "<default>";
        }
        if (configTypeIsClusterLinking) {
            return CoreUtils$.MODULE$.toJavaUUIDStringFromKafkaUuidString(entityName);
        }
        return entityName;
    }

    private ClientQuotaRecord.EntityData buildClientQuotaEntityData(String entityType, String znodeName) {
        ClientQuotaRecord.EntityData result = new ClientQuotaRecord.EntityData().setEntityType(entityType);
        if (znodeName.equals("<default>")) {
            result.setEntityName(null);
        } else {
            result.setEntityName(Sanitizer.desanitize((String)znodeName));
        }
        return result;
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1("users", "user", visitor);
        this.migrateEntityType$1("clients", "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs("users", "clients").foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1("ips", "ip", visitor);
        this.migrateEntityType$1("confluent-tenants", "confluent-tenant", visitor);
    }

    public void iterateBrokerConfigs(ConfigMigrationClient.BrokerConfigVisitor configConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig("brokers");
        this.zkClient.getEntitiesConfigs("brokers", (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateBrokerConfigs$1(this, configConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig("topics").foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.readTopicConfigs((String)topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkConfigEntityName(topicName, false);
        Properties props = this.zkClient.getEntityConfigs("topics", topicResource);
        java.util.Map decodedProps = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        String string = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            configConsumer.accept(decodedProps);
            return;
        }
        catch (Throwable logAndRethrow_e) {
            void logAndRethrow_msg;
            this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state, boolean createChangeNotification) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state, createChangeNotification);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        ZkMigrationLeadershipState zkMigrationLeadershipState;
        Object object = new Object();
        try {
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                    throw throwable;
                }
                if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
        return zkMigrationLeadershipState;
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state, boolean createChangeNotification) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state, createChangeNotification);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readClusterLinkConfig(Uuid linkId, Consumer<java.util.Map<String, String>> configConsumer) {
        String linkResource = this.toZkConfigEntityName(linkId.toString(), true);
        Properties props = this.zkClient.getEntityConfigs("cluster-links", linkResource);
        HashMap decodedPropsMap = new HashMap();
        this.zkClusterLinkConfigEncoder.decode(props).entrySet().forEach(entry -> decodedPropsMap.put(entry.getKey().toString(), entry.getValue().toString()));
        String string = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(linkResource).append(".").toString();
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            configConsumer.accept(decodedPropsMap);
            return;
        }
        catch (Throwable logAndRethrow_e) {
            void logAndRethrow_msg;
            this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String znodeName = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)$this.buildClientQuotaEntityData(entityType$1, znodeName), (List)Nil$.MODULE$)).asJava();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1))))).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String string = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    if (ZkMigrationClient$.MODULE$ == null) {
                        throw null;
                    }
                    try {
                        visitor$1.visitScramCredential(Sanitizer.desanitize((String)znodeName), mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        void logAndRethrow_msg;
                        $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    double value = x0$2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            if (!quotaMap.isEmpty()) {
                String string = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                if (ZkMigrationClient$.MODULE$ == null) {
                    throw null;
                }
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                    return;
                }
                catch (Throwable logAndRethrow_e) {
                    void logAndRethrow_msg;
                    $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block6: {
            String[] components;
            Properties props;
            block8: {
                String znodePath;
                block7: {
                    if (x0$1 == null) break block6;
                    znodePath = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = znodePath.split("/");
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).size() != 3) break block7;
                    String string = components[1];
                    String string2 = "clients";
                    if (string != null && string.equals(string2)) break block8;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(znodePath).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildClientQuotaEntityData("user", components[0]), (List)new .colon.colon((Object)$this.buildClientQuotaEntityData("client-id", components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Double d;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                    Double doubleValue = d;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom())).asJava();
            String string = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                visitor$1.visitClientQuota((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, ConfigMigrationClient.BrokerConfigVisitor configConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkConfigEntityName(broker, false);
            HashMap plainProps = new HashMap();
            HashMap encryptedProps = new HashMap();
            ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    void var6_7;
                    boolean bl;
                    String string;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        string = $this.passwordEncoder.decode(value).value();
                        bl = true;
                    } else {
                        string = value;
                        bl = false;
                    }
                    boolean bl2 = bl;
                    String newValue = string;
                    if (bl2) {
                        return (String)encryptedProps.put(key, var6_7);
                    }
                    return (String)plainProps.put(key, var6_7);
                }
                throw new MatchError(null);
            });
            String string = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            if (ZkMigrationClient$.MODULE$ == null) {
                throw null;
            }
            try {
                configConsumer$1.visitBrokerConfig(brokerResource, (java.util.Map)plainProps, (java.util.Map)encryptedProps);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                void logAndRethrow_msg;
                $this.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1((String)logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopicConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$2, String topic) {
        $this.readTopicConfigs(topic, props -> configConsumer.accept((String)topic, (java.util.Map<String, String>)props));
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1, boolean createChangeNotification$1) {
        ConfigResource.Type type = configResource$1.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)"cluster-links") : None$.MODULE$));
        String configName = $this.toZkConfigEntityName(configResource$1.name(), configType.contains((Object)"cluster-links"));
        if (configType.isDefined()) {
            Properties properties;
            if (configType.contains((Object)"cluster-links")) {
                Properties newProps = new Properties();
                configMap$1.forEach((x0$1, x1$1) -> {
                    String key = x0$1;
                    String value = x1$1;
                    newProps.put(key, value);
                });
                properties = $this.zkClusterLinkConfigEncoder.encode(newProps);
            } else {
                Properties newProps = new Properties();
                configMap$1.forEach((x0$2, x1$2) -> {
                    String key = x0$2;
                    String value = x1$2;
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        newProps.put(key, $this.passwordEncoder.encode(new Password(value)));
                        return;
                    }
                    newProps.put(key, value);
                });
                properties = newProps;
            }
            Properties props = properties;
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state$1, createChangeNotification$1);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                boolean x$2 = false;
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, x$2);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state$1, createChangeNotification$1);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)"cluster-links") : None$.MODULE$));
        String configName = $this.toZkConfigEntityName(configResource$2.name(), configType.contains((Object)"cluster-links"));
        if (configType.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)configType.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), DeleteRequest$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(configType.get()).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    public static final /* synthetic */ void $anonfun$writeClientQuotas$3(java.util.Map configKeys$1, Properties props$2, String x0$1, Double x1$1) {
        String key = x0$1;
        Double value = x1$1;
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys$1.get(key);
        if (configKey == null) {
            throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append(key).toString());
        }
        ConfigDef.Type type = configKey.type;
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            props$2.setProperty(key, value.toString());
            return;
        }
        if (ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type)) {
            long intValue;
            double epsilon = 1.0E-6;
            ConfigDef.Type type2 = configKey.type;
            ConfigDef.Type type3 = ConfigDef.Type.LONG;
            long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(value) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(value) + epsilon)));
            if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(value))) > epsilon) {
                throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append(key).append(" must be a ").append(configKey.type).append(" value").toString());
            }
            props$2.setProperty(key, Long.toString(intValue));
            return;
        }
        throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        void var13_15;
        void var12_14;
        void var11_13;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Some some;
        Some some2;
        Some user = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "user");
        Option<String> client = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "client-id");
        Some ip = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "ip");
        Some tenant = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "confluent-tenant");
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some2 = new Some((Object)"users");
            some = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some2 = new Some((Object)"users");
            some = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some2 = new Some((Object)"clients");
            some = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some2 = new Some((Object)"ips");
            some = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else if (tenant.isDefined()) {
            some2 = new Some((Object)"confluent-tenants");
            some = tenant;
            map = DynamicConfig$Tenant$.MODULE$.configKeys();
        } else {
            some2 = None$.MODULE$;
            some = None$.MODULE$;
            map = CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Some some3 = some;
        Option configType = (Option)some2;
        Option path = (Option)some3;
        java.util.Map<String, ConfigDef.ConfigKey> configKeys = map2;
        void configType2 = var11_13;
        void path2 = var12_14;
        void configKeys2 = var13_15;
        if (path2.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((arg_0, arg_1) -> ZkConfigMigrationClient.$anonfun$writeClientQuotas$3((java.util.Map)configKeys2, props, arg_0, arg_1));
        scram$1.forEach((x0$2, x1$2) -> {
            String key = x0$2;
            String value = x1$2;
            props.put(key, value);
        });
        Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, false, state$3, true);
        if (option instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)configType2.get());
            boolean x$2 = false;
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, x$2);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType2.get(), (String)path2.get(), props, true, state$3, true);
            if (option2 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option2).value();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$3, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4, boolean createChangeNotification$2) {
        void var11_11;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$3);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), SetDataRequest$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var11_11.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var11_11.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var10_10;
            if (createChangeNotification$2) {
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            }
            return new Some((Object)state$4.withMigrationZkVersion((int)var10_10));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var11_11.head()).resultCode(), (String)path$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder, ClusterLinkConfigEncoder zkClusterLinkConfigEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        this.zkClusterLinkConfigEncoder = zkClusterLinkConfigEncoder;
        Logging.$init$(this);
        this.adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
    }
}

