/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.MultiRequest;
import kafka.zookeeper.MultiResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZkOp;
import kafka.zookeeper.ZkOpResult;
import kafka.zookeeper.ZooKeeperClient$;
import kafka.zookeeper.ZooKeeperClient$ZooKeeperClientWatcher$;
import kafka.zookeeper.ZooKeeperClientAuthFailedException;
import kafka.zookeeper.ZooKeeperClientExpiredException;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=t!B$I\u0011\u0003ie!B(I\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003A\u0006bB-\u0002\u0005\u0004%\tA\u0017\u0005\u0007=\u0006\u0001\u000b\u0011B.\u0007\t=C\u0005a\u0018\u0005\tM\u0016\u0011\t\u0011)A\u0005O\"A!/\u0002B\u0001B\u0003%1\f\u0003\u0005t\u000b\t\u0005\t\u0015!\u0003\\\u0011!!XA!A!\u0002\u0013Y\u0006\u0002C;\u0006\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0013\u0005\u0015QA!A!\u0002\u00139\u0007\"CA\u0004\u000b\t\u0005\t\u0015!\u0003h\u0011-\tI!\u0002BC\u0002\u0013\u0005\u0001*a\u0003\t\u0015\u0005mQA!A!\u0002\u0013\ti\u0001C\u0005\u0002\u001e\u0015\u0011\t\u0011)A\u0005O\"1q+\u0002C\u0001\u0003?A\u0011\"!\u000e\u0006\u0005\u0004%I!a\u000e\t\u0011\u0005%S\u0001)A\u0005\u0003sA\u0011\"a\u0013\u0006\u0005\u0004%I!!\u0014\t\u0011\u0005\u001dT\u0001)A\u0005\u0003\u001fB\u0011\"!\u001b\u0006\u0005\u0004%I!a\u001b\t\u0011\u0005MT\u0001)A\u0005\u0003[B\u0011\"!\u001e\u0006\u0005\u0004%I!a\u001e\t\u0011\u0005}T\u0001)A\u0005\u0003sB\u0011\"!!\u0006\u0005\u0004%I!a!\t\u0011\u0005eU\u0001)A\u0005\u0003\u000bC\u0011\"a'\u0006\u0005\u0004%I!!(\t\u0011\u0005\u001dV\u0001)A\u0005\u0003?C\u0011\"!+\u0006\u0005\u0004%I!a+\t\u0011\u0005UV\u0001)A\u0005\u0003[C\u0011\"a.\u0006\u0005\u0004%I!!/\t\u0011\u0005\rW\u0001)A\u0005\u0003wC!\"!2\u0006\u0005\u0004%\t\u0001SAd\u0011!\t\u0019.\u0002Q\u0001\n\u0005%\u0007\"CAk\u000b\u0001\u0007I\u0011BAl\u0011%\ty.\u0002a\u0001\n\u0013\t\t\u000f\u0003\u0005\u0002n\u0016\u0001\u000b\u0015BAm\u0011%\ty/\u0002b\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002\u0000\u0016\u0001\u000b\u0011BAz\u0011%\u0011\t!\u0002b\u0001\n\u0013\u0011\u0019\u0001\u0003\u0005\u00036\u0015\u0001\u000b\u0011\u0002B\u0003\u0011%\u00119$\u0002a\u0001\n\u0013\u0011I\u0004C\u0005\u0003D\u0015\u0001\r\u0011\"\u0003\u0003F!A!\u0011J\u0003!B\u0013\u0011Y\u0004C\u0004\u0003T\u0015!\tA!\u0016\t\u000f\tET\u0001\"\u0001\u0003t!9!qS\u0003\u0005\u0002\te\u0005\u0002\u0003BY\u000b\u0011\u0005\u0001Ja-\t\u000f\t-W\u0001\"\u0001\u0003N\"9!1Z\u0003\u0005\n\t=\u0007b\u0002Bs\u000b\u0011%!q\u001d\u0005\b\u0005W,A\u0011\u0001Bw\u0011\u001d\u0011\u00190\u0002C\u0001\u0005kDqAa?\u0006\t\u0003\u0011i\u0010C\u0004\u0004\u0004\u0015!\ta!\u0002\t\u000f\r%Q\u0001\"\u0001\u0004\f!91\u0011C\u0003\u0005\u0002\rM\u0001bBB\f\u000b\u0011\u0005!Q\u001a\u0005\b\u00073)A\u0011AB\u000e\u0011!\u0019i\"\u0002C\u0001\u0015\ne\u0002bBB\u0010\u000b\u0011%!Q\u001a\u0005\t\u0007C)A\u0011\u0001%\u0003N\"911E\u0003\u0005\n\r\u0015\u0002bBB\u0016\u000b\u0011%1Q\u0006\u0005\t\u0007c)A\u0011\u0001%\u00044!91qH\u0003\u0005\n\r\u0005s\u0001CB\"\u000b!\u0005\u0001j!\u0012\u0007\u0011\r%S\u0001#\u0001I\u0007\u0017Baa\u0016#\u0005\u0002\r}\u0003bBB1\t\u0012\u000531M\u0001\u00105>|7*Z3qKJ\u001cE.[3oi*\u0011\u0011JS\u0001\nu>|7.Z3qKJT\u0011aS\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0015!D\u0001I\u0005=Qvn\\&fKB,'o\u00117jK:$8CA\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!T\u0001\u000f%\u0016$(/\u001f\"bG.|gMZ't+\u0005Y\u0006C\u0001*]\u0013\ti6KA\u0002J]R\fqBU3uef\u0014\u0015mY6pM\u001al5\u000fI\n\u0004\u000bE\u0003\u0007CA1e\u001b\u0005\u0011'BA2K\u0003\u0015)H/\u001b7t\u0013\t)'MA\u0004M_\u001e<\u0017N\\4\u0002\u001b\r|gN\\3diN#(/\u001b8h!\tAwN\u0004\u0002j[B\u0011!nU\u0007\u0002W*\u0011A\u000eT\u0001\u0007yI|w\u000e\u001e \n\u00059\u001c\u0016A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\*\u0002!M,7o]5p]RKW.Z8vi6\u001b\u0018aE2p]:,7\r^5p]RKW.Z8vi6\u001b\u0018aE7bq&sg\t\\5hQR\u0014V-];fgR\u001c\u0018\u0001\u0002;j[\u0016\u00042a^A\u0001\u001b\u0005A(BA2z\u0015\tQ80\u0001\u0004d_6lwN\u001c\u0006\u0003\u0017rT!! @\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0018aA8sO&\u0019\u00111\u0001=\u0003\tQKW.Z\u0001\f[\u0016$(/[2He>,\b/\u0001\u0006nKR\u0014\u0018n\u0019+za\u0016\fAb\u00197jK:$8i\u001c8gS\u001e,\"!!\u0004\u0011\t\u0005=\u0011qC\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511\r\\5f]RT!!\u0013?\n\t\u0005e\u0011\u0011\u0003\u0002\u000f5.\u001bE.[3oi\u000e{gNZ5h\u00035\u0019G.[3oi\u000e{gNZ5hA\u0005!a.Y7f)Q\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u00024A\u0011a*\u0002\u0005\u0006MB\u0001\ra\u001a\u0005\u0006eB\u0001\ra\u0017\u0005\u0006gB\u0001\ra\u0017\u0005\u0006iB\u0001\ra\u0017\u0005\u0006kB\u0001\rA\u001e\u0005\u0007\u0003\u000b\u0001\u0002\u0019A4\t\r\u0005\u001d\u0001\u00031\u0001h\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u001bAa!!\b\u0011\u0001\u00049\u0017\u0001D7fiJL7m]$s_V\u0004XCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nq!\\3ue&\u001c7OC\u0002\u0002Dm\faa]3sm\u0016\u0014\u0018\u0002BA$\u0003{\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005\u0011\u0012N\\5uS\u0006d\u0017N_1uS>tGj\\2l+\t\ty\u0005\u0005\u0003\u0002R\u0005\rTBAA*\u0015\u0011\t)&a\u0016\u0002\u000b1|7m[:\u000b\t\u0005e\u00131L\u0001\u000bG>t7-\u001e:sK:$(\u0002BA/\u0003?\nA!\u001e;jY*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005M#A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]2{7m\u001b\u0011\u00021%\u001c8i\u001c8oK\u000e$X\rZ(s\u000bb\u0004\u0018N]3e\u0019>\u001c7.\u0006\u0002\u0002nA!\u0011\u0011KA8\u0013\u0011\t\t(a\u0015\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003eI7oQ8o]\u0016\u001cG/\u001a3Pe\u0016C\b/\u001b:fI2{7m\u001b\u0011\u0002;%\u001c8i\u001c8oK\u000e$X\rZ(s\u000bb\u0004\u0018N]3e\u0007>tG-\u001b;j_:,\"!!\u001f\u0011\t\u0005E\u00131P\u0005\u0005\u0003{\n\u0019FA\u0005D_:$\u0017\u000e^5p]\u0006q\u0012n]\"p]:,7\r^3e\u001fJ,\u0005\u0010]5sK\u0012\u001cuN\u001c3ji&|g\u000eI\u0001\u0014u:{G-Z\"iC:<W\rS1oI2,'o]\u000b\u0003\u0003\u000b\u0003r!a\"\u0002\u0010\u001e\f\u0019*\u0004\u0002\u0002\n*!\u0011\u0011LAF\u0015\r\tiiU\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u0013\u00131!T1q!\rq\u0015QS\u0005\u0004\u0003/C%A\u0005.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ\fAC\u001f(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN\u0004\u0013\u0001\u0007>O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sgV\u0011\u0011q\u0014\t\b\u0003\u000f\u000byiZAQ!\rq\u00151U\u0005\u0004\u0003KC%a\u0006.O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\u0003eQhj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'o\u001d\u0011\u0002!%tg\t\\5hQR\u0014V-];fgR\u001cXCAAW!\u0011\ty+!-\u000e\u0005\u0005]\u0013\u0002BAZ\u0003/\u0012\u0011bU3nCBDwN]3\u0002#%tg\t\\5hQR\u0014V-];fgR\u001c\b%A\nti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148/\u0006\u0002\u0002<B9\u0011qQAHO\u0006u\u0006c\u0001(\u0002@&\u0019\u0011\u0011\u0019%\u0003%M#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM]\u0001\u0015gR\fG/Z\"iC:<W\rS1oI2,'o\u001d\u0011\u0002+I,\u0017N\\5uS\u0006d\u0017N_3TG\",G-\u001e7feV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\fy-\u0004\u0002\u0002N*!\u0011QLA!\u0013\u0011\t\t.!4\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u00061\"/Z5oSRL\u0017\r\\5{KN\u001b\u0007.\u001a3vY\u0016\u0014\b%\u0001\u000fjg\u001aK'o\u001d;D_:tWm\u0019;j_:,5\u000f^1cY&\u001c\b.\u001a3\u0016\u0005\u0005e\u0007c\u0001*\u0002\\&\u0019\u0011Q\\*\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n\u001d$jeN$8i\u001c8oK\u000e$\u0018n\u001c8FgR\f'\r\\5tQ\u0016$w\fJ3r)\u0011\t\u0019/!;\u0011\u0007I\u000b)/C\u0002\u0002hN\u0013A!\u00168ji\"I\u00111\u001e\u0013\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0004q\u0012\n\u0014!H5t\r&\u00148\u000f^\"p]:,7\r^5p]\u0016\u001bH/\u00192mSNDW\r\u001a\u0011\u0002\u00175,GO]5d\u001d\u0006lWm]\u000b\u0003\u0003g\u0004R!!>\u0002|\u001el!!a>\u000b\t\u0005e\u00181R\u0001\b[V$\u0018M\u00197f\u0013\u0011\ti0a>\u0003\u0007M+G/\u0001\u0007nKR\u0014\u0018n\u0019(b[\u0016\u001c\b%A\bti\u0006$X\rV8NKR,'/T1q+\t\u0011)\u0001\u0005\u0005\u0003\b\t5!q\u0002B\u0010\u001b\t\u0011IA\u0003\u0003\u0003\f\u0005-\u0015!C5n[V$\u0018M\u00197f\u0013\u0011\t\tJ!\u0003\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005)QI^3oi*!!\u0011DA\u000b\u0003\u001d9\u0016\r^2iKJLAA!\b\u0003\u0014\tY1*Z3qKJ\u001cF/\u0019;f!\u0011\u0011\tC!\r\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\tAaY8sK*!\u0011q\bB\u0015\u0015\u0011\u0011YC!\f\u0002\re\fW.\\3s\u0015\t\u0011y#A\u0002d_6LAAa\r\u0003$\t)Q*\u001a;fe\u0006\u00012\u000f^1uKR{W*\u001a;fe6\u000b\u0007\u000fI\u0001\nu>|7*Z3qKJ,\"Aa\u000f\u0011\t\tu\"qH\u0007\u0003\u0003+IAA!\u0011\u0002\u0016\tI!l\\8LK\u0016\u0004XM]\u0001\u000eu>|7*Z3qKJ|F%Z9\u0015\t\u0005\r(q\t\u0005\n\u0003W\\\u0013\u0011!a\u0001\u0005w\t!B_8p\u0017\u0016,\u0007/\u001a:!Q\ra#Q\n\t\u0004%\n=\u0013b\u0001B)'\nAao\u001c7bi&dW-A\bd_:tWm\u0019;j_:\u001cF/\u0019;f+\t\u00119\u0006\u0005\u0003\u0003Z\t-d\u0002\u0002B.\u0005OrAA!\u0018\u0003f9!!q\fB2\u001d\rQ'\u0011M\u0005\u0002\u007f&\u0011QP`\u0005\u0003\u0013rLAA!\u001b\u0002\u0016\u0005I!l\\8LK\u0016\u0004XM]\u0005\u0005\u0005[\u0012yG\u0001\u0004Ti\u0006$Xm\u001d\u0006\u0005\u0005S\n)\"A\u0007iC:$G.\u001a*fcV,7\u000f^\u000b\u0005\u0005k\u0012i\b\u0006\u0003\u0003x\tM\u0005\u0003\u0002B=\u0005\u001f\u0003BAa\u001f\u0003~1\u0001Aa\u0002B@]\t\u0007!\u0011\u0011\u0002\u0004%\u0016\f\u0018\u0003\u0002BB\u0005\u0013\u00032A\u0015BC\u0013\r\u00119i\u0015\u0002\b\u001d>$\b.\u001b8h!\rq%1R\u0005\u0004\u0005\u001bC%\u0001D!ts:\u001c'+Z9vKN$\u0018\u0002\u0002BI\u0005\u0017\u0013\u0001BU3ta>t7/\u001a\u0005\b\u0005+s\u0003\u0019\u0001B=\u0003\u001d\u0011X-];fgR\fa\u0002[1oI2,'+Z9vKN$8/\u0006\u0003\u0003\u001c\n%F\u0003\u0002BO\u0005W\u0003bAa(\u0003\"\n\u0015VBAAF\u0013\u0011\u0011\u0019+a#\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003(\n=\u0005\u0003\u0002B>\u0005S#qAa 0\u0005\u0004\u0011\t\tC\u0004\u0003.>\u0002\rAa,\u0002\u0011I,\u0017/^3tiN\u0004bAa(\u0003\"\n\u001d\u0016\u0001B:f]\u0012,BA!.\u0003HR!!q\u0017Be)\u0011\t\u0019O!/\t\u000f\tm\u0006\u00071\u0001\u0003>\u0006y\u0001O]8dKN\u001c(+Z:q_:\u001cX\rE\u0004S\u0005\u007f\u0013\u0019-a9\n\u0007\t\u00057KA\u0005Gk:\u001cG/[8ocA!!Q\u0019BH!\u0011\u0011YHa2\u0005\u000f\t}\u0004G1\u0001\u0003\u0002\"9!Q\u0013\u0019A\u0002\t\u0015\u0017AE<bSR,f\u000e^5m\u0007>tg.Z2uK\u0012$\"!a9\u0015\r\u0005\r(\u0011\u001bBn\u0011\u001d\u0011\u0019N\ra\u0001\u0005+\fq\u0001^5nK>,H\u000fE\u0002S\u0005/L1A!7T\u0005\u0011auN\\4\t\u000f\tu'\u00071\u0001\u0003`\u0006AA/[7f+:LG\u000f\u0005\u0003\u00020\n\u0005\u0018\u0002\u0002Br\u0003/\u0012\u0001\u0002V5nKVs\u0017\u000e^\u0001\fg\"|W\u000f\u001c3XCR\u001c\u0007\u000e\u0006\u0003\u0002Z\n%\bb\u0002BKg\u0001\u0007!\u0011R\u0001\u001be\u0016<\u0017n\u001d;fejsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u000b\u0005\u0003G\u0014y\u000fC\u0004\u0003rR\u0002\r!a%\u0002%itu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM]\u0001\u001dk:\u0014XmZ5ti\u0016\u0014(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s)\u0011\t\u0019Oa>\t\r\teX\u00071\u0001h\u0003\u0011\u0001\u0018\r\u001e5\u0002?I,w-[:uKJTfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'\u000f\u0006\u0003\u0002d\n}\bbBB\u0001m\u0001\u0007\u0011\u0011U\u0001\u0018u:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJ\f\u0011%\u001e8sK\u001eL7\u000f^3s5:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJ$B!a9\u0004\b!1!\u0011`\u001cA\u0002\u001d\f!D]3hSN$XM]*uCR,7\t[1oO\u0016D\u0015M\u001c3mKJ$B!a9\u0004\u000e!91q\u0002\u001dA\u0002\u0005u\u0016AE:uCR,7\t[1oO\u0016D\u0015M\u001c3mKJ\fA$\u001e8sK\u001eL7\u000f^3s'R\fG/Z\"iC:<W\rS1oI2,'\u000f\u0006\u0003\u0002d\u000eU\u0001BBA\u000fs\u0001\u0007q-A\u0003dY>\u001cX-A\u0005tKN\u001c\u0018n\u001c8JIV\u0011!Q[\u0001\u0011GV\u0014(/\u001a8u5>|7*Z3qKJ\fAB]3j]&$\u0018.\u00197ju\u0016\f\u0011CZ8sG\u0016\u0014V-\u001b8ji&\fG.\u001b>f\u0003u\u0019\u0017\r\u001c7CK\u001a|'/Z%oSRL\u0017\r\\5{S:<7+Z:tS>tG\u0003BAr\u0007OAqa!\u000b@\u0001\u0004\ti,A\u0004iC:$G.\u001a:\u00029\r\fG\u000e\\!gi\u0016\u0014\u0018J\\5uS\u0006d\u0017N_5oON+7o]5p]R!\u00111]B\u0018\u0011\u001d\u0019I\u0003\u0011a\u0001\u0003{\u000bAc]2iK\u0012,H.\u001a*fS:LG/[1mSj,G\u0003CAr\u0007k\u00199da\u000f\t\r\u0005u\u0011\t1\u0001h\u0011\u0019\u0019I$\u0011a\u0001O\u00069Q.Z:tC\u001e,\u0007bBB\u001f\u0003\u0002\u0007!Q[\u0001\bI\u0016d\u0017-_'t\u00031!\bN]3bIB\u0013XMZ5y+\u00059\u0017A\u0006.p_.+W\r]3s\u00072LWM\u001c;XCR\u001c\u0007.\u001a:\u0011\u0007\r\u001dC)D\u0001\u0006\u0005YQvn\\&fKB,'o\u00117jK:$x+\u0019;dQ\u0016\u00148#\u0002#\u0004N\re\u0003\u0003BB(\u0007+j!a!\u0015\u000b\t\rM\u0013qL\u0001\u0005Y\u0006tw-\u0003\u0003\u0004X\rE#AB(cU\u0016\u001cG\u000f\u0005\u0003\u0003>\rm\u0013\u0002BB/\u0003+\u0011qaV1uG\",'\u000f\u0006\u0002\u0004F\u00059\u0001O]8dKN\u001cH\u0003BAr\u0007KBqaa\u001aG\u0001\u0004\u0019I'A\u0003fm\u0016tG\u000f\u0005\u0003\u0003>\r-\u0014\u0002BB7\u0003+\u0011AbV1uG\",G-\u0012<f]R\u0004")
public class ZooKeeperClient
implements Logging {
    private volatile ZooKeeperClient$ZooKeeperClientWatcher$ ZooKeeperClientWatcher$module;
    private final String connectString;
    private final int sessionTimeoutMs;
    private final Time time;
    public final String kafka$zookeeper$ZooKeeperClient$$metricGroup;
    public final String kafka$zookeeper$ZooKeeperClient$$metricType;
    private final ZKClientConfig clientConfig;
    private final String name;
    private final KafkaMetricsGroup metricsGroup;
    private final ReentrantReadWriteLock initializationLock;
    private final ReentrantLock kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock;
    private final Condition kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition;
    private final scala.collection.concurrent.Map<String, ZNodeChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers;
    private final scala.collection.concurrent.Map<String, ZNodeChildChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers;
    private final Semaphore inFlightRequests;
    private final scala.collection.concurrent.Map<String, StateChangeHandler> kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers;
    private final KafkaScheduler reinitializeScheduler;
    private boolean kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished;
    private final Set<String> metricNames;
    private final scala.collection.immutable.Map<Watcher.Event.KeeperState, Meter> kafka$zookeeper$ZooKeeperClient$$stateToMeterMap;
    private volatile ZooKeeper zooKeeper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int RetryBackoffMs() {
        return ZooKeeperClient$.MODULE$.RetryBackoffMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZooKeeperClient$ZooKeeperClientWatcher$ ZooKeeperClientWatcher() {
        if (this.ZooKeeperClientWatcher$module == null) {
            this.ZooKeeperClientWatcher$lzycompute$1();
        }
        return this.ZooKeeperClientWatcher$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZKClientConfig clientConfig() {
        return this.clientConfig;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ReentrantReadWriteLock initializationLock() {
        return this.initializationLock;
    }

    public ReentrantLock kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock() {
        return this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock;
    }

    public Condition kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition() {
        return this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition;
    }

    public scala.collection.concurrent.Map<String, ZNodeChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers;
    }

    public scala.collection.concurrent.Map<String, ZNodeChildChangeHandler> kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers;
    }

    private Semaphore inFlightRequests() {
        return this.inFlightRequests;
    }

    public scala.collection.concurrent.Map<String, StateChangeHandler> kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers() {
        return this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers;
    }

    public KafkaScheduler reinitializeScheduler() {
        return this.reinitializeScheduler;
    }

    public boolean kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished() {
        return this.kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished;
    }

    private void kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished_$eq(boolean x$1) {
        this.kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished = x$1;
    }

    private Set<String> metricNames() {
        return this.metricNames;
    }

    public scala.collection.immutable.Map<Watcher.Event.KeeperState, Meter> kafka$zookeeper$ZooKeeperClient$$stateToMeterMap() {
        return this.kafka$zookeeper$ZooKeeperClient$$stateToMeterMap;
    }

    private ZooKeeper zooKeeper() {
        return this.zooKeeper;
    }

    private void zooKeeper_$eq(ZooKeeper x$1) {
        this.zooKeeper = x$1;
    }

    public ZooKeeper.States connectionState() {
        return this.zooKeeper().getState();
    }

    public <Req extends AsyncRequest> AsyncResponse handleRequest(Req request) {
        return (AsyncResponse)this.handleRequests((Seq<Req>)new .colon.colon(request, (List)Nil$.MODULE$)).head();
    }

    public <Req extends AsyncRequest> Seq<AsyncResponse> handleRequests(Seq<Req> requests) {
        if (requests.isEmpty()) {
            return Nil$.MODULE$;
        }
        CountDownLatch countDownLatch = new CountDownLatch(requests.size());
        ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(requests.size());
        requests.foreach((Function1 & Serializable & scala.Serializable)request -> {
            ZooKeeperClient.$anonfun$handleRequests$1(this, responseQueue, countDownLatch, request);
            return BoxedUnit.UNIT;
        });
        countDownLatch.await();
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(responseQueue).asScala()).toBuffer();
    }

    public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
        long sendTimeMs = this.time.hiResClockMs();
        if (request instanceof ExistsRequest) {
            ExistsRequest existsRequest = (ExistsRequest)request;
            String path2 = existsRequest.path();
            Option<Object> ctx2 = existsRequest.ctx();
            this.zooKeeper().exists(path2, this.shouldWatch(request), new AsyncCallback.StatCallback(this, sendTimeMs, processResponse){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final long sendTimeMs$1;
                private final Function1 processResponse$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new ExistsResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sendTimeMs$1 = sendTimeMs$1;
                    this.processResponse$1 = processResponse$1;
                }
            }, ctx2.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof GetDataRequest) {
            GetDataRequest getDataRequest = (GetDataRequest)request;
            String path3 = getDataRequest.path();
            Option<Object> ctx3 = getDataRequest.ctx();
            this.zooKeeper().getData(path3, this.shouldWatch(request), new AsyncCallback.DataCallback(this, sendTimeMs, processResponse){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final long sendTimeMs$1;
                private final Function1 processResponse$1;

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new GetDataResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), data, stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sendTimeMs$1 = sendTimeMs$1;
                    this.processResponse$1 = processResponse$1;
                }
            }, ctx3.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof GetChildrenRequest) {
            GetChildrenRequest getChildrenRequest = (GetChildrenRequest)request;
            String path4 = getChildrenRequest.path();
            Option<Object> ctx4 = getChildrenRequest.ctx();
            this.zooKeeper().getChildren(path4, this.shouldWatch(request), new AsyncCallback.Children2Callback(this, sendTimeMs, processResponse){
                private final /* synthetic */ ZooKeeperClient $outer;
                private final long sendTimeMs$1;
                private final Function1 processResponse$1;

                public void processResult(int rc, String path, Object ctx, java.util.List<String> children, Stat stat) {
                    ZooKeeperClient.kafka$zookeeper$ZooKeeperClient$$callback$1(new GetChildrenResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), (Seq<String>)((Seq)Option$.MODULE$.apply(children).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), stat, this.$outer.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(this.sendTimeMs$1)), this.processResponse$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sendTimeMs$1 = sendTimeMs$1;
                    this.processResponse$1 = processResponse$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$processResult$1(java.util.List ), $anonfun$processResult$2()}, serializedLambda);
                }
            }, ctx4.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            String path5 = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl2 = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx5 = createRequest.ctx();
            this.zooKeeper().create(path5, data, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(acl2).asJava(), createMode, (rc, path, ctx, name) -> {
                CreateResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new CreateResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), name, this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx5.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)request;
            String path6 = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx6 = setDataRequest.ctx();
            this.zooKeeper().setData(path6, data, version, (rc, path, ctx, stat) -> {
                SetDataResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new SetDataResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx6.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            String path7 = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx7 = deleteRequest.ctx();
            this.zooKeeper().delete(path7, version, (rc, path, ctx) -> {
                DeleteResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new DeleteResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx7.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof GetAclRequest) {
            GetAclRequest getAclRequest = (GetAclRequest)request;
            String path8 = getAclRequest.path();
            Option<Object> ctx8 = getAclRequest.ctx();
            this.zooKeeper().getACL(path8, null, (rc, path, ctx, acl, stat) -> {
                GetAclResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new GetAclResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), (Seq<ACL>)((Seq)Option$.MODULE$.apply((Object)acl).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), stat, this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx8.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof SetAclRequest) {
            SetAclRequest setAclRequest = (SetAclRequest)request;
            String path9 = setAclRequest.path();
            Seq<ACL> acl3 = setAclRequest.acl();
            int version = setAclRequest.version();
            Option<Object> ctx9 = setAclRequest.ctx();
            this.zooKeeper().setACL(path9, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(acl3).asJava(), version, (rc, path, ctx, stat) -> {
                SetAclResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new SetAclResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), stat, this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx9.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        if (request instanceof MultiRequest) {
            MultiRequest multiRequest = (MultiRequest)request;
            Seq<ZkOp> zkOps = multiRequest.zkOps();
            Option<Object> ctx10 = multiRequest.ctx();
            this.zooKeeper().multi((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)zkOps.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toZookeeperOp(), Seq$.MODULE$.canBuildFrom())).asJava(), (rc, path, ctx, opResults) -> {
                MultiResponse kafka$zookeeper$ZooKeeperClient$$callback$1_response = new MultiResponse(KeeperException.Code.get((int)rc), path, (Option<Object>)Option$.MODULE$.apply(ctx), (Seq<ZkOpResult>)ZooKeeperClient.toZkOpResult$1(opResults, zkOps), this.kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(sendTimeMs));
                processResponse.apply((Object)kafka$zookeeper$ZooKeeperClient$$callback$1_response);
            }, ctx10.orNull(Predef$.MODULE$.$conforms()));
            return;
        }
        throw new MatchError(request);
    }

    public void waitUntilConnected() {
        CoreUtils$.MODULE$.inLock(this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.waitUntilConnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    private void waitUntilConnected(long timeout, TimeUnit timeUnit) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting until connected.");
        LongRef nanos = LongRef.create((long)timeUnit.toNanos(timeout));
        CoreUtils$.MODULE$.inLock(this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ZooKeeper.States state = this.connectionState();
            while (!state.isConnected() && state.isAlive()) {
                if (nanos$1.elem <= 0L) {
                    throw new ZooKeeperClientTimeoutException(new StringBuilder(49).append("Timed out waiting for connection while in state: ").append(state).toString());
                }
                nanos$1.elem = this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition().awaitNanos(nanos$1.elem);
                state = this.connectionState();
            }
            if (state.equals(ZooKeeper.States.AUTH_FAILED)) {
                throw new ZooKeeperClientAuthFailedException("Auth failed either before or while waiting for connection");
            }
            ZooKeeper.States states = state;
            ZooKeeper.States states2 = ZooKeeper.States.CLOSED;
            if (!(states != null ? !states.equals(states2) : states2 != null)) {
                throw new ZooKeeperClientExpiredException("Session expired either before or while waiting for connection");
            }
            this.kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished_$eq(true);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connected.");
    }

    private boolean shouldWatch(AsyncRequest request) {
        if (request instanceof GetChildrenRequest) {
            return ((GetChildrenRequest)request).registerWatch() && this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().contains((Object)request.path());
        }
        if (request instanceof ExistsRequest ? true : request instanceof GetDataRequest) {
            return this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().contains((Object)request.path());
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Request ").append(request).append(" is not watchable").toString());
    }

    public void registerZNodeChangeHandler(ZNodeChangeHandler zNodeChangeHandler) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().put((Object)zNodeChangeHandler.path(), (Object)zNodeChangeHandler);
    }

    public void unregisterZNodeChangeHandler(String path) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().remove((Object)path);
    }

    public void registerZNodeChildChangeHandler(ZNodeChildChangeHandler zNodeChildChangeHandler) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().put((Object)zNodeChildChangeHandler.path(), (Object)zNodeChildChangeHandler);
    }

    public void unregisterZNodeChildChangeHandler(String path) {
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().remove((Object)path);
    }

    public void registerStateChangeHandler(StateChangeHandler stateChangeHandler) {
        CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (stateChangeHandler != null) {
                return this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().put((Object)stateChangeHandler.name(), (Object)stateChangeHandler);
            }
            return BoxedUnit.UNIT;
        });
    }

    public void unregisterStateChangeHandler(String name) {
        CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().remove((Object)name));
    }

    public void close() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing.");
        this.reinitializeScheduler().shutdown();
        CoreUtils$.MODULE$.inWriteLock(this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers().clear();
            this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers().clear();
            this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().clear();
            this.zooKeeper().close();
            this.metricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ZooKeeperClient.$anonfun$close$3(this, x$1);
                return BoxedUnit.UNIT;
            });
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closed.");
    }

    public long sessionId() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.zooKeeper().getSessionId()));
    }

    public ZooKeeper currentZooKeeper() {
        return (ZooKeeper)CoreUtils$.MODULE$.inReadLock(this.initializationLock(), (Function0 & Serializable & scala.Serializable)() -> this.zooKeeper());
    }

    private void reinitialize() {
        this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            this.callBeforeInitializingSession(handler);
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.inWriteLock(this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.connectionState().isAlive()) {
                this.zooKeeper().close();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Initializing a new session to ").append($this.connectString).append(".").toString());
                boolean connected = false;
                while (!connected) {
                    try {
                        this.zooKeeper_$eq(new ZooKeeper($this.connectString, $this.sessionTimeoutMs, (Watcher)this.ZooKeeperClientWatcher(), this.clientConfig()));
                        connected = true;
                    }
                    catch (Exception e) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error when recreating ZooKeeper, retrying after a short sleep", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        Thread.sleep(ZooKeeperClient$.MODULE$.RetryBackoffMs());
                    }
                }
                return;
            }
        });
        this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            this.callAfterInitializingSession(handler);
            return BoxedUnit.UNIT;
        });
    }

    public void forceReinitialize() {
        this.zooKeeper().close();
        this.reinitialize();
    }

    private void callBeforeInitializingSession(StateChangeHandler handler) {
        try {
            handler.beforeInitializingSession();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Uncaught error in handler ").append(handler.name()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    private void callAfterInitializingSession(StateChangeHandler handler) {
        try {
            handler.afterInitializingSession();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Uncaught error in handler ").append(handler.name()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    public void scheduleReinitialize(String name, String message, long delayMs) {
        this.reinitializeScheduler().scheduleOnce(name, () -> {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            this.reinitialize();
        }, delayMs);
    }

    private String threadPrefix() {
        return new StringBuilder(1).append(this.name.replaceAll("\\s", "")).append("-").toString();
    }

    private final void ZooKeeperClientWatcher$lzycompute$1() {
        synchronized (this) {
            if (this.ZooKeeperClientWatcher$module == null) {
                this.ZooKeeperClientWatcher$module = new ZooKeeperClient$ZooKeeperClientWatcher$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleRequests$3(ZooKeeperClient $this, ArrayBlockingQueue responseQueue$1, CountDownLatch countDownLatch$1, AsyncResponse response) {
        responseQueue$1.add(response);
        $this.inFlightRequests().release();
        countDownLatch$1.countDown();
    }

    public static final /* synthetic */ void $anonfun$handleRequests$1(ZooKeeperClient $this, ArrayBlockingQueue responseQueue$1, CountDownLatch countDownLatch$1, AsyncRequest request) {
        $this.inFlightRequests().acquire();
        try {
            CoreUtils$.MODULE$.inReadLock($this.initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.send(request, (Function1<AsyncResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ZooKeeperClient.$anonfun$handleRequests$3($this, responseQueue$1, countDownLatch$1, response);
                return BoxedUnit.UNIT;
            }));
            return;
        }
        catch (Throwable e) {
            $this.inFlightRequests().release();
            throw e;
        }
    }

    public static final void kafka$zookeeper$ZooKeeperClient$$callback$1(AsyncResponse response, Function1 processResponse$1) {
        processResponse$1.apply((Object)response);
    }

    public final ResponseMetadata kafka$zookeeper$ZooKeeperClient$$responseMetadata$1(long sendTimeMs) {
        return new ResponseMetadata(sendTimeMs, this.time.hiResClockMs());
    }

    private static final Seq toZkOpResult$1(java.util.List opResults, Seq zkOps$1) {
        return (Seq)Option$.MODULE$.apply((Object)opResults).map((Function1 & Serializable & scala.Serializable)results -> (Seq)((TraversableLike)zkOps$1.zip((GenIterable)CollectionConverters$.MODULE$.asScalaBufferConverter(results).asScala(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ZkOp zkOp = (ZkOp)x0$1._1();
                OpResult result = (OpResult)x0$1._2();
                return new ZkOpResult(zkOp, result);
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom())).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$close$3(ZooKeeperClient $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public ZooKeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String metricGroup, String metricType, ZKClientConfig clientConfig, String name) {
        this.connectString = connectString;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.time = time;
        this.kafka$zookeeper$ZooKeeperClient$$metricGroup = metricGroup;
        this.kafka$zookeeper$ZooKeeperClient$$metricType = metricType;
        this.clientConfig = clientConfig;
        this.name = name;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this){
            private final /* synthetic */ ZooKeeperClient $outer;

            public MetricName metricName(String name, Map<String, String> metricTags) {
                return KafkaMetricsGroup.explicitMetricName((String)this.$outer.kafka$zookeeper$ZooKeeperClient$$metricGroup, (String)this.$outer.kafka$zookeeper$ZooKeeperClient$$metricType, (String)name, metricTags);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.getClass());
            }
        };
        this.logIdent_$eq(new StringBuilder(19).append("[ZooKeeperClient ").append(name).append("] ").toString());
        this.initializationLock = new ReentrantReadWriteLock();
        this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock = new ReentrantLock();
        this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredCondition = this.kafka$zookeeper$ZooKeeperClient$$isConnectedOrExpiredLock().newCondition();
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChangeHandlers = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.kafka$zookeeper$ZooKeeperClient$$zNodeChildChangeHandlers = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.inFlightRequests = new Semaphore(maxInFlightRequests);
        this.kafka$zookeeper$ZooKeeperClient$$stateChangeHandlers = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.reinitializeScheduler = new KafkaScheduler(1, true, new StringBuilder(17).append("zk-client-").append(this.threadPrefix()).append("reinit-").toString(), false);
        this.kafka$zookeeper$ZooKeeperClient$$isFirstConnectionEstablished = false;
        this.metricNames = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$zookeeper$ZooKeeperClient$$stateToMeterMap = (scala.collection.immutable.Map)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.Disconnected), (Object)"Disconnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.SyncConnected), (Object)"SyncConnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.AuthFailed), (Object)"AuthFailures"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.ConnectedReadOnly), (Object)"ReadOnlyConnects"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.SaslAuthenticated), (Object)"SaslAuthentications"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Watcher.Event.KeeperState.Expired), (Object)"Expires")}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Watcher.Event.KeeperState state = (Watcher.Event.KeeperState)x0$1._1();
                String eventType = (String)x0$1._2();
                String name = new StringBuilder(15).append("ZooKeeper").append(eventType).append("PerSec").toString();
                this.metricNames().$plus$eq((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)this.metricsGroup().newMeter(name, eventType.toLowerCase(Locale.ROOT), TimeUnit.SECONDS));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Initializing a new session to ").append($this.connectString).append(".").toString());
        this.zooKeeper = new ZooKeeper(connectString, sessionTimeoutMs, (Watcher)this.ZooKeeperClientWatcher(), clientConfig);
        this.metricsGroup().newGauge("SessionState", () -> this.connectionState().toString());
        this.metricNames().$plus$eq((Object)"SessionState");
        this.reinitializeScheduler().startup();
        try {
            this.waitUntilConnected(connectionTimeoutMs, TimeUnit.MILLISECONDS);
            return;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }
}

