/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.server.config.QuotaConfigs;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ConfigCommand$
implements Logging {
    public static ConfigCommand$ MODULE$;
    private final String BrokerDefaultEntityName;
    private final String BrokerLoggerConfigType;
    private final Buffer<String> kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes;
    private final Seq<String> kafka$admin$ConfigCommand$$ZkSupportedConfigTypes;
    private final int DefaultScramIterations;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String BrokerDefaultEntityName() {
        return this.BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return this.BrokerLoggerConfigType;
    }

    public Buffer<String> kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes() {
        return this.kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes;
    }

    public Seq<String> kafka$admin$ConfigCommand$$ZkSupportedConfigTypes() {
        return this.kafka$admin$ConfigCommand$$ZkSupportedConfigTypes;
    }

    private int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to manipulate and describe entity config for a topic, client, user, broker, ip, client-metrics or cluster link.");
            opts.checkArgs();
            if (!opts.options.has(opts.zkConnectOpt())) {
                this.processCommand(opts);
                return;
            }
            Predef$.MODULE$.println((Object)"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.");
            Predef$.MODULE$.println((Object)"Use --bootstrap-server instead to specify a broker to connect to.");
            this.processCommandWithZk((String)opts.options.valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        ZKClientConfig zkClientConfig = (ZKClientConfig)ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options, opts.zkTlsConfigFile()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ZKClientConfig());
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        int x$3 = 30000;
        int x$4 = 30000;
        int x$5 = Integer.MAX_VALUE;
        Time x$6 = Time.SYSTEM;
        String x$8 = "ConfigCommand";
        boolean x$9 = false;
        String x$10 = KafkaZkClient$.MODULE$.apply$default$9();
        String x$11 = KafkaZkClient$.MODULE$.apply$default$10();
        boolean x$12 = KafkaZkClient$.MODULE$.apply$default$11();
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, x$3, x$4, x$5, x$6, x$8, zkClientConfig, x$10, x$11, x$12, x$9);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        try {
            if (opts.options.has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String errorMessage = new StringBuilder(81).append("--bootstrap-server option must be specified to update ").append(entityType).append(" configs: {add: ").append(configsToBeAdded).append(", delete: ").append(configsToBeDeleted).append("}").toString();
        boolean isUserClientId = false;
        String string = entityType;
        String string2 = "users";
        if (string != null && string.equals(string2)) {
            isUserClientId = entity.child().exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$1(e)));
            if (!configsToBeAdded.isEmpty() || configsToBeDeleted.nonEmpty()) {
                String info = "User configuration updates using ZooKeeper are only supported for SCRAM credential updates.";
                String[] scramMechanismNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.apache.kafka.common.security.scram.internals.ScramMechanism.values())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.mechanismName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                Predef$.MODULE$.require(((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(configsToBeAdded.stringPropertyNames()).asScala()).forall(arg_0 -> ConfigCommand$.$anonfun$alterConfigWithZk$3$adapted(Predef$.MODULE$.refArrayOps((Object[])scramMechanismNames), arg_0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(". ").append(info).toString());
                Predef$.MODULE$.require(configsToBeDeleted.forall(arg_0 -> ConfigCommand$.$anonfun$alterConfigWithZk$5$adapted(Predef$.MODULE$.refArrayOps((Object[])scramMechanismNames), arg_0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(". ").append(info).toString());
            }
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            String string3 = entityType;
            String string4 = "brokers";
            if (string3 != null && string3.equals(string4) && (!configsToBeAdded.isEmpty() || configsToBeDeleted.nonEmpty())) {
                this.validateBrokersNotRunning(entityName, adminZkClient, zkClient, errorMessage);
                String string5 = entityName;
                String string6 = "<default>";
                boolean perBrokerConfig = string5 == null || !string5.equals(string6);
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$2)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$3 -> configs.remove(x$3));
        adminZkClient.changeConfigs(entityType, entityName, configs, isUserClientId);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed updating config for entity: ").append(entity).append(".").toString());
    }

    private void validateBrokersNotRunning(String entityName, AdminZkClient adminZkClient, KafkaZkClient zkClient, String errorMessage) {
        String string = entityName;
        String string2 = "<default>";
        boolean perBrokerConfig = string == null || !string.equals(string2);
        String info = "Broker configuration operations using ZooKeeper are only supported if the affected broker(s) are not running.";
        if (perBrokerConfig) {
            adminZkClient.parseBroker(entityName).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Predef$.MODULE$.require(zkClient.getBroker(brokerId).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append(errorMessage).append(" - broker ").append(brokerId).append(" is running. ").append(info).toString()));
            return;
        }
        int runningBrokersCount = zkClient.getAllBrokersInCluster().size();
        Predef$.MODULE$.require(runningBrokersCount == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append(errorMessage).append(" - ").append(runningBrokersCount).append(" brokers are running. ").append(info).toString());
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.apache.kafka.common.security.scram.internals.ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            String string = configsToBeAdded.getProperty(mechanism.mechanismName());
            if (string == null) {
                return BoxedUnit.UNIT;
            }
            return configsToBeAdded.setProperty(mechanism.mechanismName(), this.scramCredential$1((org.apache.kafka.common.security.scram.internals.ScramMechanism)mechanism, string));
        });
    }

    public PasswordEncoder createPasswordEncoder(java.util.Map<String, String> encoderConfigs) {
        String encoderSecret = Optional.ofNullable(encoderConfigs.get("password.encoder.secret")).orElseThrow(() -> new IllegalArgumentException("Password encoder secret not specified"));
        return PasswordEncoder.encrypting((Password)new Password(encoderSecret), null, (String)encoderConfigs.getOrDefault("password.encoder.cipher.algorithm", "AES/GCM/NoPadding"), (int)BoxesRunTime.unboxToInt((Object)Optional.ofNullable(encoderConfigs.get("password.encoder.key.length")).map(x$1 -> BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$2(x$1))).orElse(BoxesRunTime.boxToInteger((int)128))), (int)BoxesRunTime.unboxToInt((Object)Optional.ofNullable(encoderConfigs.get("password.encoder.iterations")).map(x$1 -> BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$1))).orElse(BoxesRunTime.boxToInteger((int)4096))));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs)));
            }
            ((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            Predef$.MODULE$.require(passwordEncoderConfigs.containsKey("password.encoder.secret"), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(249).append("password.encoder.secret").append(" must be specified to update ").append(passwordConfigs).append(".").append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString());
            HashMap<String, String> passwordConfigsMap = new HashMap<String, String>();
            passwordEncoderConfigs.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> passwordConfigsMap.put(key.toString(), value.toString())));
            PasswordEncoder passwordEncoder = this.createPasswordEncoder(passwordConfigsMap);
            passwordConfigs.foreach((Function1 & Serializable & scala.Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
            return;
        }
    }

    public void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        String entityType;
        ConfigCommand.ConfigEntity configEntity = this.parseEntity(opts);
        String string = entityType = configEntity.root().entityType();
        String string2 = "users";
        boolean describeAllUsers = string != null && string.equals(string2) && configEntity.root().sanitizedName().isEmpty() && configEntity.child().isEmpty();
        String entityName = configEntity.fullSanitizedName();
        String errorMessage = new StringBuilder(56).append("--bootstrap-server option must be specified to describe ").append(entityType).toString();
        String string3 = entityType;
        String string4 = "brokers";
        if (string3 != null && string3.equals(string4)) {
            this.validateBrokersNotRunning(entityName, adminZkClient, zkClient, errorMessage);
        }
        configEntity.getAllEntities(zkClient).foreach((Function1 & Serializable & scala.Serializable)entity -> {
            ConfigCommand$.$anonfun$describeConfigWithZk$1(adminZkClient, describeAllUsers, entity);
            return BoxedUnit.UNIT;
        });
    }

    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options.has(opts.addConfigFile())) {
            String file = (String)opts.options.valueOf(opts.addConfigFile());
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file));
        }
        if (opts.options.has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options.valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\".");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)).foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
        }
        if (props.containsKey("message.format.version")) {
            Predef$.MODULE$.println((Object)new StringBuilder(320).append("WARNING: The configuration ").append("message.format.version").append("=").append(props.getProperty("message.format.version")).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker or ").append("if the inter.broker.protocol.version is 3.0 or newer. This configuration is deprecated and it will be removed in Apache Kafka 4.0.").toString());
        }
        this.validatePropsKey(props);
        return this.parseReplicaPlacementConfig(props, opts);
    }

    private Properties parseReplicaPlacementConfig(Properties props, ConfigCommand.ConfigCommandOptions opts) {
        if (props.containsKey("confluent.placement.constraints")) {
            throw new IllegalArgumentException(new StringBuilder(101).append("When adding the ").append("confluent.placement.constraints").append(" configuration please use the --replica-placement flag").toString());
        }
        if (opts.options.has(opts.replicaPlacementOpt())) {
            String jsonString = Utils.readFileAsString((String)((String)opts.options.valueOf(opts.replicaPlacementOpt())));
            OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)jsonString))).foreach((Function1 & Serializable & scala.Serializable)replicaPlacement -> props.setProperty("confluent.placement.constraints", replicaPlacement.toJson()));
        }
        return props;
    }

    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options.has(opts.deleteConfig())) {
            return (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options.valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.trim(), Buffer$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    private void validatePropsKey(Properties props) {
        props.keySet().forEach(propsKey -> {
            if (!propsKey.toString().matches("[a-zA-Z0-9._-]*")) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid character found for config key: ").append(propsKey).toString());
            }
        });
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt()))) : new Properties();
        CommandLineUtils.initializeBootstrapProperties((OptionParser)opts.parser, (OptionSet)opts.options, (Properties)props, opts.bootstrapServerOpt(), opts.bootstrapControllerOpt());
        Admin adminClient = Admin.create((Properties)props);
        if (opts.options.has((OptionSpec)opts.alterOpt()) && opts.entityTypes().size() != opts.entityNames().size()) {
            throw new IllegalArgumentException("An entity name must be specified for every entity type");
        }
        try {
            if (opts.options.has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    private void verifyClusterLinkingPropertyAndFilters(Properties propsToBeAdded, String propName, String propFilterName, ConfigCommand.ConfigCommandOptions opts) {
        boolean propValue = propsToBeAdded.getProperty(propName, "false").equals("true");
        String propFilterJsonValue = propsToBeAdded.getProperty(propFilterName, "");
        if (propValue && propFilterJsonValue.trim().isEmpty()) {
            opts.printMessageAndExit(new StringBuilder(167).append(propName).append(" is set to true but the JSON filters are not passed in. Please pass").append(" in the path to the JSON file using the --add-config-file option and rerun the alter config command.").toString());
            return;
        }
    }

    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        String entityTypeHead = (String)entityTypes.head();
        String entityNameHead = (String)entityNames.head();
        Properties configsToBeAddedProps = this.parseConfigsToBeAdded(opts);
        scala.collection.immutable.Map configsToBeAddedMap = ((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAddedProps).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map configsToBeAdded = (scala.collection.immutable.Map)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        if ("topics".equals(entityTypeHead) ? true : "cluster-links".equals(entityTypeHead)) {
            Seq invalidConfigs;
            ConfigResource.Type resourceType;
            scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String string = entityTypeHead;
            String string2 = "topics";
            ConfigResource.Type type = resourceType = string != null && string.equals(string2) ? ConfigResource.Type.TOPIC : ConfigResource.Type.CLUSTER_LINK;
            ConfigResource.Type type2 = ConfigResource.Type.CLUSTER_LINK;
            if (!(type != null ? !type.equals(type2) : type2 != null) && oldConfig.get((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()).forall((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$3(m)))) {
                this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), ClusterLinkConfig$.MODULE$.AclFiltersProp(), opts);
                this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), opts);
                this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), ClusterLinkConfig$.MODULE$.TopicFiltersProp(), opts);
            }
            if ((invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)))).nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            ConfigResource configResource = new ConfigResource(resourceType, entityNameHead);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            Collection alterEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$7 -> new AlterConfigOp(x$7, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
            Void cfr_ignored_0 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else if ("brokers".equals(entityTypeHead)) {
            scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
            scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$9(x$8)));
            if (sensitiveEntries.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
            }
            Config newConfig = new Config(((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityNameHead);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            Void cfr_ignored_1 = (Void)adminClient.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string = this.BrokerLoggerConfigType();
            if (!(string != null ? !string.equals(entityTypeHead) : entityTypeHead != null)) {
                Seq validLoggers = (Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Seq$.MODULE$.canBuildFrom());
                Seq invalidBrokerLoggers = (Seq)((TraversableLike)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((GenTraversableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))), Seq$.MODULE$.canBuildFrom());
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString(",")).toString());
                }
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Collection alterLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$10 -> new AlterConfigOp(x$10, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                Void cfr_ignored_2 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterLogLevelEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else if ("users".equals(entityTypeHead) ? true : "clients".equals(entityTypeHead)) {
                boolean hasQuotaConfigsToAdd = configsToBeAdded.keys().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(QuotaConfigs.isClientOrUserQuotaConfig((String)x$1))));
                scala.collection.immutable.Map scramConfigsToAddMap = (scala.collection.immutable.Map)configsToBeAdded.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$16(entry)));
                Iterable unknownConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$17(key)));
                boolean hasQuotaConfigsToDelete = configsToBeDeleted.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(QuotaConfigs.isClientOrUserQuotaConfig((String)x$1))));
                Seq scramConfigsToDelete = (Seq)configsToBeDeleted.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$19(x$1)));
                Seq unknownConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$20(key)));
                String string3 = entityTypeHead;
                String string4 = "clients";
                if (string3 != null && string3.equals(string4) || entityTypes.size() == 2) {
                    if (unknownConfigsToAdd.nonEmpty() || scramConfigsToAddMap.nonEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(97).append("Only quota configs can be added for '").append("clients").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd.$plus$plus((GenTraversableOnce)scramConfigsToAddMap.keys(), Iterable$.MODULE$.canBuildFrom())).toString());
                    }
                    if (unknownConfigsToDelete.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(99).append("Only quota configs can be deleted for '").append("clients").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete.$plus$plus((GenTraversableOnce)scramConfigsToDelete, Seq$.MODULE$.canBuildFrom())).toString());
                    }
                } else {
                    if (unknownConfigsToAdd.nonEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(116).append("Only quota and SCRAM credential configs can be added for '").append("users").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd).toString());
                    }
                    if (unknownConfigsToDelete.nonEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(118).append("Only quota and SCRAM credential configs can be deleted for '").append("users").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete).toString());
                    }
                    if (scramConfigsToAddMap.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                        if (entityNames.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isEmpty()))) {
                            throw new IllegalArgumentException("The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.");
                        }
                        if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                            throw new IllegalArgumentException(new StringBuilder(105).append("Cannot alter both quota and SCRAM credential configs simultaneously for '").append("users").append("' using --bootstrap-server.").toString());
                        }
                    }
                }
                if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                    this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                } else {
                    if (entityNames.size() != 1) {
                        throw new IllegalStateException(new StringBuilder(84).append("Altering user SCRAM credentials should never occur for more zero or multiple users: ").append(entityNames).toString());
                    }
                    this.alterUserScramCredentialConfigs(adminClient, (String)entityNames.head(), (Map<String, ConfigEntry>)scramConfigsToAddMap, (Seq<String>)scramConfigsToDelete);
                }
            } else if ("ips".equals(entityTypeHead)) {
                Iterable unknownConfigs = (Iterable)((TraversableLike)configsToBeAdded.keys().$plus$plus(configsToBeDeleted, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$22(key)));
                if (unknownConfigs.nonEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(104).append("Only connection quota configs can be added for '").append("ips").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigs.mkString(",")).toString());
                }
                this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
            } else if ("confluent-tenants".equals(entityTypeHead)) {
                Iterable unknownConfigs = (Iterable)((TraversableLike)configsToBeAdded.keys().$plus$plus(configsToBeDeleted, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$23(key)));
                if (unknownConfigs.nonEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(118).append("Only connection quota configs can be added for '").append("confluent-tenants").append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigs.mkString(",")).toString());
                }
                this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
            } else if ("client-metrics".equals(entityTypeHead)) {
                scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                if (invalidConfigs.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
                }
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Collection alterEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                Void cfr_ignored_3 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported entity type: ").append(entityTypeHead).toString());
            }
        }
        if (new StringOps(Predef$.MODULE$.augmentString(entityNameHead)).nonEmpty()) {
            System.out.println(new StringBuilder(32).append("Completed updating config for ").append(new StringOps(Predef$.MODULE$.augmentString(entityTypeHead)).dropRight(1)).append(" ").append(entityNameHead).append(".").toString());
            return;
        }
        System.out.println(new StringBuilder(54).append("Completed updating default config for ").append(entityTypeHead).append(" in the cluster.").toString());
    }

    private Void alterUserScramCredentialConfigs(Admin adminClient, String user, Map<String, ConfigEntry> scramConfigsToAddMap, Seq<String> scramConfigsToDelete) {
        Seq deletions = (Seq)scramConfigsToDelete.map((Function1 & Serializable & scala.Serializable)mechanismName -> new UserScramCredentialDeletion(user, ScramMechanism.fromMechanismName((String)mechanismName)), Seq$.MODULE$.canBuildFrom());
        Iterable upsertions = (Iterable)scramConfigsToAddMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                void var7_7;
                void var6_6;
                String mechanismName = (String)x0$1._1();
                ConfigEntry configEntry = (ConfigEntry)x0$1._2();
                Tuple2 tuple2 = this.iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName((String)mechanismName), configEntry.value());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Integer iterations = (Integer)tuple2._1();
                byte[] passwordBytes = (byte[])tuple2._2();
                void iterations2 = var6_6;
                void passwordBytes2 = var7_7;
                return new UserScramCredentialUpsertion(user, new ScramCredentialInfo(ScramMechanism.fromMechanismName((String)mechanismName), Predef$.MODULE$.Integer2int((Integer)iterations2)), (byte[])passwordBytes2);
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom());
        return (Void)adminClient.alterUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)deletions.$plus$plus((GenTraversableOnce)upsertions, Seq$.MODULE$.canBuildFrom())).toList()).asJava()).all().get(60L, TimeUnit.SECONDS);
    }

    private Void alterQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames, Map<String, String> configsToBeAddedMap, Seq<String> configsToBeDeleted) {
        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        List alterEntityTypes = (List)entityTypes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if ("users".equals(x0$1)) {
                return "user";
            }
            if ("clients".equals(x0$1)) {
                return "client-id";
            }
            if ("ips".equals(x0$1)) {
                return "ip";
            }
            if ("confluent-tenants".equals(x0$1)) {
                return "confluent-tenant";
            }
            throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected entity type: ").append((String)x0$1).toString());
        }, List$.MODULE$.canBuildFrom());
        List alterEntityNames = (List)entityNames.map((Function1 & Serializable & scala.Serializable)en -> {
            if (new StringOps(Predef$.MODULE$.augmentString(en)).nonEmpty()) {
                return en;
            }
            return null;
        }, List$.MODULE$.canBuildFrom());
        HashMap alterEntityMap = new HashMap();
        ((List)alterEntityTypes.zip((GenIterable)alterEntityNames, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return alterEntityMap.put(k, v);
            }
            throw new MatchError(null);
        });
        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
        Collection alterOps = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 != null) {
                double d;
                String key = (String)x0$3._1();
                String value = (String)x0$3._2();
                try {
                    d = new StringOps(Predef$.MODULE$.augmentString(value)).toDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Cannot parse quota configuration value for ").append(key).append(": ").append(value).toString());
                }
                double doubleValue = d;
                return new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(doubleValue));
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)key -> new ClientQuotaAlteration.Op(key, null), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
        return (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options.has((OptionSpec)opts.allOpt());
        String string = (String)entityTypes.head();
        if ("topics".equals(string)) {
            bl = true;
        } else if ("brokers".equals(string)) {
            bl = true;
        } else {
            String string2 = this.BrokerLoggerConfigType();
            bl = !(string2 != null ? !string2.equals(string) : string != null) ? true : ("cluster-links".equals(string) ? true : "client-metrics".equals(string));
        }
        if (bl) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), (Option<String>)entityNames.headOption(), describeAll);
            return;
        }
        if ("users".equals(string) ? true : "clients".equals(string)) {
            this.describeClientQuotaAndUserScramCredentialConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        if ("ips".equals(string) ? true : "confluent-tenants".equals(string)) {
            this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(string).toString());
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        ((Seq)entityName.map((Function1 & Serializable & scala.Serializable)name -> new .colon.colon(name, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl;
            if ("topics".equals(entityType)) {
                return ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala()).toSeq();
            }
            if ("brokers".equals(entityType)) {
                bl = true;
            } else {
                String string = MODULE$.BrokerLoggerConfigType();
                bl = !(string != null ? !string.equals(entityType) : entityType != null);
            }
            if (bl) {
                return (Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.idString(), Iterable$.MODULE$.canBuildFrom())).toSeq().$colon$plus((Object)MODULE$.BrokerDefaultEntityName(), Seq$.MODULE$.canBuildFrom());
            }
            if ("cluster-links".equals(entityType)) {
                ConfluentAdmin confluentAdminClient = (ConfluentAdmin)adminClient;
                return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)confluentAdminClient.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.linkName(), Iterable$.MODULE$.canBuildFrom())).toSeq();
            }
            if ("client-metrics".equals(entityType)) {
                return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.listClientMetricsResources().all().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.name(), Iterable$.MODULE$.canBuildFrom())).toSeq();
            }
            throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(entityType).toString());
        })).foreach((Function1 & Serializable & scala.Serializable)entity -> {
            ConfigCommand$.$anonfun$describeResourceConfig$6(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        void var7_8;
        void var6_7;
        Some some;
        ConfigResource.Type type;
        if ("topics".equals(entityType)) {
            if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
                Topic.validate((String)entityName);
            }
            type = ConfigResource.Type.TOPIC;
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
        } else if ("brokers".equals(entityType)) {
            String string = this.BrokerDefaultEntityName();
            if (!(string != null ? !string.equals(entityName) : entityName != null)) {
                type = ConfigResource.Type.BROKER;
                some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
            } else {
                ConfigCommand$.validateBrokerId$1(entityName, entityType);
                type = ConfigResource.Type.BROKER;
                some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
            }
        } else {
            String string = this.BrokerLoggerConfigType();
            if (!(string != null ? !string.equals(entityType) : entityType != null)) {
                if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                }
                type = ConfigResource.Type.BROKER_LOGGER;
                some = None$.MODULE$;
            } else if ("cluster-links".equals(entityType)) {
                ClusterLinkUtils$.MODULE$.validateLinkName(entityName);
                type = ConfigResource.Type.CLUSTER_LINK;
                some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_CLUSTER_LINK_CONFIG);
            } else if ("client-metrics".equals(entityType)) {
                type = ConfigResource.Type.CLIENT_METRICS;
                some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_CLIENT_METRICS_CONFIG);
            } else {
                throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(entityType).toString());
            }
        }
        Some some2 = some;
        ConfigResource.Type configResourceType = type;
        Option dynamicConfigSource = (Option)some2;
        void configResourceType2 = var6_7;
        void dynamicConfigSource2 = var7_8;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : dynamicConfigSource2;
        ConfigResource configResource = new ConfigResource((ConfigResource.Type)configResourceType2, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return (Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter(arg_0 -> ConfigCommand$.$anonfun$getResourceConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)entry -> entry.name(), (Ordering)Ordering.String$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private void describeQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> quotaConfigs = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(entity, entries) -> {
            ConfigCommand$.$anonfun$describeQuotaConfigs$1(entity, entries);
            return BoxedUnit.UNIT;
        };
        Map<ClientQuotaEntity, java.util.Map<String, Double>> map = Implicits$.MODULE$.MapExtensionMethods(quotaConfigs);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    private void describeClientQuotaAndUserScramCredentialConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
        if (!entityTypes.contains((Object)"clients") && !entityNames.contains((Object)"")) {
            DescribeUserScramCredentialsResult result = adminClient.describeUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(entityNames).asJava());
            ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)result.users().get(30L, TimeUnit.SECONDS)).asScala()).foreach((Function1 & Serializable & scala.Serializable)user -> {
                ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(result, user);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes.size() != entityNames.size()) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        return (Map)this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption().map((Function1 & Serializable & scala.Serializable)x$19 -> (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$19._2()).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        List components = (List)((List)((IterableLike)entityTypes.map((Function1 & Serializable & scala.Serializable)x$20 -> new Some(x$20), List$.MODULE$.canBuildFrom())).zipAll((GenIterable)entityNames.map((Function1 & Serializable & scala.Serializable)x$21 -> new Some(x$21), List$.MODULE$.canBuildFrom()), (Object)None$.MODULE$, (Object)None$.MODULE$, List$.MODULE$.canBuildFrom())).map(ConfigCommand$::$anonfun$getAllClientQuotasConfigs$3, List$.MODULE$.canBuildFrom());
        return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)components).asJava()))).entities().get(30L, TimeUnit.SECONDS)).asScala();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        List<String> entityNames;
        List<String> entityTypes;
        block3: {
            block2: {
                entityTypes = opts.entityTypes();
                entityNames = opts.entityNames();
                Object object = entityTypes.head();
                String string2 = "users";
                if (object != null && object.equals(string2)) break block2;
                Object object2 = entityTypes.head();
                String string3 = "clients";
                if (object2 == null || !object2.equals(string3)) break block3;
            }
            return this.parseClientQuotaEntity(opts, entityTypes, entityNames);
        }
        Option option = entityNames.headOption();
        Option name = option instanceof Some && "".equals(string = (String)((Some)option).value()) ? new Some((Object)"<default>") : option;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseClientQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options.has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = "clients";
        if (v0 != null && v0.equals(var5_4)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        entities = (List)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseClientQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames), List$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$1(ConfigCommand.Entity e) {
        return "clients".equals(e.entityType());
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$3(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$5(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$2$1).contains(elem);
    }

    /*
     * WARNING - void declaration
     */
    private final String scramCredential$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        void var5_5;
        void var6_6;
        String iterations;
        Option option = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r().unapplySeq((CharSequence)credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            String password = (String)((LinearSeqOptimized)option.get()).apply(1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int iterations2 = iterations != null ? new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt() : this.DefaultScramIterations();
        if (var6_6 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append((int)var6_6).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential((String)var5_5, (int)var6_6));
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$2(String x$1) {
        return Integer.parseInt(x$1);
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$1) {
        return Integer.parseInt(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((String)x0$1._1()).startsWith("password.encoder.");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(101).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ void $anonfun$describeConfigWithZk$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$3(ConfigEntry m) {
        return ClusterLinkConfig.LinkMode.fromString((String)m.value()).mayActAsDestination();
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$9(Tuple2 x$8) {
        return ((ConfigEntry)x$8._2()).value() == null;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$16(Tuple2 entry) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)((String)entry._1()));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$17(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfigs.isClientOrUserQuotaConfig((String)key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$19(String x$1) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$20(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfigs.isClientOrUserQuotaConfig((String)key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$22(String key) {
        return DynamicConfig$Ip$.MODULE$.names().contains(key);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$23(String key) {
        return DynamicConfig$Tenant$.MODULE$.names().contains(key);
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        void var5_5;
        void var6_6;
        String iterations;
        Option option = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=(\\-?[0-9]*),)?password=(.*)")).r().unapplySeq((CharSequence)credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            String password = (String)((LinearSeqOptimized)option.get()).apply(1);
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int iterations2 = iterations != null && !iterations.equals("-1") ? new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt() : this.DefaultScramIterations();
        if (var6_6 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append((int)var6_6).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism.mechanismName()).toString());
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer((int)var6_6), (Object)var5_5.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$7(ConfigEntry entry) {
        String synonyms = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(entry.synonyms()).asScala()).map((Function1 & Serializable & scala.Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        System.out.println(new StringBuilder(26).append("  ").append(entry.name()).append("=").append(entry.value()).append(" sensitive=").append(entry.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString());
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$6(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            System.out.println(new StringBuilder(40).append("Default configs for ").append(entityType$1).append(" in the cluster are:").toString());
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            System.out.println(new StringBuilder(19).append(configSourceStr).append(" configs for ").append(new StringOps(Predef$.MODULE$.augmentString(entityType$1)).dropRight(1)).append(" ").append(entity).append(" are:").toString());
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$7(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$1, String entityType$2) {
        try {
            new StringOps(Predef$.MODULE$.augmentString(entityName$1)).toInt();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(63).append("The entity name for ").append(entityType$2).append(" must be a valid integer broker id, found: ").append(entityName$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            return !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        }
        if (None$.MODULE$.equals(configSourceFilter$1)) {
            return true;
        }
        throw new MatchError((Object)configSourceFilter$1);
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        return entityEntries$1.get((Object)entityType).map((Function1 & Serializable & scala.Serializable)name -> {
            String string;
            if ("user".equals(entityType)) {
                string = "user-principal";
            } else if ("client-id".equals(entityType)) {
                string = "client-id";
            } else if ("ip".equals(entityType)) {
                string = "ip";
            } else if ("confluent-tenant".equals(entityType)) {
                string = "confluent-tenant";
            } else {
                throw new MatchError((Object)entityType);
            }
            String typeStr = string;
            if (name != null) {
                return new StringBuilder(3).append(typeStr).append(" '").append((String)name).append("'").toString();
            }
            return new StringBuilder(12).append("the default ").append(typeStr).toString();
        });
    }

    public static final /* synthetic */ void $anonfun$describeQuotaConfigs$1(ClientQuotaEntity entity, java.util.Map entries) {
        scala.collection.mutable.Map entityEntries = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity.entries()).asScala();
        String entityStr = ((TraversableOnce)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("client-id", entityEntries)), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("ip", entityEntries)), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("confluent-tenant", entityEntries)), Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        String entriesStr = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entries).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append(e._1()).append("=").append(e._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        System.out.println(new StringBuilder(23).append("Quota configs for ").append(entityStr).append(" are ").append(entriesStr).toString());
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(DescribeUserScramCredentialsResult result$1, String user) {
        try {
            UserScramCredentialsDescription description = (UserScramCredentialsDescription)result$1.description(user).get(30L, TimeUnit.SECONDS);
            String descriptionText = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(description.credentialInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> new StringBuilder(12).append(info.mechanism().mechanismName()).append("=iterations=").append(info.iterations()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
            System.out.println(new StringBuilder(51).append("SCRAM credential configs for user-principal '").append(user).append("' are ").append(descriptionText).toString());
            return;
        }
        catch (Exception e) {
            System.out.println(new StringBuilder(67).append("Error retrieving SCRAM credential configs for user-principal '").append(user).append("': ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block14: {
            if (x0$1 == null) break block14;
            entityTypeOpt = (Option)x0$1._1();
            entityNameOpt = (Option)x0$1._2();
            var4_3 = false;
            var5_4 = null;
            if (!(entityTypeOpt instanceof Some)) ** GOTO lbl-1000
            var4_3 = true;
            var5_4 = (Some)entityTypeOpt;
            var6_5 = (String)var5_4.value();
            if ("users".equals(var6_5)) {
                v0 = "user";
            } else if (var4_3 && "clients".equals(var7_6 = (String)var5_4.value())) {
                v0 = "client-id";
            } else if (var4_3 && "ips".equals(var8_7 = (String)var5_4.value())) {
                v0 = "ip";
            } else if (var4_3 && "confluent-tenants".equals(var9_8 = (String)var5_4.value())) {
                v0 = "confluent-tenant";
            } else {
                if (var4_3) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected entity type ").append(entityTypeOpt.get()).toString());
                }
                if (None$.MODULE$.equals(entityTypeOpt)) {
                    throw new IllegalArgumentException("More entity names specified than entity types");
                }
                throw new MatchError((Object)entityTypeOpt);
            }
            entityType = v0;
            var10_10 = false;
            var11_11 = null;
            if (entityNameOpt instanceof Some) {
                var10_10 = true;
                var11_11 = (Some)entityNameOpt;
                var12_12 = (String)var11_11.value();
                if ("".equals(var12_12)) {
                    return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                }
            }
            if (var10_10) {
                name = (String)var11_11.value();
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name);
            }
            if (None$.MODULE$.equals(entityNameOpt)) {
                return ClientQuotaFilterComponent.ofEntityType((String)entityType);
            }
            throw new MatchError((Object)entityNameOpt);
        }
        throw new MatchError(null);
    }

    private static final String sanitizeName$1(String entityType, String name) {
        if (name.isEmpty()) {
            return "<default>";
        }
        if ("users".equals(entityType) ? true : "clients".equals(entityType)) {
            return Sanitizer.sanitize((String)name);
        }
        throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseClientQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.BrokerDefaultEntityName = "";
        this.BrokerLoggerConfigType = "broker-loggers";
        this.kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes = (Buffer)((SeqLike)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ConfigType.ALL).asScala()).$colon$plus((Object)this.BrokerLoggerConfigType(), Buffer$.MODULE$.canBuildFrom())).$colon$plus((Object)"client-metrics", Buffer$.MODULE$.canBuildFrom());
        this.kafka$admin$ConfigCommand$$ZkSupportedConfigTypes = new .colon.colon((Object)"users", (List)new .colon.colon((Object)"brokers", (List)Nil$.MODULE$));
        this.DefaultScramIterations = 4096;
    }

    public static final /* synthetic */ Object $anonfun$alterConfigWithZk$3$adapted(Object[] eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$3(eta$0$1$1, elem));
    }

    public static final /* synthetic */ Object $anonfun$alterConfigWithZk$5$adapted(Object[] eta$0$2$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$5(eta$0$2$1, elem));
    }

    public static final /* synthetic */ Object $anonfun$getResourceConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter$1, entry));
    }
}

