/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\f\u0018\u0005qA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019I\u0005\u0001)A\u0005\u0007\"9!\n\u0001b\u0001\n\u0003\u0011\u0005BB&\u0001A\u0003%1\tC\u0004M\u0001\t\u0007I\u0011\u0001\"\t\r5\u0003\u0001\u0015!\u0003D\u0011\u001dq\u0005A1A\u0005\u0002\tCaa\u0014\u0001!\u0002\u0013\u0019\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u0007+\u0002\u0001\u000b\u0011\u0002*\t\u000fY\u0003!\u0019!C\u0001#\"1q\u000b\u0001Q\u0001\nICq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004Z\u0001\u0001\u0006IA\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001R\u0011\u0019Y\u0006\u0001)A\u0005%\")A\f\u0001C\u0001;\")\u0011\r\u0001C\u0005E\")A\u0010\u0001C\u0001{\n\u0001C*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t\u0015\tA\u0012$A\u0003bI6LgNC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005yAS\"A\u0010\u000b\u0005\u0001\n\u0013\u0001B;uS2T!AI\u0012\u0002\rM,'O^3s\u0015\tQBE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015 \u0005U\u0019u.\\7b]\u0012$UMZ1vYR|\u0005\u000f^5p]N\fA!\u0019:hgB\u0019AfL\u0019\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012Q!\u0011:sCf\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b.\u001b\u0005)$B\u0001\u001c\u001c\u0003\u0019a$o\\8u}%\u0011\u0001(L\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029[\u00051A(\u001b8jiz\"\"A\u0010!\u0011\u0005}\u0002Q\"A\f\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u001f\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ,\u0012a\u0011\t\u0004\t\u001e\u000bT\"A#\u000b\u0003\u0019\u000b!B[8qiNLW\u000e\u001d7f\u0013\tAUIA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003XmY\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<fe\u0002\n\u0001cY8n[\u0006tGmQ8oM&<w\n\u001d;\u0002#\r|W.\\1oI\u000e{gNZ5h\u001fB$\b%A\u0005sK\u0006\u001cxN\\(qi\u0006Q!/Z1t_:|\u0005\u000f\u001e\u0011\u0002\u0019\t\u0014xn[3s\u0013\u0012\u001cx\n\u001d;\u0002\u001b\t\u0014xn[3s\u0013\u0012\u001cx\n\u001d;!\u0003!1wN]2f\u001fB$X#\u0001*\u0011\u0005\u0011\u001b\u0016B\u0001+F\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\nM>\u00148-Z(qi\u0002\n\u0011\u0002Z3n_R,w\n\u001d;\u0002\u0015\u0011,Wn\u001c;f\u001fB$\b%\u0001\u0006qe>lw\u000e^3PaR\f1\u0002\u001d:p[>$Xm\u00149uA\u0005YA-Z:de&\u0014Wm\u00149u\u00031!Wm]2sS\n,w\n\u001d;!\u0003)1XM]5gs\u0006\u0013xm\u001d\u000b\u0002=B\u0011AfX\u0005\u0003A6\u0012A!\u00168ji\u0006\u0011b/\u001a:jMf\u0014V-];je\u0016$\u0017I]4t)\rq6\r\u001b\u0005\u0006IR\u0001\r!Z\u0001\b_B$\u0018n\u001c8t!\t!e-\u0003\u0002h\u000b\nIq\n\u001d;j_:\u001cV\r\u001e\u0005\u0006SR\u0001\rA[\u0001\te\u0016\fX/\u001b:fIB\u0019Af[7\n\u00051l#A\u0003\u001fsKB,\u0017\r^3e}A\u0012an\u001d\t\u0004\t>\f\u0018B\u00019F\u0005)y\u0005\u000f^5p]N\u0003Xm\u0019\t\u0003eNd\u0001\u0001B\u0005uQ\u0006\u0005\t\u0011!B\u0001k\n\u0019q\fJ\u0019\u0012\u0005YL\bC\u0001\u0017x\u0013\tAXFA\u0004O_RD\u0017N\\4\u0011\u00051R\u0018BA>.\u0005\r\te._\u0001\tM2\fwMT1nKR\u0011\u0011G \u0005\u0007\u007fV\u0001\r!!\u0001\u0002\r=\u0004H/[8oa\u0011\t\u0019!a\u0002\u0011\t\u0011{\u0017Q\u0001\t\u0004e\u0006\u001dAACA\u0005}\u0006\u0005\t\u0011!B\u0001k\n\u0019q\f\n\u001a")
public final class LeadershipPriorityCommandOptions
extends CommandDefaultOptions {
    private final ArgumentAcceptingOptionSpec<String> bootstrapServer;
    private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
    private final ArgumentAcceptingOptionSpec<String> reasonOpt;
    private final ArgumentAcceptingOptionSpec<String> brokerIdsOpt;
    private final OptionSpecBuilder forceOpt;
    private final OptionSpecBuilder demoteOpt;
    private final OptionSpecBuilder promoteOpt;
    private final OptionSpecBuilder describeOpt;

    public ArgumentAcceptingOptionSpec<String> bootstrapServer() {
        return this.bootstrapServer;
    }

    public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
        return this.commandConfigOpt;
    }

    public ArgumentAcceptingOptionSpec<String> reasonOpt() {
        return this.reasonOpt;
    }

    public ArgumentAcceptingOptionSpec<String> brokerIdsOpt() {
        return this.brokerIdsOpt;
    }

    public OptionSpecBuilder forceOpt() {
        return this.forceOpt;
    }

    public OptionSpecBuilder demoteOpt() {
        return this.demoteOpt;
    }

    public OptionSpecBuilder promoteOpt() {
        return this.promoteOpt;
    }

    public OptionSpecBuilder describeOpt() {
        return this.describeOpt;
    }

    public void verifyArgs() {
        if (new .colon.colon((Object)this.demoteOpt(), (List)new .colon.colon((Object)this.promoteOpt(), (List)new .colon.colon((Object)this.describeOpt(), (List)Nil$.MODULE$))).count((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.options.has(x$1))) != 1) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Command must include exactly one action: ").append(this.flagName((OptionSpec<?>)this.demoteOpt())).append(", ").append(this.flagName((OptionSpec<?>)this.promoteOpt())).append(", OR ").append(this.flagName((OptionSpec<?>)this.describeOpt())).append(".").toString());
        }
        if (this.options.has((OptionSpec)this.demoteOpt()) || this.options.has((OptionSpec)this.promoteOpt())) {
            this.verifyRequiredArgs(this.options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer(), this.reasonOpt(), this.brokerIdsOpt()}));
            return;
        }
        if (this.options.has((OptionSpec)this.describeOpt())) {
            this.verifyRequiredArgs(this.options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer()}));
            if (this.options.has(this.reasonOpt())) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Describe cannot be used with ").append(this.flagName((OptionSpec<?>)this.reasonOpt())).append("!").toString());
            }
            if (this.options.has(this.brokerIdsOpt())) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Describe cannot be used with ").append(this.flagName((OptionSpec<?>)this.brokerIdsOpt())).append("!").toString());
            }
            return;
        }
    }

    private void verifyRequiredArgs(OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1 & java.io.Serializable & Serializable)arg -> {
            LeadershipPriorityCommandOptions.$anonfun$verifyRequiredArgs$1(options, arg);
            return BoxedUnit.UNIT;
        });
    }

    public String flagName(OptionSpec<?> option) {
        return new StringBuilder(2).append("--").append(option.options().get(0)).toString();
    }

    public static final /* synthetic */ void $anonfun$verifyRequiredArgs$1(OptionSet options$1, OptionSpec arg) {
        if (!options$1.has(arg)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Missing required argument '").append(arg).append("'").toString());
        }
    }

    public LeadershipPriorityCommandOptions(String[] args) {
        super(args);
        this.bootstrapServer = this.parser.accepts("bootstrap-server", "A hostname and port for the broker to connect to, in the form host:port. Multiple comma separated URLs can be given. REQUIRED.").withRequiredArg().describedAs("host:port").ofType(String.class);
        this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("file").ofType(String.class);
        this.reasonOpt = this.parser.accepts("reason", "Reason for changing leadership priority. Valid characters for the reason are the ASCII alphanumerics, '.', '_', and '-'. The string cannot start with the '.' character and must be between 1-32 characters. Example: operator").withRequiredArg().describedAs("reason").ofType(String.class);
        this.brokerIdsOpt = this.parser.accepts("broker-ids", "Comma separated non-negative integers representing a non-empty list of broker ids to change leadership priority.").withRequiredArg().describedAs("id1, id2, id3, ...").ofType(String.class);
        this.forceOpt = this.parser.accepts("force", "Whether the operation will be forced if the cluster has already reached the max number of brokers that can be demoted.");
        this.demoteOpt = this.parser.accepts("demote", "Demote brokers with normal priority. Demoted brokers will be less preferred as partition leaders compared to brokers with normal leadership priority.");
        this.promoteOpt = this.parser.accepts("promote", "Promote brokers with demoted priority. Brokers with normal leadership priority are more preferred as partition leaders compared to demoted brokers.");
        this.describeOpt = this.parser.accepts("describe", "Describe demoted brokers. Demote brokers with normal priority. Demoted brokers are less preferred as partition leaders compared to brokers with normal leadership priority.");
        this.options = this.parser.parse(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps makes calls to Leadership Priority API. It changes leadership priority and describes demoted brokers. Demoted brokers will be less preferred as partition leaders compared to brokers with normal leadership priority.");
        this.verifyArgs();
    }
}

