/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.Kafka$;
import kafka.common.TenantHelpers;
import kafka.controller.PartitionSLOMetrics;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;

public final class PartitionSLOMetrics$ {
    public static PartitionSLOMetrics$ MODULE$;
    private final HashMap<String, PartitionSLOMetrics> partitionMetricsMap;
    private int brokerId;
    private final String globalPartitionMetricsKey;
    private boolean isActiveController;
    private boolean isMultiTenantCluster;
    private final String TenantPartitionAvailabilitySLOMetric;
    private final String GlobalPartitionAvailabilityMetric;
    private final String GlobalUnderMinIsrPartitionCountMetric;
    private final String GlobalPartitionCountMetric;
    private final String GlobalOfflinePartitionsCount;

    static {
        new PartitionSLOMetrics$();
    }

    private HashMap<String, PartitionSLOMetrics> partitionMetricsMap() {
        return this.partitionMetricsMap;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private void brokerId_$eq(int x$1) {
        this.brokerId = x$1;
    }

    private String globalPartitionMetricsKey() {
        return this.globalPartitionMetricsKey;
    }

    public boolean isActiveController() {
        return this.isActiveController;
    }

    public void isActiveController_$eq(boolean x$1) {
        this.isActiveController = x$1;
    }

    public boolean isMultiTenantCluster() {
        return this.isMultiTenantCluster;
    }

    public void isMultiTenantCluster_$eq(boolean x$1) {
        this.isMultiTenantCluster = x$1;
    }

    public String TenantPartitionAvailabilitySLOMetric() {
        return this.TenantPartitionAvailabilitySLOMetric;
    }

    public String GlobalPartitionAvailabilityMetric() {
        return this.GlobalPartitionAvailabilityMetric;
    }

    public String GlobalUnderMinIsrPartitionCountMetric() {
        return this.GlobalUnderMinIsrPartitionCountMetric;
    }

    public String GlobalPartitionCountMetric() {
        return this.GlobalPartitionCountMetric;
    }

    public String GlobalOfflinePartitionsCount() {
        return this.GlobalOfflinePartitionsCount;
    }

    public HashMap<String, PartitionSLOMetrics> getPartitionMetricsMap() {
        return this.partitionMetricsMap();
    }

    public Option<PartitionSLOMetrics> getPartitionMetrics(String key) {
        return this.partitionMetricsMap().get((Object)key);
    }

    public PartitionSLOMetrics apply(boolean perTenantMetrics, Map<String, String> tags) {
        PartitionSLOMetrics metricsInstance = new PartitionSLOMetrics(perTenantMetrics, tags);
        metricsInstance.createMetrics();
        return metricsInstance;
    }

    public void onControllerChange(int broker, boolean activeController, boolean multiTenant) {
        this.isActiveController_$eq(activeController);
        this.isMultiTenantCluster_$eq(multiTenant);
        this.brokerId_$eq(broker);
        Kafka$ kafka$ = Kafka$.MODULE$;
        if (kafka$ == null) {
            throw null;
        }
        Kafka$ info_this = kafka$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent(PartitionSLOMetrics$.$anonfun$onControllerChange$1()));
        }
        if (this.isActiveController()) {
            this.getOrCreateMetrics(this.globalPartitionMetricsKey(), false);
            return;
        }
        Kafka$ kafka$2 = Kafka$.MODULE$;
        if (kafka$2 == null) {
            throw null;
        }
        Kafka$ info_this2 = kafka$2;
        if (info_this2.logger().underlying().isInfoEnabled()) {
            info_this2.logger().underlying().info(info_this2.msgWithLogIdent(PartitionSLOMetrics$.$anonfun$onControllerChange$2()));
        }
        this.partitionMetricsMap().foreach((Function1 & java.io.Serializable & Serializable)p -> {
            PartitionSLOMetrics$.$anonfun$onControllerChange$3(p);
            return BoxedUnit.UNIT;
        });
        this.partitionMetricsMap().clear();
    }

    public void updateGlobalPartitionMetrics(int partitionCount, int offlineCount, int underMinIsrCount) {
        Option tm = this.partitionMetricsMap().get((Object)this.globalPartitionMetricsKey());
        if (tm.isDefined()) {
            ((PartitionSLOMetrics)tm.get()).update(partitionCount, offlineCount, underMinIsrCount);
            return;
        }
    }

    public void updateTenantPartitionMetrics(String topic, int partitionCount, int offlinePartitionCount, int underMinIsrPartitionCount) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & java.io.Serializable & Serializable)tm -> {
            tm.update(partitionCount, offlinePartitionCount, underMinIsrPartitionCount);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantPartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & java.io.Serializable & Serializable)tm -> {
            tm.updatePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantOfflinePartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & java.io.Serializable & Serializable)tm -> {
            tm.updateOfflinePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantUnderMinIsrCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1 & java.io.Serializable & Serializable)tm -> {
            tm.updateUnderMinIsrCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    private Option<PartitionSLOMetrics> getTenantPartitionMetrics(String topic) {
        Option tenantName = Option$.MODULE$.apply((Object)TenantHelpers.extractTenantPrefix(topic, false));
        if (this.isMultiTenantCluster() && this.isActiveController() && tenantName.isDefined()) {
            return Option$.MODULE$.apply((Object)this.getOrCreateMetrics((String)tenantName.get(), this.getOrCreateMetrics$default$2()));
        }
        return None$.MODULE$;
    }

    private PartitionSLOMetrics getOrCreateMetrics(String name, boolean perTenantMetrics) {
        return (PartitionSLOMetrics)this.partitionMetricsMap().getOrElseUpdate((Object)name, (Function0 & java.io.Serializable & Serializable)() -> MODULE$.apply(perTenantMetrics, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)name)})))));
    }

    private boolean getOrCreateMetrics$default$2() {
        return true;
    }

    public static final /* synthetic */ String $anonfun$onControllerChange$1() {
        return new StringBuilder(123).append("Partition SLO metrics processing controller change event for the broker ").append(MODULE$.brokerId()).append(" with flags [isActiveController: ").append(MODULE$.isActiveController()).append(", isMultiTenant: ").append(MODULE$.isMultiTenantCluster()).append("]").toString();
    }

    public static final /* synthetic */ String $anonfun$onControllerChange$2() {
        return new StringBuilder(56).append("Unregistering the Partition SLO metrics from the broker ").append(MODULE$.brokerId()).toString();
    }

    public static final /* synthetic */ void $anonfun$onControllerChange$3(Tuple2 p) {
        ((PartitionSLOMetrics)p._2()).removeMetrics();
    }

    private PartitionSLOMetrics$() {
        MODULE$ = this;
        this.partitionMetricsMap = HashMap$.MODULE$.empty();
        this.brokerId = 0;
        this.globalPartitionMetricsKey = new StringBuilder(7).append("global_").append(Uuid.randomUuid().toString()).toString();
        this.isActiveController = false;
        this.isMultiTenantCluster = false;
        this.TenantPartitionAvailabilitySLOMetric = "TenantPartitionAvailability";
        this.GlobalPartitionAvailabilityMetric = "PartitionAvailability";
        this.GlobalUnderMinIsrPartitionCountMetric = "GlobalUnderMinIsrPartitionCount";
        this.GlobalPartitionCountMetric = "GlobalPartitionCount";
        this.GlobalOfflinePartitionsCount = "OfflinePartitionsCount";
    }
}

