/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$All$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Sample$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r=sAB$I\u0011\u0003AeJ\u0002\u0004Q\u0011\"\u0005\u0001*\u0015\u0005\u00061\u0006!\tA\u0017\u0005\u00067\u0006!\t\u0001\u0018\u0005\u00077\u0006!\ta!\u0005\t\rm\u000bA\u0011AB\u0010\u0011\u001d\u0019\t$\u0001C\u0001\u0007gA\u0011ba\u000e\u0002#\u0003%\ta!\u000f\u0007\u000bAC\u0005\u0001\u00130\t\u0011\u0015D!Q1A\u0005\u0002\u0019D\u0001B\u001d\u0005\u0003\u0002\u0003\u0006Ia\u001a\u0005\tg\"\u0011\t\u0019!C\u0001i\"A\u0001\u0010\u0003BA\u0002\u0013\u0005\u0011\u0010\u0003\u0005\u0000\u0011\t\u0005\t\u0015)\u0003v\u0011%\t\t\u0001\u0003BA\u0002\u0013\u0005A\u000f\u0003\u0006\u0002\u0004!\u0011\t\u0019!C\u0001\u0003\u000bA\u0011\"!\u0003\t\u0005\u0003\u0005\u000b\u0015B;\t\u0015\u0005-\u0001B!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0016!\u0011\t\u0019!C\u0001\u0003/A!\"a\u0007\t\u0005\u0003\u0005\u000b\u0015BA\b\u0011)\ti\u0002\u0003BA\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003?A!\u00111A\u0005\u0002\u0005\u0005\u0002BCA\u0013\u0011\t\u0005\t\u0015)\u0003\u0002\u0010!Q\u0011q\u0005\u0005\u0003\u0002\u0004%\t!!\u000b\t\u0015\u0005E\u0002B!a\u0001\n\u0003\t\u0019\u0004\u0003\u0006\u00028!\u0011\t\u0011)Q\u0005\u0003WA!\"!\u000f\t\u0005\u0003\u0007I\u0011AA\u001e\u0011)\t\u0019\u0005\u0003BA\u0002\u0013\u0005\u0011Q\t\u0005\u000b\u0003\u0013B!\u0011!Q!\n\u0005u\u0002BCA*\u0011\t\u0015\r\u0011\"\u0001\u0002V!Q\u0011Q\u0010\u0005\u0003\u0002\u0003\u0006I!a\u0016\t\u0013\u0005}\u0004B!a\u0001\n\u0003!\bBCAA\u0011\t\u0005\r\u0011\"\u0001\u0002\u0004\"I\u0011q\u0011\u0005\u0003\u0002\u0003\u0006K!\u001e\u0005\n\u0003\u0017C!\u00111A\u0005\u0002QD!\"!$\t\u0005\u0003\u0007I\u0011AAH\u0011%\t\u0019\n\u0003B\u0001B\u0003&Q\u000f\u0003\u0004Y\u0011\u0011\u0005\u0011q\u0013\u0005\n\u0003[C\u0001\u0019!C\u0001\u0003_C\u0011\"a.\t\u0001\u0004%\t!!/\t\u0011\u0005u\u0006\u0002)Q\u0005\u0003cC\u0011\"!1\t\u0001\u0004%\t!a1\t\u0013\u0005-\u0007\u00021A\u0005\u0002\u00055\u0007\u0002CAi\u0011\u0001\u0006K!!2\t\u0015\u0005M\u0007B1A\u0005\u0002!\u000b)\u000e\u0003\u0005\u0002p\"\u0001\u000b\u0011BAl\u0011\u001d\t\t\u0010\u0003C\u0001\u0003gDqAa\u0006\t\t\u0003\u0011I\u0002C\u0004\u0003&!!\tAa\n\t\u000f\t5\u0002\u0002\"\u0001\u00030!9!q\u0007\u0005\u0005\u0002\t=\u0002b\u0002B\u001d\u0011\u0011\u0005!1\b\u0005\b\u0005SBA\u0011\u0001B6\u0011\u001d\u0011I\b\u0003C\u0001\u0005wBqA!$\t\t\u0003\u0011y\tC\u0004\u0003\u0018\"!\tA!'\t\u000f\tu\u0005\u0002\"\u0001\u00030!9!q\u0014\u0005\u0005\u0002\u0005\r\u0007b\u0002BQ\u0011\u0011\u0005\u00111\u0019\u0005\b\u0005GCA\u0011BAb\u0011\u001d\u0011)\u000b\u0003C\u0001\u0005OCqA!1\t\t\u0003\u0011\u0019\rC\u0004\u0003J\"!IAa3\t\u000f\t=\u0007\u0002\"\u0003\u0003R\"9!Q\u001b\u0005\u0005\n\t]\u0007b\u0002Bo\u0011\u0011\u0005\u00111\u0019\u0005\b\u0005?DA\u0011BAb\u0011\u001d\u0011\t\u000f\u0003C\u0001\u0005GDqA!9\t\t\u0003\u0012y\u000fC\u0004\u0003r\"!\tEa=\t\u000f\te\b\u0002\"\u0011\u0003|\u0006\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC*\u0011\u0011JS\u0001\fiJ\fgn]1di&|gN\u0003\u0002L\u0019\u0006Y1m\\8sI&t\u0017\r^8s\u0015\u0005i\u0015!B6bM.\f\u0007CA(\u0002\u001b\u0005A%a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7CA\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001O\u0003\u0015\t\u0007\u000f\u001d7z)-i6QAB\u0004\u0007\u0013\u0019Ya!\u0004\u0011\u0005=C1c\u0001\u0005S?B\u0011\u0001mY\u0007\u0002C*\u0011!\rT\u0001\u0006kRLGn]\u0005\u0003I\u0006\u0014q\u0001T8hO&tw-A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u00059\u0007C\u00015p\u001d\tIW\u000e\u0005\u0002k)6\t1N\u0003\u0002m3\u00061AH]8pizJ!A\u001c+\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]R\u000b\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\u0002\u0015A\u0014x\u000eZ;dKJLE-F\u0001v!\t\u0019f/\u0003\u0002x)\n!Aj\u001c8h\u00039\u0001(o\u001c3vG\u0016\u0014\u0018\nZ0%KF$\"A_?\u0011\u0005M[\u0018B\u0001?U\u0005\u0011)f.\u001b;\t\u000fyd\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010J\u0019\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u000fY\u0006\u001cH\u000f\u0015:pIV\u001cWM]%e\u0003Ia\u0017m\u001d;Qe>$WoY3s\u0013\u0012|F%Z9\u0015\u0007i\f9\u0001C\u0004\u007f\u001f\u0005\u0005\t\u0019A;\u0002\u001f1\f7\u000f\u001e)s_\u0012,8-\u001a:JI\u0002\nQ\u0002\u001d:pIV\u001cWM]#q_\u000eDWCAA\b!\r\u0019\u0016\u0011C\u0005\u0004\u0003'!&!B*i_J$\u0018!\u00059s_\u0012,8-\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0019!0!\u0007\t\u0011y\u0014\u0012\u0011!a\u0001\u0003\u001f\ta\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007%A\tmCN$\bK]8ek\u000e,'/\u00129pG\"\fQ\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2i?\u0012*\u0017\u000fF\u0002{\u0003GA\u0001B`\u000b\u0002\u0002\u0003\u0007\u0011qB\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0007%\u0001\u0007uq:$\u0016.\\3pkRl5/\u0006\u0002\u0002,A\u00191+!\f\n\u0007\u0005=BKA\u0002J]R\f\u0001\u0003\u001e=o)&lWm\\;u\u001bN|F%Z9\u0015\u0007i\f)\u0004\u0003\u0005\u007f1\u0005\u0005\t\u0019AA\u0016\u00035!\bP\u001c+j[\u0016|W\u000f^'tA\u0005)1\u000f^1uKV\u0011\u0011Q\b\t\u0004\u001f\u0006}\u0012bAA!\u0011\n\u0001BK]1og\u0006\u001cG/[8o'R\fG/Z\u0001\ngR\fG/Z0%KF$2A_A$\u0011!q8$!AA\u0002\u0005u\u0012AB:uCR,\u0007\u0005K\u0002\u001d\u0003\u001b\u00022aUA(\u0013\r\t\t\u0006\u0016\u0002\tm>d\u0017\r^5mK\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002XA1\u0011\u0011LA2\u0003Oj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\b[V$\u0018M\u00197f\u0015\r\t\t\u0007V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA3\u00037\u00121aU3u!\u0011\tI'!\u001f\u000e\u0005\u0005-$\u0002BA7\u0003_\naaY8n[>t'bA'\u0002r)!\u00111OA;\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qO\u0001\u0004_J<\u0017\u0002BA>\u0003W\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c8tA\u0005\tB\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\u0002+QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019!0!\"\t\u000fy\u0004\u0013\u0011!a\u0001k\u0006\u0011B\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!Q\r\t\u0013QJ\u0001\u0017ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0006QB\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019!0!%\t\u000fy\u001c\u0013\u0011!a\u0001k\u00069B\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0004I\u00055C#F/\u0002\u001a\u0006m\u0015QTAP\u0003C\u000b\u0019+!*\u0002(\u0006%\u00161\u0016\u0005\u0006K\u0016\u0002\ra\u001a\u0005\u0006g\u0016\u0002\r!\u001e\u0005\u0007\u0003\u0003)\u0003\u0019A;\t\u000f\u0005-Q\u00051\u0001\u0002\u0010!9\u0011QD\u0013A\u0002\u0005=\u0001bBA\u0014K\u0001\u0007\u00111\u0006\u0005\b\u0003s)\u0003\u0019AA\u001f\u0011\u001d\t\u0019&\na\u0001\u0003/B\u0001\"a &!\u0003\u0005\r!\u001e\u0005\u0007\u0003\u0017+\u0003\u0019A;\u0002\u0019A,g\u000eZ5oON#\u0018\r^3\u0016\u0005\u0005E\u0006#B*\u00024\u0006u\u0012bAA[)\n1q\n\u001d;j_:\f\u0001\u0003]3oI&twm\u0015;bi\u0016|F%Z9\u0015\u0007i\fY\f\u0003\u0005\u007fO\u0005\u0005\t\u0019AAY\u00035\u0001XM\u001c3j]\u001e\u001cF/\u0019;fA!\u001a\u0001&!\u0014\u0002'!\f7OR1jY\u0016$W\t]8dQ\u001a+gnY3\u0016\u0005\u0005\u0015\u0007cA*\u0002H&\u0019\u0011\u0011\u001a+\u0003\u000f\t{w\u000e\\3b]\u00069\u0002.Y:GC&dW\rZ#q_\u000eDg)\u001a8dK~#S-\u001d\u000b\u0004u\u0006=\u0007\u0002\u0003@+\u0003\u0003\u0005\r!!2\u0002)!\f7OR1jY\u0016$W\t]8dQ\u001a+gnY3!\u0003\u0011awnY6\u0016\u0005\u0005]\u0007\u0003BAm\u0003Wl!!a7\u000b\t\u0005u\u0017q\\\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003C\f\u0019/\u0001\u0006d_:\u001cWO\u001d:f]RTA!!:\u0002h\u0006!Q\u000f^5m\u0015\t\tI/\u0001\u0003kCZ\f\u0017\u0002BAw\u00037\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013AB5o\u0019>\u001c7.\u0006\u0003\u0002v\u0006mH\u0003BA|\u0005\u001b\u0001B!!?\u0002|2\u0001AaBA\u007f]\t\u0007\u0011q \u0002\u0002)F!!\u0011\u0001B\u0004!\r\u0019&1A\u0005\u0004\u0005\u000b!&a\u0002(pi\"Lgn\u001a\t\u0004'\n%\u0011b\u0001B\u0006)\n\u0019\u0011I\\=\t\u0011\t=a\u0006\"a\u0001\u0005#\t1AZ;o!\u0015\u0019&1CA|\u0013\r\u0011)\u0002\u0016\u0002\ty\tLh.Y7f}\u0005i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$2A\u001fB\u000e\u0011\u001d\u0011ib\fa\u0001\u0005?\t!\u0002]1si&$\u0018n\u001c8t!\u0019\u0011\tCa\t\u0002h5\u0011\u0011qL\u0005\u0005\u0003K\ny&A\bsK6|g/\u001a)beRLG/[8o)\rQ(\u0011\u0006\u0005\b\u0005W\u0001\u0004\u0019AA4\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003\u001d:fa\u0006\u0014XMT8Ue\u0006t7/\u001b;\u0015\u0005\tE\u0002cA(\u00034%\u0019!Q\u0007%\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/Y\u0001\u001aaJ,\u0007/\u0019:f\r\u0016t7-\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007.A\u000fqe\u0016\u0004\u0018M]3J]\u000e\u0014X-\\3oiB\u0013x\u000eZ;dKJ,\u0005o\\2i)!\u0011iDa\u0017\u0003`\t\u0015\u0004\u0003\u0003B \u0005\u0013\u0012yE!\r\u000f\t\t\u0005#Q\t\b\u0004U\n\r\u0013\"A+\n\u0007\t\u001dC+A\u0004qC\u000e\\\u0017mZ3\n\t\t-#Q\n\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\t\u001dC\u000b\u0005\u0003\u0003R\t]SB\u0001B*\u0015\u0011\u0011)&a\u001b\u0002\u0011A\u0014x\u000e^8d_2LAA!\u0017\u0003T\t1QI\u001d:peNDqA!\u00184\u0001\u0004\tY#A\boK^$\u0006P\u001c+j[\u0016|W\u000f^'t\u0011\u001d\u0011\tg\ra\u0001\u0005G\nQ#\u001a=qK\u000e$X\r\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0003T\u0003g\u000by\u0001\u0003\u0004\u0003hM\u0002\r!^\u0001\u0010kB$\u0017\r^3US6,7\u000f^1na\u0006I\u0002O]3qCJ,\u0007K]8ek\u000e,'/\u00133S_R\fG/[8o))\u0011\tD!\u001c\u0003r\tM$Q\u000f\u0005\u0007\u0005_\"\u0004\u0019A;\u0002\u001b9,w\u000f\u0015:pIV\u001cWM]%e\u0011\u001d\u0011i\u0006\u000ea\u0001\u0003WAaAa\u001a5\u0001\u0004)\bb\u0002B<i\u0001\u0007\u0011QY\u0001\u0010e\u0016\u001cwN\u001d3MCN$X\t]8dQ\u0006!\u0002O]3qCJ,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$bA!\r\u0003~\t-\u0005b\u0002B@k\u0001\u0007!\u0011Q\u0001\u0015C\u0012$W\r\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\t\r%\u0011RA4\u001b\t\u0011)I\u0003\u0003\u0003\b\u0006}\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\t)G!\"\t\r\t\u001dT\u00071\u0001v\u0003Q\u0001(/\u001a9be\u0016\f%m\u001c:u\u001fJ\u001cu.\\7jiR1!\u0011\u0007BI\u0005+CqAa%7\u0001\u0004\ti$\u0001\u0005oK^\u001cF/\u0019;f\u0011\u0019\u00119G\u000ea\u0001k\u0006y\u0001O]3qCJ,7i\\7qY\u0016$X\r\u0006\u0003\u00032\tm\u0005B\u0002B4o\u0001\u0007Q/A\u0006qe\u0016\u0004\u0018M]3EK\u0006$\u0017\u0001G5t!J|G-^2fe\u0016\u0003xn\u00195Fq\"\fWo\u001d;fI\u0006q\u0012n\u001d#jgR\u0014\u0018NY;uK\u0012$vo\u001c)iCN,7i\\7nSR$\u0006P\\\u0001\u0016Q\u0006\u001c\b+\u001a8eS:<GK]1og\u0006\u001cG/[8o\u0003M\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+p)I\u0011\tD!+\u0003,\n5&\u0011\u0017B[\u0005o\u0013YLa0\t\u000f\tME\b1\u0001\u0002>!1!q\u000e\u001fA\u0002UDqAa,=\u0001\u0004\ty!\u0001\u0005oK^,\u0005o\\2i\u0011\u001d\u0011\u0019\f\u0010a\u0001\u0003\u001f\tAB\\3x\u0019\u0006\u001cH/\u00129pG\"DqA!\u0018=\u0001\u0004\tY\u0003C\u0004\u0003:r\u0002\rA!!\u0002%9,w\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0005{c\u0004\u0019A;\u0002)9,w\u000f\u0016=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u0019\u00119\u0007\u0010a\u0001k\u0006!2m\\7qY\u0016$X\r\u0016:b]NLG/[8o)>$2A\u001fBc\u0011\u001d\u00119-\u0010a\u0001\u0005c\tq\u0002\u001e:b]NLG/T3uC\u0012\fG/Y\u0001\u0013m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0002F\n5\u0007b\u0002Bd}\u0001\u0007!\u0011G\u0001\u0017m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007NQ;naR!\u0011Q\u0019Bj\u0011\u001d\u00119m\u0010a\u0001\u0005c\t1\u0004\u001e5s_^\u001cF/\u0019;f)J\fgn]5uS>tg)Y5mkJ,Gc\u0001>\u0003Z\"9!1\u001c!A\u0002\tE\u0012A\u0005;y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\f1\u0004]3oI&tw\r\u0016:b]NLG/[8o\u0013:\u0004&o\\4sKN\u001c\u0018aD5oG2,H-Z:PM\u001a\u001cX\r^:\u0002\u0011Q|7\u000b\u001e:j]\u001e$2a\u001aBs\u0011\u001d\u00119o\u0011a\u0001\u0005S\f\u0011B^3sE>\u001c\u0018\u000e^=\u0011\u0007=\u0013Y/C\u0002\u0003n\"\u00131\u0004\u0016:b]N\f7\r^5p]2{wmZ5oOZ+'OY8tSRLH#A4\u0002\r\u0015\fX/\u00197t)\u0011\t)M!>\t\u000f\t]X\t1\u0001\u0003\b\u0005!A\u000f[1u\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0016Q\rA!q \t\u0004A\u000e\u0005\u0011bAB\u0002C\nian\u001c8uQJ,\u0017\rZ:bM\u0016DQ!Z\u0002A\u0002\u001dDQa]\u0002A\u0002UDq!a\u0003\u0004\u0001\u0004\ty\u0001C\u0004\u0002(\r\u0001\r!a\u000b\t\r\r=1\u00011\u0001v\u0003%!\u0018.\\3ti\u0006l\u0007\u000fF\u0007^\u0007'\u0019)ba\u0006\u0004\u001a\rm1Q\u0004\u0005\u0006K\u0012\u0001\ra\u001a\u0005\u0006g\u0012\u0001\r!\u001e\u0005\b\u0003\u0017!\u0001\u0019AA\b\u0011\u001d\t9\u0003\u0002a\u0001\u0003WAq!!\u000f\u0005\u0001\u0004\ti\u0004\u0003\u0004\u0004\u0010\u0011\u0001\r!\u001e\u000b\u0012;\u000e\u000521EB\u0013\u0007O\u0019Ica\u000b\u0004.\r=\u0002\"B3\u0006\u0001\u00049\u0007\"B:\u0006\u0001\u0004)\bBBA\u0001\u000b\u0001\u0007Q\u000fC\u0004\u0002\f\u0015\u0001\r!a\u0004\t\u000f\u0005uQ\u00011\u0001\u0002\u0010!9\u0011qE\u0003A\u0002\u0005-\u0002bBA\u001d\u000b\u0001\u0007\u0011Q\b\u0005\u0007\u0007\u001f)\u0001\u0019A;\u0002!%\u001cX\t]8dQ\u0016C\b.Y;ti\u0016$G\u0003BAc\u0007kAq!a\u0003\u0007\u0001\u0004\ty!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0007wQ3!^B\u001fW\t\u0019y\u0004\u0005\u0003\u0004B\r-SBAB\"\u0015\u0011\u0019)ea\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAB%)\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r531\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new java.lang.StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new java.lang.StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(91).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString());
                right = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        Right epochBumpResult = right;
        if (epochBumpResult instanceof Right && (tuple2 = (Tuple2)epochBumpResult.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            return package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        }
        if (epochBumpResult instanceof Left) {
            Errors err = (Errors)((Left)epochBumpResult).value();
            return package$.MODULE$.Left().apply((Object)err);
        }
        throw new MatchError((Object)epochBumpResult);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        long newTxnStartTimestamp = (Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState))) ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), newTxnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    public boolean isDistributedTwoPhaseCommitTxn() {
        return this.txnTimeoutMs() == Integer.MAX_VALUE;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        return Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
    }

    public TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new java.lang.StringBuilder(78).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already has pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        TransactionState transactionState = newState;
        Dead$ dead$ = Dead$.MODULE$;
        if ((transactionState == null ? dead$ != null : !transactionState.equals(dead$)) && newEpoch < 0) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (newState.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new java.lang.StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new java.lang.StringBuilder(95).append("TransactionalId ").append(this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else if (PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                this.throwStateTransitionFailure(transitMetadata);
            }
        } else if (CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.topicPartitions().clear();
            }
        } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
            this.throwStateTransitionFailure(transitMetadata);
        } else {
            if (Dead$.MODULE$.equals(toState)) {
                throw new IllegalStateException(new java.lang.StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
            }
            throw new MatchError((Object)toState);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new java.lang.StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    private boolean includesOffsets() {
        return this.topicPartitions().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMetadata.$anonfun$includesOffsets$1(x$2)));
    }

    public String toString(TransactionLoggingVerbosity verbosity) {
        StringBuilder res = new StringBuilder("TransactionMetadata(");
        res.append("transactionalId=").append(this.transactionalId());
        res.append(", producerId").append(this.producerId());
        res.append(", producerEpoch=").append(this.producerEpoch());
        res.append(", txnTimeoutMs=").append(this.txnTimeoutMs());
        res.append(", state=").append((Object)this.state());
        res.append(", pendingState=").append(this.pendingState());
        res.append(", txnStartTimestamp=").append(this.txnStartTimestamp());
        res.append(", txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp());
        if (TransactionLoggingVerbosity$All$.MODULE$.equals(verbosity)) {
            res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
        } else if (TransactionLoggingVerbosity$Sample$.MODULE$.equals(verbosity)) {
            if (this.topicPartitions().size() > 20) {
                scala.collection.mutable.Set partitionsSample = (scala.collection.mutable.Set)this.topicPartitions().take(20);
                res.append(", samplePartitions=").append(TransactionMetadata.partitionsToString$1((Iterable)partitionsSample));
                res.append(", includesOffsets=").append(this.includesOffsets());
            } else {
                res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
            }
        } else if (TransactionLoggingVerbosity$Off$.MODULE$.equals(verbosity)) {
            res.append(", numPartitions=").append(this.topicPartitions().size());
            res.append(", includesOffsets=").append(this.includesOffsets());
        } else {
            throw new MatchError((Object)verbosity);
        }
        return res.append(")").toString();
    }

    public String toString() {
        return this.toString(TransactionLoggingVerbosity$Sample$.MODULE$);
    }

    public boolean equals(Object that) {
        if (that instanceof TransactionMetadata) {
            TransactionMetadata transactionMetadata = (TransactionMetadata)that;
            String string = this.transactionalId();
            String string2 = transactionMetadata.transactionalId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (this.producerId() == transactionMetadata.producerId() && this.producerEpoch() == transactionMetadata.producerEpoch() && this.lastProducerEpoch() == transactionMetadata.lastProducerEpoch() && this.txnTimeoutMs() == transactionMetadata.txnTimeoutMs() && this.state().equals(transactionMetadata.state()) && this.topicPartitions().equals(transactionMetadata.topicPartitions()) && this.txnStartTimestamp() == transactionMetadata.txnStartTimestamp() && this.txnLastUpdateTimestamp() == transactionMetadata.txnLastUpdateTimestamp()) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ boolean $anonfun$includesOffsets$1(TopicPartition x$2) {
        String string = x$2.topic();
        String string2 = "__consumer_offsets";
        return string != null && string.equals(string2);
    }

    private static final String partitionsToString$1(Iterable topicPartitions) {
        return topicPartitions.mkString("[", ",", "]");
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

