/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Map;
import java.util.Optional;
import kafka.network.AbstractAutoTuningQuota;
import org.apache.kafka.common.metrics.Sensor;

class ListenerTenantAutoTuningQuota
extends AbstractAutoTuningQuota {
    ListenerTenantAutoTuningQuota(Sensor connectionRateThrottleSensor, Sensor connectionRateLimitSensor) {
        super(connectionRateThrottleSensor, connectionRateLimitSensor);
    }

    @Override
    String quotaName(String listenerName) {
        return listenerName + "-per-tenant-connection-rate";
    }

    @Override
    double nextMax(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get("confluent.max.connection.rate.per.tenant")).map(v -> Double.valueOf(String.valueOf(v))).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    double nextFloor(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get("confluent.floor.connection.rate.per.tenant")).map(v -> Double.valueOf(String.valueOf(v))).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    double nextStep(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get("confluent.step.connection.rate.per.tenant")).map(v -> Double.valueOf(String.valueOf(v))).orElse(0.0);
    }

    @Override
    protected double connectionRateThrottleEnableThreshold(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get("max.connection.creation.rate.per.tenant.enable.threshold")).map(v -> Double.valueOf(String.valueOf(v))).orElse(0.0);
    }
}

