/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ClusterLinkQuotaRecordListener;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.ClusterLinkReplicaQuota;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.ClusterLinkReplicationQuotaManager$;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.QuotaType;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.link.ClusterLinkPrincipal;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005%x!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003yc\u0001\u0002\u0014 \u0001AB\u0001\"P\u0002\u0003\u0006\u0004%IA\u0010\u0005\t\u0005\u000e\u0011\t\u0011)A\u0005\u007f!I1i\u0001BC\u0002\u0013\u0005q\u0004\u0012\u0005\t\u0011\u000e\u0011\t\u0011)A\u0005\u000b\"A\u0011j\u0001BC\u0002\u0013%!\n\u0003\u0005X\u0007\t\u0005\t\u0015!\u0003L\u0011!A6A!b\u0001\n\u0013I\u0006\u0002C0\u0004\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000b9\u001aA\u0011\u00011\t\u0011\u0019\u001c!\u0019!C)?\u001dDaa[\u0002!\u0002\u0013A\u0007b\u00027\u0004\u0005\u0004%I!\u001c\u0005\u0007c\u000e\u0001\u000b\u0011\u00028\t\rI\u001cA\u0011A\u0010t\u0011\u001d\t\tb\u0001C\u0005\u0003'Aq!a\u0012\u0004\t\u0013\tI\u0005C\u0004\u0002l\r!I!!\u001c\t\u000f\u0005-5\u0001\"\u0011\u0002\u000e\"9\u0011\u0011U\u0002\u0005B\u0005\r\u0006bBAY\u0007\u0011\u0005\u00131\u0017\u0005\b\u0003o\u001bA\u0011AA]\u0011\u001d\t\u0019m\u0001C!\u0003\u000bDq!a3\u0004\t\u0003\ni\rC\u0004\u0002P\u000e!\t!!5\t\u000f\u0005u7\u0001\"\u0001\u0002N\"9\u0011q\\\u0002\u0005\u0002\u0005\u0005\u0018AI\"mkN$XM\u001d'j].\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'O\u0003\u0002!C\u000511/\u001a:wKJT\u0011AI\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0013!D\u0001 \u0005\t\u001aE.^:uKJd\u0015N\\6SKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4feN\u0011\u0011\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!3#B\u0002)c]R\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\"\u0003\u0015)H/\u001b7t\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0015B\u0014BA\u001d \u0005]\u0019E.^:uKJd\u0015N\\6SKBd\u0017nY1Rk>$\u0018\r\u0005\u0002&w%\u0011Ah\b\u0002\u001f\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mK2K7\u000f^3oKJ\fQ\u0003\\5oWJ+\u0007\u000f\\5dCRLwN\\\"p]\u001aLw-F\u0001@!\t)\u0003)\u0003\u0002B?\ta2\t\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004H.[2bi&|gnQ8oM&<\u0017A\u00067j].\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u0011\u0002'A\u0014x\u000eZ;dKF+x\u000e^1NC:\fw-\u001a:\u0016\u0003\u0015\u0003\"!\n$\n\u0005\u001d{\"AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\fA\u0003\u001d:pIV\u001cW-U;pi\u0006l\u0015M\\1hKJ\u0004\u0013aB7fiJL7m]\u000b\u0002\u0017B\u0011A*V\u0007\u0002\u001b*\u0011\u0011J\u0014\u0006\u0003\u001fB\u000baaY8n[>t'B\u0001\u0012R\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Yk%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005Q\u0006CA.^\u001b\u0005a&B\u0001\u001bO\u0013\tqFL\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004C#B1cG\u0012,\u0007CA\u0013\u0004\u0011\u0015iD\u00021\u0001@\u0011\u0015\u0019E\u00021\u0001F\u0011\u0015IE\u00021\u0001L\u0011\u0015AF\u00021\u0001[\u0003%\tXo\u001c;b)f\u0004X-F\u0001i!\t)\u0013.\u0003\u0002k?\tI\u0011+^8uCRK\b/Z\u0001\u000bcV|G/\u0019+za\u0016\u0004\u0013a\u0005:fa2L7-Y)v_R\fW*\u00198bO\u0016\u0014X#\u00018\u0011\u0005\u0015z\u0017B\u00019 \u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\u000bsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\u001fO\u0016$Hj\\2bYB\u0013x\u000eZ;dKF+x\u000e^1NKR\u0014\u0018n\u0019(b[\u0016$\"\u0001\u001e=\u0011\u0005U4X\"\u0001(\n\u0005]t%AC'fiJL7MT1nK\")\u00110\u0005a\u0001u\u0006y\u0011/^8uC6+GO]5d)\u0006<7\u000fE\u0004|\u0003\u000b\tY!a\u0003\u000f\u0007q\f\t\u0001\u0005\u0002~U5\taP\u0003\u0002\u0000G\u00051AH]8pizJ1!a\u0001+\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u0007Q\u0003cA>\u0002\u000e%!\u0011qBA\u0005\u0005\u0019\u0019FO]5oO\u0006\u0011r-\u001a;UK:\fg\u000e^)v_R\fWj\u001c3f)\u0011\t)\"a\u0011\u0011\t\u0005]\u0011Q\b\b\u0005\u00033\t9D\u0004\u0003\u0002\u001c\u0005Eb\u0002BA\u000f\u0003[qA!a\b\u0002,9!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#a\n\u000f\u0007u\f)#C\u0001U\u0013\t\u00116+\u0003\u0002##&\u0011q\nU\u0005\u0004\u0003_q\u0015AB2p]\u001aLw-\u0003\u0003\u00024\u0005U\u0012!C5oi\u0016\u0014h.\u00197t\u0015\r\tyCT\u0005\u0005\u0003s\tY$\u0001\tD_:4G.^3oi\u000e{gNZ5hg*!\u00111GA\u001b\u0013\u0011\ty$!\u0011\u0003)\rcWo\u001d;fe2Kgn[)v_R\fWj\u001c3f\u0015\u0011\tI$a\u000f\t\u000f\u0005\u0015#\u00031\u0001\u0002\f\u00051A/\u001a8b]R\fa#[:DYV\u001cH/\u001a:MS:\\\u0007K]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u0002*\u0003\u001bJ1!a\u0014+\u0005\u001d\u0011un\u001c7fC:Dq!a\u0015\u0014\u0001\u0004\t)&A\u0005qe&t7-\u001b9bYB!\u0011qKA4\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013aC7vYRLG/\u001a8b]RT1AIA0\u0015\u0011\t\t'a\u0019\u0002\u0013\r|gN\u001a7vK:$(BAA3\u0003\tIw.\u0003\u0003\u0002j\u0005e#\u0001F'vYRLG+\u001a8b]R\u0004&/\u001b8dSB\fG.\u0001\u000bdYV\u001cH/\u001a:MS:\\\u0007K]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0003_\n\t\tE\u0003*\u0003c\n)(C\u0002\u0002t)\u0012aa\u00149uS>t\u0007\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005mt$\u0001\u0003mS:\\\u0017\u0002BA@\u0003s\u0012Ac\u00117vgR,'\u000fT5oWB\u0013\u0018N\\2ja\u0006d\u0007bBAB)\u0001\u0007\u0011QQ\u0001\u0012Y&t7\u000eV3oC:$8i\u001c8uKb$\bcA\u0013\u0002\b&\u0019\u0011\u0011R\u0010\u00031\rcWo\u001d;fe2Kgn\u001b+f]\u0006tGoQ8oi\u0016DH/\u0001\u0004sK\u000e|'\u000f\u001a\u000b\u0007\u0003\u001f\u000b)*a&\u0011\u0007%\n\t*C\u0002\u0002\u0014*\u0012A!\u00168ji\"9\u00111Q\u000bA\u0002\u0005\u0015\u0005bBAM+\u0001\u0007\u00111T\u0001\u0006m\u0006dW/\u001a\t\u0004S\u0005u\u0015bAAPU\t!Aj\u001c8h\u0003-I7\u000f\u00165s_R$H.\u001a3\u0015\r\u0005-\u0013QUAT\u0011\u001d\t\u0019I\u0006a\u0001\u0003\u000bCq!!+\u0017\u0001\u0004\tY+\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\u0007U\fi+C\u0002\u00020:\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bjgF+x\u000e^1Fq\u000e,W\rZ3e)\u0011\tY%!.\t\u000f\u0005\ru\u00031\u0001\u0002\u0006\u0006\tr-\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\t\u0005m\u0016\u0011\u0019\t\u0004S\u0005u\u0016bAA`U\t\u0019\u0011J\u001c;\t\u000f\u0005\r\u0005\u00041\u0001\u0002\u0006\u0006\u0011\u0002.\u00198eY\u0016$\u0015n]6Ta\u0006\u001cW\rT8x)\u0011\ty)a2\t\u000f\u0005%\u0017\u00041\u0001\u0002\u001c\u0006A2-\u00199qK\u0012\fVo\u001c;b\u0013:\u0014\u0015\u0010^3t!\u0016\u00148+Z2\u00021!\fg\u000e\u001a7f\t&\u001c8n\u00159bG\u0016\u0014VmY8wKJ,G\r\u0006\u0002\u0002\u0010\u0006YQ\u000f\u001d3bi\u0016\fVo\u001c;b)\u0011\ty)a5\t\u000f\u0005U7\u00041\u0001\u0002X\u0006)\u0011/^8uCB\u0019A*!7\n\u0007\u0005mWJA\u0003Rk>$\u0018-A\nnCJ\\'I]8lKJ$\u0006N]8ui2,G-A\nhKR\u0014%o\\6feF+x\u000e^1MS6LG/\u0006\u0002\u0002dB\u0019\u0011&!:\n\u0007\u0005\u001d(F\u0001\u0004E_V\u0014G.\u001a")
public class ClusterLinkReplicationQuotaManager
implements Logging,
ClusterLinkReplicaQuota,
DiskUsageBasedThrottleListener {
    private final ClusterLinkReplicationConfig kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig;
    private final ClientQuotaManager produceQuotaManager;
    private final Metrics kafka$server$ClusterLinkReplicationQuotaManager$$metrics;
    private final Time time;
    private final QuotaType quotaType;
    private final ReplicationQuotaManager kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager;
    private final AtomicReference<Option<Object>> lastSignalledQuotaOptRef;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
        return this.lastSignalledQuotaOptRef;
    }

    @Override
    public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
        this.lastSignalledQuotaOptRef = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkReplicationConfig kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig;
    }

    public ClientQuotaManager produceQuotaManager() {
        return this.produceQuotaManager;
    }

    public Metrics kafka$server$ClusterLinkReplicationQuotaManager$$metrics() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics;
    }

    private Time time() {
        return this.time;
    }

    @Override
    public QuotaType quotaType() {
        return this.quotaType;
    }

    public ReplicationQuotaManager kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager;
    }

    public MetricName getLocalProduceQuotaMetricName(scala.collection.immutable.Map<String, String> quotaMetricTags) {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("local-produce-tokens", this.quotaType().toString(), "Tracking remaining tokens in the token bucket per user/client-id for all produce except cluster linking", (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    public ConfluentConfigs.ClusterLinkQuotaMode kafka$server$ClusterLinkReplicationQuotaManager$$getTenantQuotaMode(String tenant) {
        ConfluentConfigs.ClusterLinkQuotaMode defaultClusterLinkQuotaMode = (ConfluentConfigs.ClusterLinkQuotaMode)this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaMode().apply();
        return (ConfluentConfigs.ClusterLinkQuotaMode)((MapLike)this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaModePerTenantOverrides().apply()).getOrElse((Object)tenant, (Function0 & Serializable & scala.Serializable)() -> defaultClusterLinkQuotaMode);
    }

    public boolean kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal(MultiTenantPrincipal principal) {
        return principal instanceof ClusterLinkPrincipal;
    }

    private Option<ClusterLinkPrincipal> clusterLinkPrincipal(ClusterLinkTenantContext linkTenantContext) {
        return ClusterLinkQuotas$.MODULE$.clusterLinkPrincipal(this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig(), linkTenantContext);
    }

    @Override
    public void record(ClusterLinkTenantContext linkTenantContext, long value) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)((Object)((Some)option).value());
            this.produceQuotaManager().maybeRecordAndGetThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), value, this.time().milliseconds());
            return;
        }
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record(value);
    }

    @Override
    public boolean isThrottled(ClusterLinkTenantContext linkTenantContext, TopicPartition topicPartition) {
        if (this.clusterLinkPrincipal(linkTenantContext) instanceof Some) {
            return true;
        }
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().isThrottled(topicPartition);
    }

    @Override
    public boolean isQuotaExceeded(ClusterLinkTenantContext linkTenantContext) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)((Object)((Some)option).value());
            return this.produceQuotaManager().getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.time().milliseconds()) > 0;
        }
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().isQuotaExceeded();
    }

    public int getThrottleTimeMs(ClusterLinkTenantContext linkTenantContext) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)((Object)((Some)option).value());
            return this.produceQuotaManager().getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.time().milliseconds());
        }
        throw new UnsupportedOperationException("Should not reach here in normal flow");
    }

    @Override
    public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().handleDiskSpaceLow(cappedQuotaInBytesPerSec);
    }

    @Override
    public void handleDiskSpaceRecovered() {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().handleDiskSpaceRecovered();
    }

    public void updateQuota(Quota quota) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().updateQuota(quota);
    }

    public void markBrokerThrottled() {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().markBrokerThrottled();
    }

    public double getBrokerQuotaLimit() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().getBrokerQuotaLimit();
    }

    public ClusterLinkReplicationQuotaManager(ClusterLinkReplicationConfig linkReplicationConfig, ClientQuotaManager produceQuotaManager, Metrics metrics, Time time) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig = linkReplicationConfig;
        this.produceQuotaManager = produceQuotaManager;
        this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics = metrics;
        this.time = time;
        Logging.$init$(this);
        DiskUsageBasedThrottleListener.$init$(this);
        this.quotaType = QuotaType$ClusterLinkReplication$.MODULE$;
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager = new ReplicationQuotaManager(linkReplicationConfig.replicationQuotaManagerConfig(), metrics, QuotaType$ClusterLinkReplication$.MODULE$, time);
        produceQuotaManager.setLinkQuotaRecordListener(new ClusterLinkQuotaRecordListener(this){
            private final /* synthetic */ ClusterLinkReplicationQuotaManager $outer;

            public void maybeRecordWhenClientQuotasDisabled(Session session, String clientId, double value, long timeMs) {
                if (this.isBrokerLevelTotalInboundLinkQuota()) {
                    this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record((long)value);
                    return;
                }
            }

            public void maybeRecord(ClientSensors clientSensors, double value, long timeMs) {
                if (this.isBrokerLevelTotalInboundLinkQuota()) {
                    this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record((long)value);
                    return;
                }
                Option<MultiTenantPrincipal> principal = this.getPrincipal(clientSensors);
                if (principal.nonEmpty() && this.isTenantLevelTotalInboundLinkQuota((MultiTenantPrincipal)principal.get())) {
                    if (this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal((MultiTenantPrincipal)principal.get())) {
                        this.linkUsageSensor((MultiTenantPrincipal)principal.get(), clientSensors).record(value, timeMs, false);
                        return;
                    }
                    this.localProduceQuotaSensor(clientSensors).record(value, timeMs, false);
                    return;
                }
            }

            public void updateQuotaMetricConfig(scala.collection.immutable.Map<String, String> tags, MetricConfig config) {
                KafkaMetric localProduceQuotaMetric = (KafkaMetric)this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metrics().get(this.$outer.getLocalProduceQuotaMetricName(tags));
                if (localProduceQuotaMetric != null) {
                    localProduceQuotaMetric.config(config);
                    return;
                }
            }

            public int adjustedThrottleTimeMs(int throttleTimeMs, ClientSensors clientSensors, long timeMs) {
                KafkaMetric clientMetric;
                Option<MultiTenantPrincipal> principal = this.getPrincipal(clientSensors);
                if (principal.nonEmpty() && !this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal((MultiTenantPrincipal)principal.get()) && this.isTenantLevelTotalInboundLinkQuota((MultiTenantPrincipal)principal.get()) && (clientMetric = (KafkaMetric)this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metrics().get(this.linkClientRateMetricName(this.tenantMetricTags((MultiTenantPrincipal)principal.get())))) != null && BoxesRunTime.unboxToDouble((Object)clientMetric.metricValue()) > 0.0) {
                    double clUsage = BoxesRunTime.unboxToDouble((Object)clientMetric.metricValue());
                    Sensor quotaSensor = this.localProduceQuotaSensor(clientSensors);
                    int adjustedThrottleTimeMs = this.$outer.produceQuotaManager().computeThrottleTimeMs(quotaSensor, timeMs);
                    this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Adjusting throttleTimeMs=").append(throttleTimeMs).append(" with adjustedThrottleTimeMs=").append(adjustedThrottleTimeMs).append(" using all produce except cl quota sensor, clUsage=").append(clUsage).append(" with tags ").append(clientSensors.metricTags()).toString());
                    return Math.min(throttleTimeMs, adjustedThrottleTimeMs);
                }
                return throttleTimeMs;
            }

            private Sensor localProduceQuotaSensor(ClientSensors clientSensors) {
                return clientSensors.sensorAccessor().getOrCreateWithParent(this.getLocalProduceQuotaSensorName(clientSensors.metricTags()), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<Option<Sensor>>)(Function0 & Serializable & scala.Serializable)() -> this.getOrCreateLocalProduceParentQuotaSensor(clientSensors), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
                    $anon$1.$anonfun$localProduceQuotaSensor$2(this, clientSensors, sensor);
                    return BoxedUnit.UNIT;
                });
            }

            private Option<Sensor> getOrCreateLocalProduceParentQuotaSensor(ClientSensors clientSensors) {
                scala.collection.immutable.Map<String, String> parentQuotaMetricTags = clientSensors.parentMetricTags();
                if (parentQuotaMetricTags.isEmpty()) {
                    return None$.MODULE$;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Creating parent quota sensor with tags ").append(parentQuotaMetricTags).toString());
                return new Some((Object)clientSensors.sensorAccessor().getOrCreate(this.getLocalProduceQuotaSensorName(parentQuotaMetricTags), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
                    $anon$1.$anonfun$getOrCreateLocalProduceParentQuotaSensor$2(this, parentQuotaMetricTags, sensor);
                    return BoxedUnit.UNIT;
                }));
            }

            public void registerLocalProduceQuotaMetrics(scala.collection.immutable.Map<String, String> metricTags, Sensor sensor) {
                sensor.add(this.$outer.getLocalProduceQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(TimeUnit.SECONDS, ClientQuotaManager$.MODULE$.MAX_TOKEN_BUCKET_THROTTLE_TIME_MS()), this.$outer.produceQuotaManager().getQuotaMetricConfig(metricTags));
            }

            private Sensor linkUsageSensor(MultiTenantPrincipal principal, ClientSensors clientSensors) {
                scala.collection.immutable.Map<String, String> metricTags = this.tenantMetricTags(principal);
                return clientSensors.sensorAccessor().getOrCreate(this.getLinkUsageSensorName(metricTags), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
                    $anon$1.$anonfun$linkUsageSensor$1(this, metricTags, sensor);
                    return BoxedUnit.UNIT;
                });
            }

            private String getLocalProduceQuotaSensorName(scala.collection.immutable.Map<String, String> metricTags) {
                return new StringBuilder(14).append(this.$outer.quotaType()).append("-localproduce-").append(ClientQuotaManager$.MODULE$.metricTagsToSensorSuffix(metricTags)).toString();
            }

            private String getLinkUsageSensorName(scala.collection.immutable.Map<String, String> metricTags) {
                return new StringBuilder(7).append(this.$outer.quotaType()).append("-usage-").append(ClientQuotaManager$.MODULE$.metricTagsToSensorSuffix(metricTags)).toString();
            }

            private MetricName linkClientRateMetricName(scala.collection.immutable.Map<String, String> tenantMetricTags) {
                return this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("link-byte-rate", this.$outer.quotaType().toString(), "Tracking cluster linking byte-rate per tenant", (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(tenantMetricTags).asJava());
            }

            private scala.collection.immutable.Map<String, String> tenantMetricTags(MultiTenantPrincipal principal) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)principal.tenantMetadata().tenantName)}));
            }

            private boolean isBrokerLevelTotalInboundLinkQuota() {
                if (this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkEnable().apply$mcZ$sp() && !this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkTenantQuotaEnable().apply$mcZ$sp()) {
                    Object object = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaMode().apply();
                    ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
                    if (!(object != null ? !object.equals(clusterLinkQuotaMode) : clusterLinkQuotaMode != null)) {
                        return true;
                    }
                }
                return false;
            }

            private Option<MultiTenantPrincipal> getPrincipal(ClientSensors clientSensors) {
                return clientSensors.principalOpt().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getPrincipal$1(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (MultiTenantPrincipal)x$2);
            }

            private boolean isTenantLevelTotalInboundLinkQuota(MultiTenantPrincipal principal) {
                if (this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkEnable().apply$mcZ$sp() && this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkTenantQuotaEnable().apply$mcZ$sp()) {
                    ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$getTenantQuotaMode(principal.tenantMetadata().tenantName);
                    ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
                    if (!(clusterLinkQuotaMode != null ? !clusterLinkQuotaMode.equals(clusterLinkQuotaMode2) : clusterLinkQuotaMode2 != null)) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ void $anonfun$localProduceQuotaSensor$2($anon$1 $this, ClientSensors clientSensors$2, Sensor sensor) {
                $this.registerLocalProduceQuotaMetrics(clientSensors$2.metricTags(), sensor);
            }

            public static final /* synthetic */ void $anonfun$getOrCreateLocalProduceParentQuotaSensor$2($anon$1 $this, scala.collection.immutable.Map parentQuotaMetricTags$1, Sensor sensor) {
                $this.registerLocalProduceQuotaMetrics((scala.collection.immutable.Map<String, String>)parentQuotaMetricTags$1, sensor);
            }

            public static final /* synthetic */ void $anonfun$linkUsageSensor$1($anon$1 $this, scala.collection.immutable.Map metricTags$1, Sensor sensor) {
                sensor.add($this.linkClientRateMetricName((scala.collection.immutable.Map<String, String>)metricTags$1), (MeasurableStat)new Rate(), $this.$outer.produceQuotaManager().getRateMetricConfig());
            }

            public static final /* synthetic */ boolean $anonfun$getPrincipal$1(KafkaPrincipal x$1) {
                return x$1 instanceof MultiTenantPrincipal;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$adjustedThrottleTimeMs$1(int int double kafka.server.ClientSensors ), $anonfun$localProduceQuotaSensor$1(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 kafka.server.ClientSensors ), $anonfun$localProduceQuotaSensor$2$adapted(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 kafka.server.ClientSensors org.apache.kafka.common.metrics.Sensor ), $anonfun$getOrCreateLocalProduceParentQuotaSensor$1(scala.collection.immutable.Map ), $anonfun$getOrCreateLocalProduceParentQuotaSensor$2$adapted(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 scala.collection.immutable.Map org.apache.kafka.common.metrics.Sensor ), $anonfun$linkUsageSensor$1$adapted(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 scala.collection.immutable.Map org.apache.kafka.common.metrics.Sensor ), $anonfun$getPrincipal$1$adapted(org.apache.kafka.common.security.auth.KafkaPrincipal ), $anonfun$getPrincipal$2(org.apache.kafka.common.security.auth.KafkaPrincipal )}, serializedLambda);
            }
        });
    }
}

