/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.Fetching$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaState;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierState;
import kafka.server.TierStateMachine;
import kafka.tier.exceptions.TierPartitionStateClosedException;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.utils.ExponentialBackoff;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMb\u0001B%K\u0001=C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A!\r\u0001B\u0001B\u0003%1\rC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u00026\u0001!\t%a\u000e\t\u0011\u0005=\u0003\u0001\"\u0001K\u0003#B\u0001\"! \u0001\t\u0003Q\u0015q\u0010\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\u0019i\u0001\u0001C\u0005\u0007\u001fA\u0001b!\u0007\u0001\t\u0003Q51\u0004\u0005\t\u0007W\u0001A\u0011\u0001&\u0004.\u001d9\u0011\u0011\u0017&\t\u0002\u0005MfAB%K\u0011\u0003\t)\f\u0003\u0004p\u001d\u0011\u0005\u0011Q\u0018\u0004\u0007\u0003\u007fs\u0001)!1\t\u0015\u0005U\u0007C!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0002ZB\u0011\t\u0012)A\u0005\u0003'B!\"a7\u0011\u0005+\u0007I\u0011AAo\u0011)\ty\u000e\u0005B\tB\u0003%\u0011\u0011\u000f\u0005\u000b\u0003C\u0004\"Q3A\u0005\u0002\u0005\r\bBCAs!\tE\t\u0015!\u0003\u0002D\"1q\u000e\u0005C\u0001\u0003OD\u0011\"a=\u0011\u0003\u0003%\t!!>\t\u0013\u0005u\b#%A\u0005\u0002\u0005}\b\"\u0003B\u000b!E\u0005I\u0011\u0001B\f\u0011%\u0011Y\u0002EI\u0001\n\u0003\u0011i\u0002C\u0005\u0003\"A\t\t\u0011\"\u0011\u0003$!I!\u0011\u0007\t\u0002\u0002\u0013\u0005!1\u0007\u0005\n\u0005k\u0001\u0012\u0011!C\u0001\u0005oA\u0011Ba\u0011\u0011\u0003\u0003%\tE!\u0012\t\u0013\tM\u0003#!A\u0005\u0002\tU\u0003\"\u0003B0!\u0005\u0005I\u0011\tB1\u0011%\u0011\u0019\u0007EA\u0001\n\u0003\u0012)\u0007C\u0005\u0003hA\t\t\u0011\"\u0011\u0003j\u001dI!Q\u000e\b\u0002\u0002#\u0005!q\u000e\u0004\n\u0003\u007fs\u0011\u0011!E\u0001\u0005cBaa\\\u0013\u0005\u0002\t}\u0004\"\u0003B2K\u0005\u0005IQ\tB3\u0011%\u0011\t)JA\u0001\n\u0003\u0013\u0019\tC\u0005\u0003\f\u0016\n\t\u0011\"!\u0003\u000e\"I!qT\u0013\u0002\u0002\u0013%!\u0011\u0015\u0004\u0007\u0005Ss\u0001Ia+\t\u0015\u0005U7F!f\u0001\n\u0003\u0011i\u000b\u0003\u0006\u0002Z.\u0012\t\u0012)A\u0005\u0005_C!Ba.,\u0005+\u0007I\u0011\u0001B]\u0011)\u0011Yl\u000bB\tB\u0003%\u0011q\f\u0005\u000b\u00037\\#Q3A\u0005\u0002\u0005u\u0007BCApW\tE\t\u0015!\u0003\u0002r!Q\u0011\u0011]\u0016\u0003\u0016\u0004%\t!a9\t\u0015\u0005\u00158F!E!\u0002\u0013\t\u0019\r\u0003\u0004pW\u0011\u0005!Q\u0018\u0005\n\u0003g\\\u0013\u0011!C\u0001\u0005\u0013D\u0011\"!@,#\u0003%\tAa5\t\u0013\tU1&%A\u0005\u0002\t]\u0007\"\u0003B\u000eWE\u0005I\u0011\u0001B\f\u0011%\u0011YnKI\u0001\n\u0003\u0011i\u0002C\u0005\u0003\"-\n\t\u0011\"\u0011\u0003$!I!\u0011G\u0016\u0002\u0002\u0013\u0005!1\u0007\u0005\n\u0005kY\u0013\u0011!C\u0001\u0005;D\u0011Ba\u0011,\u0003\u0003%\tE!\u0012\t\u0013\tM3&!A\u0005\u0002\t\u0005\b\"\u0003B0W\u0005\u0005I\u0011\tB1\u0011%\u0011\u0019gKA\u0001\n\u0003\u0012)\u0007C\u0005\u0003h-\n\t\u0011\"\u0011\u0003f\u001eI!\u0011\u001e\b\u0002\u0002#\u0005!1\u001e\u0004\n\u0005Ss\u0011\u0011!E\u0001\u0005[Daa\\\"\u0005\u0002\tU\b\"\u0003B2\u0007\u0006\u0005IQ\tB3\u0011%\u0011\tiQA\u0001\n\u0003\u00139\u0010C\u0005\u0003\f\u000e\u000b\t\u0011\"!\u0004\u0002!I!qT\"\u0002\u0002\u0013%!\u0011\u0015\u0002(\u0007>tg\r\\;f]R\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0016.\u001a:Ti\u0006$X-T1dQ&tWM\u0003\u0002L\u0019\u000611/\u001a:wKJT\u0011!T\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\u000b\u0016\t\u0003#Jk\u0011AS\u0005\u0003'*\u0013\u0001\u0003V5feN#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005UCV\"\u0001,\u000b\u0005]c\u0015!B;uS2\u001c\u0018BA-W\u0005\u001daunZ4j]\u001e\fa\u0001\\3bI\u0016\u0014\bCA)]\u0013\ti&J\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002RA&\u0011\u0011M\u0013\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I)\u0007\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0011\u0005\u0011lW\"A3\u000b\u0005]3'BA4i\u0003\u0019\u0019w.\\7p]*\u0011Q*\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oK\n\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003\u0019a\u0014N\\5u}Q!\u0011O]:u!\t\t\u0006\u0001C\u0003[\t\u0001\u00071\fC\u0003_\t\u0001\u0007q\fC\u0003c\t\u0001\u00071-A\u0003ti\u0006\u0014H\u000f\u0006\u0004xu\u0006\u0005\u0011Q\u0001\t\u0003#bL!!\u001f&\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000bm,\u0001\u0019\u0001?\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011QP`\u0007\u0002M&\u0011qP\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0019!\u0002a\u0001o\u0006\t2-\u001e:sK:$h)\u001a;dQN#\u0018\r^3\t\u000f\u0005\u001dQ\u00011\u0001\u0002\n\u0005\u0011b-\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\u0011\tY!a\f\u000f\t\u00055\u0011\u0011\u0006\b\u0005\u0003\u001f\t)C\u0004\u0003\u0002\u0012\u0005\rb\u0002BA\n\u0003CqA!!\u0006\u0002 9!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c9\u000ba\u0001\u0010:p_Rt\u0014\"\u00017\n\u0005)\\\u0017BA'j\u0013\t9\u0007.C\u0002\u0002(\u0019\fq!\\3tg\u0006<W-\u0003\u0003\u0002,\u00055\u0012!\u0005$fi\u000eD'+Z:q_:\u001cX\rR1uC*\u0019\u0011q\u00054\n\t\u0005E\u00121\u0007\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005-\u0012QF\u0001\u0012[\u0006L(-Z!em\u0006t7-Z*uCR,GCBA\u001d\u0003\u0013\ni\u0005E\u0003\u0002<\u0005\u0015s/\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002>\tAq\n\u001d;j_:\fG\u000e\u0003\u0004\u0002L\u0019\u0001\r\u0001`\u0001\u0003iBDa!a\u0001\u0007\u0001\u00049\u0018aH7bi\u0016\u0014\u0018.\u00197ju\u0016$\u0016.\u001a:Ti\u0006$X-\u00168uS2|eMZ:fiR1\u00111KA6\u0003[\u0002b!!\u0016\u0002\\\u0005}SBAA,\u0015\u0011\tI&!\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002^\u0005]#A\u0002$viV\u0014X\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007T\u0001\u0004Y><\u0017\u0002BA5\u0003G\u0012a\u0002V5fe2{wmU3h[\u0016tG\u000fC\u0003|\u000f\u0001\u0007A\u0010C\u0004\u0002p\u001d\u0001\r!!\u001d\u0002\u0019Q\f'oZ3u\u001f\u001a47/\u001a;\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR!!a\u001e\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005m\u0014Q\u000f\u0002\u0005\u0019>tw-A\u0011nCR,'/[1mSj,G+[3s'R\fG/Z+oi&dwJ\u00196fGRLE\r\u0006\u0006\u0002T\u0005\u0005\u00151QAC\u0003\u001fCQa\u001f\u0005A\u0002qDq!a\u001c\t\u0001\u0004\t\t\bC\u0004\u0002\b\"\u0001\r!!#\u0002\u001dQ\f'oZ3u\u001f\nTWm\u0019;JIB!\u00111HAF\u0013\u0011\ti)!\u0010\u0003\tU+\u0016\n\u0012\u0005\b\u0003#C\u0001\u0019AAJ\u0003I!\u0018M]4fiJ+7\u000f^8sK\u0016\u0003xn\u00195\u0011\t\u0005M\u0014QS\u0005\u0005\u0003/\u000b)HA\u0002J]R\f1\u0004\u001e:b]NLG/[8o\r\u0016$8\r[5oORKWM]*uCR,GcB<\u0002\u001e\u0006}\u0015\u0011\u0015\u0005\u0006w&\u0001\r\u0001 \u0005\u0007\u0003\u0007I\u0001\u0019A<\t\u000f\u0005\r\u0016\u00021\u0001\u0002&\u0006IA/[3s'R\fG/\u001a\t\u0004\u0003O[cbAAU\u001b9!\u00111VAX\u001d\u0011\t9\"!,\n\u00035K!a\u0013'\u0002O\r{gN\u001a7vK:$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H+[3s'R\fG/Z'bG\"Lg.\u001a\t\u0003#:\u00192ADA\\!\u0011\t\u0019(!/\n\t\u0005m\u0016Q\u000f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005M&!G'bi\u0016\u0014\u0018.\u00197ju&tw\rV5fe6+G/\u00193bi\u0006\u001c\u0012\u0002EA\\\u0003\u0007\fI-a4\u0011\u0007E\u000b)-C\u0002\u0002H*\u0013ABU3qY&\u001c\u0017m\u0015;bi\u0016\u0004B!a\u001d\u0002L&!\u0011QZA;\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u001d\u0002R&!\u00111[A;\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003A\u0019w.\u001c9mKRLwN\\*uCR,8/\u0006\u0002\u0002T\u0005\t2m\\7qY\u0016$\u0018n\u001c8Ti\u0006$Xo\u001d\u0011\u0002#1,\u0017\rZ3s'R\f'\u000f^(gMN,G/\u0006\u0002\u0002r\u0005\u0011B.Z1eKJ\u001cF/\u0019:u\u001f\u001a47/\u001a;!\u00035\u0001(/\u001a<j_V\u001c8\u000b^1uKV\u0011\u00111Y\u0001\u000faJ,g/[8vgN#\u0018\r^3!)!\tI/!<\u0002p\u0006E\bcAAv!5\ta\u0002C\u0004\u0002V^\u0001\r!a\u0015\t\u000f\u0005mw\u00031\u0001\u0002r!9\u0011\u0011]\fA\u0002\u0005\r\u0017\u0001B2paf$\u0002\"!;\u0002x\u0006e\u00181 \u0005\n\u0003+D\u0002\u0013!a\u0001\u0003'B\u0011\"a7\u0019!\u0003\u0005\r!!\u001d\t\u0013\u0005\u0005\b\u0004%AA\u0002\u0005\r\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003QC!a\u0015\u0003\u0004-\u0012!Q\u0001\t\u0005\u0005\u000f\u0011\t\"\u0004\u0002\u0003\n)!!1\u0002B\u0007\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\u0010\u0005U\u0014AC1o]>$\u0018\r^5p]&!!1\u0003B\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IB\u000b\u0003\u0002r\t\r\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005?QC!a1\u0003\u0004\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQAAa\u000b\u0002B\u0005!A.\u00198h\u0013\u0011\u0011yC!\u000b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\te\"q\b\t\u0005\u0003g\u0012Y$\u0003\u0003\u0003>\u0005U$aA!os\"I!\u0011\t\u0010\u0002\u0002\u0003\u0007\u00111S\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u001d\u0003C\u0002B%\u0005\u001f\u0012I$\u0004\u0002\u0003L)!!QJA;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u0012YE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B,\u0005;\u0002B!a\u001d\u0003Z%!!1LA;\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0011!\u0003\u0003\u0005\rA!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\n\u0002\r\u0015\fX/\u00197t)\u0011\u00119Fa\u001b\t\u0013\t\u00053%!AA\u0002\te\u0012!G'bi\u0016\u0014\u0018.\u00197ju&tw\rV5fe6+G/\u00193bi\u0006\u00042!a;&'\u0015)#1OAh!1\u0011)Ha\u001f\u0002T\u0005E\u00141YAu\u001b\t\u00119H\u0003\u0003\u0003z\u0005U\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005{\u00129HA\tBEN$(/Y2u\rVt7\r^5p]N\"\"Aa\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005%(Q\u0011BD\u0005\u0013Cq!!6)\u0001\u0004\t\u0019\u0006C\u0004\u0002\\\"\u0002\r!!\u001d\t\u000f\u0005\u0005\b\u00061\u0001\u0002D\u00069QO\\1qa2LH\u0003\u0002BH\u00057\u0003b!a\u001d\u0003\u0012\nU\u0015\u0002\u0002BJ\u0003k\u0012aa\u00149uS>t\u0007CCA:\u0005/\u000b\u0019&!\u001d\u0002D&!!\u0011TA;\u0005\u0019!V\u000f\u001d7fg!I!QT\u0015\u0002\u0002\u0003\u0007\u0011\u0011^\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa)\u0011\t\t\u001d\"QU\u0005\u0005\u0005O\u0013IC\u0001\u0004PE*,7\r\u001e\u0002\u0012\r\u0016$8\r[5oORKWM]*uCR,7#C\u0016\u00028\u0006\r\u0017\u0011ZAh+\t\u0011y\u000b\u0005\u0004\u0002V\u0005m#\u0011\u0017\t\u0004#\nM\u0016b\u0001B[\u0015\nIA+[3s'R\fG/Z\u0001\fi&,'oU3h[\u0016tG/\u0006\u0002\u0002`\u0005aA/[3s'\u0016<W.\u001a8uAQQ!q\u0018Ba\u0005\u0007\u0014)Ma2\u0011\u0007\u0005-8\u0006C\u0004\u0002VR\u0002\rAa,\t\u000f\t]F\u00071\u0001\u0002`!9\u00111\u001c\u001bA\u0002\u0005E\u0004bBAqi\u0001\u0007\u00111\u0019\u000b\u000b\u0005\u007f\u0013YM!4\u0003P\nE\u0007\"CAkkA\u0005\t\u0019\u0001BX\u0011%\u00119,\u000eI\u0001\u0002\u0004\ty\u0006C\u0005\u0002\\V\u0002\n\u00111\u0001\u0002r!I\u0011\u0011]\u001b\u0011\u0002\u0003\u0007\u00111Y\u000b\u0003\u0005+TCAa,\u0003\u0004U\u0011!\u0011\u001c\u0016\u0005\u0003?\u0012\u0019!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0015\t\te\"q\u001c\u0005\n\u0005\u0003b\u0014\u0011!a\u0001\u0003'#BAa\u0016\u0003d\"I!\u0011\t \u0002\u0002\u0003\u0007!\u0011\b\u000b\u0005\u0005/\u00129\u000fC\u0005\u0003B\u0005\u000b\t\u00111\u0001\u0003:\u0005\tb)\u001a;dQ&tw\rV5feN#\u0018\r^3\u0011\u0007\u0005-8iE\u0003D\u0005_\fy\r\u0005\b\u0003v\tE(qVA0\u0003c\n\u0019Ma0\n\t\tM(q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001Bv))\u0011yL!?\u0003|\nu(q \u0005\b\u0003+4\u0005\u0019\u0001BX\u0011\u001d\u00119L\u0012a\u0001\u0003?Bq!a7G\u0001\u0004\t\t\bC\u0004\u0002b\u001a\u0003\r!a1\u0015\t\r\r11\u0002\t\u0007\u0003g\u0012\tj!\u0002\u0011\u0019\u0005M4q\u0001BX\u0003?\n\t(a1\n\t\r%\u0011Q\u000f\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tuu)!AA\u0002\t}\u0016a\t;sC:\u001c\u0018\u000e^5p]6\u000bG/\u001a:jC2L'0\u001b8h)&,'/T3uC\u0012\fG/\u0019\u000b\bo\u000eE11CB\u000b\u0011\u0015Y(\u00021\u0001}\u0011\u0019\t\u0019A\u0003a\u0001o\"9\u00111\u0015\u0006A\u0002\r]\u0001cAAT!\u0005\u0011rN\u001c*fgR|'/\u001a+jKJ\u001cF/\u0019;f)!\u0019iba\t\u0004&\r%\u0002\u0003BA:\u0007?IAa!\t\u0002v\t!QK\\5u\u0011\u0015Y8\u00021\u0001}\u0011\u001d\u00199c\u0003a\u0001\u0003c\nQ\u0003\u001d:pa>\u001cX\r\u001a'pG\u0006dGj\\4Ti\u0006\u0014H\u000fC\u0004\u0002$.\u0001\rA!-\u0002\u001d\u0019,Go\u00195US\u0016\u00148\u000b^1uKR1!qVB\u0018\u0007cAQa\u001f\u0007A\u0002qDqAa.\r\u0001\u0004\ty\u0006")
public class ConfluentReplicaFetcherTierStateMachine
extends TierStateMachine
implements Logging {
    private final LeaderEndPoint leader;
    private final ReplicaManager replicaMgr;
    private final ExponentialBackoff exponentialBackoff;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
        block3: {
            block2: {
                var4_4 = this.leader.fetchTierMaterializationTarget(topicPartition, currentFetchState.currentLeaderEpoch());
                if (var4_4 == null) break block2;
                leaderStartOffset = var4_4.localLogStartOffset();
                var7_6 = var4_4.tierRestorePoint();
                if (!(var7_6 instanceof Some) || (var8_7 = (TierMaterializationRequirements)((Some)var7_6).value()) == null) break block2;
                objectId = var8_7.objectId();
                restoreEpoch = var8_7.restoreEpoch();
                status = this.materializeTierStateUntilObjectId(topicPartition, leaderStartOffset, objectId, restoreEpoch);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$1(org.apache.kafka.common.TopicPartition java.util.UUID ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (UUID)objectId));
                v0 = status;
                v1 = leaderStartOffset;
                break block3;
            }
            if (var4_4 == null) ** GOTO lbl-1000
            leaderStartOffset = var4_4.localLogStartOffset();
            var14_12 = var4_4.tierRestorePoint();
            if (None$.MODULE$.equals(var14_12)) {
                status = this.materializeTierStateUntilOffset(topicPartition, leaderStartOffset - 1L);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$2(org.apache.kafka.common.TopicPartition long ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (long)leaderStartOffset));
                v0 = status;
                v1 = leaderStartOffset;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var4_4);
            }
        }
        var27_14 = v1;
        completionStatus = v0;
        x$1 = new MaterializingTierMetadata((Future<TierLogSegment>)var16_15, var27_14, currentFetchState.state());
        x$2 = currentFetchState.copy$default$1();
        x$3 = currentFetchState.copy$default$2();
        x$4 = currentFetchState.copy$default$3();
        x$5 = currentFetchState.copy$default$4();
        x$6 = currentFetchState.copy$default$5();
        x$7 = currentFetchState.copy$default$7();
        x$8 = currentFetchState.copy$default$8();
        x$9 = currentFetchState.copy$default$9();
        return currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
    }

    @Override
    public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
        MaterializingTierMetadata materializingTierMetadata;
        FetchingTierState fetchingTierState;
        ReplicaState replicaState = currentFetchState.state();
        if (replicaState instanceof FetchingTierState && (fetchingTierState = (FetchingTierState)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionFetchingTierState(tp, currentFetchState, fetchingTierState));
        }
        if (replicaState instanceof MaterializingTierMetadata && (materializingTierMetadata = (MaterializingTierMetadata)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionMaterializingTierMetadata(tp, currentFetchState, materializingTierMetadata));
        }
        return Optional.empty();
    }

    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilOffset(targetOffset);
    }

    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    private PartitionFetchState transitionFetchingTierState(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchingTierState tierState) {
        try {
            long leaderStartOffset = tierState.leaderStartOffset();
            long proposedLocalLogStart = tierState.tierSegment().endOffset() + 1L;
            long replicationOffset = package$.MODULE$.max(leaderStartOffset, proposedLocalLogStart);
            this.onRestoreTierState(topicPartition, replicationOffset, tierState.completionStatus().get());
            if (leaderStartOffset > proposedLocalLogStart) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Tier state ").append(tierState.tierSegment()).append(" restored. Resuming replicating from leader's local log ").append("start offset ").append(leaderStartOffset).append(".").toString());
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Tier state ").append(tierState.tierSegment()).append(" restored.").append(" Resuming replicating from one offset past the materialized end offset ").append(proposedLocalLogStart).toString());
            }
            return new PartitionFetchState(currentFetchState.topicId(), replicationOffset, currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), Fetching$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)tierState.tierSegment().metadata().tierEpoch())), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
        }
        catch (ExecutionException ee) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception fetching tier state.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ee.getCause());
            return new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), (Option<DelayedItem>)new Some((Object)new DelayedItem(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
    }

    private PartitionFetchState transitionMaterializingTierMetadata(TopicPartition topicPartition, PartitionFetchState currentFetchState, MaterializingTierMetadata tierState) {
        try {
            TierLogSegment tierSegment = tierState.completionStatus().get();
            long leaderStartOffset = tierState.leaderStartOffset();
            Future<TierState> completionStatus = this.fetchTierState(topicPartition, tierSegment);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Restoring tiered state corresponding to ").append(tierSegment).append(" for partition ").append(topicPartition).toString());
            FetchingTierState x$1 = new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, currentFetchState.state());
            Option<Uuid> x$2 = currentFetchState.copy$default$1();
            long x$3 = currentFetchState.copy$default$2();
            Option<Object> x$4 = currentFetchState.copy$default$3();
            int x$5 = currentFetchState.copy$default$4();
            Option<DelayedItem> x$6 = currentFetchState.copy$default$5();
            Option<Object> x$7 = currentFetchState.copy$default$7();
            Option<Object> x$8 = currentFetchState.copy$default$8();
            int x$9 = currentFetchState.copy$default$9();
            return currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof TierPartitionStateClosedException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ee.getCause());
            } else {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ee.getCause());
            }
            return new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), (Option<DelayedItem>)new Some((Object)new DelayedItem(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
    }

    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Restoring tier state ").append(topicPartition).append(": ").append(tierState).toString());
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        return ((Partition)this.replicaMgr.onlinePartition(topicPartition).get()).fetchTierState(tierSegment);
    }

    public static final /* synthetic */ String $anonfun$start$1(TopicPartition topicPartition$1, UUID objectId$1) {
        return new StringBuilder(106).append("Processed OFFSET_TIERED exception for ").append(topicPartition$1).append(". Waiting until tier partition state is ").append("materialized until objectId ").append(CoreUtils$.MODULE$.uuidToBase64(objectId$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$start$2(TopicPartition topicPartition$1, long leaderStartOffset$1) {
        return new StringBuilder(97).append("Processed OFFSET_TIERED exception for ").append(topicPartition$1).append(". Waiting until tier partition state is ").append("materialized until ").append(leaderStartOffset$1 - 1L).toString();
    }

    public ConfluentReplicaFetcherTierStateMachine(LeaderEndPoint leader, ReplicaManager replicaMgr, ExponentialBackoff exponentialBackoff) {
        this.leader = leader;
        this.replicaMgr = replicaMgr;
        this.exponentialBackoff = exponentialBackoff;
        super(leader, replicaMgr, false);
        Logging.$init$(this);
    }

    public static class FetchingTierState
    implements ReplicaState,
    Product,
    scala.Serializable {
        private final Future<TierState> completionStatus;
        private final TierLogSegment tierSegment;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        public Future<TierState> completionStatus() {
            return this.completionStatus;
        }

        public TierLogSegment tierSegment() {
            return this.tierSegment;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public FetchingTierState copy(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            return new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, previousState);
        }

        public Future<TierState> copy$default$1() {
            return this.completionStatus();
        }

        public TierLogSegment copy$default$2() {
            return this.tierSegment();
        }

        public long copy$default$3() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$4() {
            return this.previousState();
        }

        public String productPrefix() {
            return "FetchingTierState";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return this.tierSegment();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.leaderStartOffset());
                }
                case 3: {
                    return this.previousState();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchingTierState;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash(this.completionStatus())), (int)Statics.anyHash((Object)this.tierSegment())), (int)Statics.longHash((long)this.leaderStartOffset())), (int)Statics.anyHash((Object)this.previousState())), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchingTierState)) break block3;
                    FetchingTierState fetchingTierState = (FetchingTierState)x$1;
                    Future<TierState> future = this.completionStatus();
                    Future<TierState> future2 = fetchingTierState.completionStatus();
                    if (future != null ? !future.equals(future2) : future2 != null) break block3;
                    TierLogSegment tierLogSegment = this.tierSegment();
                    TierLogSegment tierLogSegment2 = fetchingTierState.tierSegment();
                    if ((tierLogSegment != null ? !((Object)tierLogSegment).equals(tierLogSegment2) : tierLogSegment2 != null) || this.leaderStartOffset() != fetchingTierState.leaderStartOffset()) break block3;
                    ReplicaState replicaState = this.previousState();
                    ReplicaState replicaState2 = fetchingTierState.previousState();
                    if ((replicaState != null ? !replicaState.equals(replicaState2) : replicaState2 != null) || !fetchingTierState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FetchingTierState(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.tierSegment = tierSegment;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$((Product)this);
        }
    }

    public static class MaterializingTierMetadata
    implements ReplicaState,
    Product,
    scala.Serializable {
        private final Future<TierLogSegment> completionStatus;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        public Future<TierLogSegment> completionStatus() {
            return this.completionStatus;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public MaterializingTierMetadata copy(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            return new MaterializingTierMetadata(completionStatus, leaderStartOffset, previousState);
        }

        public Future<TierLogSegment> copy$default$1() {
            return this.completionStatus();
        }

        public long copy$default$2() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$3() {
            return this.previousState();
        }

        public String productPrefix() {
            return "MaterializingTierMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.leaderStartOffset());
                }
                case 2: {
                    return this.previousState();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaterializingTierMetadata;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash(this.completionStatus())), (int)Statics.longHash((long)this.leaderStartOffset())), (int)Statics.anyHash((Object)this.previousState())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof MaterializingTierMetadata)) break block3;
                    MaterializingTierMetadata materializingTierMetadata = (MaterializingTierMetadata)x$1;
                    Future<TierLogSegment> future = this.completionStatus();
                    Future<TierLogSegment> future2 = materializingTierMetadata.completionStatus();
                    if ((future != null ? !future.equals(future2) : future2 != null) || this.leaderStartOffset() != materializingTierMetadata.leaderStartOffset()) break block3;
                    ReplicaState replicaState = this.previousState();
                    ReplicaState replicaState2 = materializingTierMetadata.previousState();
                    if ((replicaState != null ? !replicaState.equals(replicaState2) : replicaState2 != null) || !materializingTierMetadata.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public MaterializingTierMetadata(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$((Product)this);
        }
    }
}

