/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0011\u001a\u0001)B\u0001BL\u0002\u0003\u0006\u0004%Ia\f\u0005\tw\r\u0011\t\u0011)A\u0005a!AAh\u0001BC\u0002\u0013%Q\b\u0003\u0005F\u0007\t\u0005\t\u0015!\u0003?\u0011!15A!b\u0001\n#:\u0005\"\u0003(\u0004\u0005\u0003\u0005\u000b\u0011\u0002%P\u0011!\u00016A!b\u0001\n\u0013\t\u0006\u0002C/\u0004\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011y\u001b!Q1A\u0005\n}C\u0001\"[\u0002\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006Q\r!\tA\u001b\u0005\u0006c\u000e!\tE\u001d\u0005\u0006y\u000e!\t% \u0005\b\u0003\u0007\u0019A\u0011IA\u0003\u0011\u001d\t)d\u0001C\u0001\u0003oAq!a\u0011\u0004\t\u0003\t)\u0005C\u0004\u0002D\r!\t!!\u0015\t\u000f\u0005%4\u0001\"\u0001\u0002l!9\u0011\u0011N\u0002\u0005\u0002\u0005E\u0004bBA;\u0007\u0011\u0005\u0011qO\u0001\u001f\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006l\u0015M\\1hKJT!AG\u000e\u0002\rM,'O^3s\u0015\u0005a\u0012!B6bM.\f7\u0001\u0001\t\u0003?\u0005i\u0011!\u0007\u0002\u001f\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006l\u0015M\\1hKJ\u001c\"!\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tad\u0005\u0002\u0004WA\u0011q\u0004L\u0005\u0003[e\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000611m\u001c8gS\u001e,\u0012\u0001\r\t\u0003cej\u0011A\r\u0006\u0003]MR!A\u0007\u001b\u000b\u0005q)$B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001eL!A\u000f\u001a\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\ta\b\u0005\u0002@\u00076\t\u0001I\u0003\u0002=\u0003*\u0011!\tN\u0001\u0007G>lWn\u001c8\n\u0005\u0011\u0003%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005A\u0005CA%M\u001b\u0005Q%BA&B\u0003\u0015)H/\u001b7t\u0013\ti%J\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013B\u0001$-\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001S!\t\u0019&L\u0004\u0002U1B\u0011Q\u000bJ\u0007\u0002-*\u0011q+H\u0001\u0007yI|w\u000e\u001e \n\u0005e#\u0013A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u0013\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%A\ndY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.F\u0001a!\r\u0019\u0013mY\u0005\u0003E\u0012\u0012aa\u00149uS>t\u0007C\u00013h\u001b\u0005)'B\u000144\u0003\u0015\tXo\u001c;b\u0013\tAWMA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\u000bdY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7\u000e\t\u000b\u0007W2lgn\u001c9\u0011\u0005}\u0019\u0001\"\u0002\u0018\u000f\u0001\u0004\u0001\u0004\"\u0002\u001f\u000f\u0001\u0004q\u0004\"\u0002$\u000f\u0001\u0004A\u0005\"\u0002)\u000f\u0001\u0004\u0011\u0006\"\u00020\u000f\u0001\u0004\u0001\u0017\u0001F2mS\u0016tGOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0002toB\u0011A/^\u0007\u0002\u0003&\u0011a/\u0011\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\"\u0002=\u0010\u0001\u0004I\u0018aD9v_R\fW*\u001a;sS\u000e$\u0016mZ:\u0011\tMS(KU\u0005\u0003wr\u00131!T1q\u0003M\u0011\u0017mY6qe\u0016\u001c8/\u001e:f\u000b:\f'\r\\3e+\u0005q\bCA\u0012\u0000\u0013\r\t\t\u0001\n\u0002\b\u0005>|G.Z1o\u0003i\u0011XmY8sI\u0006sGmR3u)\"\u0014x\u000e\u001e;mKRKW.Z't))\t9!!\u0004\u0002\u001e\u0005\u0005\u00121\u0006\t\u0004G\u0005%\u0011bAA\u0006I\t\u0019\u0011J\u001c;\t\u000f\u0005=\u0011\u00031\u0001\u0002\u0012\u000591/Z:tS>t\u0007\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]A'A\u0004oKR<xN]6\n\t\u0005m\u0011Q\u0003\u0002\b'\u0016\u001c8/[8o\u0011\u0019\ty\"\u0005a\u0001%\u0006A1\r\\5f]RLE\rC\u0004\u0002$E\u0001\r!!\n\u0002\u000bY\fG.^3\u0011\u0007\r\n9#C\u0002\u0002*\u0011\u0012a\u0001R8vE2,\u0007bBA\u0017#\u0001\u0007\u0011qF\u0001\u0007i&lW-T:\u0011\u0007\r\n\t$C\u0002\u00024\u0011\u0012A\u0001T8oO\u0006qA\u000f\u001b:piRdW\rV5nK6\u001bH\u0003BA\u0018\u0003sAq!a\u000f\u0013\u0001\u0004\ti$A\u0001f!\ry\u0014qH\u0005\u0004\u0003\u0003\u0002%aF)v_R\fg+[8mCRLwN\\#yG\u0016\u0004H/[8o\u0003EqWm^*ue&\u001cG/U;pi\u00064uN\u001d\u000b\u0007\u0003\u000f\ni%a\u0014\u0011\u0007}\tI%C\u0002\u0002Le\u0011qcQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\t\u000f\u0005=1\u00031\u0001\u0002\u0012!1\u0011qD\nA\u0002I#B!a\u0012\u0002T!9\u0011Q\u000b\u000bA\u0002\u0005]\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u00033\n\u0019G\u0004\u0003\u0002\\\u0005}SBAA/\u0015\r\t9bG\u0005\u0005\u0003C\ni&\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005\u0015\u0014q\r\u0002\b%\u0016\fX/Z:u\u0015\u0011\t\t'!\u0018\u0002+9,w\u000fU3s[&\u001c8/\u001b<f#V|G/\u0019$peR1\u0011qIA7\u0003_Bq!a\u0004\u0016\u0001\u0004\t\t\u0002\u0003\u0004\u0002 U\u0001\rA\u0015\u000b\u0005\u0003\u000f\n\u0019\bC\u0004\u0002VY\u0001\r!a\u0016\u0002\u00179,w/U;pi\u00064uN\u001d\u000b\u0007\u0003\u000f\nI(a\u001f\t\u000f\u0005Us\u00031\u0001\u0002X!9\u0011QP\fA\u0002\u0005}\u0014AE:ue&\u001cGoU5oG\u00164VM]:j_:\u00042aIAA\u0013\r\t\u0019\t\n\u0002\u0006'\"|'\u000f\u001e")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", QuotaType$ControllerMutation$.MODULE$.toString(), "Tracking mutation-rate per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTimeMs(e);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public long throttleTimeMs(QuotaViolationException e) {
        return QuotaUtils$.MODULE$.boundedTokenBucketThrottleTime(e, this.quotaMaxThrottleTimeMs());
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, clientQuotaCallback, ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
    }
}

