/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerQueueItem;
import kafka.server.NodeToControllerRequestThread;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\f\u0019\u0001uA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011q\u0003!\u0011!Q\u0001\nuCQ!\u0019\u0001\u0005\u0002\tDqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u0019I\b\u0001)A\u0005g\"9!\u0010\u0001b\u0001\n\u0013Y\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u0010!A\u0011\u0011\u0004\u0001\u0005\u0002a\t\u0019\u0001C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\u000e\u0001\u0005\u0002\u0005E$A\t(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u00136\u0004HN\u0003\u0002\u001a5\u000511/\u001a:wKJT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001aD\n\u0019\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001\u00027b]\u001eT\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t1qJ\u00196fGR\u0004\"a\n\u0018\u000e\u0003!R!!G\u0015\u000b\u0005mQ#BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001eL!a\f\u0015\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\bCA\u00195\u001b\u0005\u0011$BA\u001a\u001b\u0003\u0015)H/\u001b7t\u0013\t)$GA\u0004M_\u001e<\u0017N\\4\u0002-\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\u0004\"\u0001O\u001d\u000e\u0003aI!A\u000f\r\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fA\u0001^5nKB\u0011Q(Q\u0007\u0002})\u00111g\u0010\u0006\u0003\u0001&\naaY8n[>t\u0017B\u0001\"?\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB\u0011QiR\u0007\u0002\r*\u00111iP\u0005\u0003\u0011\u001a\u0013q!T3ue&\u001c7/\u0001\u0004d_:4\u0017n\u001a\t\u0003q-K!\u0001\u0014\r\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fG\"\fgN\\3m\u001d\u0006lW\r\u0005\u0002P1:\u0011\u0001K\u0016\t\u0003#Rk\u0011A\u0015\u0006\u0003'r\ta\u0001\u0010:p_Rt$\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#\u0016A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!a\u0016+\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\u0018A\u0004:fiJLH+[7f_V$Xj\u001d\t\u0003=~k\u0011\u0001V\u0005\u0003AR\u0013A\u0001T8oO\u00061A(\u001b8jiz\"\u0002b\u00193fM\u001eD\u0017N\u001b\t\u0003q\u0001AQA\u000e\u0005A\u0002]BQa\u000f\u0005A\u0002qBQa\u0011\u0005A\u0002\u0011CQ!\u0013\u0005A\u0002)CQ!\u0014\u0005A\u00029CQa\u0017\u0005A\u00029CQ\u0001\u0018\u0005A\u0002u\u000b!\u0002\\8h\u0007>tG/\u001a=u+\u0005i\u0007CA\u001fo\u0013\tygH\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005)R.\u00198vC2lU\r^1eCR\fW\u000b\u001d3bi\u0016\u0014X#A:\u0011\u0005Q<X\"A;\u000b\u0005YL\u0013aB2mS\u0016tGo]\u0005\u0003qV\u0014Q#T1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'/\u0001\fnC:,\u0018\r\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:!\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0003q\u0004\"\u0001^?\n\u0005y,(aC!qSZ+'o]5p]N\fA\"\u00199j-\u0016\u00148/[8og\u0002\nQB]3rk\u0016\u001cH\u000f\u00165sK\u0006$WCAA\u0003!\rA\u0014qA\u0005\u0004\u0003\u0013A\"!\b(pI\u0016$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u)\"\u0014X-\u00193\u0002\u001dI,\u0017/^3tiRC'/Z1eA\u0005)1\u000f^1siR\u0011\u0011\u0011\u0003\t\u0004=\u0006M\u0011bAA\u000b)\n!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017\u0001\u00058foJ+\u0017/^3tiRC'/Z1e\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\r\u0005E\u0011qDA(\u0011\u001d\t\t\u0003\u0006a\u0001\u0003G\tqA]3rk\u0016\u001cH\u000f\r\u0003\u0002&\u0005u\u0002CBA\u0014\u0003g\tID\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ticP\u0001\te\u0016\fX/Z:ug&!\u0011\u0011GA\u0016\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002BA\u001b\u0003o\u0011qAQ;jY\u0012,'O\u0003\u0003\u00022\u0005-\u0002\u0003BA\u001e\u0003{a\u0001\u0001\u0002\u0007\u0002@\u0005}\u0011\u0011!A\u0001\u0006\u0003\t\tEA\u0002`IE\nB!a\u0011\u0002JA\u0019a,!\u0012\n\u0007\u0005\u001dCKA\u0004O_RD\u0017N\\4\u0011\t\u0005%\u00121J\u0005\u0005\u0003\u001b\nYCA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001d\t\t\u0006\u0006a\u0001\u0003'\n\u0001bY1mY\n\f7m\u001b\t\u0004O\u0005U\u0013bAA,Q\t\u00113i\u001c8ue>dG.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\fQcY8oiJ|G\u000e\\3s\u0003BLg+\u001a:tS>t7\u000f\u0006\u0002\u0002^A1\u0011qLA3\u0003Sj!!!\u0019\u000b\u0007\u0005\r$%\u0001\u0003vi&d\u0017\u0002BA4\u0003C\u0012\u0001b\u00149uS>t\u0017\r\u001c\t\u0004i\u0006-\u0014bAA7k\nyaj\u001c3f\u0003BLg+\u001a:tS>t7/\u0001\u0007hKR$\u0016.\\3pkRl5\u000fF\u0001^\u0001")
public class NodeToControllerChannelManagerImpl
implements NodeToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final String threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final NodeToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private NodeToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    public void start() {
        this.requestThread().start();
    }

    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Node to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public NodeToControllerRequestThread newRequestThread() {
        String threadName = new StringBuilder(30).append(this.threadNamePrefix).append("to-controller-").append(this.channelName).append("-channel-manager").toString();
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new NodeToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), controllerInformation.isZkController(), (Function1<ControllerInformation, KafkaClient>)(Function1 & Serializable & scala.Serializable)controllerInfo -> this.buildNetworkClient$1((ControllerInformation)controllerInfo), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, threadName, this.retryTimeoutMs);
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback, Context.current()));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable & scala.Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())))));
    }

    public long getTimeoutMs() {
        return this.retryTimeoutMs;
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
    }

    public NodeToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, String threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(43).append("[NodeToControllerChannelManager id=").append(config.nodeId()).append(" name=").append(channelName).append("] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

