/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B8q\u0001UD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005M\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005%\u0002A!A!\u0002\u0013\tY\u0003\u0003\u0006\u0002F\u0001\u0011\t\u0011)A\u0005\u0003\u000fB!\"!\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA(\u0011)\t)\u0006\u0001B\u0001B\u0003%\u0011q\u000b\u0005\u000b\u0003;\u0002!\u0011!Q\u0001\n\u0005}\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\u000b\u0003\u0007\u0003!\u0019!C\u0001a\u0006\u0015\u0005\u0002CB\u0010\u0001\u0001\u0006I!a\"\t\u000f\r\u0005\u0002\u0001\"\u0015\u0004$!911\u0006\u0001\u0005R\r5\u0002bBB\u001c\u0001\u0011E3\u0011\b\u0005\b\u0007{\u0001A\u0011KB \u0011\u001d\u0019y\u0005\u0001C!\u0007#Bqaa \u0001\t\u0003\u001a\t\tC\u0004\u0002P\u0002!Ia!'\t\u0011\r}\u0005\u0001\"\u0001q\u0007CCqa!+\u0001\t\u0013\u0019Y\u000bC\u0004\u0004@\u0002!\te!1\t\u0013\r=\u0007A1A\u0005R\u0005\u001d\b\u0002CBi\u0001\u0001\u0006I!!;\t\u000f\rM\u0007\u0001\"\u0011\u0004V\"911\u001d\u0001\u0005R\r\u0015xaBAXa\"\u0005\u0011\u0011\u0017\u0004\u0007_BD\t!a-\t\u000f\u0005-D\u0004\"\u0001\u0002>\u001a1\u0011q\u0018\u000fA\u0003\u0003D!\"a4\u001f\u0005+\u0007I\u0011AAi\u0011)\u00119I\bB\tB\u0003%\u00111\u001b\u0005\u000b\u0005\u0013s\"Q3A\u0005\u0002\t-\u0005B\u0003BM=\tE\t\u0015!\u0003\u0003\u000e\"Q!1\u0014\u0010\u0003\u0016\u0004%\tAa#\t\u0015\tueD!E!\u0002\u0013\u0011i\tC\u0004\u0002ly!\tAa(\t\u000f\t%f\u0004\"\u0001\u0003,\"I!\u0011\u0017\u0010\u0002\u0002\u0013\u0005!1\u0017\u0005\n\u0005ws\u0012\u0013!C\u0001\u0005{C\u0011Ba5\u001f#\u0003%\tA!6\t\u0013\teg$%A\u0005\u0002\tU\u0007\"\u0003B\u0003=\u0005\u0005I\u0011\tB\u0004\u0011%\u0011\u0019BHA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001ey\t\t\u0011\"\u0001\u0003\\\"I!1\u0006\u0010\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005wq\u0012\u0011!C\u0001\u0005?D\u0011B!\u0011\u001f\u0003\u0003%\tEa\u0011\t\u0013\t\u0015c$!A\u0005B\t\u001d\u0003\"\u0003Br=\u0005\u0005I\u0011\tBs\u000f%\u0011I\u000fHA\u0001\u0012\u0003\u0011YOB\u0005\u0002@r\t\t\u0011#\u0001\u0003n\"9\u00111\u000e\u001b\u0005\u0002\tm\b\"\u0003B#i\u0005\u0005IQ\tB$\u0011%\u0011i\u0010NA\u0001\n\u0003\u0013y\u0010C\u0005\u0004\bQ\n\t\u0011\"!\u0004\n!I!\u0011\n\u001b\u0002\u0002\u0013%!1\n\u0004\n\u0003/d\u0002\u0013aA\u0011\u00033Dq!a7;\t\u0003\ti\u000eC\u0004\u0002fj\"\t!a:\b\u000f\r]A\u0004#\u0001\u0002x\u001a9\u0011q\u001b\u000f\t\u0002\u0005M\bbBA6}\u0011\u0005\u0011Q_\u0004\b\u0003st\u0004\u0012QA~\r\u001d\tyP\u0010EA\u0005\u0003Aq!a\u001bB\t\u0003\u0011\u0019\u0001C\u0005\u0003\u0006\u0005\u000b\t\u0011\"\u0011\u0003\b!I!1C!\u0002\u0002\u0013\u0005!Q\u0003\u0005\n\u0005;\t\u0015\u0011!C\u0001\u0005?A\u0011Ba\u000bB\u0003\u0003%\tE!\f\t\u0013\tm\u0012)!A\u0005\u0002\tu\u0002\"\u0003B!\u0003\u0006\u0005I\u0011\tB\"\u0011%\u0011)%QA\u0001\n\u0003\u00129\u0005C\u0005\u0003J\u0005\u000b\t\u0011\"\u0003\u0003L\u001d9!1\u000b \t\u0002\nUca\u0002B,}!\u0005%\u0011\f\u0005\b\u0003WbE\u0011\u0001B.\u0011\u001d\t)\u000f\u0014C!\u0003OD\u0011B!\u0002M\u0003\u0003%\tEa\u0002\t\u0013\tMA*!A\u0005\u0002\tU\u0001\"\u0003B\u000f\u0019\u0006\u0005I\u0011\u0001B/\u0011%\u0011Y\u0003TA\u0001\n\u0003\u0012i\u0003C\u0005\u0003<1\u000b\t\u0011\"\u0001\u0003b!I!\u0011\t'\u0002\u0002\u0013\u0005#1\t\u0005\n\u0005\u000bb\u0015\u0011!C!\u0005\u000fB\u0011B!\u0013M\u0003\u0003%IAa\u0013\b\u000f\t\u0015d\b#!\u0003h\u00199\u0011\u0011\u001f \t\u0002\nm\u0004bBA61\u0012\u0005!Q\u0010\u0005\b\u0003KDF\u0011IAt\u0011%\u0011)\u0001WA\u0001\n\u0003\u00129\u0001C\u0005\u0003\u0014a\u000b\t\u0011\"\u0001\u0003\u0016!I!Q\u0004-\u0002\u0002\u0013\u0005!q\u0010\u0005\n\u0005WA\u0016\u0011!C!\u0005[A\u0011Ba\u000fY\u0003\u0003%\tAa!\t\u0013\t\u0005\u0003,!A\u0005B\t\r\u0003\"\u0003B#1\u0006\u0005I\u0011\tB$\u0011%\u0011I\u0005WA\u0001\n\u0013\u0011YeB\u0004\u0003jyB\tIa\u001b\u0007\u000f\t5d\b#!\u0003p!9\u00111\u000e3\u0005\u0002\tE\u0004\"\u0003B\u0003I\u0006\u0005I\u0011\tB\u0004\u0011%\u0011\u0019\u0002ZA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001e\u0011\f\t\u0011\"\u0001\u0003t!I!1\u00063\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005w!\u0017\u0011!C\u0001\u0005oB\u0011B!\u0011e\u0003\u0003%\tEa\u0011\t\u0013\t\u0015C-!A\u0005B\t\u001d\u0003\"\u0003B%I\u0006\u0005I\u0011\u0002B&\u0011%\u0019I\u0002HI\u0001\n\u0003\u0019YBA\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$'BA9s\u0003\u0019\u0019XM\u001d<fe*\t1/A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\bCA<y\u001b\u0005\u0001\u0018BA=q\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0019A0a\u0003\u000f\u0007u\f9\u0001E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003!\u0018A\u0002\u001fs_>$hH\u0003\u0002\u0002\u0006\u0005)1oY1mC&!\u0011\u0011BA\u0002\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\u0019\u0019FO]5oO*!\u0011\u0011BA\u0002\u0003\u0019aW-\u00193feB\u0019q/!\u0006\n\u0007\u0005]\u0001O\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bcA<\u0002\u001e%\u0019\u0011q\u00049\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001\u00059bkN,G\rU1si&$\u0018n\u001c8t!\r9\u0018QE\u0005\u0004\u0003O\u0001(\u0001\u0005)bkN,G\rU1si&$\u0018n\u001c8t\u0003I)\u0007\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0011\t\u00055\u0012\u0011I\u0007\u0003\u0003_QA!!\r\u00024\u0005)Q\u000f^5mg*!\u0011QGA\u001c\u0003\u0019\u0019w.\\7p]*\u00191/!\u000f\u000b\t\u0005m\u0012QH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0012aA8sO&!\u00111IA\u0018\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u0002x\u0003\u0013J1!a\u0013q\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u00042a^A)\u0013\r\t\u0019\u0006\u001d\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\f\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\u0007]\fI&C\u0002\u0002\\A\u0014\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002+\u0011L'/Z2u_JLXI^3oi\"\u000bg\u000e\u001a7feB!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u00026\u0005\u0015$bA9\u00028%!\u0011\u0011NA2\u0005U!\u0015N]3di>\u0014\u00180\u0012<f]RD\u0015M\u001c3mKJ\fa\u0001P5oSRtD\u0003FA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t\t\u0005\u0002x\u0001!)!P\u0003a\u0001w\"9\u0011\u0011\u0003\u0006A\u0002\u0005M\u0001bBA\r\u0015\u0001\u0007\u00111\u0004\u0005\b\u0003CQ\u0001\u0019AA\u0012\u0011\u001d\tIC\u0003a\u0001\u0003WAq!!\u0012\u000b\u0001\u0004\t9\u0005C\u0004\u0002N)\u0001\r!a\u0014\t\u000f\u0005U#\u00021\u0001\u0002X!I\u0011Q\f\u0006\u0011\u0002\u0003\u0007\u0011qL\u0001\u0010aJ|Wn\u001c;j_:\u001cF/\u0019;fgV\u0011\u0011q\u0011\t\t\u0003\u0013\u000b9*a'\u0002$6\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0006d_:\u001cWO\u001d:f]RTA!!%\u0002\u0014\u0006!Q\u000f^5m\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BAM\u0003\u0017\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\ti*a(\u000e\u0005\u0005M\u0012\u0002BAQ\u0003g\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u0002&zq1!a*\u001c\u001d\u0011\tI+!,\u000f\u0007y\fY+C\u0001t\u0013\t\t(/A\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$\u0007CA<\u001d'\ra\u0012Q\u0017\t\u0005\u0003o\u000bI,\u0004\u0002\u0002\u0004%!\u00111XA\u0002\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011\u0017\u0002\u000f!J|Wn\u001c;j_:\u001cF/\u0019;f'\u001dq\u0012QWAb\u0003\u0013\u0004B!a.\u0002F&!\u0011qYA\u0002\u0005\u001d\u0001&o\u001c3vGR\u0004B!a.\u0002L&!\u0011QZA\u0002\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003E\u0011X-Y:tS\u001etW.\u001a8u'R\fG/Z\u000b\u0003\u0003'\u00042!!6;\u001b\u0005a\"!\u0005*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uKN\u0019!(!.\u0002\r\u0011Jg.\u001b;%)\t\ty\u000e\u0005\u0003\u00028\u0006\u0005\u0018\u0002BAr\u0003\u0007\u0011A!\u00168ji\u0006IR.Y=cK&s7m\u001c8tSN$XM\u001c;NKR\fG-\u0019;b+\t\tI\u000f\u0005\u0003\u00028\u0006-\u0018\u0002BAw\u0003\u0007\u0011qAQ8pY\u0016\fg.K\u0003;1\u0012\fEJ\u0001\u0005BG\u000e,\u0007\u000f^3e'\rq\u0014Q\u0017\u000b\u0003\u0003o\u00042!!6?\u0003\u0011quN\\3\u0011\u0007\u0005u\u0018)D\u0001?\u0005\u0011quN\\3\u0014\u0013\u0005\u000b),a5\u0002D\u0006%GCAA~\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0002\t\u0005\u0005\u0017\u0011\t\"\u0004\u0002\u0003\u000e)!!qBAJ\u0003\u0011a\u0017M\\4\n\t\u00055!QB\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005/\u0001B!a.\u0003\u001a%!!1DA\u0002\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tCa\n\u0011\t\u0005]&1E\u0005\u0005\u0005K\t\u0019AA\u0002B]fD\u0011B!\u000bF\u0003\u0003\u0005\rAa\u0006\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u0003\u0005\u0004\u00032\t]\"\u0011E\u0007\u0003\u0005gQAA!\u000e\u0002\u0004\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te\"1\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002j\n}\u0002\"\u0003B\u0015\u000f\u0006\u0005\t\u0019\u0001B\u0011\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\f\u0003!!xn\u0015;sS:<GC\u0001B\u0005\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0003\u0003\u0002B\u0006\u0005\u001fJAA!\u0015\u0003\u000e\t1qJ\u00196fGR\fa!U;fk\u0016$\u0007cAA\u007f\u0019\n1\u0011+^3vK\u0012\u001c\u0012\u0002TA[\u0003'\f\u0019-!3\u0015\u0005\tUC\u0003\u0002B\u0011\u0005?B\u0011B!\u000bR\u0003\u0003\u0005\rAa\u0006\u0015\t\u0005%(1\r\u0005\n\u0005S\u0019\u0016\u0011!a\u0001\u0005C\t\u0001\"Q2dKB$X\r\u001a\t\u0004\u0003{D\u0016!C#gM\u0016\u001cG/\u001b<f!\r\ti\u0010\u001a\u0002\n\u000b\u001a4Wm\u0019;jm\u0016\u001c\u0012\u0002ZA[\u0003'\f\u0019-!3\u0015\u0005\t-D\u0003\u0002B\u0011\u0005kB\u0011B!\u000bi\u0003\u0003\u0005\rAa\u0006\u0015\t\u0005%(\u0011\u0010\u0005\n\u0005SQ\u0017\u0011!a\u0001\u0005C\u0019\u0012\u0002WA[\u0003'\f\u0019-!3\u0015\u0005\t\u001dD\u0003\u0002B\u0011\u0005\u0003C\u0011B!\u000b^\u0003\u0003\u0005\rAa\u0006\u0015\t\u0005%(Q\u0011\u0005\n\u0005Sy\u0016\u0011!a\u0001\u0005C\t!C]3bgNLwM\\7f]R\u001cF/\u0019;fA\u00059Ao\u001c9jG&#WC\u0001BG!\u0019\t9La$\u0003\u0014&!!\u0011SA\u0002\u0005\u0019y\u0005\u000f^5p]B!\u0011Q\u0014BK\u0013\u0011\u00119*a\r\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005Q1-\u001e:sK:$H)\u001b:\u0002\u0017\r,(O]3oi\u0012K'\u000f\t\u000b\t\u0005C\u0013\u0019K!*\u0003(B\u0019\u0011Q\u001b\u0010\t\u000f\u0005=W\u00051\u0001\u0002T\"9!\u0011R\u0013A\u0002\t5\u0005b\u0002BNK\u0001\u0007!QR\u0001\u000fo&$\b.Q:tS\u001etW.\u001a8u)\u0011\u0011\tK!,\t\u000f\t=f\u00051\u0001\u0002T\u00069b.Z<ESJ\u0014V-Y:tS\u001etW.\u001a8u'R\fG/Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0003\"\nU&q\u0017B]\u0011%\tym\nI\u0001\u0002\u0004\t\u0019\u000eC\u0005\u0003\n\u001e\u0002\n\u00111\u0001\u0003\u000e\"I!1T\u0014\u0011\u0002\u0003\u0007!QR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yL\u000b\u0003\u0002T\n\u00057F\u0001Bb!\u0011\u0011)Ma4\u000e\u0005\t\u001d'\u0002\u0002Be\u0005\u0017\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t5\u00171A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bi\u0005\u000f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa6+\t\t5%\u0011Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134)\u0011\u0011\tC!8\t\u0013\t%R&!AA\u0002\t]A\u0003BAu\u0005CD\u0011B!\u000b0\u0003\u0003\u0005\rA!\t\u0002\r\u0015\fX/\u00197t)\u0011\tIOa:\t\u0013\t%\"'!AA\u0002\t\u0005\u0012A\u0004)s_6|G/[8o'R\fG/\u001a\t\u0004\u0003+$4#\u0002\u001b\u0003p\u0006%\u0007\u0003\u0004By\u0005o\f\u0019N!$\u0003\u000e\n\u0005VB\u0001Bz\u0015\u0011\u0011)0a\u0001\u0002\u000fI,h\u000e^5nK&!!\u0011 Bz\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005W\fQ!\u00199qYf$\u0002B!)\u0004\u0002\r\r1Q\u0001\u0005\b\u0003\u001f<\u0004\u0019AAj\u0011\u001d\u0011Ii\u000ea\u0001\u0005\u001bCqAa'8\u0001\u0004\u0011i)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r-11\u0003\t\u0007\u0003o\u0013yi!\u0004\u0011\u0015\u0005]6qBAj\u0005\u001b\u0013i)\u0003\u0003\u0004\u0012\u0005\r!A\u0002+va2,7\u0007C\u0005\u0004\u0016a\n\t\u00111\u0001\u0003\"\u0006\u0019\u0001\u0010\n\u0019\u0002#I+\u0017m]:jO:lWM\u001c;Ti\u0006$X-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0007;QC!a\u0018\u0003B\u0006\u0001\u0002O]8n_RLwN\\*uCR,7\u000fI\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0004&\r\u001d\u0002CBA\\\u0005\u001f\u00139\u0002C\u0004\u0004*5\u0001\r!a'\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BB\u0018\u0007k\u0001B!a.\u00042%!11GA\u0002\u0005\u0011auN\\4\t\u000f\r%b\u00021\u0001\u0002\u001c\u0006aAn\\4F]\u0012|eMZ:fiR!1qFB\u001e\u0011\u001d\u0019Ic\u0004a\u0001\u00037\u000b\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u0019\te!\u0013\u0004LA1\u0011q\u0017BH\u0007\u0007\u0002B!!\u0019\u0004F%!1qIA2\u00059yeMZ:fi\u0006sG-\u00129pG\"Dqa!\u000b\u0011\u0001\u0004\tY\nC\u0004\u0004NA\u0001\rAa\u0006\u0002\u000b\u0015\u0004xn\u00195\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b))\u0019\u0019f!\u001b\u0004l\r=41\u000f\t\u0007\u0003o\u0013yi!\u0016\u0011\t\r]3QM\u0007\u0003\u00073RAaa\u0017\u0004^\u0005\u0019An\\4\u000b\t\r}3\u0011M\u0001\nS:$XM\u001d8bYNTAaa\u0019\u00028\u000591\u000f^8sC\u001e,\u0017\u0002BB4\u00073\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBB\u0015#\u0001\u0007\u00111\u0014\u0005\b\u0007[\n\u0002\u0019AB\u0018\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\rE\u0014\u00031\u0001\u0003\u0018\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"Dqa!\u001e\u0012\u0001\u0004\u00199(A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0007s\u001aY(D\u0001\u0001\u0013\r\u0019i\b\u001f\u0002\n\r\u0016$8\r\u001b#bi\u0006\f\u0001C]3n_Z,\u0007+\u0019:uSRLwN\\:\u0015\t\r\r5q\u0012\t\t\u0005c\u0019))a'\u0004\n&!1q\u0011B\u001a\u0005\ri\u0015\r\u001d\t\u0004o\u000e-\u0015bABGa\n\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"91\u0011\u0013\nA\u0002\rM\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\tE2QSAN\u0013\u0011\u00199Ja\r\u0003\u0007M+G\u000f\u0006\u0003\u0004\u001c\u000eu\u0005cAASu!91\u0011F\nA\u0002\u0005m\u0015aF;qI\u0006$XMU3bgNLwM\\7f]R\u001cF/\u0019;f)\u0019\tyna)\u0004&\"91\u0011\u0006\u000bA\u0002\u0005m\u0005bBBT)\u0001\u000711T\u0001\u0006gR\fG/Z\u0001\u001a[\u0006L(-\u001a)s_6|G/\u001a$viV\u0014XMU3qY&\u001c\u0017\r\u0006\u0004\u0003\"\r56q\u0016\u0005\b\u0007S)\u0002\u0019AAN\u0011\u001d\u0019\t,\u0006a\u0001\u0007g\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\rU61X\u0007\u0003\u0007oS1a!/s\u0003\u001d\u0019G.^:uKJLAa!0\u00048\nI\u0001+\u0019:uSRLwN\\\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\t\rM51\u0019\u0005\b\u0007\u000b4\u0002\u0019ABd\u0003IIg.\u001b;jC24U\r^2i'R\fG/Z:\u0011\u0011\tE2QQAN\u0007\u0013\u00042a^Bf\u0013\r\u0019i\r\u001d\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0017aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003!!(/\u001e8dCR,GCBAu\u0007/\u001cI\u000eC\u0004\u0004*e\u0001\r!a'\t\u000f\rm\u0017\u00041\u0001\u0004^\u0006yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002x\u0007?L1a!9q\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005}7q]Bu\u0011\u001d\u0019IC\u0007a\u0001\u00037Cqaa;\u001b\u0001\u0004\u0019y#\u0001\u0004pM\u001a\u001cX\r\u001e")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;
    private final boolean isOffsetForLeaderEpochSupported;

    public static DirectoryEventHandler $lessinit$greater$default$9() {
        return ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$9();
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true, partitionLeaderEpoch) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var5_5;
                void var4_4;
                void var3_3;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                void reassignmentState2 = var3_3;
                void topicId2 = var4_4;
                void originalDir2 = var5_5;
                if (originalDir2.isDefined() && topicId2.isDefined() && reassignmentState2.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)topicId2.get(), topicPartition.partition()), (Uuid)originalDir2.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Updating future replica ").append(topicPartition).append(" reassignment state to ").append(state).toString());
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(27).append("Topic ").append(topicPartition.topic()).append(" does not have an ID.").toString());
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<AbstractLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$2, AbstractLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$2.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        TierStateMachine x$4 = new TierStateMachine(leader, replicaMgr, false);
        boolean x$8 = false;
        Map<String, String> x$10 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$10();
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, x$4, x$8, brokerTopicStats, x$10);
        this.promotionStates = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PromotionState
    implements Product,
    scala.Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

